<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.9.9
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

$tag = get_the_terms( $product->get_id(), 'product_tag' );
?>


    <?php do_action( 'woocommerce_product_meta_start' ); ?>
    
    <div class="tp-shop-details__product-info">
        <ul>
            <?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>
            <li>
                <span><?php esc_html_e( 'SKU:', 'poorex' ); ?></span>
                <?php echo esc_html(( $sku = $product->get_sku() ), 'poorex') ? $sku : esc_html__( 'N/A', 'poorex' ); ?>
            </li>
            <?php endif; ?>
            <li>
                <?php echo wc_get_product_category_list( $product->get_id(), ', ', '<span>' . _n( 'Category: ', 'Categories: ', count( $product->get_category_ids() ), 'poorex' )  . '</span> '); ?> 
            </li>
            <?php if(!empty($tag)) : ?>
            <li>
                <?php echo wc_get_product_tag_list( $product->get_id(), ', ', '<span>' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'poorex' ) . '</span> '); ?>
            </li>
            <?php endif; ?>
            <?php
            if(function_exists('poorex_product_social_share')) :
            echo poorex_product_social_share(); 
            endif;
            ?>
        </ul>
    </div>
    
    <?php do_action( 'woocommerce_product_meta_end' ); ?>