<?php 

	/**
	 * Template part for displaying header layout three
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
	 *
	 * @package poorex
	*/
	// info
   $header_topbar_switch = get_theme_mod( 'header_topbar_switch', false );


   // Button Text
   $header_top_button_switch = get_theme_mod( 'header_top_button_switch', false);
   $header_top_button_text = get_theme_mod( 'header_button_text', __( 'Donate Now', 'poorex' ) );
   $header_top_button_link = get_theme_mod( 'header_button_link', __( '#', 'poorex' ) );

   // header right
   $poorex_header_right = get_theme_mod( 'header_right_switch', false );
   $poorex_menu_col = $poorex_header_right ? 'col-xxl-6 col-xl-6 col-lg-8 d-none d-lg-block' : 'col-xxl-9 col-xl-9 col-lg-8 d-none d-lg-block text-end';
   $header_search_switch = get_theme_mod( 'header_search_switch', false );

   //Phone
   $header_top_phone = get_theme_mod( 'header_phone', __( '+88 0190 678956', 'poorex' ) );
   
   // Email id 
   $header_top_email = get_theme_mod( 'header_email', __( 'poorex@support.com', 'poorex' ) );

   // Header Address Text
   $header_top_address_text = get_theme_mod( 'header_address', __( '734 H, Bryan Burlington, NC 27215', 'poorex' ) );

   // Header Address Link
   $header_top_address_link = get_theme_mod( 'header_address_link', __( '#', 'poorex' ) );

   $header_language_switch = get_theme_mod( 'header_language_switch', false );

   // Header charity Text
   $header_top_charity_text = get_theme_mod( 'header_top_charity_text', __( 'Connect with our charity', 'poorex' ) );
      // header auth btn 
      $header_auth_switch = get_theme_mod( 'header_auth_switch', false );
      $header_auth_link = get_theme_mod( 'header_auth_link',"#" );

?>
    <header class="tp-header-height">
        <div id="header-sticky" class="tp-header__left-wrap p-relative">
            <div class="tp-header__logo">
            <?php poorex_header_logo(); ?>
            </div>
            <div class="tp-header__right-wrap tp-header__plr">
                <!-- header-top-area-start -->
                <?php if(!empty($header_topbar_switch)) : ?>
                <div class="tp-header-top__area tp-header-top__hide tp-header-top__space theme-bg">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-xxl-6 col-xl-5 col-lg-7 col-md-8">
                                <div class="tp-header-top__left-box">
                                    <ul>
                                    <?php if(!empty($header_top_charity_text)) : ?>
                                        <li><span><?php echo esc_html( $header_top_charity_text ); ?></span></li>
                                        <?php endif;  ?> 
                                        <li>
                                            <div class="tp-header-top__social">
                                            <?php poorex_header_social_profiles(); ?>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-xxl-6 col-xl-7 col-lg-5 col-md-4">
                                <div class="tp-header-top__right-box text-end">
                                    <ul>
                                    <?php if(!empty($header_top_address_text)) : ?>
                                        <li class="location"><i class="fa-solid fa-location-dot"></i><a target="_blank"
                                                href="<?php echo esc_url( $header_top_address_link ); ?>"><?php echo esc_html( $header_top_address_text ); ?></a></li>
                                                <?php endif;  ?>  
                                                <?php if(!empty($header_top_email)) : ?> 
                                        <li><i class="fa-solid fa-envelope"></i><a
                                                href="mailto:<?php echo esc_attr( $header_top_email ); ?>"><?php echo esc_html( $header_top_email ); ?></a></li>
                                                <?php endif;  ?> 
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif;  ?> 
                <!-- header-top-area-end -->

                <!-- header-area-start -->
                <div class="tp-header__area tp-header__space">
                    <div class="container-fluid">
                        <div class="row align-items-center">
                            <div class="col-xxl-6 col-xl-8 col-lg-8 d-none d-lg-block">
                                <div class="tp-header__main-menu">
                                    <nav class="tp-main-menu-content">
                                    <?php poorex_header_menu(); ?>
                                    </nav>
                                </div>
                            </div>
                            <?php if(!empty($poorex_header_right)) : ?>
                            <div class="col-xxl-6 col-xl-4 col-lg-4 col-12">
                                <div class="tp-header__right-action">
                                    <ul class="d-flex align-items-center justify-content-end">
                                        <li class="d-none d-xl-block">
                                            <div class="tp-header__icon-box">
                                            <?php  if ( !empty( $header_search_switch ) ): ?>
                                                <button class="search-open-btn"><i class="flaticon-loupe"></i></button>
                                                <?php endif;  ?> 
                                                <?php  if ( !empty( $header_auth_switch ) ): ?>
                                                <a href="<?php echo esc_url( $header_auth_link  );?>"><i class="flaticon-user"></i></a>
                                                <?php endif;  ?> 
                                            </div>
                                        </li>
                                        <?php  if ( !empty( $header_top_button_switch ) and !empty( $header_top_button_text ) ): ?>  
                                        <li>
                                            <div class="tp-header__btn d-none d-md-block">
                                                <a class="tp-btn" href="<?php echo esc_url( $header_top_button_link ); ?>"><?php echo esc_html( $header_top_button_text ); ?></a>
                                            </div>
                                        </li>
                                        <?php endif;  ?>   
                                        <li>
                                            <div class="tp-header-2__bar d-lg-none">
                                                <button class="tp-menu-bar" type="button"><span><i
                                                            class="fa-solid fa-bars-staggered"></i></span></button>
                                            </div>
                                        </li>
                                        <?php  if ( !empty( $header_top_phone ) ): ?> 
                                        <li>
                                            <div class="tp-header__tel-box d-flex align-items-center">
                                                <div class="tp-header__tel-icon">
                                                    <span><i class="flaticon-phone"></i></span>
                                                </div>
                                                <div class="tp-header__tel-text">
                                                    <span><?php echo esc_html__("Call Us Anytime","poorex") ?></span>
                                                    <a href="tel:<?php echo esc_html( $header_top_phone ); ?>"><?php echo esc_html( $header_top_phone ); ?></a>
                                                </div>
                                            </div>
                                        </li>
                                        <?php endif;  ?>   
                                    </ul>
                                </div>
                            </div>
                            <?php endif;  ?> 
                        </div>
                    </div>
                </div>
                <!-- header-area-end -->
            </div>
        </div>

    </header>
    <?php get_template_part( 'template-parts/header/header-side-info' ); ?>