<?php 

	/**
	 * Template part for displaying header layout two
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
	 *
	 * @package poorex
	*/

	 // info
    $poorex_topbar_switch = get_theme_mod( 'header_topbar_switch', false );


     // Phone Number
   $header_top_phone = get_theme_mod( 'header_phone', __( '+88 01310-069824', 'poorex' ) );

    // contact button
	$poorex_button_text = get_theme_mod( 'poorex_button_text', __( 'Make Request', 'poorex' ) );
   $poorex_button_link = get_theme_mod( 'poorex_button_link', __( '#', 'poorex' ) );

    // acc button
	$poorex_acc_button_text = get_theme_mod( 'poorex_acc_button_text', __( 'Login', 'poorex' ) );
   $poorex_acc_button_link = get_theme_mod( 'poorex_acc_button_link', __( '#', 'poorex' ) );

    $poorex_site_logo = get_theme_mod( 'logo', get_template_directory_uri() . '/assets/img/logo/logo-white.png' );

    
   // Button Text
   $header_top_button_switch = get_theme_mod( 'header_top_button_switch', false);
   $header_top_button_text = get_theme_mod( 'header_button_text', __( 'Donate Now', 'poorex' ) );

   // Button Text
   $header_top_button_link = get_theme_mod( 'header_button_link', __( '#', 'poorex' ) );
       // header right
   $poorex_header_right = get_theme_mod( 'header_right_switch', false );
   $poorex_menu_col = $poorex_header_right ? 'col-xl-7 col-lg-8 d-none d-lg-block' : 'col-xl-10 col-lg-8 d-none d-lg-block';
   $poorex_menu_end = $poorex_header_right ? '' : 'justify-content-end';
   // header search btn 
   $header_search_switch = get_theme_mod( 'header_search_switch', false );

   // header auth btn 
   $header_auth_switch = get_theme_mod( 'header_auth_switch', false );
   $header_auth_link = get_theme_mod( 'header_auth_link',"#" );

?>

<header class="tp-header-height">
        <div id="header-sticky" class="tp-header-2__area tp-header-2__transparent">
            <div class="container container-large">
                <div class="tp-header-2__plr">
                    <div class="row align-items-center">
                        <div class="col-xl-2 col-lg-6 col-md-4 col-7">
                            <div class="tp-header-2__logo">
                              <?php poorex_header_logo(); ?>
                            </div>
                        </div>
                        <div class="<?php echo esc_attr($poorex_menu_col);?>">
                            <div class="tp-header-2__main-menu">
                                <nav class="tp-main-menu-content">
                                    <?php poorex_header_menu(); ?>
                                </nav>
                            </div>
                        </div>
                        <?php if(!empty($poorex_header_right)) : ?>
                        <div class="col-xl-3 col-lg-6 col-md-8 col-5">
                            <div class="tp-header-2__right-box">
                                <div class="tp-header-2__right-action ">
                                    <ul>
                                        <li>
                                            <div class="tp-header-2__icon-box d-none d-md-block">
                                            <?php  if ( !empty( $header_search_switch ) ): ?>
                                                <button class="search-open-btn"><i class="flaticon-loupe"></i></button>
                                                <?php endif;  ?>    
                                                <?php  if ( !empty( $header_auth_switch ) ): ?>
                                                <a href="<?php echo esc_url( $header_auth_link  );?>"><i class="flaticon-user"></i></a>
                                                <?php endif;  ?>  
                                            </div>
                                        </li>
                                        <?php  if ( !empty( $header_top_button_switch ) and !empty( $header_top_button_text ) ): ?>  
                                        <li>
                                        <div class="tp-header-2__btn d-none d-md-block">
                                            <a class="tp-btn" href="<?php echo esc_url( $header_top_button_link ); ?>"><?php echo esc_html( $header_top_button_text ); ?></a>
                                        </div>
                                        </li>     
                                        <?php endif;  ?>                                      
                                        <li>
                                            <div class="tp-header-2__bar d-xl-none">
                                                <button class="tp-menu-bar"><i class="fa-solid fa-bars-staggered"></i></button>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <?php get_template_part( 'template-parts/header/header-side-info' ); ?>