<?php 

	/**
	 * Template part for displaying header layout one
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
	 *
	 * @package poorex
	*/

	// info
    $header_topbar_switch = get_theme_mod( 'header_topbar_switch', false );

   // Email id 
   $header_top_email = get_theme_mod( 'header_email', __( 'poorex@support.com', 'poorex' ) );

   // Phone Number
   $header_top_phone = get_theme_mod( 'header_phone', __( '+88 01310-069824', 'poorex' ) );

   // Header Address Text
   $header_top_address_text = get_theme_mod( 'header_address', __( '734 H, Bryan Burlington, NC 27215', 'poorex' ) );

   // Header charity Text
   $header_top_charity_text = get_theme_mod( 'header_top_charity_text', __( 'Connect with our charity', 'poorex' ) );

   // Header Address Link
   $header_top_address_link = get_theme_mod( 'header_address_link', __( '#', 'poorex' ) );

   // Button Text
   $header_top_button_switch = get_theme_mod( 'header_top_button_switch', false);
   $header_top_button_text = get_theme_mod( 'header_button_text', __( 'Donate Now', 'poorex' ) );

   // Button Text
   $header_top_button_link = get_theme_mod( 'header_button_link', __( '#', 'poorex' ) );

   $header_language_switch = get_theme_mod( 'header_language_switch', __( 'false', 'poorex' ) );


   // header right
   $poorex_header_right = get_theme_mod( 'header_right_switch', false );
   $poorex_menu_col = $poorex_header_right ? 'col-xl-7 col-lg-8 d-none d-lg-block' : 'col-xl-10 col-lg-8 d-none d-lg-block';
   $poorex_menu_end = $poorex_header_right ? '' : 'd-flex justify-content-end';

//    col-xl-7 d-none d-xl-block

   // header search btn 
   $header_search_switch = get_theme_mod( 'header_search_switch', true );

   // header auth btn 
   $header_auth_switch = get_theme_mod( 'header_auth_switch', true );
   $header_auth_link = get_theme_mod( 'header_auth_link',"#" );



?>


<header class="tp-header-height">
        <!-- header-top-area-start -->
        <?php if(!empty($header_topbar_switch)) : ?>
        <div class="tp-header-top-3__area grey-bg">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-6 col-lg-5 col-md-7 col-12 col-sm-12">
                        <div class="tp-header-top-3__left-box text-center text-md-start">
                            <ul>
                            <?php if(!empty($header_top_charity_text)) : ?>
                                <li><span><?php echo esc_html( $header_top_charity_text ); ?></span></li>
                            <?php endif;  ?> 
                                <li>
                                    <div class="tp-header-top-3__social">
                                    <?php poorex_header_social_profiles(); ?>
                                    </div>  
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-7 col-md-5">
                        <div class="tp-header-top-3__right-box text-end">
                            <ul>
                            <?php if(!empty($header_top_address_text)) : ?>
                                <li class="location"><i class="flaticon-map"></i><a target="_blank" href="<?php echo esc_url( $header_top_address_link ); ?>"><?php echo esc_html( $header_top_address_text ); ?></a></li>
                                <?php endif;  ?>  
                                <?php if(!empty($header_top_email)) : ?> 
                                <li class="email"><i class="flaticon-mail"></i><a href="mailto:<?php echo esc_attr( $header_top_email ); ?>"><?php echo esc_html( $header_top_email ); ?></a></li>
                                <?php endif;  ?> 
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif;  ?>  
        <!-- header-top-area-end -->
        
        <!-- header-area-start -->
        <div id="header-sticky" class="tp-header-3__area">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-2 col-lg-6 col-md-4 col-7">
                        <div class="tp-header-3__logo">
                        <?php poorex_header_logo(); ?>
                        </div>
                    </div>
                    <div class="<?php echo esc_attr($poorex_menu_col);?>">
                        <div class="tp-header-3__main-menu">
                            <nav class="tp-main-menu-content <?php echo esc_attr($poorex_menu_end);?>">
                            <?php poorex_header_menu(); ?>
                            </nav>
                        </div>
                        <div>
                    </div>
                    
                    </div>
                    <?php if(!empty($poorex_header_right)) : ?>
                    <div class="col-xl-3 col-lg-6 col-md-8 col-5">
                        <div class="tp-header-3__right-box">
                            <div class="tp-header-3__right-action text-end">
                                <ul class="d-flex align-items-center justify-content-end">
                                
                                    <li>
                                        <div class="tp-header-3__icon-box d-none d-md-block">
                                        <?php  if ( !empty( $header_search_switch ) ): ?>
                                            <button class="search-open-btn"><i class="flaticon-loupe"></i></button>
                                            <?php endif;  ?>    
                                            <?php  if ( !empty( $header_auth_switch ) ): ?>
                                            <a href="<?php echo esc_url( $header_auth_link  );?>"><i class="flaticon-user"></i></a>
                                            <?php endif;  ?>  
                                        </div>
                                    </li>    
                                    <?php  if ( !empty( $header_top_button_switch ) and !empty( $header_top_button_text ) ): ?>          
                                    <li>
                                        <div class="tp-header-3__btn d-none d-md-block">
                                            <a class="tp-btn" href="<?php echo esc_url( $header_top_button_link ); ?>"><?php echo esc_html( $header_top_button_text ); ?></a>
                                        </div>
                                    </li>  
                                    <?php endif;  ?>  
                                    <li>
                                        <div class="tp-header-3__bar d-xl-none">
                                            <button class="tp-menu-bar"><i class="fa-solid fa-bars-staggered"></i></button>
                                        </div>
                                    </li>                                  
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if(empty($poorex_header_right)) : ?>
                        <div class="col-xl-3 col-lg-6 col-md-8 col-5">
                        <div class="tp-header-3__bar d-xl-none">
                                 <button class="tp-menu-bar"><i class="fa-solid fa-bars-staggered"></i></button>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- header-area-end -->
    </header>
<?php get_template_part( 'template-parts/header/header-side-info' ); ?>