<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package poorex
 */

 $poorex_video_url = function_exists('tpmeta_field')? tpmeta_field('poorex_post_video') : '';
 $categories = get_the_terms( $post->ID, 'category' );
$poorex_blog_cat = get_theme_mod( 'poorex_blog_cat', false );

if ( is_single() ): 
?>

<article id="post-<?php the_ID();?>" <?php post_class( 'postbox__item format-video mb-75' );?>>
    <?php if ( has_post_thumbnail() ): ?>
    <div class="postbox__thumb postbox-video p-relative">
        <div class="postbox__thumb-text d-none d-md-block">
            <span><?php the_time( 'j F' ); ?></span>
        </div>
        <?php the_post_thumbnail( 'full', ['class' => 'img-responsive'] );?>
        <?php if ( !empty($poorex_video_url) ): ?>
        <div class="tp-video-play text-center postbox__play-btn text-center">
            <a class="popup-video popup-video pulse-btn" href="<?php echo esc_url($poorex_video_url); ?>"><i
                    class="fa-sharp fa-solid fa-play"></i></a>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <div class="postbox__content">
        <!-- blog meta -->
        <?php get_template_part( 'template-parts/blog/blog-meta' ); ?>
        <h3 class="postbox__title"><?php the_title();?></h3>

        <?php the_content();?>
        <?php
            wp_link_pages( [
                'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'poorex' ),
                'after'       => '</div>',
                'link_before' => '<span class="page-number">',
                'link_after'  => '</span>',
            ] );
        ?>
    </div>

    <div class="postbox__tags">
        <?php echo poorex_get_tag(); ?>
    </div>
</article>

<?php else: ?>

<article id="post-<?php the_ID();?>" <?php post_class( 'postbox__item mb-50 format-video' );?>>
    <?php if ( has_post_thumbnail() ): ?>
    <div class="postbox__thumb postbox-video p-relative">
        <div class="postbox__thumb-text d-none d-md-block">
                <span><?php the_time( 'j F' ); ?></span>
            </div>
        <a href="<?php the_permalink();?>">
            <?php the_post_thumbnail( 'full', ['class' => 'img-responsive'] );?>
        </a>
        <?php if ( !empty($poorex_video_url) ): ?>
        <div class="tp-video-play postbox__play-btn text-center">
            <a class="popup-video popup-video pulse-btn" href="<?php echo esc_url($poorex_video_url); ?>"><i
                    class="fa-sharp fa-solid fa-play"></i></a>
        </div>
        <?php endif; ?>
    </div>

    <?php endif; ?>

    <div class="postbox__content">
        <!-- blog meta -->
        <?php get_template_part( 'template-parts/blog/blog-meta' ); ?>

        <h3 class="postbox__title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>


        <div class="postbox__text">
            <?php the_excerpt();?>
        </div>

        <!-- blog btn -->
        <?php get_template_part( 'template-parts/blog/blog-btn' ); ?>
    </div>
</article>

<?php
endif;?>