<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package poorex
 */
$categories = get_the_terms( $post->ID, 'category' );
$poorex_blog_cat = get_theme_mod( 'poorex_blog_cat', false );
if ( is_single() ) : ?>

<article id="post-<?php the_ID();?>" <?php post_class( 'postbox__item format-image mb-75' );?>>
    <?php if ( has_post_thumbnail() ): ?>
    <div class="postbox__thumb">
    <div class="postbox__thumb-text d-none d-md-block">
                <span><?php the_time( 'j F' ); ?></span>
            </div>
        <?php the_post_thumbnail( 'full', ['class' => 'img-responsive'] );?>
    </div>
    <?php endif;?>

    <div class="postbox__content">
        <!-- blog meta -->
        <?php get_template_part( 'template-parts/blog/blog-meta' ); ?>
        <h3 class="postbox__title"><?php the_title();?></h3>
        <?php the_content();?>
        <?php
            wp_link_pages( [
                'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'poorex' ),
                'after'       => '</div>',
                'link_before' => '<span class="page-number">',
                'link_after'  => '</span>',
            ] );
        ?>
    </div>

    <div class="postbox-tags">
        <?php echo poorex_get_tag(); ?>
    </div>
</article>

<?php else: ?>

<article id="post-<?php the_ID();?>" <?php post_class( 'postbox__item mb-60 format-image transition-3' );?>>
    <?php if ( has_post_thumbnail() ): ?>
    <div class="postbox__thumb">
    <div class="postbox__thumb-text d-none d-md-block">
                <span><?php the_time( 'j F' ); ?></span>
            </div>
        <a href="<?php the_permalink();?>">
            <?php the_post_thumbnail( 'full', ['class' => 'img-responsive'] );?>
        </a>
    </div>
    <?php endif; ?>

    <div class="postbox__content">
        <!-- blog meta -->
        <?php get_template_part( 'template-parts/blog/blog-meta' ); ?>

        <h3 class="postbox__title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>

        <div class="postbox__text">
            <?php the_excerpt();?>
        </div>

        <!-- blog btn -->
        <?php get_template_part( 'template-parts/blog/blog-btn' ); ?>
    </div>
</article>
<?php endif;?>