<?php


new \Kirki\Panel(
    'panel_id',
    [
        'priority'    => 10,
        'title'       => esc_html__( 'Poorex Panel', 'poorex' ),
        'description' => esc_html__( 'Poorex Panel Description.', 'poorex' ),
    ]
);

// header_top_section
function header_top_section(){
    // header_top_bar section 
    new \Kirki\Section(
        'header_top_section',
        [
            'title'       => esc_html__( 'Header Info', 'poorex' ),
            'description' => esc_html__( 'Header Section Information.', 'poorex' ),
            'panel'       => 'panel_id',
            'priority'    => 100,
        ]
    );
    // header_top_bar section 

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'poorex_header_elementor_switch',
            'label'       => esc_html__( 'Header Custom/Elementor Switch', 'poorex' ),
            'description' => esc_html__( 'Header Custom/Elementor On/Off', 'poorex' ),
            'section'     => 'header_top_section',
            'default'     => 'off',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    ); 

    new \Kirki\Field\Radio_Image(
        [
            'settings'    => 'header_layout_custom',
            'label'       => esc_html__( 'Chose Header Style', 'poorex' ),
            'section'     => 'header_top_section',
            'priority'    => 10,
            'choices'     => [
                'header_1'   => get_template_directory_uri() . '/inc/img/header/header-1.png',
                'header_2' => get_template_directory_uri() . '/inc/img/header/header-2.png',
                'header_3'  => get_template_directory_uri() . '/inc/img/header/header-3.png'
            ],
            'default'     => 'header_1',
            'active_callback' => [
                [
                    'setting' => 'poorex_header_elementor_switch',
                    'operator' => '==',
                    'value' => false
                ]
            ]
        ]
    );

    $header_posttype = array(
        'post_type'      => 'tp-header'
    );
    $header_posttype_loop = get_posts($header_posttype);
    $header_post_obj_arr = array();
    foreach($header_posttype_loop as $post){
        $header_post_obj_arr[$post->ID] = $post->post_title;
    }

    wp_reset_postdata();


    new \Kirki\Field\Select(
        [
            'settings'    => 'poorex_header_templates',
            'label'       => esc_html__( 'Elementor Header Template', 'poorex' ),
            'section'     => 'header_top_section',
            'placeholder' => esc_html__( 'Choose an option', 'poorex' ),
            'choices'     => $header_post_obj_arr,
            'active_callback' => [
                [
                    'setting' => 'poorex_header_elementor_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'header_topbar_switch',
            'label'       => esc_html__( 'Header Topbar Switch', 'poorex' ),
            'description' => esc_html__( 'Header Topbar switch On/Off', 'poorex' ),
            'section'     => 'header_top_section',
            'default'     => 'off',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    );    

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'header_right_switch',
            'label'       => esc_html__( 'Header Right Switch', 'poorex' ),
            'description' => esc_html__( 'Header Right switch On/Off', 'poorex' ),
            'section'     => 'header_top_section',
            'default'     => 'off',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    ); 

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'header_preloader_switch',
            'label'       => esc_html__( 'Header Preloader Switch', 'poorex' ),
            'description' => esc_html__( 'Header Preloader switch On/Off', 'poorex' ),
            'section'     => 'header_top_section',
            'default'     => 'off',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'header_search_switch',
            'label'       => esc_html__( 'Header Search Switch', 'poorex' ),
            'description' => esc_html__( 'Header Search switch On/Off', 'poorex' ),
            'section'     => 'header_top_section',
            'default'     => 'off',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    ); 

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'header_auth_switch',
            'label'       => esc_html__( 'Header Auth Switch', 'poorex' ),
            'description' => esc_html__( 'Header Auth switch On/Off', 'poorex' ),
            'section'     => 'header_top_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    ); 


    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'header_backtotop_switch',
            'label'       => esc_html__( 'Header Back to Top Switch', 'poorex' ),
            'description' => esc_html__( 'Header Back to Top switch On/Off', 'poorex' ),
            'section'     => 'header_top_section',
            'default'     => 'off',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'header_top_button_switch',
            'label'       => esc_html__( 'Header Top Button On/Off', 'poorex' ),
            'description' => esc_html__( 'Header Top Button switch On/Off', 'poorex' ),
            'section'     => 'header_top_section',
            'default'     => 'off',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    );
    

    new \Kirki\Field\Text(
        [
            'settings' => 'header_button_text',
            'label'    => esc_html__( 'Button Text', 'poorex' ),
            'section'  => 'header_top_section',
            'default'  => esc_html__( 'Donate Now ', 'poorex' ),
            'priority' => 10,
        ]
    );

    new \Kirki\Field\URL(
        [
            'settings' => 'header_button_link',
            'label'    => esc_html__( 'Button URL', 'poorex' ),
            'section'  => 'header_top_section',
            'default'  => '#',
            'priority' => 10,
        ]
    );

    new \Kirki\Field\URL(
        [
            'settings' => 'header_auth_link',
            'label'    => esc_html__( 'Header Auth Link', 'poorex' ),
            'section'  => 'header_top_section',
            'default'  => '#',
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Text(
        [
            'settings' => 'header_phone',
            'label'    => esc_html__( 'Phone Number', 'poorex' ),
            'section'  => 'header_top_section',
            'default'  => esc_html__( '+88 01310-069824', 'poorex' ),
            'priority' => 10,
        ]
    );    

    new \Kirki\Field\Text(
        [
            'settings' => 'header_email',
            'label'    => esc_html__( 'Email ID', 'poorex' ),
            'section'  => 'header_top_section',
            'default'  => esc_html__( 'poorex@support.com', 'poorex' ),
            'priority' => 10,
        ]
    );    

    new \Kirki\Field\Text(
        [
            'settings' => 'header_top_charity_text',
            'label'    => esc_html__( 'Charity Text', 'poorex' ),
            'section'  => 'header_top_section',
            'default'  => esc_html__( 'Connect with our charity', 'poorex' ),
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Text(
        [
            'settings' => 'header_address',
            'label'    => esc_html__( 'Address Text', 'poorex' ),
            'section'  => 'header_top_section',
            'default'  => esc_html__( '734 H, Bryan Burlington, NC 27215', 'poorex' ),
            'priority' => 10,
        ]
    );

    new \Kirki\Field\URL(
        [
            'settings' => 'header_address_link',
            'label'    => esc_html__( 'Address URL', 'poorex' ),
            'section'  => 'header_top_section',
            'default'  => 'https://www.google.com/maps/@36.0758266,-79.4558848,17z',
            'priority' => 10,
        ]
    );



}
header_top_section();


// header_side_section
function header_side_section(){
    // header_top_bar section 
    new \Kirki\Section(
        'header_side_section',
        [
            'title'       => esc_html__( 'Header Side Info', 'poorex' ),
            'description' => esc_html__( 'Header Side Information.', 'poorex' ),
            'panel'       => 'panel_id',
            'priority'    => 110,
        ]
    );
    // header_side_section section 

    // header_side_logo_section 
    new \Kirki\Field\Image(
        [
            'settings'    => 'header_side_logo',
            'label'       => esc_html__( 'Header Side Logo', 'poorex' ),
            'description' => esc_html__( 'Header Sid Default/Primary Logo Here', 'poorex' ),
            'section'     => 'header_side_section',
            'default'     => get_template_directory_uri() . '/assets/img/logo/footer-1.png',
        ]
    );

    new \Kirki\Field\Textarea(
        [
            'settings'    => 'header_top_offcanvas_textarea',
            'label'       => esc_html__( 'Offcanvas About Us', 'poorex' ),
            'section'     => 'header_side_section',
            'default'     => esc_html__( 'Web designing in a powerful way of just not an only professions. We have tendency to believe the idea that smart looking .', 'poorex' ),
        ]
    );

    // Contacts Text 
    new \Kirki\Field\Text(
        [
            'settings' => 'header_side_contacts_text',
            'label'    => esc_html__( 'Contacts Text', 'poorex' ),
            'section'  => 'header_side_section',
            'default'  => esc_html__( 'CONTACT US', 'poorex' ),
            'priority' => 10,
        ]
    );

}
header_side_section();

// header_social_section
function header_social_section(){
    // header_top_bar section 
    new \Kirki\Section(
        'header_social_section',
        [
            'title'       => esc_html__( 'Social Area', 'poorex' ),
            'description' => esc_html__( 'Social URL.', 'poorex' ),
            'panel'       => 'panel_id',
            'priority'    => 120,
        ]
    );
    // header_top_bar section 

    new \Kirki\Field\URL(
        [
            'settings' => 'header_facebook_link',
            'label'    => esc_html__( 'Facebook URL', 'poorex' ),
            'section'  => 'header_social_section',
            'default'  => '#',
            'priority' => 10,
        ]
    ); 

    new \Kirki\Field\URL(
        [
            'settings' => 'header_twitter_link',
            'label'    => esc_html__( 'Twitter URL', 'poorex' ),
            'section'  => 'header_social_section',
            'default'  => '#',
            'priority' => 10,
        ]
    );  

    new \Kirki\Field\URL(
        [
            'settings' => 'header_linkedin_link',
            'label'    => esc_html__( 'Linkedin URL', 'poorex' ),
            'section'  => 'header_social_section',
            'default'  => '#',
            'priority' => 10,
        ]
    ); 

    new \Kirki\Field\URL(
        [
            'settings' => 'header_instagram_link',
            'label'    => esc_html__( 'Instagram URL', 'poorex' ),
            'section'  => 'header_social_section',
            'default'  => '#',
            'priority' => 10,
        ]
    );  

    new \Kirki\Field\URL(
        [
            'settings' => 'header_youtube_link',
            'label'    => esc_html__( 'Youtube URL', 'poorex' ),
            'section'  => 'header_social_section',
            'default'  => '#',
            'priority' => 10,
        ]
    );  

    new \Kirki\Field\URL(
        [
            'settings' => 'header_fb_link',
            'label'    => esc_html__( 'Facebook URL', 'poorex' ),
            'section'  => 'header_social_section',
            'default'  => '#',
            'priority' => 10,
        ]
    );  

}
header_social_section();

// header_logo_section
function header_logo_section(){
    // header_logo_section section 
    new \Kirki\Section(
        'header_logo_section',
        [
            'title'       => esc_html__( 'Header Logo', 'poorex' ),
            'description' => esc_html__( 'Header Logo Settings.', 'poorex' ),
            'panel'       => 'panel_id',
            'priority'    => 130,
        ]
    );

    // header_logo_section section 
    new \Kirki\Field\Image(
        [
            'settings'    => 'header_logo',
            'label'       => esc_html__( 'Header Logo', 'poorex' ),
            'description' => esc_html__( 'Theme Default/Primary Logo Here', 'poorex' ),
            'section'     => 'header_logo_section',
            'default'     => get_template_directory_uri() . '/assets/img/logo/logo.png',
        ]
    );
    new \Kirki\Field\Image(
        [
            'settings'    => 'header_secondary_logo',
            'label'       => esc_html__( 'Header Secondary Logo', 'poorex' ),
            'description' => esc_html__( 'Theme Secondary Logo Here', 'poorex' ),
            'section'     => 'header_logo_section',
            'default'     => get_template_directory_uri() . '/assets/img/logo/logo-2.png',
        ]
    );

    new \Kirki\Field\Image(
        [
            'settings'    => 'header_search_logo',
            'label'       => esc_html__( 'Header Search Logo', 'poorex' ),
            'description' => esc_html__( 'Theme Search Logo Here', 'poorex' ),
            'section'     => 'header_logo_section',
            'default'     => get_template_directory_uri() . '/assets/img/logo/footer-1.png',
        ]
    );

}
header_logo_section();


// header_logo_section
function header_breadcrumb_section(){
    // header_logo_section section 
    new \Kirki\Section(
        'header_breadcrumb_section',
        [
            'title'       => esc_html__( 'Breadcrumb', 'poorex' ),
            'description' => esc_html__( 'Breadcrumb Settings.', 'poorex' ),
            'panel'       => 'panel_id',
            'priority'    => 160,
        ]
    );

    // header_logo_section section 
    new \Kirki\Field\Image(
        [
            'settings'    => 'breadcrumb_image',
            'label'       => esc_html__( 'Breadcrumb Image', 'poorex' ),
            'description' => esc_html__( 'Breadcrumb Image add/remove', 'poorex' ),
            'section'     => 'header_breadcrumb_section',
        ]
    );

    // header_breadcrumb_shape_switch
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'breadcrumb_shape_switch',
            'label'       => esc_html__( 'Bradecrumb Shape Switch', 'poorex' ),
            'description' => esc_html__( 'Bradecrumb Shape On/Off', 'poorex' ),
            'section'     => 'header_breadcrumb_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings'    => 'breadcrumb_bg_color',
            'label'       => __( 'Breadcrumb BG Color', 'poorex' ),
            'description' => esc_html__( 'You can change breadcrumb bg color from here.', 'poorex' ),
            'section'     => 'header_breadcrumb_section',
            'default'     => '#f3fbfe',
        ]
    );

    new \Kirki\Field\Dimensions(
        [
            'settings'    => 'breadcrumb_padding',
            'label'       => esc_html__( 'Dimensions Control', 'poorex' ),
            'description' => esc_html__( 'Description', 'poorex' ),
            'section'     => 'header_breadcrumb_section',
            'default'     => [
                'padding-top'  => '',
                'padding-bottom' => '',
            ],
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings'    => 'breadcrumb_typography',
            'label'       => esc_html__( 'Typography Control', 'poorex' ),
            'description' => esc_html__( 'The full set of options.', 'poorex' ),
            'section'     => 'header_breadcrumb_section',
            'priority'    => 10,
            'transport'   => 'auto',
            'default'     => [
                'font-family'     => '',
                'variant'         => '',
                'color'           => '',
                'font-size'       => '',
                'line-height'     => '',
                'text-align'      => '',
            ],
            'output'      => [
                [
                    'element' => '.tpbreadcrumb-title',
                ],
            ],
        ]
    );


}
header_breadcrumb_section();

// header_logo_section
function full_site_typography(){
    // header_logo_section section 
    new \Kirki\Section(
        'full_site_typography',
        [
            'title'       => esc_html__( 'Typography', 'poorex' ),
            'description' => esc_html__( 'Typography Settings.', 'poorex' ),
            'panel'       => 'panel_id',
            'priority'    => 190,
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings'    => 'full_site_typography_settings',
            'label'       => esc_html__( 'Typography Control', 'poorex' ),
            'description' => esc_html__( 'The full set of options.', 'poorex' ),
            'section'     => 'full_site_typography',
            'priority'    => 10,
            'transport'   => 'auto',
            'default'     => [
                'font-family'     => '',
                'variant'         => '',
                'color'           => '',
                'font-size'       => '',
                'line-height'     => '',
                'text-align'      => '',
            ],
            'output'      => [
                [
                    'element' => '.tpbreadcrumb-title',
                ],
            ],
        ]
    );
}
full_site_typography();

// header_logo_section
function footer_layout_section(){
    // header_logo_section section 
    new \Kirki\Section(
        'footer_layout_section',
        [
            'title'       => esc_html__( 'Footer', 'poorex' ),
            'description' => esc_html__( 'Footer Settings.', 'poorex' ),
            'panel'       => 'panel_id',
            'priority'    => 190,
        ]
    );
    // footer_widget_number section 
    new \Kirki\Field\Select(
        [
            'settings'    => 'footer_widget_number',
            'label'       => esc_html__( 'Footer Widget Number', 'poorex' ),
            'section'     => 'footer_layout_section',
            'default'     => '4',
            'placeholder' => esc_html__( 'Choose an option', 'poorex' ),
            'choices'     => [
                '1' => esc_html__( '1', 'poorex' ),
                '2' => esc_html__( '2', 'poorex' ),
                '3' => esc_html__( '3', 'poorex' ),
                '4' => esc_html__( '4', 'poorex' ),
            ],
        ]
    );


    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'poorex_footer_elementor_switch',
            'label'       => esc_html__( 'Footer Custom/Elementor Switch', 'poorex' ),
            'description' => esc_html__( 'Footer Custom/Elementor On/Off', 'poorex' ),
            'section'     => 'footer_layout_section',
            'default'     => 'off',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    ); 

    new \Kirki\Field\Radio_Image(
        [
            'settings'    => 'footer_layout',
            'label'       => esc_html__( 'Footer Layout Control', 'poorex' ),
            'section'     => 'footer_layout_section',
            'priority'    => 10,
            'choices'     => [
                'footer_1'   => get_template_directory_uri() . '/inc/img/footer/footer-1.png',
                'footer_2' => get_template_directory_uri() . '/inc/img/footer/footer-2.png',
            ],
            'default'     => 'footer_1',
            'active_callback' => [
                [
                    'setting' => 'poorex_footer_elementor_switch',
                    'operator' => '==',
                    'value' => false
                ]
            ]
        ]
    );

    $footer_posttype = array(
        'post_type'      => 'tp-footer'
    );
    $footer_posttype_loop = get_posts($footer_posttype);
    $footer_post_obj_arr = array();
    foreach($footer_posttype_loop as $post){
        $footer_post_obj_arr[$post->ID] = $post->post_title;
    }

    wp_reset_postdata();

    new \Kirki\Field\Select(
        [
            'settings'    => 'poorex_footer_templates',
            'label'       => esc_html__( 'Elementor Footer Template', 'poorex' ),
            'section'     => 'footer_layout_section',
            'placeholder' => esc_html__( 'Choose an option', 'poorex' ),
            'choices'     => $footer_post_obj_arr,
            'active_callback' => [
                [
                    'setting' => 'poorex_footer_elementor_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );



    // footer_layout_section section 
    new \Kirki\Field\Image(
        [
            'settings'    => 'footer_bg_image',
            'label'       => esc_html__( 'Footer BG Image', 'poorex' ),
            'description' => esc_html__( 'Footer Image add/remove', 'poorex' ),
            'section'     => 'footer_layout_section',
        ]
    );

    // footer_layout_section section 
    new \Kirki\Field\Image(
        [
            'settings'    => 'footer_logo_image',
            'label'       => esc_html__( 'Footer Logo Image', 'poorex' ),
            'description' => esc_html__( 'Footer Logo add/remove', 'poorex' ),
            'section'     => 'footer_layout_section',
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings'    => 'footer_bg_color',
            'label'       => __( 'Footer BG Color', 'poorex' ),
            'description' => esc_html__( 'You can change footer bg color from here.', 'poorex' ),
            'section'     => 'footer_layout_section',
            'default'     => '',
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'footer_layout_2_switch',
            'label'       => esc_html__( 'Footer Style 2 Switch', 'poorex' ),
            'description' => esc_html__( 'Footer Style 2 On/Off', 'poorex' ),
            'section'     => 'footer_layout_section',
            'default'     => 'off',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'poorex' ),
                'off' => esc_html__( 'Disable', 'poorex' ),
            ],
        ]
    );      


    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'footer_copyright_switch',
            'label'       => esc_html__( 'Footer Copyright On/Off', 'poorex' ),
            'section'     => 'footer_layout_section',
            'default'     => true,
            'priority' => 10,
        ]
    ); 

    new \Kirki\Field\Text(
        [
            'settings' => 'footer_copyright',
            'label'    => esc_html__( 'Footer Copyright', 'poorex' ),
            'section'  => 'footer_layout_section',
            'default'  => esc_html__( 'Copyright &copy; 2025 Theme_Pure. All Rights Reserved', 'poorex' ),
            'priority' => 10,
        ]
    );  


    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'footer_social_switch',
            'label'       => esc_html__( 'Footer Social On / Off', 'poorex' ),
            'section'     => 'footer_layout_section',
            'default'     => false,
            'priority' => 10,
        ]
    ); 


  new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'footer_bottom_copyright_area_switch',
            'label'       => esc_html__( 'Footer Bottom  Copyright Area On/Off', 'poorex' ),
            'section'     => 'footer_layout_section',
            'default'     => true,
            'priority' => 10,
        ]
    ); 

}
footer_layout_section();

// blog_section
function blog_section(){
    // blog_section section 
    new \Kirki\Section(
        'blog_section',
        [
            'title'       => esc_html__( 'Blog Section', 'poorex' ),
            'description' => esc_html__( 'Blog Section Settings.', 'poorex' ),
            'panel'       => 'panel_id',
            'priority'    => 150,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'poorex_blog_btn_switch',
            'label'       => esc_html__( 'Blog BTN On/Off', 'poorex' ),
            'section'     => 'blog_section',
            'default'     => true,
            'priority' => 10,
        ]
    ); 

    // blog_section BTN 
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'poorex_blog_cat',
            'label'    => esc_html__( 'Blog Category Meta On/Off', 'poorex' ),
            'section'  => 'blog_section',
            'default'  => false,
            'priority' => 10,
        ]
    );

    // blog_section Author Meta 
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'poorex_blog_author',
            'label'    => esc_html__( 'Blog Author Meta On/Off', 'poorex' ),
            'section'  => 'blog_section',
            'default'  => true,
            'priority' => 10,
        ]
    );
    // blog_section Date Meta 
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'poorex_blog_date',
            'label'    => esc_html__( 'Blog Date Meta On/Off', 'poorex' ),
            'section'  => 'blog_section',
            'default'  => true,
            'priority' => 10,
        ]
    );

    // blog_section Comments Meta 
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'poorex_blog_comments',
            'label'    => esc_html__( 'Blog Comments Meta On/Off', 'poorex' ),
            'section'  => 'blog_section',
            'default'  => true,
            'priority' => 10,
        ]
    );


    // blog_section Blog BTN text 
    new \Kirki\Field\Text(
        [
            'settings' => 'poorex_blog_btn',
            'label'    => esc_html__( 'Blog Button Text', 'poorex' ),
            'section'  => 'blog_section',
            'default'  => "Read More",
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'poorex_singleblog_social',
            'label'    => esc_html__( 'Single Blog Social Share', 'poorex' ),
            'section'  => 'blog_section',
            'default'  => false,
            'priority' => 10,
        ]
    );

}
blog_section();


// 404 section
function error_404_section(){
    // 404_section section 
    new \Kirki\Section(
        'error_404_section',
        [
            'title'       => esc_html__( '404 Page', 'poorex' ),
            'description' => esc_html__( '404 Page Settings.', 'poorex' ),
            'panel'       => 'panel_id',
            'priority'    => 150,
        ]
    );


    // 404_section 
    new \Kirki\Field\Text(
        [
            'settings' => 'poorex_error_title',
            'label'    => esc_html__( 'Not Found Title', 'poorex' ),
            'section'  => 'error_404_section',
            'default'  => "Sorry We Can't Find That Page! ",
            'priority' => 10,
        ]
    );

    // 404_section Image
    new \Kirki\Field\Image(
        [
            'settings'    => 'error_404_image',
            'label'       => esc_html__( 'Error 404 Image', 'poorex' ),
            'description' => esc_html__( 'Error 404 Image Add / Remove', 'poorex' ),
            'section'     => 'error_404_section',
            'default'     => get_template_directory_uri() . '/assets/img/error/error.png',
        ]
    );


    // 404_section description
    new \Kirki\Field\Text(
        [
            'settings' => 'poorex_error_link_text',
            'label'    => esc_html__( 'Error Link Text', 'poorex' ),
            'section'  => 'error_404_section',
            'default'  => "Back To Home",
            'priority' => 10,
        ]
    );


}
error_404_section();

// theme color section
function theme_color_section(){
    new \Kirki\Section(
        'theme_color_section',
        [
            'title'       => esc_html__( 'Theme Color', 'poorex' ),
            'description' => esc_html__( 'Poorex theme color Settings.', 'poorex' ),
            'panel'       => 'panel_id',
            'priority'    => 150,
        ]
    );
    new \Kirki\Field\Color(
        [
            'settings'    => 'poorex_color_1',
            'label'       => __( 'Theme Color 1', 'poorex' ),
            'description' => esc_html__( 'this is theme color 1 control.', 'poorex' ),
            'section'     => 'theme_color_section',
            'default'     => '#1e3737',
        ]
    );
    new \Kirki\Field\Color(
        [
            'settings'    => 'poorex_color_2',
            'label'       => __( 'Theme Color 2', 'poorex' ),
            'description' => esc_html__( 'this is theme color 2 control.', 'poorex' ),
            'section'     => 'theme_color_section',
            'default'     => '#07847f',
        ]
    );
    new \Kirki\Field\Color(
        [
            'settings'    => 'poorex_color_3',
            'label'       => __( 'Theme Color 3', 'poorex' ),
            'description' => esc_html__( 'this is theme color 3 control.', 'poorex' ),
            'section'     => 'theme_color_section',
            'default'     => '#8fe1de',
        ]
    );
    new \Kirki\Field\Color(
        [
            'settings'    => 'poorex_color_4',
            'label'       => __( 'Theme Color 4', 'poorex' ),
            'description' => esc_html__( 'this is theme color 4 control.', 'poorex' ),
            'section'     => 'theme_color_section',
            'default'     => '#fe7f4c',
        ]
    );
}
theme_color_section();