<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package poorex
 */
$poorex_error_title = get_theme_mod('poorex_error_title', __("Sorry We Can't Find That Page! ", 'poorex'));
$poorex_error_link_text = get_theme_mod('poorex_error_link_text', __('Back To Home', 'poorex'));
$error_404_image = get_theme_mod('error_404_image', get_template_directory_uri() . '/assets/img/error/error.png');


get_header();
?>
<div class="tp-error__area pt-120 pb-120">
   <div class="container">
         <div class="row">
            <div class="col-xl-12">
               <div class="tp-error__box text-center">
                     <div class="tp-error__thumb">
                        <img src="<?php print esc_url( $error_404_image );?>" alt="<?php print esc_attr__( 'Error 404', 'poorex' );?>">
                     </div>
                     <div class="tp-error__text">
                        <h4 class="tp-error__title"><?php print esc_html($poorex_error_title);?></h4>
                     </div>
                     <div class="tp-error__form-box">
                        <form method="get" action="<?php print esc_url( home_url( '/' ) );?>">
                           <input type="text" name="s" value="<?php print esc_attr( get_search_query() )?>"  placeholder="<?php print esc_attr__( 'Search here', 'poorex' );?>">
                           <button class="tp-error__search-box"><i class="flaticon-loupe"></i></button>
                        </form>
                     </div>
                     <div class="tp-error__btn">                                
                        <a class="tp-btn" href="<?php print esc_url(home_url('/'));?>"><?php print esc_html($poorex_error_link_text);?></a>
                     </div>
               </div>
            </div>
         </div>
   </div>
</div>

<?php
get_footer();
