<?php 

   /**
    * Template part for displaying header side information
    *
    * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
    *
    * @package poorex
   */

    $header_side_logo = get_theme_mod( 'header_side_logo', get_template_directory_uri() . '/assets/img/logo/footer-1.png' );

    // Contacts Text 
    $header_side_contacts_text = get_theme_mod( 'header_side_contacts_text', __( 'CONTACT US', 'poorex' ) );

    // Contacts Text 
    $header_side_contacts_text = get_theme_mod( 'header_side_contacts_text', __( 'CONTACT US', 'poorex' ) );
   // Email id 
   $header_top_email = get_theme_mod( 'header_email', __( 'poorex@support.com', 'poorex' ) );

   // Phone Number
   $header_top_phone = get_theme_mod( 'header_phone', __( '+88 01310-069824', 'poorex' ) );

   // Header Address Text
   $header_top_address_text = get_theme_mod( 'header_address', __( '734 H, Bryan Burlington, NC 27215', 'poorex' ) );

   // Header Address Link
   $header_top_address_link = get_theme_mod( 'header_address_link', __( 'https://www.google.com/maps/@36.0758266,-79.4558848,17z', 'poorex' ) );


   //Offcanvas About Us
   $offcanvas_about_us = get_theme_mod( 'header_top_offcanvas_textarea', __( 'Web designing in a powerful way of just not an only professions. We have tendency to believe the idea that smart looking .', 'poorex' ) );



  

   $gallery_repeater = get_theme_mod( 'header_side_gallery_repeater');

?>

<div class="tpoffcanvas-area">
        <div class="tpoffcanvas">
            <div class="tpoffcanvas__close-btn">
                <button class="close-btn"><i class="fal fa-times"></i></button>
            </div>
            <div class="tpoffcanvas__logo">
                <a href="<?php print esc_url( home_url( '/' ) );?>">
                    <img src="<?php echo esc_url( $header_side_logo ); ?>">
                </a>
            </div>
            <?php  if ( !empty( $offcanvas_about_us ) ): ?>
            <div class="tpoffcanvas__title">
                <p><?php echo esc_html( $offcanvas_about_us ); ?></p>
            </div>
            <?php endif;  ?> 
            <div class="tp-main-menu-mobile d-xl-none"></div>
            <div class="tpoffcanvas__contact-info">
            <?php  if ( !empty( $header_side_contacts_text ) ): ?>
                <div class="tpoffcanvas__contact-title">
                    <h5><?php echo esc_html( $header_side_contacts_text ); ?></h5>
                </div>
                <?php endif;  ?> 
                <ul>
                <?php  if ( !empty( $header_top_address_text ) ): ?>
                    <li>
                        <i class="fa-light fa-location-dot"></i>
                        <a href="<?php echo esc_url( $header_top_address_link ); ?>" target="_blank"><?php echo esc_html( $header_top_address_text ); ?></a>
                    </li>
                    <?php endif;  ?> 
                    <?php  if ( !empty( $header_top_email ) ): ?>
                    <li>
                        <i class="fas fa-envelope"></i>
                        <a href="mailto:<?php echo esc_attr( $header_top_email ); ?>"><?php echo esc_html( $header_top_email ); ?></a>
                    </li>
                    <?php endif;  ?>
                    <?php  if ( !empty(  $header_top_phone ) ): ?>
                    <li>
                        <i class="fal fa-phone-alt"></i>
                        <a href="tel:<?php echo esc_attr( $header_top_phone ); ?>"><?php echo esc_html( $header_top_phone ); ?></a>
                    </li>
                    <?php endif;  ?>
                </ul>
            </div>
            <div class="tpoffcanvas__input">
                <div class="tpoffcanvas__input-title">
                    <h4><?php echo esc_html__("Get UPdate","poorex") ?></h4>
                </div>
                <form action="<?php print esc_url( home_url( '/' ) );?>">
                    <div class="p-relative">
                        <input type="text" placeholder="Enter mail">
                        <button>
                            <i class="fas fa-paper-plane"></i>
                        </button>
                    </div>
                </form>
            </div>
            <div class="tpoffcanvas__social">
                <div class="social-icon">
                <?php poorex_header_social_profiles(); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="body-overlay"></div>