<?php 

/**
 * Template part for displaying footer layout three
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package poorex
*/

    $footer_bg_img = get_theme_mod( 'footer_bg_image' );
    $poorex_footer_logo = get_theme_mod( 'poorex_footer_logo' );
    $poorex_footer_top_space = function_exists('tpmeta_field') ? tpmeta_field('poorex_footer_top_space') : '0';
    $poorex_copyright_center = $poorex_footer_logo ? 'col-lg-4 offset-lg-4 col-md-6 text-right' : 'col-lg-12 text-center';
    $poorex_footer_bg_url_from_page = function_exists( 'tpmeta_image_field' ) ? tpmeta_image_field( 'poorex_footer_bg_image' ) : '';
    $poorex_footer_bg_color_from_page = function_exists( 'tpmeta_field' ) ? tpmeta_field( 'poorex_footer_bg_color' ) : '';
    $footer_bg_color = get_theme_mod( 'footer_bg_color' );
    $footer_copyright_switch = get_theme_mod( 'footer_copyright_switch', true );
    $footer_bottom_copyright_area_switch = get_theme_mod( 'footer_bottom_copyright_area_switch', true );

    // bg image
    $bg_img = !empty( $poorex_footer_bg_url_from_page['url'] ) ? $poorex_footer_bg_url_from_page['url'] : $footer_bg_img;

    // bg color
    $bg_color = !empty( $poorex_footer_bg_color_from_page ) ? $poorex_footer_bg_color_from_page : $footer_bg_color;
 


    $footer_social_switch = get_theme_mod( 'footer_social_switch', false );

    // footer_columns
    $footer_columns = 0;
    $footer_widgets = get_theme_mod( 'footer_widget_number', 4 );

    for ( $num = 1; $num <= $footer_widgets + 1; $num++ ) {
        if ( is_active_sidebar( 'footer-2-' . $num ) ) {
            $footer_columns++;
        }
    }

    switch ( $footer_columns ) {
    case '1':
        $footer_class[1] = 'col-lg-12';
        break;
    case '2':
        $footer_class[1] = 'col-lg-6 col-md-6';
        $footer_class[2] = 'col-lg-6 col-md-6';
        break;
    case '3':
        $footer_class[1] = 'col-xl-4 col-lg-6 col-md-5';
        $footer_class[2] = 'col-xl-4 col-lg-6 col-md-7';
        $footer_class[3] = 'col-xl-4 col-lg-6';
        break;
    case '4':
        $footer_class[1] = 'col-xxl-4 col-xl-4 col-lg-4 col-md-6 col-sm-7';
        $footer_class[2] = 'col-xxl-2 col-xl-2 col-lg-2 col-md-3 col-sm-5';
        $footer_class[3] = 'col-xxl-3 col-xl-2 col-lg-2 col-md-3 col-sm-5';
        $footer_class[4] = 'col-xxl-3 col-xl-4 col-lg-4 col-md-6 col-sm-7';
        break;
    case '5':
        $footer_class[1] = 'col-xl-2 col-lg-2 col-md-3 col-sm-4';
        $footer_class[2] = 'col-xl-2 col-lg-2 col-md-3 col-sm-4 col-6';
        $footer_class[3] = 'col-xl-2 col-lg-2 col-md-3 col-sm-4 col-6';
        $footer_class[4] = 'col-xl-2 col-lg-2 col-md-3 col-sm-4 col-6';
        $footer_class[5] = 'col-xl-4 col-lg-4 col-md-8 col-sm-8';
        break;
    default:
        $footer_class = 'col-xl-3 col-lg-3 col-md-6';
        break;
    }

?>


<footer>
        <!-- footer-area-start -->
    <div class="tp-footer__area">
        <?php if ( is_active_sidebar('footer-2-1') OR is_active_sidebar('footer-2-2') OR is_active_sidebar('footer-2-3') OR is_active_sidebar('footer-2-4') ): ?>
        <div class="footer_overl p-relative" data-bg-color="<?php echo esc_attr( $bg_color ); ?>">
            <div class="tp-footer__bg " data-background="<?php echo esc_url( $bg_img ) ?>" >
                <div class="tp-footer-color p-relative" data-bg-color="<?php echo esc_attr( $bg_color ); ?>"></div>
                <div class="container">
                    <div class="row">
                        <?php
                        if ( $footer_columns < 5 ) {
                        print '<div class="col-xl-4 col-lg-4 col-md-6 mb-45 wow tpfadeUp" data-wow-duration=".9s">';
                        dynamic_sidebar( 'footer-2-1' );
                        print '</div>';

                        print '<div class="col-xl-2 col-lg-2 col-md-6 mb-45 wow tpfadeUp" data-wow-duration=".9s">';
                        dynamic_sidebar( 'footer-2-2' );
                        print '</div>';

                        print '<div class="col-xl-2 col-lg-2 col-md-6 mb-45 wow tpfadeUp" data-wow-duration=".9s">';
                        dynamic_sidebar( 'footer-2-3' );
                        print '</div>';

                        print '<div class="col-xl-4 col-lg-4 col-md-6 mb-45  wow tpfadeUp" data-wow-duration=".9s">';
                        dynamic_sidebar( 'footer-2-4' );
                        print '</div>';
                        } else {
                            for ( $num = 1; $num <= $footer_columns; $num++ ) {
                                if ( !is_active_sidebar( 'footer-2-' . $num ) ) {
                                    continue;
                                }
                                print '<div class="' . esc_attr( $footer_class[$num] ) . '">';
                                dynamic_sidebar( 'footer-2-' . $num );
                                print '</div>';
                            }
                        }
                    ?>
                        
                    </div>
                </div>
            </div>
        </div>
            <?php endif; ?>
    </div>
        <!-- footer-area-end -->

        <!-- copyright-area-start -->
        <?php  if ( !empty($footer_bottom_copyright_area_switch  ) ): ?>
        <div class="tp-copyright__area tp-copyright__bg">
            <div class="container">
                <div class="row align-items-center">
                <?php  if ( !empty($footer_copyright_switch  ) ): ?>
                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                        <div class="tp-copyright__text text-center text-sm-start">
                            <span><?php print poorex_copyright_text(); ?></span>
                        </div>
                    </div>
                    <?php endif;  ?>
                    <?php  if ( !empty( $footer_social_switch  ) ): ?>
                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                        <div class="tp-copyright__social text-center text-sm-end">
                            <?php poorex_header_social_profiles() ?>
                        </div>
                    </div>
                    <?php endif;  ?>
                </div>
            </div>
        </div>
        <!-- copyright-area-end -->
        <?php endif;  ?>
    </footer>
