<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package poorex
 */

$gallery_images = function_exists('tpmeta_gallery_field')? tpmeta_gallery_field('poorex_post_gallery') : '';

if ( is_single() ): ?>


<article id="post-<?php the_ID();?>" <?php post_class( 'postbox__item format-gallery mb-75' );?>>
   <?php if ( !empty( $gallery_images ) ): ?>
   <div class="postbox__thumb">
      <div class="postbox__thumb-text d-none d-md-block">
         <span><?php the_time( 'j F' ); ?></span>
      </div>
   <div class="swiper-container postbox__thumb-slider-active">
      <div class="swiper-wrapper">
         <?php foreach ( $gallery_images as $key => $image ): ?>
         <div class="postbox-slider-item swiper-slide">
            <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>">
         </div>
         <?php endforeach;?>
      </div>
      <div class="postbox__slider-arrow-wrap">
            <button class="postbox-arrow-prev">
               <i class="fa-solid fa-angle-left"></i>
            </button>
            <button class="postbox-arrow-next">                                                
               <i class="fa-solid fa-angle-right"></i>
            </button>
         </div>
   </div>
   </div>
   <?php endif;?>

   <div class="postbox__content">
      <!-- blog meta -->
      <?php get_template_part( 'template-parts/blog/blog-meta' ); ?>
      <h3 class="postbox__title"><?php the_title();?></h3>
      <?php the_content();?>
      <?php
            wp_link_pages( [
                'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'poorex' ),
                'after'       => '</div>',
                'link_before' => '<span class="page-number">',
                'link_after'  => '</span>',
            ] );
        ?>
   </div>

   <div class="postbox-tags">
      <?php echo poorex_get_tag(); ?>
   </div>
</article>



<?php else: 
    $categories = get_the_terms( $post->ID, 'category' );    
    $poorex_blog_cat = get_theme_mod( 'poorex_blog_cat', false );
?>

<article id="post-<?php the_ID();?>" <?php post_class( 'postbox-item postbox__item format-gallery mb-60 transition-3' );?> >

   <?php if ( !empty( $gallery_images ) ): ?>
   <div class="postbox__thumb w-img">
      <div class="postbox__thumb-slider p-relative">

         <div class="swiper-container postbox__thumb-slider-active">
            <div class="swiper-wrapper">

               <?php foreach ( $gallery_images as $key => $image ): ?>
               <div class="swiper-slide">
                  <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>">
               </div>
               <?php endforeach;?>

            </div>
         </div>

         <div class="postbox__slider-arrow-wrap">
            <button class="postbox-arrow-prev">
               <i class="fa-solid fa-angle-left"></i>
            </button>
            <button class="postbox-arrow-next">
               <i class="fa-solid fa-angle-right"></i>
            </button>
         </div>
      </div>
   </div>
   <?php endif; ?>

   <div class="postbox__content">
      <!-- blog meta -->
      <?php get_template_part( 'template-parts/blog/blog-meta' ); ?>
      <h3 class="postbox__title">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
      </h3>
      <div class="postbox__text">
            <?php the_excerpt();?>
      </div>
      <!-- blog btn -->
      <?php get_template_part( 'template-parts/blog/blog-btn' ); ?>
   </div>
</article>


<?php
endif;?>