<?php 

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function poorex_widgets_init() {

    $footer_style_2_switch = get_theme_mod( 'footer_layout_2_switch', false );
    $footer_style_3_switch = get_theme_mod( 'footer_layout_2_switch', false );

    /**
     * blog sidebar
     */
    register_sidebar( [
        'name'          => esc_html__( 'Blog Sidebar', 'poorex' ),
        'id'            => 'blog-sidebar',
        'before_widget' => '<div id="%1$s" class="sidebar__widget mb-30 %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="sidebar__widget-title">',
        'after_title'   => '</h3>',
    ] );
    /**
     * Charity sidebar
     */
    register_sidebar( [
        'name'          => esc_html__( 'Charity Sidebar', 'poorex' ),
        'id'            => 'campaigns-sidebar',
        'before_widget' => '<div id="%1$s" class="sidebar__widget charity_widget mb-30 %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="sidebar__widget-title">',
        'after_title'   => '</h3>',
    ] );    

    /**
     * blog sidebar
     */
    register_sidebar( [
        'name'          => esc_html__( 'Portfolio Sidebar', 'poorex' ),
        'id'            => 'portfolio-sidebar',
        'before_widget' => '<div id="%1$s" class="portfolio__widget mb-30 %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h5 class="ps__title">',
        'after_title'   => '</h5>',
    ] );


    $footer_widgets = get_theme_mod( 'footer_widget_number', 4 );

    // footer default
    for ( $num = 1; $num <= $footer_widgets; $num++ ) {
        register_sidebar( [
            'name'          => sprintf( esc_html__( 'Footer %1$s', 'poorex' ), $num ),
            'id'            => 'footer-' . $num,
            'description'   => sprintf( esc_html__( 'Footer Column %1$s', 'poorex' ), $num ),
            'before_widget' => '<div id="%1$s" class="tp-footer__widget tp-footer__list footer-col-'.$num.' mb-40 %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="tp-footer__widget-title">',
            'after_title'   => '</h4>',
        ] );
    }

    // footer 2
    if ( $footer_style_2_switch ) {
        for ( $num = 1; $num <= $footer_widgets; $num++ ) {

            register_sidebar( [
                'name'          => sprintf( esc_html__( 'Footer Style 2 : %1$s', 'poorex' ), $num ),
                'id'            => 'footer-2-' . $num,
                'description'   => sprintf( esc_html__( 'Footer Style 2 : %1$s', 'poorex' ), $num ),
                'before_widget' => '<div id="%1$s" class="tp-footer__widget tp-footer__list footer-2-col-'.$num.' mb-40 %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h3 class="tp-footer__widget-title-2">',
                'after_title'   => '</h3>',
            ] );
        }
    }    
  

}
add_action( 'widgets_init', 'poorex_widgets_init' );