 <?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Synox for publication on ThemeForest
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

require_once get_template_directory() . '/inc/class-tgm-plugin-activation.php';

add_action('tgmpa_register', 'educash_register_required_plugins');

function educash_register_required_plugins() {
    /*
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(

        array(
            'name'      => esc_attr__('Educash demo', 'educash'),
            'slug'      => 'educash-demo',
            'source'       => esc_url( 'https://webangon.com/zip/educash-demo.zip' ),
            'required'     => true,
            'external_url' => esc_url( 'https://webangon.com/zip/educash-demo.zip' ),
        ),
        array(
            'name'      => esc_html__('Educat Elementor LMS Addon', 'educash'),
            'slug'      => 'educat',
            'required'  => true,
        ),
        array(
            'name'      => esc_html__('Tutor LMS - eLearning and online course solution', 'educash'),
            'slug'      => 'tutor',
            'required'  => true,
        ),
        array(
            'name'      => esc_html__('Elementor Page Builder', 'educash'),
            'slug'      => 'elementor',
            'required'  => true,
        ),
    );

    $config = array(
        'id'           => 'educash',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                       // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins',  // Menu slug.
        'has_notices'  => true,                     // Show admin notices or not.
        'dismissable'  => true,                     // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                       // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                    // Automatically activate plugins after installation or not.
        'message'      => '',                       // Message to output right before the plugins table.
    );

    tgmpa($plugins, $config);
}
?>
