<?php
$widget->add_render_attribute('inner', [
    'class' => 'ct-carousel-inner',
]);

$col_xs = 1;
$col_sm = 1;
$col_md = 1;
$col_lg = 1;
$col_xl = 1;
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute('carousel', [
    'class' => 'ct-slick-carousel slick-arrow-style2 nav-middle1',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
]);
?>
<?php if (isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="ct-testimonial ct-testimonial-carousel27 ct-slick-slider <?php echo esc_attr($settings['style_l1']); ?>">
        <div <?php ct_print_html($widget->get_render_attribute_string('inner')); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string('carousel')); ?>>
                <?php foreach ($settings['testimonial'] as $value):
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $image = isset($value['image']) ? $value['image'] : ''; 
                    $logo = isset($value['logo']) ? $value['logo'] : ''; ?>
                    <div class="slick-slide">
                        <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                            <div class="item--icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="72" height="72" viewBox="0 0 72 72" fill="none">
                                    <path d="M0 9V63L27 36V9H0Z" fill="currentColor"/>
                                    <path d="M45 9V63L72 36V9H45Z" fill="currentColor"/>
                                </svg>
                            </div>
                            <div class="item--description"><?php echo esc_html($description); ?></div>
                            <div class="item-holder">
                                <?php if (!empty($image['id'])) {
                                    $img_image = consultio_get_image_by_size(array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => 'full',
                                    ));
                                    $thumbnail_image = $img_image['thumbnail']; ?>
                                    <div class="item--image">
                                        <?php echo wp_kses_post($thumbnail_image); ?>
                                    </div>
                                <?php } ?>
                                <div class="item-meta">
                                    <h3 class="item--title">
                                        <?php echo esc_attr($title); ?>
                                    </h3>
                                    <div class="item--position"><?php echo esc_attr($position); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>