<?php
$default_settings = [
    'team' => '',
    'thumbnail_size' => 'full',
    'thumbnail_custom_dimension' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '410x522';
}

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel slick-arrow-style3',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );

?>
<?php if(isset($team) && !empty($team) && count($team)): ?>
    <div class="ct-team ct-team-carousel14 dot-style-u7 ct-slick-slider">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ($team as $key => $value) :
                    $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                    if ( ! empty( $value['link']['url'] ) ) {
                        $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                        if ( $value['link']['is_external'] ) {
                            $widget->add_render_attribute( $link_key, 'target', '_blank' );
                        }

                        if ( $value['link']['nofollow'] ) {
                            $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                    }
                    $link_attributes = $widget->get_render_attribute_string( $link_key );
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    $img = consultio_get_image_by_size( array(
                        'attach_id'  => $image['id'],
                        'thumb_size' => $img_size,
                    ));
                    $thumbnail = $img['thumbnail'];
                    $social = isset($value['social']) ? $value['social'] : '';
                    ?>
                    <div class="slick-slide">
                        <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                            <?php if(!empty($image)) { ?>
                                <div class="item--image">
                                    <a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php echo wp_kses_post($thumbnail); ?></a>
                                </div>
                            <?php } ?>
                            <div class="item--holder">
                                <div class="item--meta">
                                    <h3 class="item--title">
                                        <a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php echo ct_print_html($title); ?></a>
                                    </h3>
                                    <div class="item--position"><?php echo ct_print_html($position); ?></div>
                                </div>
                                <div class="item--share">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                        <path d="M18 15C17.3709 15.0015 16.751 15.1517 16.1911 15.4385C15.6311 15.7253 15.1469 16.1404 14.778 16.65L9.76301 13.307C10.079 12.4643 10.079 11.5357 9.76301 10.693L14.778 7.35002C15.3409 8.11315 16.1575 8.65054 17.081 8.86564C18.0046 9.08075 18.9746 8.95946 19.8167 8.52357C20.6589 8.08769 21.318 7.36578 21.6757 6.48754C22.0333 5.6093 22.0661 4.6323 21.768 3.73208C21.47 2.83186 20.8607 2.06742 20.0497 1.57611C19.2386 1.08479 18.2789 0.898808 17.343 1.05157C16.4071 1.20433 15.5564 1.68582 14.9436 2.40953C14.3309 3.13325 13.9963 4.05175 14 5.00002C14.0065 5.14573 14.0212 5.29096 14.044 5.43502L8.65301 9.02902C8.07849 8.51111 7.36614 8.17088 6.60222 8.04954C5.8383 7.9282 5.05558 8.03095 4.34886 8.34536C3.64214 8.65976 3.04174 9.17232 2.62037 9.82097C2.199 10.4696 1.97473 11.2265 1.97473 12C1.97473 12.7735 2.199 13.5304 2.62037 14.1791C3.04174 14.8277 3.64214 15.3403 4.34886 15.6547C5.05558 15.9691 5.8383 16.0718 6.60222 15.9505C7.36614 15.8292 8.07849 15.4889 8.65301 14.971L14.044 18.565C14.0212 18.7091 14.0065 18.8543 14 19C14 19.7911 14.2346 20.5645 14.6741 21.2223C15.1137 21.8801 15.7384 22.3928 16.4693 22.6955C17.2002 22.9983 18.0044 23.0775 18.7804 22.9232C19.5563 22.7688 20.269 22.3879 20.8284 21.8284C21.3878 21.269 21.7688 20.5563 21.9231 19.7804C22.0775 19.0045 21.9983 18.2002 21.6955 17.4693C21.3928 16.7384 20.8801 16.1137 20.2223 15.6741C19.5645 15.2346 18.7911 15 18 15Z" fill="currentColor"/>
                                    </svg>
                                </div>
                            </div>
                            <div class="item--social">
                                <?php if(!empty($social)):
                                    $team_social = json_decode($social, true);
                                    foreach ($team_social as $value): ?>
                                        <a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
                                    <?php endforeach;
                                endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
