<?php
$default_settings = [
    'team' => '',
    'thumbnail_size' => 'full',
    'thumbnail_custom_dimension' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '302x390';
}

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel slick-arrow-stylexxx',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );
$html_id = ct_get_element_id($settings);
?>
<?php if(isset($team) && !empty($team) && count($team)): ?>
    <div class="ct-team ct-team-carousel12 ct-slick-slider dot-style-u9">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ($team as $key => $value) :
                    $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                    if ( ! empty( $value['link']['url'] ) ) {
                        $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                        if ( $value['link']['is_external'] ) {
                            $widget->add_render_attribute( $link_key, 'target', '_blank' );
                        }

                        if ( $value['link']['nofollow'] ) {
                            $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                    }
                    $link_attributes = $widget->get_render_attribute_string( $link_key );
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $desc = isset($value['desc']) ? $value['desc'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    $img = consultio_get_image_by_size( array(
                        'attach_id'  => $image['id'],
                        'thumb_size' => $img_size,
                    ));
                    $thumbnail = $img['thumbnail'];
                    $social = isset($value['social']) ? $value['social'] : '';
                    ?>
                    <div class="slick-slide">
                        <div id="<?php echo esc_attr($html_id.$key); ?>" class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                            <div class="item--wrapper">
                                <?php if(!empty($image)) { ?>
                                    <div class="item--image">
                                        <?php echo wp_kses_post($thumbnail); ?>
                                    </div>
                                <?php } ?>
                                <div class="item--holder">
                                    <a <?php echo implode( ' ', [ $link_attributes ] ); ?> class="item--link">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                            <g clip-path="url(#clip0_1_2936)">
                                                <path d="M12.4878 17.5999C12.4901 17.5977 12.4923 17.5955 12.4945 17.5932L19.3957 10.7011C19.4502 10.6463 19.4985 10.5858 19.54 10.5206L19.6483 10.3222L19.6934 10.1869L19.6934 10.0876C19.7213 9.93555 19.7213 9.77964 19.6934 9.62753L19.6934 9.53734L19.6934 9.42908L19.6122 9.27571C19.5658 9.19025 19.5081 9.11134 19.4408 9.04114L12.4945 2.12193C12.0348 1.6586 11.2866 1.65559 10.8232 2.11525C10.821 2.11745 10.8188 2.11969 10.8166 2.12193C10.3709 2.58899 10.3709 3.32376 10.8166 3.79086L14.9302 7.91352C15.1046 8.09138 15.1018 8.37699 14.9239 8.55138C14.8412 8.63253 14.7304 8.6787 14.6145 8.68031L1.18195 8.68031C0.529255 8.68027 0.000121745 9.20932 7.78477e-05 9.86201C3.58575e-05 10.5147 0.529085 11.0438 1.18178 11.0439L1.18195 11.0439L14.6145 11.0439C14.8635 11.0474 15.0627 11.2521 15.0591 11.5012C15.0575 11.6171 15.0114 11.7279 14.9302 11.8107L10.8166 15.9153C10.3652 16.3836 10.3652 17.125 10.8166 17.5933C11.2762 18.0566 12.0245 18.0596 12.4878 17.5999Z" fill="currentColor"/>
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_1_2936">
                                                <path d="M14.7144 -2.18557e-07C17.4758 -9.78512e-08 19.7144 2.23858 19.7144 5L19.7144 19.7143L6.78028e-05 19.7143L6.8446e-05 5C6.85667e-05 2.23857 2.23865 -7.63888e-07 5.00007 -6.43182e-07L14.7144 -2.18557e-07Z" fill="white"/>
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </a>
                                    <ul class="item--social">
                                        <?php if(!empty($social)):
                                            $team_social = json_decode($social, true);
                                            foreach ($team_social as $value): ?>
                                                <li>
                                                    <a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
                                                </li>
                                            <?php endforeach;
                                        endif; ?>
                                    </ul>
                                    <h3 class="item--title">    
                                        <a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php echo ct_print_html($title); ?></a>
                                    </h3>
                                    <div class="item--position el-empty"><?php echo ct_print_html($position); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
