<?php
$default_settings = [
    'title' => '',
    'description' => '',
    'recommended' => '',
    'currency' => '',
    'price' => '',
    'price_constant' => '',
    'content_list' => '',
    'item_highlight' => '',
    'ct_animate' => '',
    'ct_animate_delay' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if ( ! empty( $settings['bg_image']['url'] ) ) {
    $widget->add_render_attribute( 'image', 'src', $settings['bg_image']['url'] );
    $widget->add_render_attribute( 'image', 'alt', \Elementor\Control_Media::get_image_alt( $settings['bg_image'] ) );
    $widget->add_render_attribute( 'image', 'title', \Elementor\Control_Media::get_image_title( $settings['bg_image'] ) );
}
$image_html = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'bg_image' );
?>
<div class="ct-pricing-layout8 <?php echo esc_attr($ct_animate); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <?php if(!empty($image_html)) : ?>
        <div class="pricing-image">
            <img <?php echo $widget->get_render_attribute_string( 'image' ); ?> class="img-fluid" alt="<?php echo esc_attr($settings['bg_image']['alt']); ?>">  
        </div>
    <?php endif; ?>
    <div class="pricing-price">
        <?php if(!empty($currency)) : ?>
            <span class="pricing-price-currency"><?php echo esc_attr($currency); ?></span>
        <?php endif; ?>
        <div class="pricing-price-number">
            <?php echo esc_attr($price); ?>
        </div>
        <?php if(!empty($price_constant)) : ?>
            <span class="pricing-price-constant">/ <?php echo esc_attr($price_constant); ?></span>
        <?php endif; ?>
    </div>
    <h5 class="pricing-title">
        <span>
            <?php echo esc_attr($title); ?>
        </span>
    </h5>
    <div class="pricing-divider"></div>
    <?php if(isset($settings['content_list']) && !empty($settings['content_list']) && count($settings['content_list'])): ?>
        <ul class="pricing-feature">
            <?php
                foreach ($settings['content_list'] as $key => $ct_list): ?>
                <li>
                    <i class="fas fa-check-circle"></i>
                    <span><?php echo ct_print_html($ct_list['content'])?></span>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
    <?php if(!empty($button_text)) : ?>
        <div class="pricing-button">
            <a class="<?php if($style == 'style1') { echo 'btn-secondary'; } else { echo 'btn-preset3'; } ?>" <?php ct_print_html($widget->get_render_attribute_string( 'button' )); ?>><?php echo esc_attr($button_text); ?></a>
        </div>
    <?php endif; ?>
</div>