<?php
$default_settings = [
    'title' => '',
    'description' => '',
    'recommended' => '',
    'currency' => '',
    'price' => '',
    'price_constant' => '',
    'button_text' => '',
    'button_link' => '',
    'content_list' => '',
    'item_highlight' => '',
    'ct_animate' => '',
    'ct_animate_delay' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $settings['selected_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['selected_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if ( ! empty( $button_link['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $button_link['url'] );

    if ( $button_link['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $button_link['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
?>
<div class="ct-pricing-layout7 <?php echo esc_attr($ct_animate); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <?php if ( $settings['icon_type'] == 'icon' && $has_icon ) : ?>
        <div class="item--icon">
            <?php if($is_new):
                \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                else: ?>
                <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
        <div class="item--icon">
            <?php $img_icon  = consultio_get_image_by_size( array(
                    'attach_id'  => $settings['icon_image']['id'],
                    'thumb_size' => 'full',
                ) );
                $thumbnail_icon    = $img_icon['thumbnail'];
            echo wp_kses_post($thumbnail_icon); ?>
        </div>
    <?php endif; ?>
    <h5 class="pricing-title">
        <span>
            <?php echo esc_attr($title); ?>
        </span>
    </h5>
    <div class="pricing-price">
        <?php if(!empty($currency)) : ?>
            <span class="pricing-price-currency"><?php echo esc_attr($currency); ?></span>
        <?php endif; ?>
        <div class="pricing-price-number">
            <?php echo esc_attr($price); ?>
        </div>
        <?php if(!empty($price_constant)) : ?>
            <span class="pricing-price-constant">/ <?php echo esc_attr($price_constant); ?></span>
        <?php endif; ?>
    </div>
    <div class="pricing-divider"></div>
    <?php if(isset($settings['content_list']) && !empty($settings['content_list']) && count($settings['content_list'])): ?>
        <ul class="pricing-feature">
            <?php
                foreach ($settings['content_list'] as $key => $ct_list): ?>
                <li class="<?php if($ct_list['active'] == 'yes') { echo 'active'; } ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M12 2.25C10.0716 2.25 8.18657 2.82183 6.58319 3.89317C4.97982 4.96452 3.73013 6.48726 2.99218 8.26884C2.25422 10.0504 2.06114 12.0108 2.43735 13.9021C2.81355 15.7934 3.74215 17.5307 5.10571 18.8943C6.46928 20.2579 8.20656 21.1865 10.0979 21.5627C11.9892 21.9389 13.9496 21.7458 15.7312 21.0078C17.5127 20.2699 19.0355 19.0202 20.1068 17.4168C21.1782 15.8134 21.75 13.9284 21.75 12C21.7474 9.41495 20.7193 6.93654 18.8914 5.10863C17.0635 3.28073 14.5851 2.25265 12 2.25ZM12 20.25C10.3683 20.25 8.77326 19.7661 7.41655 18.8596C6.05984 17.9531 5.00242 16.6646 4.378 15.1571C3.75358 13.6496 3.5902 11.9908 3.90853 10.3905C4.22685 8.79016 5.01259 7.32015 6.16637 6.16637C7.32016 5.01259 8.79017 4.22685 10.3905 3.90852C11.9909 3.59019 13.6497 3.75357 15.1571 4.37799C16.6646 5.00242 17.9531 6.05984 18.8596 7.41655C19.7661 8.77325 20.25 10.3683 20.25 12C20.2474 14.1872 19.3773 16.2841 17.8307 17.8307C16.2841 19.3773 14.1872 20.2474 12 20.25ZM16.48 8.42C16.6322 8.54837 16.7279 8.73134 16.7466 8.92956C16.7653 9.12779 16.7055 9.32543 16.58 9.48L11.58 15.48C11.5109 15.5594 11.4267 15.6241 11.3322 15.6705C11.2378 15.7169 11.135 15.7439 11.03 15.75C10.8312 15.7498 10.6405 15.6707 10.5 15.53L7.5 12.53C7.36752 12.3878 7.2954 12.1998 7.29883 12.0055C7.30226 11.8112 7.38097 11.6258 7.51838 11.4884C7.6558 11.351 7.84118 11.2723 8.03548 11.2688C8.22978 11.2654 8.41783 11.3375 8.56 11.47L11 13.89L15.47 8.52C15.5964 8.3818 15.7695 8.29515 15.9559 8.2767C16.1423 8.25824 16.3289 8.30927 16.48 8.42Z" fill="currentColor"/>
                    </svg>
                    <span><?php echo ct_print_html($ct_list['content'])?></span>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
    <?php if(!empty($button_text)) : ?>
        <div class="pricing-button">
            <a class="<?php if($style == 'style1') { echo 'btn-secondary'; } else { echo 'btn-preset3'; } ?>" <?php ct_print_html($widget->get_render_attribute_string( 'button' )); ?>><?php echo esc_attr($button_text); ?></a>
        </div>
    <?php endif; ?>
</div>