<?php

$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('portfolio', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

// Force 3 slides to show
$col_xs = $widget->get_setting('col_xs', '1');
$col_sm = $widget->get_setting('col_sm', '1');
$col_md = $widget->get_setting('col_md', '3'); // Always show 3 on medium and up
$col_lg = $widget->get_setting('col_lg', '3');
$col_xl = $widget->get_setting('col_xl', '3');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '1');

$show_title = $widget->get_setting('show_title');
$show_category = $widget->get_setting('show_category');
$show_button = $widget->get_setting('show_button');
$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite', 'true');
$speed = $widget->get_setting('speed', '500');
$center_mode = $widget->get_setting('center_mode', 'true');

if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}

$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
    'data-centerMode' => $center_mode,
] );

$thumbnail_size = $widget->get_setting('thumbnail_size', 'full');
$thumbnail_custom_dimension = $widget->get_setting('thumbnail_custom_dimension', '');
if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '1110x600';
}
?>
<?php if (is_array($posts)): ?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-portfolio-carousel8 ct-slick-slider ct-3slides-carousel">
    <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
        <?php
            foreach ($posts as $post):
            $img_id       = get_post_thumbnail_id( $post->ID );
            $img          = consultio_get_image_by_size( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
            ) );
            $thumbnail    = $img['thumbnail'];
            $portfolio_custom_link = get_post_meta($post->ID, 'portfolio_custom_link', true); 
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                <div class="carousel-item slick-slide">
                    <div class="grid-item-inner">
                        <div class="item--featured">
                            <?php echo wp_kses_post($thumbnail); ?>
                            <div class="item--holder">
                                <div class="item--meta">
                                    <?php if($show_category == 'true'): ?>
                                        <div class="item--category">
                                            <?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($show_title == 'true'): ?>
                                        <h3 class="item--title"><a href="<?php if(!empty($portfolio_custom_link)) { echo esc_url($portfolio_custom_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h3>
                                    <?php endif; ?>
                                </div>
                                <?php if($show_button == 'true'): ?>
                                    <div class="item--readmore">
                                        <a href="<?php if(!empty($portfolio_custom_link)) { echo esc_url($portfolio_custom_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 60 60" fill="none">
                                                <g clip-path="url(#clip0_1_2036)">
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M-1.31134e-06 30C-2.0336e-06 46.5234 13.4766 60 30 60C46.5234 60 60 46.5234 60 30C60 13.4766 46.5234 -5.89079e-07 30 -1.31134e-06C13.4766 -2.0336e-06 -5.89079e-07 13.4766 -1.31134e-06 30Z" fill="#FE5B2B"/>
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M30.7266 38.2617L38.9883 30L30.7266 21.7383L24.3398 21.7383L30.3516 27.75L16.5703 27.75L12 27.75C10.664 38.5195 19.0078 48.1524 30 48.1524C40.0195 48.1524 48.1406 40.0313 48.1406 30C48.1406 19.9688 40.0195 11.8594 30 11.8594C21.9609 11.8594 15.1523 17.0859 12.7617 24.3164L17.6133 24.3164C19.7695 19.6289 24.5039 16.3828 30 16.3828C37.5234 16.3828 43.6289 22.4883 43.6289 30.0117C43.6289 37.5352 37.5234 43.6406 30 43.6406C23.2383 43.6406 17.6367 38.7188 16.5586 32.2734L30.3398 32.2734L24.3281 38.2852L30.7266 38.2852L30.7266 38.2617Z" fill="white"/>
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M25.9336 59.7305L42.832 42.832C39.5508 46.1133 35.0156 48.1524 30 48.1524C19.0078 48.1524 10.6641 38.5195 11.9883 27.75L16.5586 27.75L30.3398 27.75L24.3281 21.7383L30.7148 21.7383L38.9766 30L30.7148 38.2617L24.3281 38.2617L30.3398 32.25L16.5586 32.25C17.6367 38.6953 23.2383 43.6172 30 43.6172C37.5234 43.6172 43.6289 37.5117 43.6289 29.9883C43.6289 22.4648 37.5234 16.3594 30 16.3594C24.5039 16.3594 19.7695 19.6172 17.6133 24.293L12.7617 24.293C13.6523 21.5977 15.1641 19.1719 17.1211 17.2031L0.281261 34.043C2.07423 47.3789 12.6211 57.9258 25.9336 59.7305Z" fill="#CB4018"/>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_1_2036">
                                                    <rect width="60" height="60" fill="white" transform="translate(60) rotate(90)"/>
                                                    </clipPath>
                                                </defs>
                                            </svg>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>