<?php
$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $settings['selected_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['selected_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}


$widget->add_inline_editing_attributes( 'title_text', 'none' );
$widget->add_inline_editing_attributes( 'description_text' );

$is_new = \Elementor\Icons_Manager::is_migration_allowed();

if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
?>
<div class="ct-fancy-box ct-fancy-box-layout28 <?php echo esc_attr($settings['style_l28']); ?> <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="item--inner">
        <div class="background-number background-number-<?php echo esc_attr($settings['background_number']); ?>">
            <?php if($settings['background_number'] == '1') : ?>
                <?php if($settings['style_l28'] == 'style1') : ?>
                    <svg width="403" height="353" viewBox="0 0 403 353" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M226.331 352.87C198.022 352.87 169.875 346.002 144.935 333.012C120.801 320.439 99.5652 302.133 83.5265 280.073C83.271 279.72 83.145 279.295 83.1594 278.874V65.2022H56.3406C42.8251 79.0237 22.4671 90.4553 3.8441 94.7205V122.313C15.0525 120.607 32.6965 115.474 42.3284 110.111C42.9223 109.78 43.6493 109.787 44.236 110.133C44.8227 110.478 45.1862 111.108 45.1862 111.789V274.76C45.1862 275.822 44.326 276.682 43.2642 276.682C42.2024 276.682 41.3421 275.822 41.3421 274.76V114.949C30.2489 120.326 12.5365 125.178 2.15241 126.424C1.60891 126.488 1.0582 126.319 0.647879 125.952C0.237553 125.589 0 125.063 0 124.516V93.1728C0 92.2622 0.637085 91.4775 1.52972 91.2903C20.1132 87.4102 40.7626 75.8923 54.1378 61.9484C54.5014 61.5705 55.0017 61.3581 55.5236 61.3581H85.0778C86.1397 61.3581 86.9999 62.2184 86.9999 63.2802V278.316C119.444 322.603 171.48 349.025 226.324 349.025C321.49 349.025 398.916 271.6 398.916 176.433C398.916 81.2661 321.498 3.8441 226.331 3.8441C193.85 3.8441 162.201 12.9145 134.814 30.0762C133.914 30.6413 132.73 30.3677 132.165 29.4679C131.599 28.568 131.873 27.3839 132.773 26.8188C160.772 9.27192 193.123 0 226.331 0C250.148 0 273.255 4.66476 295.006 13.8647C316.016 22.7515 334.884 35.4716 351.088 51.6759C367.292 67.8802 380.012 86.748 388.899 107.757C398.099 129.512 402.764 152.616 402.764 176.433C402.764 200.25 398.099 223.358 388.899 245.109C380.012 266.118 367.292 284.986 351.088 301.19C334.884 317.394 316.016 330.114 295.006 339.001C273.255 348.205 250.151 352.87 226.331 352.87Z" fill="currentColor"/>
                        <path d="M49.9386 277.175C51.457 273.484 49.6954 269.26 46.0039 267.742C42.3125 266.224 38.089 267.985 36.5706 271.677C35.0522 275.368 36.8138 279.592 40.5053 281.11C44.1967 282.628 48.4202 280.867 49.9386 277.175Z" fill="currentColor"/>
                        <path d="M140.721 31.2026C142.344 27.5558 140.704 23.2835 137.057 21.6601C133.41 20.0367 129.138 21.677 127.515 25.3237C125.891 28.9705 127.531 33.2428 131.178 34.8662C134.825 36.4896 139.097 34.8493 140.721 31.2026Z" fill="currentColor"/>
                    </svg>
                <?php elseif($settings['style_l28'] == 'style2') : ?>
                    <svg width="403" height="353" viewBox="0 0 403 353" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M226.331 352.882C198.022 352.882 169.875 346.015 144.935 333.025C120.801 320.452 99.5652 302.146 83.5265 280.085C83.271 279.733 83.145 279.308 83.1594 278.887V65.2149H56.3406C42.8251 79.0364 22.4671 90.468 3.8441 94.7332V122.326C15.0525 120.62 32.6965 115.487 42.3284 110.124C42.9223 109.793 43.6493 109.8 44.236 110.146C44.8227 110.491 45.1862 111.121 45.1862 111.801V274.773C45.1862 275.835 44.326 276.695 43.2642 276.695C42.2024 276.695 41.3421 275.835 41.3421 274.773V114.962C30.2489 120.339 12.5365 125.191 2.15241 126.436C1.60891 126.501 1.0582 126.332 0.647879 125.965C0.237553 125.601 0 125.076 0 124.529V93.1855C0 92.2749 0.637085 91.4902 1.52972 91.303C20.1132 87.4229 40.7626 75.905 54.1378 61.9611C54.5014 61.5832 55.0017 61.3708 55.5236 61.3708H85.0778C86.1397 61.3708 86.9999 62.2311 86.9999 63.2929V278.329C119.444 322.615 171.48 349.038 226.324 349.038C321.49 349.038 398.916 271.613 398.916 176.446C398.916 81.2788 321.498 3.8568 226.331 3.8568C193.85 3.8568 162.201 12.9272 134.814 30.0889C133.914 30.654 132.73 30.3804 132.165 29.4806C131.599 28.5807 131.873 27.3966 132.773 26.8315C160.772 9.28462 193.123 0.0126953 226.331 0.0126953C250.148 0.0126953 273.255 4.67745 295.006 13.8774C316.016 22.7642 334.884 35.4843 351.088 51.6886C367.292 67.8929 380.012 86.7607 388.899 107.77C398.099 129.525 402.764 152.629 402.764 176.446C402.764 200.263 398.099 223.37 388.899 245.121C380.012 266.131 367.292 284.999 351.088 301.203C334.884 317.407 316.016 330.127 295.006 339.014C273.255 348.217 250.151 352.882 226.331 352.882Z" fill="url(#paint0_linear_1_4322)"/>
                        <path d="M49.9385 277.188C51.4569 273.496 49.6953 269.273 46.0038 267.754C42.3124 266.236 38.0889 267.998 36.5705 271.689C35.0521 275.381 36.8137 279.604 40.5051 281.122C44.1966 282.641 48.42 280.879 49.9385 277.188Z" fill="url(#paint1_linear_1_4322)"/>
                        <path d="M140.721 31.2153C142.344 27.5685 140.704 23.2962 137.057 21.6728C133.411 20.0494 129.138 21.6896 127.515 25.3364C125.891 28.9832 127.532 33.2555 131.178 34.8789C134.825 36.5023 139.098 34.862 140.721 31.2153Z" fill="url(#paint2_linear_1_4322)"/>
                        <defs>
                        <linearGradient id="paint0_linear_1_4322" x1="201.382" y1="0.0126953" x2="201.382" y2="352.882" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#2AF598"/>
                        <stop offset="1" stop-color="#009EFD"/>
                        </linearGradient>
                        <linearGradient id="paint1_linear_1_4322" x1="36.5705" y1="271.689" x2="49.9385" y2="277.188" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#2AF598"/>
                        <stop offset="1" stop-color="#009EFD"/>
                        </linearGradient>
                        <linearGradient id="paint2_linear_1_4322" x1="127.515" y1="25.3364" x2="140.721" y2="31.2152" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#2AF598"/>
                        <stop offset="1" stop-color="#009EFD"/>
                        </linearGradient>
                        </defs>
                    </svg>
                <?php endif; ?>
            <?php elseif ($settings['background_number'] == '2') : ?>
                <?php if($settings['style_l28'] == 'style1') : ?>
                    <svg width="425" height="353" viewBox="0 0 425 353" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M247.955 352.868C220.229 352.868 193.687 346.619 169.071 334.295C145.881 322.683 125.159 305.749 109.092 285.286L3.29222 285.283C2.23042 285.283 1.37018 284.422 1.37018 283.361V280.744C1.37018 242.951 21.5625 211.194 66.8424 177.777C98.4807 154.277 107.601 146.614 107.601 126.67C107.601 112.708 102.555 96.0647 78.5223 96.0647C58.5135 96.0647 48.3453 106.013 44.5192 129.334C44.368 130.262 43.5654 130.946 42.6223 130.946H2.75953C2.21962 130.946 1.70494 130.719 1.3414 130.32C0.97787 129.92 0.7979 129.388 0.844692 128.851C2.64797 108.904 10.1382 91.9759 22.5092 79.9036C29.1284 73.4428 37.0901 68.4397 46.1713 65.0347C55.76 61.4426 66.6444 59.6213 78.5223 59.6213C103.779 59.6213 123.226 66.6652 136.328 80.5551C147.14 92.0191 153.097 108.213 153.097 126.144C153.097 142.813 149.422 154.831 140.805 166.324C132.07 177.975 118.094 189.194 98.3727 203.516C74.0807 221.214 60.6083 234.669 55.2741 246.654H121.531C122.593 246.654 123.453 247.515 123.453 248.576C123.453 249.638 122.593 250.498 121.531 250.498H52.4378C51.8151 250.498 51.2284 250.196 50.8685 249.685C50.5085 249.174 50.4185 248.522 50.6273 247.932C55.382 234.517 69.4087 219.861 96.1159 200.403C136.641 170.974 149.257 156.894 149.257 126.144C149.257 111.441 144.156 63.4654 78.5259 63.4654C36.7302 63.4654 9.34636 87.2067 4.89036 127.102H41.0098C43.0291 115.962 46.5852 107.799 51.8547 102.18C58.1391 95.478 66.864 92.2242 78.5295 92.2242C89.3059 92.2242 97.6492 95.3988 103.333 101.658C108.721 107.593 111.453 116.012 111.453 126.674C111.453 148.403 101.285 156.995 69.1352 180.873C24.9315 213.494 5.22152 244.297 5.22152 280.747V281.442L110.035 281.446C110.628 281.446 111.19 281.719 111.554 282.191C144.534 324.667 194.252 349.027 247.958 349.027C343.125 349.027 420.551 271.601 420.551 176.435C420.551 81.2678 343.125 3.84215 247.958 3.84215C215.478 3.84215 183.832 12.9125 156.445 30.0742C155.545 30.6393 154.361 30.3658 153.796 29.4659C153.23 28.5661 153.504 27.3819 154.404 26.8168C182.403 9.26997 214.754 -0.00195312 247.962 -0.00195312C271.779 -0.00195312 294.886 4.6628 316.637 13.8627C337.647 22.7495 356.515 35.4697 372.719 51.6739C388.923 67.8782 401.643 86.746 410.53 107.755C419.73 129.51 424.395 152.614 424.395 176.431C424.395 200.248 419.73 223.356 410.53 245.107C401.643 266.116 388.923 284.984 372.719 301.188C356.515 317.392 337.647 330.113 316.637 338.999C294.879 348.203 271.771 352.868 247.955 352.868Z" fill="currentColor"/>
                        <path d="M161.265 32.9816C163.851 29.9404 163.481 25.3791 160.44 22.7937C157.399 20.2083 152.837 20.5779 150.252 23.6191C147.667 26.6603 148.036 31.2216 151.077 33.807C154.119 36.3924 158.68 36.0228 161.265 32.9816Z" fill="currentColor"/>
                        <path d="M121.167 255.797C125.159 255.797 128.395 252.561 128.395 248.569C128.395 244.578 125.159 241.342 121.167 241.342C117.176 241.342 113.94 244.578 113.94 248.569C113.944 252.561 117.179 255.797 121.167 255.797Z" fill="currentColor"/>
                    </svg>
                <?php elseif($settings['style_l28'] == 'style2') : ?>
                    <svg width="425" height="353" viewBox="0 0 425 353" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M247.955 352.88C220.229 352.88 193.687 346.632 169.071 334.308C145.881 322.696 125.159 305.761 109.092 285.299L3.29222 285.295C2.23042 285.295 1.37018 284.435 1.37018 283.373V280.757C1.37018 242.963 21.5625 211.206 66.8424 177.79C98.4807 154.29 107.601 146.627 107.601 126.683C107.601 112.721 102.555 96.0774 78.5223 96.0774C58.5135 96.0774 48.3453 106.026 44.5192 129.346C44.368 130.275 43.5654 130.959 42.6223 130.959H2.75953C2.21962 130.959 1.70494 130.732 1.3414 130.332C0.97787 129.933 0.7979 129.4 0.844692 128.864C2.64797 108.916 10.1382 91.9886 22.5092 79.9163C29.1284 73.4555 37.0901 68.4524 46.1713 65.0474C55.76 61.4553 66.6444 59.634 78.5223 59.634C103.779 59.634 123.226 66.6779 136.328 80.5678C147.14 92.0318 153.097 108.225 153.097 126.157C153.097 142.826 149.422 154.844 140.805 166.337C132.07 177.988 118.094 189.207 98.3727 203.529C74.0807 221.227 60.6083 234.681 55.2741 246.667H121.531C122.593 246.667 123.453 247.527 123.453 248.589C123.453 249.651 122.593 250.511 121.531 250.511H52.4378C51.8151 250.511 51.2284 250.209 50.8685 249.698C50.5085 249.187 50.4185 248.535 50.6273 247.945C55.382 234.53 69.4087 219.873 96.1159 200.415C136.641 170.987 149.257 156.906 149.257 126.157C149.257 111.454 144.156 63.4781 78.5259 63.4781C36.7302 63.4781 9.34636 87.2194 4.89036 127.115H41.0098C43.0291 115.975 46.5852 107.811 51.8547 102.193C58.1391 95.4907 66.864 92.2369 78.5295 92.2369C89.3059 92.2369 97.6492 95.4115 103.333 101.671C108.721 107.606 111.453 116.025 111.453 126.686C111.453 148.416 101.285 157.007 69.1352 180.885C24.9315 213.506 5.22152 244.309 5.22152 280.76V281.455L110.035 281.458C110.628 281.458 111.19 281.732 111.554 282.203C144.534 324.679 194.252 349.04 247.958 349.04C343.125 349.04 420.551 271.614 420.551 176.447C420.551 81.2805 343.125 3.85485 247.958 3.85485C215.478 3.85485 183.832 12.9252 156.445 30.0869C155.545 30.652 154.361 30.3785 153.796 29.4786C153.23 28.5788 153.504 27.3946 154.404 26.8295C182.403 9.28266 214.754 0.0107422 247.962 0.0107422C271.779 0.0107422 294.886 4.6755 316.637 13.8754C337.647 22.7622 356.515 35.4823 372.719 51.6866C388.923 67.8909 401.643 86.7587 410.53 107.768C419.73 129.523 424.395 152.627 424.395 176.444C424.395 200.261 419.73 223.368 410.53 245.119C401.643 266.129 388.923 284.997 372.719 301.201C356.515 317.405 337.647 330.125 316.637 339.012C294.879 348.216 271.771 352.88 247.955 352.88Z" fill="url(#paint0_linear_1_4331)"/>
                        <path d="M161.266 32.9941C163.851 29.9528 163.481 25.3915 160.44 22.8062C157.399 20.2208 152.838 20.5903 150.252 23.6316C147.667 26.6728 148.036 31.234 151.078 33.8194C154.119 36.4048 158.68 36.0353 161.266 32.9941Z" fill="url(#paint1_linear_1_4331)"/>
                        <path d="M121.167 255.809C125.159 255.809 128.395 252.574 128.395 248.582C128.395 244.59 125.159 241.354 121.167 241.354C117.176 241.354 113.94 244.59 113.94 248.582C113.943 252.574 117.179 255.809 121.167 255.809Z" fill="url(#paint2_linear_1_4331)"/>
                        <defs>
                        <linearGradient id="paint0_linear_1_4331" x1="0.837402" y1="176.446" x2="424.395" y2="176.446" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#AC32E4"/>
                        <stop offset="1" stop-color="#7523F4"/>
                        </linearGradient>
                        <linearGradient id="paint1_linear_1_4331" x1="151.078" y1="33.8194" x2="160.44" y2="22.8062" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#AC32E4"/>
                        <stop offset="1" stop-color="#7523F4"/>
                        </linearGradient>
                        <linearGradient id="paint2_linear_1_4331" x1="113.94" y1="248.582" x2="128.395" y2="248.582" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#AC32E4"/>
                        <stop offset="1" stop-color="#7523F4"/>
                        </linearGradient>
                        </defs>
                </svg>
                <?php endif; ?>
            <?php elseif ($settings['background_number'] == '3') : ?>
                <?php if($settings['style_l28'] == 'style1') : ?>
                    <svg width="424" height="354" viewBox="0 0 424 354" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M247.575 353.868C219.568 353.868 192.789 347.497 167.978 334.935C144.691 323.144 123.955 305.993 107.934 285.289C99.6017 287.269 90.3477 288.273 80.4063 288.273C54.635 288.273 34.313 281.168 20.0092 267.156C8.66765 256.044 1.59128 240.614 0.0795539 223.708C0.0327624 223.172 0.212776 222.639 0.57631 222.239C0.939844 221.84 1.45453 221.613 1.99443 221.613H42.1884C43.099 221.613 43.8836 222.25 44.0708 223.139C46.3564 234.024 54.2894 252.287 81.7309 252.287C103.482 252.287 116.468 239.164 116.468 217.182C116.468 206.1 113.387 197.656 107.311 192.08C101.059 186.343 91.4527 183.435 78.7506 183.435H60.5019C59.4401 183.435 58.5798 182.575 58.5798 181.513V149.342C58.5798 148.28 59.4401 147.42 60.5019 147.42H76.3354C99.1769 147.42 108.492 139.76 108.492 120.986C108.492 104.523 97.9171 95.0815 79.4777 95.0815C56.7766 95.0815 50.8916 107.438 48.1309 119.528C47.9329 120.403 47.1555 121.022 46.2556 121.022H6.95435C6.40365 121.022 5.88175 120.788 5.51821 120.378C5.15468 119.967 4.98189 119.42 5.04668 118.873C6.92194 103.047 13.7751 88.6711 24.3464 78.3949C37.8332 65.2825 56.8377 58.6345 80.831 58.6345C103.856 58.6345 122.803 64.9945 135.617 77.0272C146.947 87.6633 153.185 102.532 153.185 118.898C153.185 129.373 150.824 138.619 146.17 146.383C142.384 152.696 137.175 157.919 130.693 161.9C129.789 162.454 128.605 162.173 128.051 161.266C127.497 160.363 127.777 159.179 128.681 158.621C138.107 152.829 149.345 141.24 149.345 118.895C149.345 92.8679 131.402 62.475 80.831 62.475C23.2414 62.475 11.5183 101.863 9.1535 117.174H44.7367C46.6696 109.522 49.5815 103.997 53.8395 99.8615C59.8144 94.0557 68.2009 91.2338 79.4705 91.2338C100.044 91.2338 112.329 102.356 112.329 120.982C112.329 131.604 109.482 139.152 103.622 144.054C97.8308 148.903 88.9008 151.26 76.3282 151.26H62.4167V179.587H78.7434C92.4389 179.587 102.92 182.837 109.903 189.244C116.807 195.579 120.305 204.977 120.305 217.179C120.305 228.394 117.051 237.922 110.896 244.735C104.166 252.186 94.0766 256.124 81.7237 256.124C60.2499 256.124 45.363 244.969 40.6478 225.45H4.12522C6.11926 241.741 17.4069 284.418 80.3991 284.418C90.5169 284.418 99.8787 283.353 108.218 281.251C109.007 281.053 109.82 281.37 110.27 282.021C143.24 325.235 193.278 350.016 247.567 350.016C342.734 350.016 420.16 272.591 420.16 177.424C420.16 82.257 342.734 4.83141 247.567 4.83141C215.087 4.83141 183.441 13.9018 156.05 31.0635C155.15 31.6286 153.966 31.355 153.401 30.4552C152.836 29.5553 153.11 28.3712 154.009 27.8061C182.009 10.2592 214.36 0.987305 247.567 0.987305C271.384 0.987305 294.492 5.65206 316.243 14.852C337.252 23.7388 356.12 36.4589 372.324 52.6632C388.529 68.8674 401.249 87.7352 410.136 108.745C419.336 130.499 424 153.603 424 177.42C424 201.237 419.336 224.345 410.136 246.096C401.249 267.105 388.529 285.973 372.324 302.177C356.12 318.382 337.252 331.102 316.243 339.989C294.499 349.203 271.395 353.868 247.575 353.868Z" fill="currentColor"/>
                        <path d="M159.293 35.3249C155.945 37.4989 151.471 36.5523 149.294 33.2049C147.12 29.8575 148.066 25.3835 151.414 23.2059C154.761 21.0319 159.235 21.9785 161.413 25.3259C163.59 28.6733 162.637 33.1509 159.293 35.3249Z" fill="currentColor"/>
                        <path d="M126.626 153.66C123.095 155.521 121.741 159.891 123.602 163.422C125.463 166.953 129.833 168.306 133.364 166.445C136.895 164.584 138.248 160.215 136.387 156.684C134.526 153.153 130.153 151.799 126.626 153.66Z" fill="currentColor"/>
                    </svg>
                <?php elseif($settings['style_l28'] == 'style2') : ?>
                    <svg width="424" height="353" viewBox="0 0 424 353" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M247.575 352.88C219.568 352.88 192.789 346.509 167.978 333.948C144.691 322.156 123.955 305.005 107.934 284.302C99.6017 286.282 90.3477 287.286 80.4063 287.286C54.635 287.286 34.313 280.181 20.0092 266.168C8.66765 255.057 1.59128 239.627 0.0795539 222.721C0.0327624 222.184 0.212776 221.652 0.57631 221.252C0.939844 220.853 1.45453 220.626 1.99443 220.626H42.1884C43.099 220.626 43.8836 221.263 44.0708 222.152C46.3564 233.036 54.2894 251.299 81.7309 251.299C103.482 251.299 116.468 238.176 116.468 216.195C116.468 205.113 113.387 196.669 107.311 191.093C101.059 185.356 91.4527 182.447 78.7506 182.447H60.5019C59.4401 182.447 58.5798 181.587 58.5798 180.525V148.354C58.5798 147.293 59.4401 146.432 60.5019 146.432H76.3354C99.1769 146.432 108.492 138.773 108.492 119.999C108.492 103.535 97.9171 94.0942 79.4777 94.0942C56.7766 94.0942 50.8916 106.451 48.1309 118.541C47.9329 119.416 47.1555 120.035 46.2556 120.035H6.95435C6.40365 120.035 5.88175 119.801 5.51821 119.39C5.15468 118.98 4.98189 118.433 5.04668 117.886C6.92194 102.06 13.7751 87.6838 24.3464 77.4076C37.8332 64.2952 56.8377 57.6472 80.831 57.6472C103.856 57.6472 122.803 64.0072 135.617 76.0399C146.947 86.6759 153.185 101.545 153.185 117.911C153.185 128.385 150.824 137.632 146.17 145.396C142.384 151.709 137.175 156.932 130.693 160.913C129.789 161.467 128.605 161.186 128.051 160.279C127.497 159.376 127.777 158.191 128.681 157.634C138.107 151.842 149.345 140.252 149.345 117.908C149.345 91.8806 131.402 61.4877 80.831 61.4877C23.2414 61.4877 11.5183 100.875 9.1535 116.187H44.7367C46.6696 108.535 49.5815 103.01 53.8395 98.8742C59.8144 93.0684 68.2009 90.2465 79.4705 90.2465C100.044 90.2465 112.329 101.368 112.329 119.995C112.329 130.617 109.482 138.165 103.622 143.067C97.8308 147.915 88.9008 150.273 76.3282 150.273H62.4167V178.6H78.7434C92.4389 178.6 102.92 181.85 109.903 188.257C116.807 194.592 120.305 203.99 120.305 216.191C120.305 227.407 117.051 236.934 110.896 243.748C104.166 251.199 94.0766 255.136 81.7237 255.136C60.2499 255.136 45.363 243.982 40.6478 224.463H4.12522C6.11926 240.753 17.4069 283.431 80.3991 283.431C90.5169 283.431 99.8787 282.365 108.218 280.263C109.007 280.065 109.82 280.382 110.27 281.034C143.24 324.247 193.278 349.029 247.567 349.029C342.734 349.029 420.16 271.603 420.16 176.437C420.16 81.2697 342.734 3.8441 247.567 3.8441C215.087 3.8441 183.441 12.9145 156.05 30.0762C155.15 30.6413 153.966 30.3677 153.401 29.4679C152.836 28.568 153.11 27.3839 154.009 26.8188C182.009 9.27192 214.36 0 247.567 0C271.384 0 294.492 4.66475 316.243 13.8647C337.252 22.7515 356.12 35.4716 372.324 51.6759C388.529 67.8801 401.249 86.7479 410.136 107.757C419.336 129.512 424 152.616 424 176.433C424 200.25 419.336 223.358 410.136 245.109C401.249 266.118 388.529 284.986 372.324 301.19C356.12 317.394 337.252 330.114 316.243 339.001C294.499 348.216 271.395 352.88 247.575 352.88Z" fill="url(#paint0_linear_1_4340)"/>
                        <path d="M159.293 34.3376C155.946 36.5116 151.472 35.565 149.294 32.2176C147.12 28.8702 148.067 24.3962 151.414 22.2186C154.761 20.0446 159.235 20.9912 161.413 24.3386C163.591 27.686 162.637 32.1636 159.293 34.3376Z" fill="url(#paint1_linear_1_4340)"/>
                        <path d="M126.626 152.673C123.095 154.534 121.741 158.903 123.602 162.434C125.463 165.965 129.833 167.319 133.364 165.458C136.894 163.597 138.248 159.227 136.387 155.696C134.526 152.165 130.153 150.812 126.626 152.673Z" fill="url(#paint2_linear_1_4340)"/>
                        <defs>
                        <linearGradient id="paint0_linear_1_4340" x1="0.0722656" y1="176.44" x2="424" y2="176.44" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#1EFEFF"/>
                        <stop offset="0.369792" stop-color="#2FB8FC"/>
                        <stop offset="1" stop-color="#4C41F6"/>
                        </linearGradient>
                        <linearGradient id="paint1_linear_1_4340" x1="148.126" y1="28.2781" x2="162.582" y2="28.2781" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#1EFEFF"/>
                        <stop offset="0.369792" stop-color="#2FB8FC"/>
                        <stop offset="1" stop-color="#4C41F6"/>
                        </linearGradient>
                        <linearGradient id="paint2_linear_1_4340" x1="122.767" y1="159.065" x2="137.222" y2="159.065" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#1EFEFF"/>
                        <stop offset="0.369792" stop-color="#2FB8FC"/>
                        <stop offset="1" stop-color="#4C41F6"/>
                        </linearGradient>
                        </defs>
                    </svg>
                <?php endif; ?>
            <?php endif; ?>
        </div>
        <div class="item--body">
            <?php if(!empty($settings['sub_title_text'])) : ?>
                <div class="item--sub-title"><?php echo esc_html($settings['sub_title_text']); ?></div>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'icon' && $has_icon ) : ?>
                <div class="item--icon item--icon-<?php echo esc_attr($settings['background_number']); ?>">
                    <?php if($is_new):
                        \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                        else: ?>
                        <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                <div class="item--icon item--icon-<?php echo esc_attr($settings['background_number']); ?>">
                    <?php $img_icon  = consultio_get_image_by_size( array(
                            'attach_id'  => $settings['icon_image']['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail'];
                    echo wp_kses_post($thumbnail_icon); ?>
                </div>
            <?php endif; ?>
            <div class="item--holder">
                <?php if(!empty($settings['title_text'])) : ?>
                    <h3 class="item--title item--title-<?php echo esc_attr($settings['background_number']); ?> <?php echo esc_attr($settings['ct_animate_t']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay_t']); ?>ms">
                        <?php echo esc_html($settings['title_text']); ?>
                    </h3>
                <?php endif; ?>
                <div class="item--description <?php echo esc_attr($settings['ct_animate_d']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay_d']); ?>ms"><?php echo ct_print_html($settings['description_text']); ?></div>
                <?php if ( ! empty( $settings['btn_text'] ) ) { ?>
                    <div class="item--button">
                        <a class="btn-text2" <?php ct_print_html($widget->get_render_attribute_string( 'button' )); ?>>
                            <span><?php echo esc_attr($settings['btn_text']); ?></span>
                            <i class="flaticonv2 flaticonv2-right-arrow"></i>
                        </a>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>