<?php

$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');


$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$show_category = $widget->get_setting('show_category');
$show_date = $widget->get_setting('show_date');
$show_author = $widget->get_setting('show_author');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');

if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}

$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-dir' => $carousel_dir,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-slidesToScroll' => $slides_to_scroll,
] );

$title_tag = $widget->get_setting('title_tag', 'h3');

$thumbnail_size = $widget->get_setting('thumbnail_size', 'full');
$thumbnail_custom_dimension = $widget->get_setting('thumbnail_custom_dimension', '');
if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '385x395';
}
?>
<?php if (is_array($posts)): ?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-blog-carousel-layout14 ct-slick-slider slick-boxshadow">
    <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
        <?php
            foreach ($posts as $post):
            $img_id       = get_post_thumbnail_id( $post->ID );
            $author = get_user_by('id', $post->post_author); ?>
            <div class="carousel-item slick-slide">
                <div class="grid-item-inner <?php echo esc_attr($settings['ct_animate']); ?>">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                        $img          = consultio_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $img_size,
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="item--featured">
                            <div class="item--meta">
                                <?php if($show_date == 'true'): ?>
                                    <div class="item--date">
                                        <span class="day"><?php echo get_the_date('j', $post->ID); ?></span>
                                        <span class="month"><?php echo get_the_date('M', $post->ID); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <div class="item--holder">
                        <?php if($show_category == 'true'): ?>  
                            <div class="item--category">
                                <?php echo get_the_category_list(', ', '', $post->ID); ?>
                            </div>
                        <?php endif; ?>
                        <h3 class="item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h3>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        </div>

        <?php if($settings['show_button'] == 'true'): ?>
            <div class="item--button">
                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn-readmore"><?php echo esc_attr($button_text); ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28" fill="none">
                        <path d="M23.3333 5.83317V17.4998C23.3333 17.8093 23.2104 18.106 22.9916 18.3248C22.7728 18.5436 22.4761 18.6665 22.1667 18.6665C21.8572 18.6665 21.5605 18.5436 21.3417 18.3248C21.1229 18.106 21 17.8093 21 17.4998V8.6495L7.82482 21.8247C7.60478 22.0372 7.31008 22.1548 7.00419 22.1521C6.69829 22.1495 6.40567 22.0268 6.18937 21.8105C5.97306 21.5941 5.85036 21.3015 5.8477 20.9956C5.84504 20.6897 5.96264 20.395 6.17515 20.175L19.3503 6.99984H10.5C10.1906 6.99984 9.89382 6.87692 9.67503 6.65813C9.45624 6.43934 9.33332 6.14259 9.33332 5.83317C9.33332 5.52375 9.45624 5.22701 9.67503 5.00821C9.89382 4.78942 10.1906 4.6665 10.5 4.6665H22.1667C22.3196 4.66723 22.471 4.69775 22.6123 4.75634C22.8255 4.84445 23.0078 4.99377 23.1361 5.18544C23.2644 5.3771 23.3331 5.60251 23.3333 5.83317Z" fill="currentColor"/>
                    </svg>
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>