<?php

$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');


$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$show_category = $widget->get_setting('show_category');
$show_date = $widget->get_setting('show_date');
$show_author = $widget->get_setting('show_author');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');

if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}

$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-dir' => $carousel_dir,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-slidesToScroll' => $slides_to_scroll,
] );

$title_tag = $widget->get_setting('title_tag', 'h3');

$thumbnail_size = $widget->get_setting('thumbnail_size', 'full');
$thumbnail_custom_dimension = $widget->get_setting('thumbnail_custom_dimension', '');
if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '680x410';
}
?>
<?php if (is_array($posts)): ?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-blog-carousel-layout13 ct-slick-slider slick-boxshadow">
    <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
        <?php
            foreach ($posts as $post):
            $img_id       = get_post_thumbnail_id( $post->ID );
            $author = get_user_by('id', $post->post_author); ?>
            <div class="carousel-item slick-slide">
                <div class="grid-item-inner <?php echo esc_attr($settings['ct_animate']); ?>">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                        $img          = consultio_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $img_size,
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="item--featured">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <div class="item--holder">
                        <div class="item--meta">
                            <?php if($show_author == 'true'): ?>
                                <div class="item--author">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                                        <path d="M9.11055 6.49154C10.0064 5.83822 10.5897 4.78089 10.5897 3.58974C10.5897 1.61036 8.97936 0 6.99997 0C5.02058 0 3.41023 1.61036 3.41023 3.58974C3.41023 4.78089 3.99355 5.83822 4.88939 6.49154C2.66251 7.34371 1.0769 9.5028 1.0769 12.0256C1.0769 13.1143 1.9626 14 3.05126 14H10.9487C12.0373 14 12.923 13.1143 12.923 12.0256C12.923 9.5028 11.3374 7.34371 9.11055 6.49154ZM4.48716 3.58974C4.48716 2.20418 5.61441 1.07693 6.99997 1.07693C8.38553 1.07693 9.51278 2.20418 9.51278 3.58974C9.51278 4.9753 8.38553 6.10258 6.99997 6.10258C5.61441 6.10258 4.48716 4.9753 4.48716 3.58974ZM10.9487 12.9231H3.05126C2.55642 12.9231 2.15384 12.5205 2.15384 12.0256C2.15384 9.35342 4.32778 7.17946 7 7.17946C9.67222 7.17946 11.8462 9.35339 11.8462 12.0256C11.8461 12.5205 11.4435 12.9231 10.9487 12.9231Z" fill="currentColor"/>
                                    </svg>
                                    <span>
                                        <?php echo esc_html__('By ', 'consultio'); ?><?php echo get_the_author_meta('display_name', $post->post_author); ?>
                                    </span>
                                </div>
                            <?php endif; ?>
                            <?php if($show_date == 'true'): ?>
                                <div class="item--date">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                                        <g clip-path="url(#clip0_1_4585)">
                                            <path d="M12.5 1.5H11V0.500009C11 0.223857 10.7761 0 10.5 0C10.2238 0 9.99998 0.223857 9.99998 0.500009V1.5H3.99999V0.500009C3.99999 0.223857 3.77613 0 3.50001 0C3.22388 0 3 0.223857 3 0.500009V1.5H1.5C0.671572 1.5 0 2.17157 0 3V12.5C0 13.3284 0.671572 14 1.5 14H12.5C13.3284 14 14 13.3284 14 12.5V3C14 2.17157 13.3284 1.5 12.5 1.5ZM13 12.5C13 12.7762 12.7761 13 12.5 13H1.5C1.22385 13 0.99999 12.7762 0.99999 12.5V6H13V12.5ZM13 5.00001H0.99999V3C0.99999 2.72385 1.22385 2.49999 1.5 2.49999H3V3.49998C3 3.77613 3.22386 3.99999 3.50001 3.99999C3.77616 3.99999 4.00002 3.77613 4.00002 3.49998V2.49999H10V3.49998C10 3.77613 10.2239 3.99999 10.5 3.99999C10.7762 3.99999 11 3.77613 11 3.49998V2.49999H12.5C12.7762 2.49999 13 2.72385 13 3V5.00001H13Z" fill="currentColor"/>
                                            <path d="M4 7H3.00001C2.72386 7 2.5 7.22386 2.5 7.50001C2.5 7.77616 2.72386 8.00002 3.00001 8.00002H4C4.27615 8.00002 4.50001 7.77616 4.50001 7.50001C4.50001 7.22386 4.27615 7 4 7Z" fill="currentColor"/>
                                            <path d="M7.5 7H6.50001C6.22386 7 6 7.22386 6 7.50001C6 7.77616 6.22386 8.00002 6.50001 8.00002H7.5C7.77615 8.00002 8.00001 7.77616 8.00001 7.50001C8.00001 7.22386 7.77615 7 7.5 7Z" fill="currentColor"/>
                                            <path d="M11 7H10C9.72386 7 9.5 7.22386 9.5 7.50001C9.5 7.77616 9.72386 8.00002 10 8.00002H11C11.2762 8.00002 11.5 7.77616 11.5 7.50001C11.5 7.22386 11.2761 7 11 7Z" fill="currentColor"/>
                                            <path d="M4 9H3.00001C2.72386 9 2.5 9.22386 2.5 9.50001C2.5 9.77616 2.72386 10 3.00001 10H4C4.27615 10 4.50001 9.77616 4.50001 9.50001C4.50001 9.22386 4.27615 9 4 9Z" fill="currentColor"/>
                                            <path d="M7.5 9H6.50001C6.22386 9 6 9.22386 6 9.50001C6 9.77616 6.22386 10 6.50001 10H7.5C7.77615 10 8.00001 9.77616 8.00001 9.50001C8.00001 9.22386 7.77615 9 7.5 9Z" fill="currentColor"/>
                                            <path d="M11 9H10C9.72386 9 9.5 9.22386 9.5 9.50001C9.5 9.77616 9.72386 10 10 10H11C11.2762 10 11.5 9.77616 11.5 9.50001C11.5 9.22386 11.2761 9 11 9Z" fill="currentColor"/>
                                            <path d="M4 11H3.00001C2.72386 11 2.5 11.2239 2.5 11.5C2.5 11.7762 2.72386 12 3.00001 12H4C4.27615 12 4.50001 11.7761 4.50001 11.5C4.50001 11.2238 4.27615 11 4 11Z" fill="currentColor"/>
                                            <path d="M7.5 11H6.50001C6.22386 11 6 11.2239 6 11.5C6 11.7762 6.22386 12 6.50001 12H7.5C7.77615 12 8.00001 11.7762 8.00001 11.5C8.00001 11.2239 7.77615 11 7.5 11Z" fill="currentColor"/>
                                            <path d="M11 11H10C9.72386 11 9.5 11.2239 9.5 11.5C9.5 11.7762 9.72386 12 10 12H11C11.2762 12 11.5 11.7762 11.5 11.5C11.5 11.2239 11.2761 11 11 11Z" fill="currentColor"/>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_1_4585">
                                            <rect width="14" height="14" fill="white"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                    <?php echo get_the_date('j M, Y', $post->ID); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <h3 class="item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h3>
                        <?php if($show_button == 'true'): ?>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn-readmore"><?php echo esc_attr($button_text); ?>
                                <span>Learn more</span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                    <path d="M15 5.83333C15 6.08333 14.9167 6.25 14.75 6.41667L6.41667 14.75C6.08333 15.0833 5.58333 15.0833 5.25 14.75C4.91667 14.4167 4.91667 13.9167 5.25 13.5833L13.5833 5.25C13.9167 4.91666 14.4167 4.91666 14.75 5.25C14.9167 5.41667 15 5.58333 15 5.83333Z" fill="currentColor"/>
                                    <path d="M15.0002 5.83366L15.0002 13.3337C15.0002 13.8337 14.6668 14.167 14.1668 14.167C13.6668 14.167 13.3335 13.8337 13.3335 13.3337L13.3335 6.66699L6.66683 6.66699C6.16683 6.66699 5.8335 6.33366 5.8335 5.83366C5.8335 5.33366 6.16683 5.00033 6.66683 5.00033L14.1668 5.00032C14.6668 5.00032 15.0002 5.33366 15.0002 5.83366Z" fill="currentColor"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>