<?php

$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');


$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$show_category = $widget->get_setting('show_category');
$show_date = $widget->get_setting('show_date');
$show_author = $widget->get_setting('show_author');

if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}

$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-dir' => $carousel_dir,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-slidesToScroll' => $slides_to_scroll,
] );

$title_tag = $widget->get_setting('title_tag', 'h3');

$thumbnail_size = $widget->get_setting('thumbnail_size', 'full');
$thumbnail_custom_dimension = $widget->get_setting('thumbnail_custom_dimension', '');
if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '680x410';
}
?>
<?php if (is_array($posts)): ?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-blog-carousel-layout10 ct-slick-slider slick-boxshadow">
    <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>

        <?php
            foreach ($posts as $post):
            $img_id       = get_post_thumbnail_id( $post->ID );
            $author = get_user_by('id', $post->post_author); ?>
            <div class="carousel-item slick-slide">
                <div class="grid-item-inner <?php echo esc_attr($settings['ct_animate']); ?>">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                        $img          = consultio_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $img_size,
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="item--featured">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                            <?php if($show_date == 'true'): ?>
                                <div class="item--date">
                                    <span>
                                        <?php echo esc_html(date('d', strtotime($post->post_date))); ?>
                                    </span>
                                    <span>
                                        <?php echo esc_html(date('M Y', strtotime($post->post_date))); ?>
                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="item--body">
                        <div class="item--holder">
                            <?php if($show_author == 'true' || $show_category == 'true' ) : ?>
                                <ul class="item--meta">
                                    <?php if($show_category == 'true'): ?>
                                        <li class="item--category">
                                            <?php the_terms( $post->ID, 'category', '', ', ' ); ?>
                                        </li>
                                    <?php endif; ?>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                        <g clip-path="url(#clip0_1_3453)">
                                            <mask id="mask0_1_3453" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="16" height="16">
                                            <path d="M0 0H16V16H0V0Z" fill="white"/>
                                            </mask>
                                            <g mask="url(#mask0_1_3453)">
                                            <path d="M8.65238 3.19601L7.99998 0.0947266L7.34758 3.19601C7.13298 4.21618 6.62623 5.15188 5.88909 5.88903C5.15194 6.62617 4.21624 7.13292 3.19607 7.34752L0.0947876 7.99992L3.19607 8.65232C4.21623 8.86692 5.15193 9.37372 5.88909 10.1109C6.62623 10.848 7.13298 11.7837 7.34758 12.8039L7.99998 15.9051L8.65238 12.8039C8.86698 11.7837 9.37371 10.848 10.1108 10.1109C10.848 9.37372 11.7837 8.86692 12.8039 8.65232L15.9052 7.99992L12.8039 7.34752C11.7837 7.13292 10.848 6.62617 10.1108 5.88903C9.37371 5.15188 8.86698 4.21618 8.65238 3.19601Z" fill="#242D31"/>
                                            </g>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_1_3453">
                                            <rect width="16" height="16" fill="white"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                    <?php if($show_author == 'true'): ?>
                                        <li class="item--author">
                                            <?php echo esc_html($author->display_name); ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            <?php endif; ?>
                            <h3 class="item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h3>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>