<?php
$default_settings = [
    'counter_number' => '',
    'counter_title' => '',
    'number' => '',
    'title' => '',
	'counter_suffix' => '',
	'counter_number_2' => '',
	'counter_title_2' => '',
	'counter_suffix_2' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if ( ! empty( $settings['image']['url'] ) ) {
    $widget->add_render_attribute( 'image', 'src', $settings['image']['url'] );
    $widget->add_render_attribute( 'image', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image'] ) );
    $widget->add_render_attribute( 'image', 'title', \Elementor\Control_Media::get_image_title( $settings['image'] ) );
}
$image_html = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' );

// image 2
if ( ! empty( $settings['image_2']['url'] ) ) {
    $widget->add_render_attribute( 'image_2', 'src', $settings['image_2']['url'] );
    $widget->add_render_attribute( 'image_2', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image_2'] ) );
    $widget->add_render_attribute( 'image_2', 'title', \Elementor\Control_Media::get_image_title( $settings['image_2'] ) );
}
$image_html_2 = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image_2' );
?>
<div class="ct-banner7 <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms" style="background-image: url('<?php echo esc_url(site_url('/wp-content/uploads/2025/05/Union.png')); ?>');">
	<div class="ct-banner-inner">
    	<div class="ct-logo">
			<?php echo wp_kses_post($image_html); ?>
		</div>
    	<div class="ct-banner-image">
        	<?php if(!empty($settings['image_2']['url'])) : ?>
            <img src="<?php echo esc_url($settings['image_2']['url']); ?>" alt="<?php echo \Elementor\Control_Media::get_image_alt( $settings['image_2'] ); ?>" class="wow skewInRight" data-wow-delay="0.1s">
            <?php endif; ?>
			<svg xmlns="http://www.w3.org/2000/svg" width="93" height="93" viewBox="0 0 93 93" fill="none">
				<mask id="mask0_1_101" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="93" height="93">
					<path d="M93 0H0V93H93V0Z" fill="white"/>
				</mask>
				<g mask="url(#mask0_1_101)">
					<path fill-rule="evenodd" clip-rule="evenodd" d="M87.8576 46.5C89.6376 46.5 91.3618 46.261 93 45.8134C91.6975 45.5387 90.3472 45.3942 88.9633 45.3942H65.9626C62.1635 45.3942 58.6184 44.3057 55.6228 42.4235C56.2776 38.5902 58.0845 34.9153 61.0438 31.9561L75.7443 17.2559C77.0031 15.9971 78.053 14.6089 78.8952 13.134C77.7796 13.8607 76.7227 14.7133 75.7443 15.692L59.48 31.9561C56.7937 34.6425 53.5173 36.3793 50.0684 37.1668C47.8206 33.993 46.5 30.1167 46.5 25.9319V5.14257C46.5 3.36245 46.261 1.63815 45.8134 0C45.5387 1.30233 45.3942 2.65267 45.3942 4.03675V27.0377C45.3942 30.8367 44.3057 34.3815 42.4236 37.3773C38.5902 36.7223 34.9153 34.9152 31.9561 31.9561L17.2559 17.2559C15.9971 15.9971 14.6089 14.9468 13.134 14.105C13.8607 15.2201 14.7133 16.2772 15.692 17.2559L31.9561 33.52C34.6425 36.2063 36.3794 39.4826 37.1668 42.9317C33.993 45.1792 30.1167 46.5 25.9319 46.5H5.14257C3.36244 46.5 1.63814 46.739 0 47.1868C1.30234 47.4612 2.65268 47.6058 4.03677 47.6058H27.0377C30.8368 47.6058 34.3815 48.6943 37.3773 50.5767C36.7223 54.4096 34.9153 58.0845 31.9561 61.0438L17.2559 75.7443C15.9972 77.0031 14.9469 78.3911 14.1051 79.8661C15.2202 79.1393 16.2772 78.2865 17.2559 77.3081L33.52 61.0438C36.2063 58.3575 39.4826 56.6207 42.9317 55.833C45.1792 59.0071 46.5 62.8833 46.5 67.0683V87.8576C46.5 89.6376 46.739 91.3618 47.1868 93C47.4612 91.6975 47.6058 90.3472 47.6058 88.9633V65.9621C47.6058 62.1631 48.6943 58.6184 50.5767 55.6228C54.4096 56.2776 58.0845 58.0845 61.0438 61.0438L75.7443 75.7443C77.0031 77.0031 78.3911 78.053 79.8661 78.8952C79.1393 77.7796 78.2865 76.7227 77.3081 75.7443L61.0438 59.48C58.3575 56.7937 56.6207 53.5173 55.8335 50.0684C59.0071 47.8206 62.8833 46.5 67.0683 46.5H87.8576Z" fill="#FC4827"/>
				</g>
			</svg>
			<div class="ct-banner-tooltip-trigger">
				<span class="wow fadeIn" data-wow-delay="0.3s"></span>
			</div>
			<div class="ct-banner-tooltip-arrow">
				<svg xmlns="http://www.w3.org/2000/svg" width="135" height="154" viewBox="0 0 135 154" fill="none">
					<path d="M0 2L4.38135 5.75993L5.44687 0.0856071L0 2ZM125.817 25.6258L126.316 25.5938L126.291 25.2061L125.909 25.1344L125.817 25.6258ZM4.33042 3.3219L125.725 26.1173L125.909 25.1344L4.51498 2.33908L4.33042 3.3219ZM125.318 25.6579L133.501 153.032L134.499 152.968L126.316 25.5938L125.318 25.6579Z" fill="white"/>
				</svg>
			</div>
			<div class="ct-banner-tooltip-content wow bounceIn" data-wow-delay="0.5s" style="background-image: url('<?php echo esc_url(site_url('/wp-content/uploads/2025/05/Rectangle-34626800.jpg')); ?>');">
				<div class="ct-banner-tooltip-title">
					<?php echo esc_attr($title); ?> <span><?php echo esc_attr($number); ?></span>
				</div>
				<div class="ct-banner-tooltip-body">
					<div class="ct-banner-tooltip-counter">
						<?php if(!empty($counter_number)) : ?>
							<div class="counter-number">
								<div class="couter-holder">
									<span class="ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($counter_number); ?>">1</span>
									<span class="counter-suffix"><?php echo esc_attr($counter_suffix); ?></span>
								</div>
								<div class="couter-title"><?php echo esc_attr($counter_title); ?></div>
							</div>
						<?php endif; ?>
					</div>
					<div class="ct-banner-tooltip-counter">
						<?php if(!empty($counter_number_2)) : ?>
							<div class="counter-number">
								<div class="couter-holder">
									<span class="ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($counter_number_2); ?>">1</span>
									<span class="counter-suffix"><?php echo esc_attr($counter_suffix_2); ?></span>
								</div>
								<div class="couter-title"><?php echo esc_attr($counter_title_2); ?></div>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
    	</div>
    </div>
</div>