<?php
$default_settings = [
    'counter_number' => '',
    'counter_title' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if ( ! empty( $settings['image']['url'] ) ) {
    $widget->add_render_attribute( 'image', 'src', $settings['image']['url'] );
    $widget->add_render_attribute( 'image', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image'] ) );
    $widget->add_render_attribute( 'image', 'title', \Elementor\Control_Media::get_image_title( $settings['image'] ) );
}
$image_html = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' );

// image 2
if ( ! empty( $settings['image_2']['url'] ) ) {
    $widget->add_render_attribute( 'image_2', 'src', $settings['image_2']['url'] );
    $widget->add_render_attribute( 'image_2', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image_2'] ) );
    $widget->add_render_attribute( 'image_2', 'title', \Elementor\Control_Media::get_image_title( $settings['image_2'] ) );
}
$image_html_2 = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image_2' );
?>
<div class="ct-banner6 <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
	<div class="ct-banner-imge">
    	<?php echo wp_kses_post($image_html); ?>
    	<div class="ct-banner-imge2">
        	<?php if(!empty($settings['image_2']['url'])) : ?>
				<img src="<?php echo esc_url($settings['image_2']['url']); ?>" alt="<?php echo \Elementor\Control_Media::get_image_alt( $settings['image_2'] ); ?>" class="wow skewIn" data-wow-delay="0.4s" />
            <?php endif; ?>
    	</div>
    	<div class="ct-banner-counter">
    		<div class="counter-holder">
				<?php if(!empty($counter_title)) : ?>
    				<div class="counter-title">
    					<?php echo esc_attr($counter_title); ?>
    				</div>
    			<?php endif; ?>
    			<?php if(!empty($counter_number)) : ?>
    				<div class="counter-number">
    					<span class="ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($counter_number); ?>">1</span>
    				</div>
    			<?php endif; ?>
    		</div>
    	</div>
    </div>
    <h3 class="ct-banner-title"><?php echo esc_attr($title); ?></h3>
</div>