<?php
$default_settings = [
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$award_list = $settings['award_list'];

?>

<div class="ct-award-list">
    <?php foreach($award_list as $item) : 
        $image = $item['image'];
        $title = $item['title'];
        $year = $item['year'];
        $link = $item['link'];
        $description = $item['description'];
        ?>
        <div class="ct-award-item">
            <div class="ct-award-item-col-1">
                <div class="ct-award-item--image">
                    <?php echo wp_get_attachment_image($item['image']['id'], 'full'); ?>
                </div>
                <div class="ct-award-item--title">
                    <a href="<?php echo esc_url($link['url']); ?>">
                        <?php echo esc_html($title); ?>
                    </a>
                </div>
            </div>
            <div class="ct-award-item-col-2">
                <div class="ct-award-item--year">
                    <?php echo esc_html($year); ?>
                </div>
                <div class="ct-award-item--description">
                    <?php echo esc_html($description); ?>
                </div>
            </div>
            <div class="ct-award-item--arrow">
                <a href="<?php echo esc_url($link['url']); ?>" class="ct-award-item--arrow-link">
                    <i class="flaticonv4-arrow"></i>
                </a>
            </div>
        </div>
    <?php endforeach; ?>
</div>
