
<?php
// Register Semi Circle Chart Widget
ct_add_custom_widget(
    array(
        'name' => 'ct_semi_circle_chart',
        'title' => esc_html__('Case Semi Circle Chart', 'consultio' ),
        'icon' => 'eicon-dashboard',
        'categories' => array( Case_Theme_Core::CT_CATEGORY_NAME ),
        'scripts' => array(
            'ct-semi-circle-chart-widget-js',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'content_section',
                    'label' => esc_html__('Content', 'consultio' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'ct-year-1',
                            'label' => esc_html__('Year 1', 'consultio' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '2023',
                        ),
                        array(
                            'name' => 'ct-year-2',
                            'label' => esc_html__('Year 2', 'consultio' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '2024',
                        ),
                        array(
                            'name' => 'ct-year-3',
                            'label' => esc_html__('Year 3', 'consultio' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '2025',
                        ),
                        array(
                            'name' => 'ct-value-1',
                            'label' => esc_html__('Value 1', 'consultio' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '98,560',
                        ),
                        array(
                            'name' => 'ct-value-2',
                            'label' => esc_html__('Value 2', 'consultio' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '102,560',
                        ),
                        array(
                            'name' => 'ct-value-3',
                            'label' => esc_html__('Value 3', 'consultio' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '105,560',
                        ),
                    ),
                ),
                array(
                    'name' => 'ct-style',
                    'label' => esc_html__('Style', 'consultio' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'ct-color-title-tooltip',
                            'label' => esc_html__('Color Title Tooltip', 'consultio' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selector' => [
                                '{{WRAPPER}} .ct-semi-circle-chart .ct-semi-circle-tooltip-content-header' => 'color: {{VALUE}};'
                            ],
                        ),
                    ),
                )
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);