<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use TPCore\Elementor\Controls\Group_Control_TPBGGradient;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Testimonial extends Widget_Base {

    use \TPCore\Widgets\TPCoreElementFunctions;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tp-testimonial';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Testimonial', 'tpcore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tpcore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'tpcore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

    protected function register_controls(){
        $this->register_controls_section();
        $this->style_tab_content();
    }   

	protected function register_controls_section() {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tp_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                    'layout-3' => esc_html__('Layout 3', 'tpcore')
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        
        // tp_section_title
        $this->tp_section_title_render_controls('section', 'Section Title', 'Sub Title', 'your title here', $default_description = 'Hic nesciunt galisum aut dolorem aperiam eum soluta quod ea cupiditate.',['layout-1','layout-2']);


        // button
        $this->tp_button_render('testi', 'Button', ['layout-1','layout-2']);

        
        // testi shape
        $this->start_controls_section(
            'tp_testi_shape',
                [
                  'label' => esc_html__( 'Testimonial Shape', 'tpcore' ),
                  'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                  'condition' => [
                    'tp_design_style' => ['layout-2']
                  ]
                ]
           );
   
           $this->add_control(
            'tp_testi_shape_switch',
            [
              'label'        => esc_html__( 'Shape On/Off', 'tpcore' ),
              'type'         => \Elementor\Controls_Manager::SWITCHER,
              'label_on'     => esc_html__( 'Show', 'tpcore' ),
              'label_off'    => esc_html__( 'Hide', 'tpcore' ),
              'return_value' => 'yes',
              'default'      => '1',
            ]
           );
   
           $this->add_control(
               'tp_bg_image_1',
               [
                   'label' => esc_html__( 'Choose Bg Image', 'tp-core' ),
                   'type' => \Elementor\Controls_Manager::MEDIA,
                   'default' => [
                       'url' => \Elementor\Utils::get_placeholder_image_src(),
                   ]
               ]
           );

           $this->add_group_control(
               Group_Control_Image_Size::get_type(),
               [
                   'name' => 'shape_image_size', // // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                   'exclude' => ['custom']
               ]
           );
           
           $this->end_controls_section();

        
        // Review group
        $this->start_controls_section(
            'review_list',
            [
                'label' => esc_html__( 'Review List', 'tpcore' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'repeater_condition',
            [
                'label' => __( 'Field condition', 'tpcore' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'tpcore' ),
                    'style_2' => __( 'Style 2', 'tpcore' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        //icon image svg

        $repeater->add_control(
            'tp_box_icon_type',
            [
                'label' => esc_html__('Select Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'svg',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                    'svg' => esc_html__('SVG', 'tpcore'),
                ],
                'condition' => [
                    'repeater_condition' => ['style_1'],
                ]
            ]
        );
        $repeater->add_control(
            'tp_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'tpcore'),
                'condition' => [
                    'tp_box_icon_type' => 'svg',
                    'repeater_condition' => ['style_1'],
                ]
            ]
        );

        $repeater->add_control(
            'tp_box_icon_image',
            [
                'label' => esc_html__('Upload Icon Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_box_icon_type' => 'image',
                    'repeater_condition' => ['style_1'],
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'tp_box_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                        'repeater_condition' => ['style_1'],
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'tp_box_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                        'repeater_condition' => ['style_1'],
                    ]
                ]
            );
        }

        $repeater->add_control(
            'brand_logo',
            [
                'label' => esc_html__('Client Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'repeater_condition' => ['style_1','style_2']
                ]

            ]
        );

        $repeater->add_control(
            'brand_logo_2',
            [
                'label' => esc_html__('Brand Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'repeater_condition' => ['style_2']
                ]

            ]
        );
        $repeater->add_control(
            'review_content',
            [
                'label' => esc_html__( 'Review Content', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => 'Aklima The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections Bonorum et Malorum original.',
                'placeholder' => esc_html__( 'Type your review content here', 'tpcore' ),
            ]
        );

        $repeater->add_control(
            'reviewer_name', [
                'label' => esc_html__( 'Reviewer Name', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Rasalina William' , 'tpcore' ),
                'label_block' => true,
                'condition' => [
                    'repeater_condition' => ['style_1', 'style_2']
                ]
            ]
        );

        $repeater->add_control(
            'reviewer_title', [
                'label' => esc_html__( 'Reviewer Title', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '- CEO at YES Germany' , 'tpcore' ),
                'label_block' => true,
                'condition' => [
                    'repeater_condition' => ['style_1', 'style_2']
                ]
            ]
        );

        // rating
        $repeater->add_control(
            'tp_testi_rating',
            [
                'label' => esc_html__('Select Rating Count', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__('Single Star', 'tpcore'),
                    '2' => esc_html__('2 Star', 'tpcore'),
                    '3' => esc_html__('3 Star', 'tpcore'),
                    '4' => esc_html__('4 Star', 'tpcore'),
                    '5' => esc_html__('5 Star', 'tpcore'),
                ],
                'default' => '5',
                'condition' => [
                    'repeater_condition' => ['style_1', 'style_3', 'style_4']
                ]
            ]
        );


        $this->add_control(
            'reviews_list',
            [
                'label' => esc_html__( 'Review List', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' =>  $repeater->get_controls(),
                'default' => [
                    [
                        'reviewer_name' => esc_html__( 'Rasalina William', 'tpcore' ),
                        'reviewer_title' => esc_html__( 'CEO at YES Germany', 'tpcore' ),
                        'review_content' => esc_html__( 'Construction can be defined as the art of building something. These construction quotes will put into perspective the fact that construction can be', 'tpcore' ),
                    ],
                    [
                        'reviewer_name' => esc_html__( 'Rasalina William 2', 'tpcore' ),
                        'reviewer_title' => esc_html__( 'CEO at YES Germany', 'tpcore' ),
                        'review_content' => esc_html__( 'Construction can be defined as the art of building something. These construction quotes will put into perspective the fact that construction can be', 'tpcore' ),
                    ],
                    [
                        'reviewer_name' => esc_html__( 'Rasalina William 3', 'tpcore' ),
                        'reviewer_title' => esc_html__( 'CEO at YES Germany', 'tpcore' ),
                        'review_content' => esc_html__( 'Construction can be defined as the art of building something. These construction quotes will put into perspective the fact that construction can be', 'tpcore' ),
                    ],

                ],
                'title_field' => '{{{ reviewer_name }}}',
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail_size',
                'default' => 'full',
                'exclude' => ['custom'],
                'separator' => 'none',
            ]
        );


        $this->end_controls_section();


	}

    // style_tab_content
    protected function style_tab_content(){
        $this->tp_section_style_controls('testimonial_section', 'Section Style', '.ele-section');
    }


	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

<!--	testimonial style 3 -->
<?php if ( $settings['tp_design_style']  == 'layout-3' ):
    $this->add_render_attribute('title_args', 'class', 'feature-title');   

?>
<div class="row">
    <div class="col-xl-12">
        <div class="tp-testimonial-3__wrapper">
            <div class="swiper-container tp-testimonial-3__active">
                <div class="swiper-wrapper">
                <?php foreach ($settings['reviews_list'] as $index => $item) : 
                    if ( !empty($item['brand_logo']['url']) ) {
                    $tp_brand_logo = !empty($item['brand_logo']['id']) ? wp_get_attachment_image_url( $item['brand_logo']['id'], $settings['thumbnail_size_size']) : $item['brand_logo']['url'];
                    $tp_brand_logo_alt = get_post_meta($item["brand_logo"]["id"], "_wp_attachment_image_alt", true);
                    }
                    if ( !empty($item['brand_logo_2']['url']) ) {
                    $tp_brand_logo_2 = !empty($item['brand_logo_2']['id']) ? wp_get_attachment_image_url( $item['brand_logo_2']['id'], $settings['thumbnail_size_size']) : $item['brand_logo_2']['url'];
                    $tp_brand_logo_2_alt = get_post_meta($item["brand_logo_2"]["id"], "_wp_attachment_image_alt", true);
                    }
                ?>
                    <div class="swiper-slide">
                        <div class="tp-testimonial-3__item">
                            <div class="tp-testimonial-3__top d-flex align-items-center justify-content-between">
                                <div class="tp-testimonial-3__top-thumb">
                                    <img src="<?php echo esc_url($tp_brand_logo); ?>"
                                        alt="<?php echo esc_attr($tp_brand_logo_alt); ?>">
                                </div>
                                <div class="tp-testimonial-3__top-text">
                                <?php if ( !empty($item['review_content']) ) : ?>
                                    <p><?php echo tp_kses($item['review_content']); ?></p>
                                <?php endif; ?>
                                </div>
                            </div>
                            <div class="tp-testimonial-3__bottom d-flex align-items-center justify-content-between">
                                <div class="tp-testimonial-3__author-info">
                                <?php if(!empty($item['reviewer_name']) ) : ?>
                                    <h4 class="tp-testimonial-3__author-name"><?php echo tp_kses($item['reviewer_name']); ?></h4>
                                    <?php endif; ?>
                                    <?php if(!empty($item['reviewer_title'])) : ?>
                                    <span><?php echo tp_kses($item['reviewer_title']); ?></span>
                                    <?php endif; ?>
                                </div>

                                <div class="tp-testimonial-3__bottom-right d-none d-sm-block">
                                <img src="<?php echo esc_url($tp_brand_logo_2); ?>"
                                    alt="<?php echo esc_attr($tp_brand_logo_2_alt); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="tp-testimonial-slider-dots"></div>
        </div>
    </div>                    
</div>

<!--	testimonial style 2 -->
<?php elseif ( $settings['tp_design_style']  == 'layout-2' ):
    $this->add_render_attribute('title_args', 'class', 'tp-section-title');   
    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    } 

    if ( !empty($settings['tp_bg_image_1']['url']) ) {
        $tp_bg_image_1 = !empty($settings['tp_bg_image_1']['id']) ? wp_get_attachment_image_url( $settings['tp_bg_image_1']['id'], $settings['shape_image_size_size']) : $settings['tp_bg_image_1']['url'];
        $tp_bg_image_alt_1 = get_post_meta($settings["tp_bg_image_1"]["id"], "_wp_attachment_image_alt", true);
    }


    if ('2' == $settings['tp_testi_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_testi_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
    } else {
        if ( ! empty( $settings['tp_testi_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_testi_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
        }
    }
?>
<div class="tp-testimonial-2__area tp-testimonial-2__space fix p-relative z-index grey-bg">
    <?php if ( !empty($tp_bg_image_1) ) : ?>
    <div class="tp-testimonial-2__shape">
        <img src="<?php echo esc_url($tp_bg_image_1);?>" alt="<?php echo esc_attr($tp_bg_image_alt_1); ?>">
    </div>
    <?php endif; ?>
    <div class="container">
        <div class="row">
        <?php if ( !empty($settings['tp_section_section_title_show']) ) : ?>
            <div class="col-xl-6 col-lg-6">
                <div class="tp-testimonial-2__left-side">
                    <div class="tp-testimonial-2__section-title pb-20">
                    <?php if ( !empty($settings['tp_section_sub_title']) ) : ?>
                        <span class="tp-section-subtitle-2"><?php echo tp_kses( $settings['tp_section_sub_title'] ); ?></span>
                        <?php endif; ?>

                        <?php if ( !empty($settings['tp_section_title' ]) ) :
                                printf( '<%1$s %2$s>%3$s</%1$s>',
                                tag_escape( $settings['tp_section_title_tag'] ),
                                $this->get_render_attribute_string( 'title_args' ),
                                tp_kses( $settings['tp_section_title' ] )
                                );
                            endif;  ?>

                    </div>
                    <?php if ( !empty($settings['tp_section_description']) ) : ?>
                    <div class="tp-testimonial-2__left-text">
                        <p><?php echo tp_kses( $settings['tp_section_description'] ); ?></p>
                    </div>
                    <?php endif; ?>
                    <?php if ( !empty($settings['tp_testi_btn_text']) ) : ?>
                    <a <?php echo $this->get_render_attribute_string( 'tp-button-arg' ); ?>><?php echo tp_kses($settings['tp_testi_btn_text']); ?></a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
            <div class="col-xl-6 col-lg-6">
                <div class="tp-testimonial-2__wrapper p-relative">
                    <div class="tp-testimonial-2__section-arrow d-flex justify-content-center  justify-content-md-end">
                        <div class="test-next">
                            <button><i class="fa-solid fa-arrow-left-long"></i></button>
                        </div>
                        <div class="test-prev">
                            <button><i class="fa-solid fa-arrow-right-long"></i></button>
                        </div>
                    </div>
                    <div class="swiper-container tp-testimonial-2__active">
                        <div class="swiper-wrapper">
                        <?php foreach ($settings['reviews_list'] as $index => $item) : 
                            if ( !empty($item['brand_logo']['url']) ) {
                            $tp_brand_logo = !empty($item['brand_logo']['id']) ? wp_get_attachment_image_url( $item['brand_logo']['id'], $settings['thumbnail_size_size']) : $item['brand_logo']['url'];
                            $tp_brand_logo_alt = get_post_meta($item["brand_logo"]["id"], "_wp_attachment_image_alt", true);
                                }
                            ?>
                            <div class="swiper-slide">
                                <div class="tp-testimonial-2__item-box p-relative">                            
                                    <div class="tp-testimonial-2__item">
                                        <div class="tp-testimonial-2__top pb-15 d-flex align-items-center justify-content-between">
                                            <div class="tp-testimonial-2__icon">
                                                <span>
                                                <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                                    <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                                    <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                                    <?php endif; ?>
                                                    <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                                    <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                                    <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                                        alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                                    <?php endif; ?>
                                                    <?php else : ?>
                                                    <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                                    <?php echo $item['tp_box_icon_svg']; ?>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                </span>                                
                                            </div>
                                            <div class="tp-testimonial-2__star">
                                                <?php
                                                $tp_rating = $item['tp_testi_rating'];
                                                for($i=1; $i<=$tp_rating; $i++) :
                                                ?>
                                                <span>
                                                <i class="fa-solid fa-star"></i>
                                                </span>
                                                <?php endfor; ?>                               
                                            </div>
                                        </div>
                                        <?php if ( !empty($item['review_content']) ) : ?>
                                        <div class="tp-testimonial-2__text">
                                            <p><?php echo tp_kses($item['review_content']); ?></p>      
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="tp-testimonial-2__author-box d-flex align-items-center">
                                        <div class="tp-testimonial-2__img pr-25">
                                        <img src="<?php echo esc_url($tp_brand_logo); ?>"
                                             alt="<?php echo esc_attr($tp_brand_logo_alt); ?>">
                                        </div>
                                        <div class="tp-testimonial-2__author-info">

                                        <?php if(!empty($item['reviewer_name']) ) : ?>
                                            <h4 class="tp-testimonial-2__author-name"><?php echo tp_kses($item['reviewer_name']); ?></h4>
                                        <?php endif; ?>
                                        <?php if(!empty($item['reviewer_title'])) : ?>
                                                    <span><?php echo tp_kses($item['reviewer_title']); ?></span>
                                                    <?php endif; ?>
                                        </div>
                                    </div> 
                                    <div class="tp-testimonial-2__item-shape">
                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/testimonial/testi-shape-2-1.png" alt="">
                                    </div>                                           
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>



<!-- default style -->
<?php else:
    $this->add_render_attribute('title_args', 'class', 'tp-section-title');   
    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }     


    if ('2' == $settings['tp_testi_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_testi_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
    } else {
        if ( ! empty( $settings['tp_testi_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_testi_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
        }
    }
?>
<div class="tp-testimonial__area">
            <div class="tp-testimonial__bg" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/testimonial/testi-bg-1.jpg">
                <div class="container-fluid g-0">
                    <div class="row g-0">
                    <?php if ( !empty($settings['tp_section_section_title_show']) ) : ?>
                        <div class="col-xl-5 col-lg-6 col-md-6">
                            <div class="tp-testimonial__left-side">
                                <div class="tp-testimonial__section-title pb-20">
                                <?php if ( !empty($settings['tp_section_sub_title']) ) : ?>
                                    <span class="tp-section-subtitle"> <?php echo tp_kses( $settings['tp_section_sub_title'] ); ?></span>
                                    <?php endif; ?>
                                    <?php
                                        if ( !empty($settings['tp_section_title' ]) ) :
                                            printf( '<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape( $settings['tp_section_title_tag'] ),
                                            $this->get_render_attribute_string( 'title_args' ),
                                            tp_kses( $settings['tp_section_title' ] )
                                            );
                                        endif;
                                        ?>
                                </div>
                                <?php if ( !empty($settings['tp_section_description']) ) : ?>
                                <div class="tp-testimonial__left-text">
                                    <p> <?php echo tp_kses( $settings['tp_section_description'] ); ?>
                                    </p>
                                </div>
                                <?php endif; ?>
                                <?php if ( !empty($settings['tp_testi_btn_text']) ) : ?>
                                <a  <?php echo $this->get_render_attribute_string( 'tp-button-arg' ); ?>><?php echo tp_kses($settings['tp_testi_btn_text']); ?></a>
                                <?php endif; ?>

                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="col-xl-7 col-lg-6 col-md-6">
                            <div class="tp-testimonial__wrapper">
                                <div class="swiper-container tp-testimonial__active">
                                    <div class="swiper-wrapper">
                                    <?php foreach ($settings['reviews_list'] as $index => $item) : 
                                        if ( !empty($item['brand_logo']['url']) ) {
                                        $tp_brand_logo = !empty($item['brand_logo']['id']) ? wp_get_attachment_image_url( $item['brand_logo']['id'], $settings['thumbnail_size_size']) : $item['brand_logo']['url'];
                                        $tp_brand_logo_alt = get_post_meta($item["brand_logo"]["id"], "_wp_attachment_image_alt", true);
                                            }
                                        ?>
                                        <div class="swiper-slide">
                                            <div class="tp-testimonial__item-box">
                                                <div class="tp-testimonial__item">
                                                    <div class="tp-testimonial__thumb">
                                                    <img src="<?php echo esc_url($tp_brand_logo); ?>"
                                                        alt="<?php echo esc_attr($tp_brand_logo_alt); ?>">
                                                    </div>
                                                    <div class="tp-testimonial__content p-relative">
                                                        <div class="tp-testimonial__text">
                                                            <div class="tp-testimonial__star">
                                                            <?php
                                                                $tp_rating = $item['tp_testi_rating'];
                                                                for($i=1; $i<=$tp_rating; $i++) :
                                                                ?>
                                                                <span>
                                                                <i class="fa-solid fa-star-sharp"></i>
                                                                </span>
                                                                <?php endfor; ?>
                                                            </div>
                                                            <?php if ( !empty($item['review_content']) ) : ?>
                                                                <p><?php echo tp_kses($item['review_content']); ?></p>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="tp-testimonial__quote">
                                                            <span>
                                                            <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                                                <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                                                <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                                                <?php endif; ?>
                                                                <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                                                <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                                                <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                                                    alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                                                <?php endif; ?>
                                                                <?php else : ?>
                                                                <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                                                <?php echo $item['tp_box_icon_svg']; ?>
                                                                <?php endif; ?>
                                                                <?php endif; ?>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tp-testimonial__author-info">
                                                    <?php if(!empty($item['reviewer_name']) ) : ?>
                                                        <h4 class="tp-testimonial__author-name"><?php echo tp_kses($item['reviewer_name']); ?></h4>
                                                    <?php endif; ?>
                                                    <?php if(!empty($item['reviewer_title'])) : ?>
                                                        <span><?php echo tp_kses($item['reviewer_title']); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


<?php endif; 
	}
}

$widgets_manager->register( new TP_Testimonial() );