<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Providing_Tab extends Widget_Base {

    use \TPCore\Widgets\TPCoreElementFunctions;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'providing-tab';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Providing Tab', 'tpcore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tpcore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'tpcore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

	protected function register_controls() {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tp_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

		
        // tp_section_title
        $this->tp_section_title_render_controls('section', 'Section Title', 'Sub Title', 'your title here', $default_description = 'Hic nesciunt galisum aut dolorem aperiam eum soluta quod ea cupiditate.');


        // Approch Tabs
		$this->start_controls_section(
            '_section_price_tabs',
            [
                'label' => __('Our Approch Tabs', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'tab_title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('Our Approch Tab', 'tpcore'),
                'default' => __('Our Approch', 'tpcore'),
                'placeholder' => __('Type Our Approch', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'tp_box_icon_type',
            [
                'label' => esc_html__('Select Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                    'svg' => esc_html__('SVG', 'tpcore'),
                ]
            ]
        );
        $repeater->add_control(
            'tp_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'tpcore'),
                'condition' => [
                    'tp_box_icon_type' => 'svg'
                ]
            ]
        );

        $repeater->add_control(
            'tp_box_icon_image',
            [
                'label' => esc_html__('Upload Icon Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_box_icon_type' => 'image'
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'tp_box_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tp_box_icon_type' => 'icon'
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'tp_box_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tp_box_icon_type' => 'icon'
                    ]
                ]
            );
        }

        $repeater->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('Title', 'tpcore'),
                'default' => __('Get Inspire and Help', 'tpcore'),
                'placeholder' => __('Type Tab Title', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'discription',
            [
                'label' => __('Discription', 'tpcore'),
                'placeholder' => __('Discription Area', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA
            ]
        );

        $this->add_control(
            'approch_tabs',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{title}}',
                'default' => [
                    [
                        'title' => 'Get Inspire and Help',
                    ],
                    [
                        'title' => 'Become a Volunteer',
                    ]
                ]
            ]
        );

        $this->end_controls_section();


         // Misson Tabs
		$this->start_controls_section(
            '_section_misson_tabs',
            [
                'label' => __('Make Difference Tabs', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'make_tab_title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('Make Difference Tab', 'tpcore'),
                'default' => __('Make Difference', 'tpcore'),
                'placeholder' => __('Type Make Difference', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'tp_box_icon_type',
            [
                'label' => esc_html__('Select Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                    'svg' => esc_html__('SVG', 'tpcore'),
                ]
            ]
        );
        $repeater->add_control(
            'tp_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'tpcore'),
                'condition' => [
                    'tp_box_icon_type' => 'svg'
                ]
            ]
        );

        $repeater->add_control(
            'tp_box_icon_image',
            [
                'label' => esc_html__('Upload Icon Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_box_icon_type' => 'image'
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'tp_box_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tp_box_icon_type' => 'icon'
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'tp_box_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tp_box_icon_type' => 'icon'
                    ]
                ]
            );
        }

        $repeater->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('Title', 'tpcore'),
                'default' => __('Get Inspire and Help', 'tpcore'),
                'placeholder' => __('Type Tab Title', 'tpcore'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'discription',
            [
                'label' => __('Discription', 'tpcore'),
                'placeholder' => __('Discription Area', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA
            ]
        );

        $this->add_control(
            'make_difference_tabs',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{title}}',
                'default' => [
                    [
                        'title' => 'Get Inspire and Help',
                    ],
                    [
                        'title' => 'Become a Volunteer',
                    ]
                ]
            ]
        );

        $this->end_controls_section();

        
        // tab shape
        $this->start_controls_section(
            'tp_tab_extra',
                [
                  'label' => esc_html__( 'Tab Extra Info', 'tpcore' ),
                  'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
           );
   
   
           $this->add_control(
               'tp_bg_image',
               [
                   'label' => esc_html__( 'Choose Background Image', 'tp-core' ),
                   'type' => \Elementor\Controls_Manager::MEDIA,
                   'default' => [
                       'url' => \Elementor\Utils::get_placeholder_image_src(),
                   ]
               ]
           );
   
           $this->add_control(
               'tp_right_image',
               [
                   'label' => esc_html__( 'Choose Right Image', 'tp-core' ),
                   'type' => \Elementor\Controls_Manager::MEDIA,
                   'default' => [
                       'url' => \Elementor\Utils::get_placeholder_image_src(),
                   ]
               ]
           );
   
           $this->add_group_control(
               Group_Control_Image_Size::get_type(),
               [
                   'name' => 'shape_image_size', // // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                   'exclude' => ['custom'],
                   'condition' => [
                       'tp_tab_shape_switch' => 'yes'
                   ]
               ]
           );

           // donation icon image 

           $this->add_control(
            'tp_box_icon_type',
            [
                'label' => esc_html__('Select Info Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                    'svg' => esc_html__('SVG', 'tpcore'),
                ]
            ]
        );
        $this->add_control(
            'tp_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'tpcore'),
                'condition' => [
                    'tp_box_icon_type' => 'svg'
                ]
            ]
        );

        $this->add_control(
            'tp_box_icon_image',
            [
                'label' => esc_html__('Upload Icon Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_box_icon_type' => 'image'
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $this->add_control(
                'tp_box_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tp_box_icon_type' => 'icon'
                    ]
                ]
            );
        } else {
            $this->add_control(
                'tp_box_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tp_box_icon_type' => 'icon'
                    ]
                ]
            );
        }



           $this->add_control(
            'donation_title',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => __('Donation Title', 'tpcore'),
                'default' => __('Donation Title Hear', 'tpcore'),
                'label_block' => true,
            ]
        );
           
           $this->end_controls_section();

	}

    // style_tab_content
    protected function style_tab_content(){
        $this->tp_section_style_controls('advanced_tab_section', 'Section Style', '.ele-section');
        $this->tp_basic_style_controls('advanced_tab_sub_title', 'Subtitle Style', '.ele-subtitle');
        $this->tp_basic_style_controls('advanced_tab_title', 'Heading Style', '.ele-heading');
        $this->tp_basic_style_controls('advanced_tab_des', 'Content Style', '.ele-description');
        $this->tp_basic_style_controls('advanced_tab_link', 'Tab Link Style', '.ele-link');
    }

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>


<?php if ( $settings['tp_design_style']  == 'layout-1' ): 
    // shape image
    if ( !empty($settings['tp_bg_image']['url']) ) {
        $tp_bg_image = !empty($settings['tp_bg_image']['id']) ? wp_get_attachment_image_url( $settings['tp_bg_image']['id'], $settings['shape_image_size_size']) : $settings['tp_bg_image']['url'];
        $tp_bg_image_alt = get_post_meta($settings["tp_bg_image"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_right_image']['url']) ) {
        $tp_right_image = !empty($settings['tp_right_image']['id']) ? wp_get_attachment_image_url( $settings['tp_right_image']['id'], $settings['shape_image_size_size']) : $settings['tp_right_image']['url'];
        $tp_right_image_alt = get_post_meta($settings["tp_right_image"]["id"], "_wp_attachment_image_alt", true);
    }

    $this->add_render_attribute('title_args', 'class', 'tp-section-title pb-15');
?>

<div class="tp-providing__area tp-providing__space p-relative">
            <div class="tp-providing__bg wow tpfadeLeft" data-wow-duration=".9s"
            data-wow-delay=".3s" data-background="<?php echo esc_url($tp_right_image); ?>">
                <div class="tp-providing__bg-text-box d-none d-xl-block">
                    <div class="tp-providing__bg-text d-flex align-items-center">
                        <span>
                            <?php if($settings['tp_box_icon_type'] == 'icon') : ?>
                                <?php if (!empty($settings['tp_box_icon']) || !empty($settings['tp_box_selected_icon']['value'])) : ?>
                                <?php tp_render_icon($settings, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                <?php endif; ?>
                                <?php elseif( $settings['tp_box_icon_type'] == 'image' ) : ?>
                                <?php if (!empty($settings['tp_box_icon_image']['url'])): ?>
                                <img src="<?php echo $settings['tp_box_icon_image']['url']; ?>"
                                    alt="<?php echo get_post_meta(attachment_url_to_postid($settings['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                <?php endif; ?>
                                <?php else : ?>
                                <?php if (!empty($settings['tp_box_icon_svg'])): ?>
                                <?php echo $settings['tp_box_icon_svg']; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </span>
                        <?php if ( !empty($settings['donation_title']) ) : ?>
                        <h4 class="tp-providing__title-2"><?php echo tp_kses( $settings['donation_title'] ); ?></h4>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php if(!empty($tp_bg_image)) : ?>
            <div class="tp-providing__grey-bg" data-background="<?php echo esc_url($tp_bg_image); ?>">    
            </div>
            <?php endif; ?>
            <div class="tp-providing__wrapper">
                <div class="container">
                    <div class="row">
                        <div class="offset-xl-5 col-xl-7 col-lg-10 col-md-12 wow tpfadeRight" data-wow-duration=".9s"
                        data-wow-delay=".7s">
                            <div class="tp-providing__item-box">
                                <div class="tp-providing__content">
                                    <?php
                                        if ( !empty($settings['tp_section_title' ]) ) :
                                            printf( '<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape( $settings['tp_section_title_tag'] ),
                                            $this->get_render_attribute_string( 'title_args' ),
                                            tp_kses( $settings['tp_section_title' ] )
                                            );
                                        endif; 
                                        ?>
                                    <?php if ( !empty($settings['tp_section_description']) ) : ?>
                                        <p><?php echo tp_kses( $settings['tp_section_description'] ); ?></p>
                                    <?php endif; ?>
                                </div>
                                <div class="tp-providing__tab">
                                    <nav>
                                        <div class="nav nav-tab pb-50" id="nav-tab" role="tablist">
                                            <button class="nav-link active" id="nav-Approch-tab" data-bs-toggle="tab"
                                                data-bs-target="#nav-Approch" type="button" role="tab"
                                                aria-controls="nav-Approch" aria-selected="true">
                                                <?php if ( !empty($settings['tab_title']) ) : ?>
                                                    <?php echo tp_kses( $settings['tab_title'] ); ?>
                                                <?php endif; ?>
                                            </button>
                                            <button class="nav-link" id="nav-Difference-tab" data-bs-toggle="tab"
                                                data-bs-target="#nav-Difference" type="button" role="tab"
                                                aria-controls="nav-Difference" aria-selected="false">
                                                <?php if ( !empty($settings['make_tab_title']) ) : ?>
                                                    <?php echo tp_kses( $settings['make_tab_title'] ); ?>
                                                <?php endif; ?>
                                            </button>
                                        </div>
                                    </nav>
                                    <div class="tab-content" id="nav-tabContent">
                                        <div class="tab-pane fade show active" id="nav-Approch" role="tabpanel"
                                            aria-labelledby="nav-Approch-tab">
                                            <div class="tp-providing__wrapper">
                                            <?php foreach ($settings['approch_tabs'] as $key => $item): ?>
                                                <div class="tp-providing__item d-flex about-items-start mb-20">
                                                    <div class="tp-providing__icon">
                                                        <span>
                                                             <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                                                <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                                                <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                                                <?php endif; ?>
                                                                <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                                                <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                                                <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                                                    alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                                                <?php endif; ?>
                                                                <?php else : ?>
                                                                <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                                                <?php echo $item['tp_box_icon_svg']; ?>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </span>
                                                    </div>
                                                    <div class="tp-providing__text">
                                                    <?php if ( !empty($item['title']) ) : ?>
                                                        <h4 class="tp-providing__title-sm"><?php echo tp_kses( $item['title'] ); ?></h4>
                                                        <?php endif; ?>
                                                        <?php if ( !empty($item['discription']) ) : ?>
                                                        <p><?php echo tp_kses( $item['discription'] ); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <?php endforeach; ?>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="nav-Difference" role="tabpanel"
                                            aria-labelledby="nav-Difference-tab">
                                            <div class="tp-providing__wrapper">
                                            <?php foreach ($settings['make_difference_tabs'] as $key => $item): ?>
                                                <div class="tp-providing__item d-flex about-items-start mb-20">
                                                    <div class="tp-providing__icon">
                                                        <span>
                                                            <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                                                <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                                                <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                                                <?php endif; ?>
                                                                <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                                                <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                                                <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                                                    alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                                                <?php endif; ?>
                                                                <?php else : ?>
                                                                <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                                                <?php echo $item['tp_box_icon_svg']; ?>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </span>
                                                    </div>
                                                    <div class="tp-providing__text">
                                                    <?php if ( !empty($item['title']) ) : ?>
                                                        <h4 class="tp-providing__title-sm"><?php echo tp_kses( $item['title'] ); ?></h4>
                                                        <?php endif; ?>
                                                        <?php if ( !empty($item['discription']) ) : ?>
                                                        <p><?php echo tp_kses( $item['discription'] ); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <?php endforeach; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<?php endif;

	}

}
$widgets_manager->register( new TP_Providing_Tab() );