<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use TPCore\Elementor\Controls\Group_Control_TPBGGradient;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Mission extends Widget_Base {

    use \TPCore\Widgets\TPCoreElementFunctions;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tp-Mission';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Mission', 'tpcore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tpcore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'tpcore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

    protected function register_controls(){
        $this->register_controls_section();
        $this->style_tab_content();
    }   

	protected function register_controls_section() {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tp_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        
        // tp_section_title
        $this->tp_section_title_render_controls('section', 'Section Title', 'Sub Title', 'your title here', $default_description = 'Hic nesciunt galisum aut dolorem aperiam eum soluta quod ea cupiditate.',['layout-1','layout-2']);


        // button
        $this->tp_button_render('testi', 'Button', ['layout-1','layout-2']);

        
        // testi shape
        $this->start_controls_section(
            'tp_testi_shape',
                [
                  'label' => esc_html__( 'Misson Shape', 'tpcore' ),
                  'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                  'condition' => [
                    'tp_design_style' => ['layout-2']
                  ]
                ]
           );
   
           $this->add_control(
            'tp_testi_shape_switch',
            [
              'label'        => esc_html__( 'Shape On/Off', 'tpcore' ),
              'type'         => \Elementor\Controls_Manager::SWITCHER,
              'label_on'     => esc_html__( 'Show', 'tpcore' ),
              'label_off'    => esc_html__( 'Hide', 'tpcore' ),
              'return_value' => 'yes',
              'default'      => '1',
            ]
           );
   
           $this->add_control(
               'tp_bg_image_1',
               [
                   'label' => esc_html__( 'Choose Bg Image', 'tp-core' ),
                   'type' => \Elementor\Controls_Manager::MEDIA,
                   'default' => [
                       'url' => \Elementor\Utils::get_placeholder_image_src(),
                   ]
               ]
           );

           $this->add_group_control(
               Group_Control_Image_Size::get_type(),
               [
                   'name' => 'shape_image_size', // // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                   'exclude' => ['custom']
               ]
           );
           
           $this->end_controls_section();

        
        // Review group
        $this->start_controls_section(
            'review_list',
            [
                'label' => esc_html__( 'Mission List', 'tpcore' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'repeater_condition',
            [
                'label' => __( 'Field condition', 'tpcore' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'tpcore' ),
                    'style_2' => __( 'Style 2', 'tpcore' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        //icon image svg

        $repeater->add_control(
            'tp_box_icon_type',
            [
                'label' => esc_html__('Select Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'svg',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                    'svg' => esc_html__('SVG', 'tpcore'),
                ],
                'condition' => [
                    'repeater_condition' => ['style_1'],
                ]
            ]
        );
        $repeater->add_control(
            'tp_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'tpcore'),
                'condition' => [
                    'tp_box_icon_type' => 'svg',
                    'repeater_condition' => ['style_1'],
                ]
            ]
        );

        $repeater->add_control(
            'tp_box_icon_image',
            [
                'label' => esc_html__('Upload Icon Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_box_icon_type' => 'image',
                    'repeater_condition' => ['style_1'],
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'tp_box_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                        'repeater_condition' => ['style_1'],
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'tp_box_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                        'repeater_condition' => ['style_1'],
                    ]
                ]
            );
        }

        $repeater->add_control(
            'brand_logo',
            [
                'label' => esc_html__('Mission Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'repeater_condition' => ['style_1','style_2']
                ]

            ]
        );

        $repeater->add_control(
            'review_content',
            [
                'label' => esc_html__( 'Misson Content', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => 'Aklima The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections Bonorum et Malorum original.',
                'placeholder' => esc_html__( 'Type your review content here', 'tpcore' ),
            ]
        );

        $repeater->add_control(
            'reviewer_title', [
                'label' => esc_html__( 'Mission Title', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '- Kids Education' , 'tpcore' ),
                'label_block' => true,
                'condition' => [
                    'repeater_condition' => ['style_1', 'style_2']
                ]
            ]
        );
        $repeater->add_control(
            'reviewer_url', [
                'label' => esc_html__( 'Mission URL', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( '#' , 'tpcore' ),
                'label_block' => true
            ]
        );


        $this->add_control(
            'reviews_list',
            [
                'label' => esc_html__( 'Mission List', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' =>  $repeater->get_controls(),
                'default' => [
                    [
                        'reviewer_title' => esc_html__( 'Kids Education', 'tpcore' ),
                        'review_content' => esc_html__( 'Construction can be defined as the art of building something. These construction quotes will put into perspective the fact that construction can be', 'tpcore' ),
                    ],

                ],
                'title_field' => '{{{ reviewer_title }}}',
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail_size',
                'default' => 'full',
                'exclude' => ['custom'],
                'separator' => 'none',
            ]
        );


        $this->end_controls_section();


	}

    // style_tab_content
    protected function style_tab_content(){
        $this->tp_section_style_controls('testimonial_section', 'Section Style', '.ele-section');
    }


	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>


<!--	testimonial style 2 -->
<?php if ( $settings['tp_design_style']  == 'layout-2' ):
    $this->add_render_attribute('title_args', 'class', 'tp-section-title');   
    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    } 

    if ( !empty($settings['tp_bg_image_1']['url']) ) {
        $tp_bg_image_1 = !empty($settings['tp_bg_image_1']['id']) ? wp_get_attachment_image_url( $settings['tp_bg_image_1']['id'], $settings['shape_image_size_size']) : $settings['tp_bg_image_1']['url'];
        $tp_bg_image_1_alt = get_post_meta($settings["tp_bg_image_1"]["id"], "_wp_attachment_image_alt", true);
    }


    if ('2' == $settings['tp_testi_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_testi_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
    } else {
        if ( ! empty( $settings['tp_testi_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_testi_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
        }
    }
?>

<div class="tp-service-3__area pt-120 pb-120">
    <div class="container">
    <?php if ( !empty($settings['tp_section_section_title_show']) ) : ?>
        <div class="row">
            <div class="col-xl-12">
                <div class="tp-service-3__section-title text-center pb-40">
                <?php if ( !empty($settings['tp_section_sub_title']) ) : ?>
                    <span class="tp-section-subtitle-3"><?php echo tp_kses( $settings['tp_section_sub_title'] ); ?></span>
                    <?php endif; ?>
                    <?php
                        if ( !empty($settings['tp_section_title' ]) ) :
                            printf( '<%1$s %2$s>%3$s</%1$s>',
                            tag_escape( $settings['tp_section_title_tag'] ),
                            $this->get_render_attribute_string( 'title_args' ),
                            tp_kses( $settings['tp_section_title' ] )
                            );
                        endif;
                        ?>
                </div>
            </div>
        </div>
    <?php endif;?>


        <div class="row">
        <?php foreach ($settings['reviews_list'] as $index => $item) : 
            if ( !empty($item['brand_logo']['url']) ) {
            $tp_brand_logo = !empty($item['brand_logo']['id']) ? wp_get_attachment_image_url( $item['brand_logo']['id'], $settings['thumbnail_size_size']) : $item['brand_logo']['url'];
            $tp_brand_logo_alt = get_post_meta($item["brand_logo"]["id"], "_wp_attachment_image_alt", true);
                }
            ?>
            <div class="col-xl-3 col-lg-4 col-md-6 mb-30 wow tpfadeUp" data-wow-duration=".9s"
                data-wow-delay=".3s">
                <div class="tp-service-3__item p-relative">
                    <div class="tp-service-3__thumb-box p-relative">
                        <div class="tp-service-3__thumb">
                            <img src="<?php echo esc_url($tp_brand_logo); ?>" alt="<?php echo esc_attr($tp_brand_logo_alt); ?>">
                            <div class="tp-service-3__icon">
                                <span>
                                <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                    <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                    <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                    <?php endif; ?>
                                    <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                    <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                    <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                        alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                    <?php endif; ?>
                                    <?php else : ?>
                                    <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                    <?php echo $item['tp_box_icon_svg']; ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="tp-service-3__content text-center">
                    <?php if(!empty($item['reviewer_title'])) : ?>
                        <a href="<?php echo esc_url($item['reviewer_url']); ?>">
                            <h4 class="tp-service-3__title-sm"><?php echo tp_kses($item['reviewer_title']); ?></h4>
                        </a>
                        <?php endif; ?>
                        <?php if ( !empty($item['review_content']) ) : ?>
                        <p><?php echo tp_kses($item['review_content']); ?></p>
                        <?php endif; ?>
                        <?php if(!empty($item['reviewer_url'])) : ?>
                        <a href="<?php echo esc_url($item['reviewer_url']); ?>"><?php esc_html__("Read More","tpcore") ?></a>
                        <?php endif; ?>
                        <div class="tp-service-3__shape">
                            <img src="<?php echo esc_url($tp_bg_image_1)?>" alt="<?php echo esc_attr($tp_bg_image_1_alt)?>">
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>


<!-- default style -->
<?php else:
    $this->add_render_attribute('title_args', 'class', 'tp-section-title');   
    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }     


    if ('2' == $settings['tp_testi_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_testi_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
    } else {
        if ( ! empty( $settings['tp_testi_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_testi_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
        }
    }
?>

<div class="tp-mission-2__area tp-mission-2__space p-relative fix z-index grey-bg">
    <div class="tp-mission-2__shape">
        <img src="<?php echo get_template_directory_uri()?>/assets/img/mission/mission-shape-1.png" alt="">
    </div>
    <div class="tp-mission-2__plr">
        <div class="container-fluid g-0">
            <div class="row">
            <?php if ( !empty($settings['tp_section_section_title_show']) ) : ?>
                <div class="col-xl-5 col-lg-7 col-md-7">
                    <div class="tp-mission-2__left-box">
                        <div class="tp-mission-2__section-box pb-10">
                        <?php if ( !empty($settings['tp_section_sub_title']) ) : ?>
                            <span class="tp-section-subtitle-2"><?php echo tp_kses( $settings['tp_section_sub_title'] ); ?></span>
                            <?php endif; ?>
                            <?php
                                if ( !empty($settings['tp_section_title' ]) ) :
                                    printf( '<%1$s %2$s>%3$s</%1$s>',
                                    tag_escape( $settings['tp_section_title_tag'] ),
                                    $this->get_render_attribute_string( 'title_args' ),
                                    tp_kses( $settings['tp_section_title' ] )
                                    );
                                endif;
                                ?>
                        </div>
                        <div class="tp-mission-2__left-text">
                        <?php if ( !empty($settings['tp_section_description']) ) : ?>
                            <p> <?php echo tp_kses( $settings['tp_section_description'] ); ?>
                            </p>
                                <?php endif; ?>
                                <?php if ( !empty($settings['tp_testi_btn_text']) ) : ?>
                            <a <?php echo $this->get_render_attribute_string( 'tp-button-arg' ); ?>><?php echo tp_kses($settings['tp_testi_btn_text']); ?> </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="col-xl-7 col-lg-5 col-md-5">
                    <div class="tp-mission-2__wrapper">
                        <div class="swiper-container tp-mission-2__active">
                            <div class="swiper-wrapper">
                            <?php foreach ($settings['reviews_list'] as $index => $item) : 
                                if ( !empty($item['brand_logo']['url']) ) {
                                $tp_brand_logo = !empty($item['brand_logo']['id']) ? wp_get_attachment_image_url( $item['brand_logo']['id'], $settings['thumbnail_size_size']) : $item['brand_logo']['url'];
                                $tp_brand_logo_alt = get_post_meta($item["brand_logo"]["id"], "_wp_attachment_image_alt", true);
                                    }
                                ?>
                                <div class="swiper-slide">
                                    <div class="tp-mission-2__item">
                                        <div class="tp-mission-2__single-bg"
                                            data-background="<?php echo esc_url($tp_brand_logo); ?>"></div>
                                        <div class="tp-mission-2__icon">
                                            <span>
                                                <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                                    <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                                    <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                                    <?php endif; ?>
                                                    <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                                    <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                                    <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                                        alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                                    <?php endif; ?>
                                                    <?php else : ?>
                                                    <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                                    <?php echo $item['tp_box_icon_svg']; ?>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                        <div class="tp-mission-2__text">
                                        <?php if(!empty($item['reviewer_url'])) : ?>
                                            <a href="<?php echo esc_url($item['reviewer_url']); ?>">
                                            <?php if(!empty($item['reviewer_title'])) : ?>
                                                <h4 class="tp-mission-2__title-sm"><?php echo tp_kses($item['reviewer_title']); ?></h4>
                                                <?php endif; ?>
                                            </a>
                                            <?php endif; ?>
                                            <?php if ( !empty($item['review_content']) ) : ?>
                                            <p><?php echo tp_kses($item['review_content']); ?></p>
                                                <?php endif; ?>
                                        </div>
                                        <div class="tp-mission-2__shape-box">
                                        <?php if(!empty($item['reviewer_url'])) : ?>
                                            <a href="<?php echo esc_url($item['reviewer_url']); ?>">
                                            <span class="tp-mission-2__arrow"><i
                                                    class="fa-light fa-arrow-right-long"></i>
                                                </span>
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php endif; 
	}
}

$widgets_manager->register( new TP_Mission() );