<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_FAQ extends Widget_Base {

	use \TPCore\Widgets\TPCoreElementFunctions;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tp-faq';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'FAQ', 'tpcore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tpcore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'tpcore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */


	protected function register_controls(){
        $this->register_controls_section();
        $this->style_tab_content();
    }   

	protected function register_controls_section() {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tp_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                    'layout-3' => esc_html__('Layout 3', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->end_controls_section();

		 // tp_section_title
		$this->tp_section_title_render_controls('section', 'Section Title', 'Sub Title', 'your title here', $default_description = 'Hic nesciunt galisum aut dolorem aperiam eum soluta quod ea cupiditate.',['layout-1']);


		$this->start_controls_section(
            '_accordion',
            [
                'label' => esc_html__( 'Accordion', 'tpcore' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );


        $repeater = new \Elementor\Repeater();

		$repeater->add_control(
            'tp_accordion_active_switch',
            [
                'label' => esc_html__( 'Show', 'tp-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'tp-core' ),
                'label_off' => esc_html__( 'Hide', 'tp-core' ),
                'return_value' => 'yes',
                'default' => '0',
            ]
        );

        $repeater->add_control(
            'accordion_title', [
                'label' => esc_html__( 'Accordion Item', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'This is accordion item title' , 'tpcore' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'accordion_description',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'description' => tp_get_allowed_html_desc( 'intermediate' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Facilis fugiat hic ipsam iusto laudantium libero maiores minima molestiae mollitia repellat rerum sunt ullam voluptates? Perferendis, suscipit.',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'accordions',
            [
                'label' => esc_html__( 'Repeater Accordion', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'accordion_title' => esc_html__( 'This is accordion item title #1', 'tpcore' ),
                    ],
                    [
                        'accordion_title' => esc_html__( 'This is accordion item title #2', 'tpcore' ),
                    ],
                    [
                        'accordion_title' => esc_html__( 'This is accordion item title #3', 'tpcore' ),
                    ],
                    [
                        'accordion_title' => esc_html__( 'This is accordion item title #4', 'tpcore' ),
                    ],
                ],
                'title_field' => '{{{ accordion_title }}}',
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
            'accordion_image_area',
            [
                'label' => esc_html__( 'Accordion Extra', 'tpcore' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
                    'tp_design_style' => "layout-1" 
                ],

            ]
        );

		$this->add_control(
			'accordion_image',
			[
				'label' => esc_html__('Fag Image', 'tpcore'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				]

			]
		);

		$this->add_control(
			'accordion_video_url',
			[
				'label' => esc_html__('Video Url', 'tpcore'),
				'type' => Controls_Manager::TEXTAREA,

			]
		);

		$this->add_control(
			'accordion_extra_text',
			[
				'label' => esc_html__('Extra Text', 'tpcore'),
				'type' => Controls_Manager::TEXTAREA,

			]
		);

		$this->add_control(
			'accordion_extra_shape',
			[
				'label' => esc_html__('Accordion Shape', 'tpcore'),
				'type' => Controls_Manager::SWITCHER,

			]
		);

		$this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail_size', // // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'exclude' => ['custom'],
                'default' => 'full',
            ]
        );
		
		$this->end_controls_section();
	}

	protected function style_tab_content(){
		$this->tp_section_style_controls('faq_section', 'Section - Style', '.tp-el-section');
    }

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>



<?php if ( $settings['tp_design_style']  == 'layout-3' ): ?>

	<div class="tp-custom-accordion">
		<div class="accordions" id="accordionExample2-<?php echo esc_attr($this->get_id()); ?>">
		<?php foreach ( $settings['accordions'] as $index => $item) :
				$collapsed = ($index == '0' ) ? '' : 'collapsed';
				$aria_expanded = ($index == '0' ) ? "true" : "false";
				$show = $item['tp_accordion_active_switch'] ? "show" : "";
				$active = $item['tp_accordion_active_switch'] ? "tp-faq-active" : "";
				?>
			<div class="accordion-items <?php echo esc_attr($active); ?>">
            <h2 class="accordion-header" id="headingOne2-<?php echo esc_attr($index); ?>">
                <button class="accordion-buttons <?php echo esc_attr($collapsed); ?>" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapse2-<?php echo esc_attr($index); ?>" aria-expanded="true"
                    aria-controls="collapse2-<?php echo esc_attr($index); ?>">
                    <?php echo esc_html($item['accordion_title']); ?>
                </button>
            </h2>
            <div id="collapse2-<?php echo esc_attr($index); ?>" class="accordion-collapse collapse <?php echo esc_attr($show); ?>"
                aria-labelledby="headingOne2-<?php echo esc_attr($index); ?>" data-bs-parent="#accordionExample2-<?php echo esc_attr($this->get_id()); ?>">
                <div class="accordion-body">
                <?php echo tp_kses($item['accordion_description']); ?>
                </div>
            </div>
        </div>
			<?php endforeach; ?>
		</div>
	</div>

<?php elseif ( $settings['tp_design_style']  == 'layout-2' ): ?>

	<div class="tp-custom-accordion">
		<div class="accordions" id="accordionExample-<?php echo esc_attr($this->get_id()); ?>">
		<?php foreach ( $settings['accordions'] as $index => $item) :
				$collapsed = ($index == '0' ) ? '' : 'collapsed';
				$aria_expanded = ($index == '0' ) ? "true" : "false";
				$show = $item['tp_accordion_active_switch'] ? "show" : "";
				$active = $item['tp_accordion_active_switch'] ? "tp-faq-active" : "";
				?>
			<div class="accordion-items <?php echo esc_attr($active); ?>">
            <h2 class="accordion-header" id="headingOne-<?php echo esc_attr($index); ?>">
                <button class="accordion-buttons <?php echo esc_attr($collapsed); ?>" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapse-<?php echo esc_attr($index); ?>" aria-expanded="true"
                    aria-controls="collapse-<?php echo esc_attr($index); ?>">
                    <?php echo esc_html($item['accordion_title']); ?>
                </button>
            </h2>
            <div id="collapse-<?php echo esc_attr($index); ?>" class="accordion-collapse collapse <?php echo esc_attr($show); ?>"
                aria-labelledby="headingOne-<?php echo esc_attr($index); ?>" data-bs-parent="#accordionExample-<?php echo esc_attr($this->get_id()); ?>">
                <div class="accordion-body">
                <?php echo tp_kses($item['accordion_description']); ?>
                </div>
            </div>
        </div>
			<?php endforeach; ?>
		</div>
	</div>

<?php else : 
	$this->add_render_attribute('title_args', 'class', 'tp-section-title');  
	if ( !empty($settings['accordion_image']['url']) ) {
		$accordion_image = !empty($settings['accordion_image']['id']) ? wp_get_attachment_image_url( $settings['accordion_image']['id'], $settings['thumbnail_size_size']) : $settings['accordion_image']['url'];
		$accordion_image_alt = get_post_meta($settings["accordion_image"]["id"], "_wp_attachment_image_alt", true);
	} 
?>

<div class="tp-faq-2__area tp-faq-2__space grey-bg z-index fix p-relative">
		<?php  if ( !empty($settings['accordion_extra_shape']) ) : ?>
            <div class="tp-faq-2__shape">
                <img src="<?php echo get_template_directory_uri() ?>/assets/img/faq/faq-shape-2.png" alt="">
            </div>
			<?php endif; ?>
            <div class="tp-faq-2__bg" data-background="<?php echo esc_url($accordion_image) ?>">
				<?php  if ( !empty($settings['accordion_extra_text']) ) : ?>
                <div class="tp-faq-2__bg-text text-center d-none d-lg-block">
                    <span><?php echo tp_kses( $settings['accordion_extra_text'] ); ?></span>
                </div>
				<?php endif; ?>
                <div class="tp-faq-2__bg-icon d-none d-lg-block">
                    <a class="popup-video" href="<?php echo esc_url($settings['accordion_video_url']) ?>">
                        <i class="flaticon-play-button"></i>
                    </a>
                </div>
            </div>
            <div class="tp-faq-2__wrapper">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-6 col-lg-6 wow tpfadeLeft" data-wow-duration=".9s" data-wow-delay=".5s">

                            <div class="tp-faq-2__section-title">
							<?php if ( !empty($settings['tp_section_sub_title']) ) : ?>
                                <span class="tp-section-subtitle-2"><?php echo tp_kses( $settings['tp_section_sub_title'] ); ?></span>
								<?php endif; ?>
								<?php
									if ( !empty($settings['tp_section_title' ]) ) :
										printf( '<%1$s %2$s>%3$s</%1$s>',
										tag_escape( $settings['tp_section_title_tag'] ),
										$this->get_render_attribute_string( 'title_args' ),
										tp_kses( $settings['tp_section_title' ] )
										);
									endif;
									?>
                            </div>

                            <div class="tp-custom-accordion">
                                <div class="accordions" id="accordionExample-<?php echo esc_attr($this->get_id()); ?>">
								<?php foreach ( $settings['accordions'] as $index => $item) :

									$collapsed = ($index == '0' ) ? '' : 'collapsed';
									$aria_expanded = ($index == '0' ) ? "true" : "false";
									$show = $item['tp_accordion_active_switch'] ? "show" : "";
									$active = $item['tp_accordion_active_switch'] ? "tp-faq-active" : "";
								?>
                                    <div class="accordion-items <?php echo esc_attr($active); ?>">
                                        <h2 class="accordion-header" id="headingOne-<?php echo esc_attr($index); ?>">
                                            <button class="accordion-buttons <?php echo esc_attr($collapsed); ?>" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapse-<?php echo esc_attr($index); ?>" aria-expanded="true"
                                                aria-controls="collapse-<?php echo esc_attr($index); ?>">
                                                <?php echo esc_html($item['accordion_title']); ?>
                                            </button>
                                        </h2>
                                        <div id="collapse-<?php echo esc_attr($index); ?>" class="accordion-collapse collapse <?php echo esc_attr($show); ?>"
                                            aria-labelledby="heading-<?php echo esc_attr($index); ?>" data-bs-parent="#accordionExample-<?php echo esc_attr($this->get_id()); ?>">
                                            <div class="accordion-body">
											<?php echo tp_kses($item['accordion_description']); ?>
                                            </div>
                                        </div>
                                    </div>
									<?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<?php endif;
	}

}

$widgets_manager->register( new TP_FAQ() );
