<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;
use TPCore\Elementor\Controls\Group_Control_TPBGGradient;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_CTA extends Widget_Base {

    use \TPCore\Widgets\TPCoreElementFunctions;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tp-cta';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'CTA', 'tpcore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tpcore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'tpcore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */


	protected function register_controls(){
		$this->register_controls_section();
		$this->style_tab_content();
	}		


	// controls file 
	protected function register_controls_section(){
        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tp-core'),
            ]
        );
        $this->add_control(
            'tp_design_style',
            [
                'label' => esc_html__('Select Layout', 'tp-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tp-core'),
                    'layout-2' => esc_html__('Layout 2', 'tp-core'),
                    'layout-3' => esc_html__('Layout 3', 'tp-core'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();
          // tp_section_title
          $this->tp_section_title_render_controls('section', 'Section Title', 'Sub Title', 'your title here', $default_description = 'Hic nesciunt galisum aut dolorem aperiam eum soluta quod ea cupiditate.',['layout-1','layout-2']);

        
        $this->tp_button_render('cta', 'Button', ['layout-1', 'layout-2','layout-4']);  

          // _tp_image
          $this->start_controls_section(
            '_tp_extra_section',
            [
                'label' => esc_html__('Extra Info', 'tpcore'),
                'condition' => [
                    'tp_design_style' => ['layout-2']
                ]
            ]
        );


        //icon image svg

        $this->add_control(
            'tp_box_icon_type',
            [
                'label' => esc_html__('Select Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'svg',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                    'svg' => esc_html__('SVG', 'tpcore'),
                ]
            ]
        );
        $this->add_control(
            'tp_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'tpcore'),
                'condition' => [
                    'tp_box_icon_type' => 'svg'
                ]
            ]
        );

        $this->add_control(
            'tp_box_icon_image',
            [
                'label' => esc_html__('Upload Icon Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_box_icon_type' => 'image'
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $this->add_control(
                'tp_box_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tp_box_icon_type' => 'icon'
                    ]
                ]
            );
        } else {
            $this->add_control(
                'tp_box_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                    ]
                ]
            );
        }


        $this->end_controls_section();

        // _tp_image
        $this->start_controls_section(
            '_tp_image',
            [
                'label' => esc_html__('Thumbnail', 'tpcore'),
                'condition' => [
                    'tp_design_style' => ['layout-1','layout-2']
                ]
            ]
        );
        $this->add_control(
            'tp_image',
            [
                'label' => esc_html__( 'Choose Image', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'tp_image_2',
            [
                'label' => esc_html__( 'Choose Image 2', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => 'layout-3'
                ]
            ]
        );
        $this->add_control(
            'tp_image_3',
            [
                'label' => esc_html__( 'Choose Image 3', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => 'layout-3'
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'tp_image_size',
                'default' => 'full',
                'exclude' => [
                    'custom'
                ]
            ]
        );
        $this->end_controls_section();

        
        // cta shape
        $this->start_controls_section(
            'tp_cta_shape',
                [
                  'label' => esc_html__( 'Section Shape', 'tpcore' ),
                  'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                  'condition' => [
                    'tp_design_style' => 'layout-1'
                  ]
                ]
           );
   
           $this->add_control(
            'tp_cta_shape_switch',
            [
              'label'        => esc_html__( 'Shape On/Off', 'tpcore' ),
              'type'         => \Elementor\Controls_Manager::SWITCHER,
              'label_on'     => esc_html__( 'Show', 'tpcore' ),
              'label_off'    => esc_html__( 'Hide', 'tpcore' ),
              'return_value' => 'yes',
              'default'      => '0',
            ]
           );
   
           $this->add_control(
               'tp_shape_image_1',
               [
                   'label' => esc_html__( 'Choose Shape Image 1', 'tp-core' ),
                   'type' => \Elementor\Controls_Manager::MEDIA,
                   'default' => [
                       'url' => \Elementor\Utils::get_placeholder_image_src(),
                   ],
                   'condition' => [
                       'tp_cta_shape_switch' => 'yes'
                   ]
               ]
           );
   
           $this->add_control(
               'tp_shape_image_2',
               [
                   'label' => esc_html__( 'Choose Shape Image 2', 'tp-core' ),
                   'type' => \Elementor\Controls_Manager::MEDIA,
                   'default' => [
                       'url' => \Elementor\Utils::get_placeholder_image_src(),
                   ],
                   'condition' => [
                       'tp_cta_shape_switch' => 'yes'
                   ]
               ]
           );

           $this->add_group_control(
               Group_Control_Image_Size::get_type(),
               [
                   'name' => 'shape_image_size', // // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                   'exclude' => ['custom'],
                   'condition' => [
                       'tp_cta_shape_switch' => 'yes'
                   ]
               ]
           );
           
           $this->end_controls_section();

           // cta 3 contact
        $this->start_controls_section(
            'tp_fact',
            [
                'label' => esc_html__('Contact', 'tpcore'),
                'description' => esc_html__( 'Control all the style settings from Style tab', 'tpcore' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => 'layout-3'
                  ]
            ]
        );


        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tp_box_icon_type',
            [
                'label' => esc_html__('Select Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'svg',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                    'svg' => esc_html__('SVG', 'tpcore'),
                ]
            ]
        );
        $repeater->add_control(
            'tp_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'tpcore'),
                'condition' => [
                    'tp_box_icon_type' => 'svg',
                ]
            ]
        );

        $repeater->add_control(
            'tp_box_icon_image',
            [
                'label' => esc_html__('Upload Icon Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_box_icon_type' => 'image',
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'tp_box_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'tp_box_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                    ]
                ]
            );
        }

        $repeater->add_control(
            'tp_contact_title',
            [
                'label' => esc_html__('Contact info 01', 'tp-core'),
                'description' => tp_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('+92307776-0800', 'tp-core'),
                'placeholder' => esc_html__('Contact Text', 'tp-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tp_contact_title_2',
            [
                'label' => esc_html__('Contact info 02', 'tp-core'),
                'description' => tp_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('+32307776-0800', 'tp-core'),
                'placeholder' => esc_html__('Contact Text', 'tp-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tp_contact_type',
            [
                'label' => esc_html__('Select Contact Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'tel',
                'options' => [
                    'tel' => esc_html__('Telephone', 'tpcore'),
                    'mailto' => esc_html__('Email', 'tpcore'),
                    'location' => esc_html__('Location', 'tpcore'),
                ],
    
            ]
        );

        $repeater->add_control(
            'tp_contact_url',
            [
               'label'   => esc_html__( 'Contact Url', 'tpcore' ),
               'type'        => \Elementor\Controls_Manager::URL,
               'label_block' => true,
               'default'     => [
                   'url'               => '#',
                   'is_external'       => true,
                   'nofollow'          => true,
                   'custom_attributes' => '',
                   ],
                   'placeholder' => esc_html__( 'Your Url', 'tpcore' ),
                   'label_block' => true,
               ]
            );

        $repeater->add_control(
            'tp_contact_url_2',
            [
               'label'   => esc_html__( 'Contact Url 2', 'tpcore' ),
               'type'        => \Elementor\Controls_Manager::URL,
               'label_block' => true,
               'default'     => [
                   'url'               => '#',
                   'is_external'       => true,
                   'nofollow'          => true,
                   'custom_attributes' => '',
                   ],
                   'placeholder' => esc_html__( 'Your Url', 'tpcore' ),
                   'label_block' => true,
               ]
            );


         $this->add_control(
           'tp_contact_list',
           [
             'label'       => esc_html__( 'Contact List', 'tpcore' ),
             'type'        => \Elementor\Controls_Manager::REPEATER,
             'fields'      => $repeater->get_controls(),
             'default'     => [
               [
                'tp_contact_title'   => esc_html__( 'support@zibber.com ', 'tpcore' ),
               ],
               [
                'tp_contact_title'   => esc_html__( '(+642) 394 396 432 ', 'tpcore' ),
               ]
             ],
             'title_field' => '{{{ tp_contact_title }}}',
           ]
         );

        $this->end_controls_section();

	}

	// style_tab_content
	protected function style_tab_content(){
        $this->tp_section_style_controls('cta_section', 'Section Style', '.ele-section'); 
	}


	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

<?php if ( $settings['tp_design_style']  == 'layout-2' ):
    // thumbnail
    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }      
    
    // Link
    if ('2' == $settings['tp_cta_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_cta_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
    } else {
        if ( ! empty( $settings['tp_cta_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_cta_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
        }
    }
    $this->add_render_attribute('title_args', 'class', 'tp-cta__title-sm');
?>
      <!-- cta-area-start -->
<div class="tp-cta__area">
    <div class="tp-cta__bg wow tpfadeUp" data-wow-duration=".9s"
    data-wow-delay=".3s" data-background="<?php echo esc_url( $tp_image ); ?>">
        <div class="container">
            <div class="row align-items-center">
            <?php if ( !empty($settings['tp_section_section_title_show']) ) : ?>
                <div class="col-xl-7 col-lg-7 col-md-7">
                    <div class="tp-cta__content d-flex align-items-center">
                        <div class="tp-cta__icon d-none d-sm-block">
                            <span>
                            <?php if($settings['tp_box_icon_type'] == 'icon') : ?>
                                <?php if (!empty($settings['tp_box_icon']) || !empty($settings['tp_box_selected_icon']['value'])) : ?>
                                <?php tp_render_icon($settings, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                <?php endif; ?>
                                <?php elseif( $settings['tp_box_icon_type'] == 'image' ) : ?>
                                <?php if (!empty($settings['tp_box_icon_image']['url'])): ?>
                                <img src="<?php echo $settings['tp_box_icon_image']['url']; ?>"
                                    alt="<?php echo get_post_meta(attachment_url_to_postid($settings['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                <?php endif; ?>
                                <?php else : ?>
                                <?php if (!empty($settings['tp_box_icon_svg'])): ?>
                                <?php echo $settings['tp_box_icon_svg']; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                            </span>
                        </div>
                        <?php if ( !empty($settings['tp_section_title' ]) ) :
                        printf( '<%1$s %2$s data-wow-duration=".9s"
                        data-wow-delay=".5s" >%3$s</%1$s>',
                        tag_escape( $settings['tp_section_title_tag'] ),
                        $this->get_render_attribute_string( 'title_args' ),
                        tp_kses( $settings['tp_section_title' ] )
                        ); endif;  ?>
                    </div>
                </div>
                <?php endif; ?>
                <?php if ( !empty($settings['tp_cta_btn_text']) ) : ?>
                <div class="col-xl-5 col-lg-5 col-md-5">
                    <div class="tp-cta__button text-md-end text-start">
                        <a <?php echo $this->get_render_attribute_string( 'tp-button-arg' ); ?>><?php echo tp_kses($settings['tp_cta_btn_text']); ?></a>
                    </div>
                </div>
                <?php endif; ?>
                        
            </div>
        </div>
    </div>
</div>

<?php elseif ( $settings['tp_design_style']  == 'layout-4' ):
    // thumbnail
    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }      
    
    // Link
    if ('2' == $settings['tp_cta_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_cta_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn-3');
    } else {
        if ( ! empty( $settings['tp_cta_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_cta_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn-3');
        }
    }
    $this->add_render_attribute('title_args', 'class', 'tp-section-title-lg text-white');
?>

<section class="tp-cta-3-area pb-120" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/services/home-3/service-bg.png">
    <div class="container">
    <div class="row">
        <div class="col-xl-12">
            <div class="tp-cta-3-wrapper p-relative">
                <div class="tp-cta-3-shape">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/cta/home-3/shape-1.png" alt="">
                </div>
                <div class="row">
                <div class="col-lg-5">
                    <div class="tp-cta-3-title-wrapper p-relative">
                        <h3 class="tp-cta-3-title"><?php echo tp_kses($settings['cta_phone_extra_text']); ?>
                        </h3>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div
                        class="tp-cta-3-content-wrapper d-flex flex-wrap justify-content-start justify-content-lg-end">
                        <div class="tp-cta-3-phone d-flex align-items-center">
                            <div class="tp-cta-3-phone-icon">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/img//icon/call.svg" alt="">
                            </div>
                            <?php if(!empty($settings['phone_number'])) : ?>
                            <div class="tp-cta-3-phone-content">
                            <span><?php echo esc_html__("Phone: ",'tpcore') ?><br> <a href="tel:<?php echo esc_attr($settings['phone_number']); ?>"><?php echo tp_kses($settings['phone_number']); ?></a></span>
                            </div>
                            <?php endif; ?>

                        </div>
                        <?php if ( !empty($settings['tp_cta_btn_text']) ) : ?>
                        <div class="tp-cta-3-btn">
                            <a <?php echo $this->get_render_attribute_string( 'tp-button-arg' ); ?>><?php echo tp_kses($settings['tp_cta_btn_text']); ?></a>
                        </div>
                        <?php endif; ?>
                        
                        
                    </div>
                </div>
                </div>
            </div>
        </div>
    </div>
    </div>
</section>



<?php elseif ( $settings['tp_design_style']  == 'layout-3' ):
    // thumbnail
    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_image_2']['url']) ) {
        $tp_image_2 = !empty($settings['tp_image_2']['id']) ? wp_get_attachment_image_url( $settings['tp_image_2']['id'], $settings['tp_image_size_size']) : $settings['tp_image_2']['url'];
        $tp_image_alt_2 = get_post_meta($settings["tp_image_2"]["id"], "_wp_attachment_image_alt", true);
    } 
    if ( !empty($settings['tp_image_3']['url']) ) {
        $tp_image_3 = !empty($settings['tp_image_3']['id']) ? wp_get_attachment_image_url( $settings['tp_image_3']['id'], $settings['tp_image_size_size']) : $settings['tp_image_3']['url'];
        $tp_image_alt_3 = get_post_meta($settings["tp_image_3"]["id"], "_wp_attachment_image_alt", true);
    } 
    
    // Link
    if ('2' == $settings['tp_cta_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_cta_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
    } else {
        if ( ! empty( $settings['tp_cta_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_cta_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
        }
    }
    $this->add_render_attribute('title_args', 'class', 'tp-section-title');
?>

<div class="tp-contact__area">
    <div class="container">
        <div class="tp-contact__bg">
            <div class="tp-contact__wrapper d-flex align-items-center justify-content-between">
                <?php foreach ($settings['tp_contact_list'] as $index => $item) :
                        if($item['tp_contact_type'] == 'tel'){
                            $contact_type = 'tel:';
                        }elseif($item['tp_contact_type'] == 'mailto'){
                            $contact_type = 'mailto:';
                        }else{
                            $contact_type = '';
                        }
                    ?>
                <div class="tp-contact__item d-flex align-items-center">
                    <div class="tp-contact__icon">
                        <span>
                            <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                <?php endif; ?>
                                <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                    alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                <?php endif; ?>
                                <?php else : ?>
                                <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                <?php echo $item['tp_box_icon_svg']; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </span>
                    </div>
                    <div class="tp-contact__text">
                        <a href="<?php echo esc_url($contact_type); ?><?php echo esc_attr($item['tp_contact_url']['url']); ?>"><?php echo tp_kses($item['tp_contact_title']); ?></a>
                        <a href="<?php echo esc_url($contact_type); ?><?php echo esc_attr($item['tp_contact_url_2']['url']); ?>"><?php echo tp_kses($item['tp_contact_title_2']); ?></a>
                    </div>
                </div>    
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
  


<?php else:

    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_shape_image_1']['url']) ) {
        $tp_shape_image = !empty($settings['tp_shape_image_1']['id']) ? wp_get_attachment_image_url( $settings['tp_shape_image_1']['id'], $settings['shape_image_size_size']) : $settings['tp_shape_image_1']['url'];
        $tp_shape_image_alt = get_post_meta($settings["tp_shape_image_1"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_shape_image_2']['url']) ) {
        $tp_shape_image_2 = !empty($settings['tp_shape_image_2']['id']) ? wp_get_attachment_image_url( $settings['tp_shape_image_2']['id'], $settings['shape_image_size_size']) : $settings['tp_shape_image_2']['url'];
        $tp_shape_image_alt_2 = get_post_meta($settings["tp_shape_image_2"]["id"], "_wp_attachment_image_alt", true);
    }

    // Link
    if ('2' == $settings['tp_cta_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_cta_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn theme-2-bg  wow tpfadeUp');
    } else {
        if ( ! empty( $settings['tp_cta_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_cta_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn theme-2-bg  wow tpfadeUp');
        }
    }
    $this->add_render_attribute('title_args', 'class', 'tp-cta-2__title wow tpfadeUp');   
?>

<div class="tp-cta-2__area">
    <div class="tp-cta-2__bg p-relative fix" data-background="<?php echo esc_url( $tp_image ); ?>">
    <?php if ( !empty($settings['tp_cta_shape_switch']) ) : ?>
        <div class="tp-cta-2__shape-1 d-none d-xl-block">
            <img src="<?php echo esc_url( $tp_shape_image ); ?>" alt="<?php echo esc_attr( $tp_shape_image_alt ); ?>">
        </div>
        <div class="tp-cta-2__shape-2 d-none d-xl-block">
        <img src="<?php echo esc_url( $tp_shape_image_2 ); ?>" alt="<?php echo esc_attr( $tp_shape_image_alt_2 ); ?>">
        </div>
        <?php endif; ?>
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="tp-cta-2__content text-center">
                    <?php if ( !empty($settings['tp_section_section_title_show']) ) : ?>
                    <?php if ( !empty($settings['tp_section_sub_title']) ) : ?>
                        <span class="tp-cta-2__subtitle  wow tpfadeUp" data-wow-duration=".9s"
                        data-wow-delay=".3s"><?php echo tp_kses( $settings['tp_section_sub_title'] ); ?></span>
                        <?php endif; ?>
                        <?php if ( !empty($settings['tp_section_title' ]) ) :
                        printf( '<%1$s %2$s data-wow-duration=".9s"
                        data-wow-delay=".5s" >%3$s</%1$s>',
                        tag_escape( $settings['tp_section_title_tag'] ),
                        $this->get_render_attribute_string( 'title_args' ),
                        tp_kses( $settings['tp_section_title' ] )
                        ); endif;  ?>
                    <?php endif; ?>
                        <?php if ( !empty($settings['tp_cta_btn_text']) ) : ?>
                        <a <?php echo $this->get_render_attribute_string( 'tp-button-arg' ); ?> data-wow-duration=".9s"
                        data-wow-delay=".7s"><?php echo tp_kses($settings['tp_cta_btn_text']); ?></a>
                        <?php endif; ?>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
     

<?php endif; 
	}
}

$widgets_manager->register( new TP_CTA() );