<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Blog_Post extends Widget_Base {

    use \TPCore\Widgets\TPCoreElementFunctions;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tp-blog-post';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Blog Post', 'tpcore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tpcore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'tpcore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
    protected function register_controls(){
        $this->register_controls_section();
        $this->style_tab_content();
    }   

	protected function register_controls_section() {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tp_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                    'layout-3' => esc_html__('Layout 3', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

		
        // title/content
        $this->tp_section_title_render_controls('section', 'Section Title', 'Sub Title', 'your title here', $default_description = 'Hic nesciunt galisum aut dolorem aperiam eum soluta quod ea cupiditate.', ['layout-1', 'layout-2', 'layout-3'] );

        // Blog Query
		$this->tp_query_controls('blog', 'Blog');



        // section column
        $this->tp_columns('col', ['layout-1', 'layout-2', 'layout-3']);
        
	}

    // style_tab_content
    protected function style_tab_content(){
        $this->tp_section_style_controls('blog_section', 'Section - Style', '.tp-el-section');
    }

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        /**
         * Setup the post arguments.
        */
        $query_args = TP_Helper::get_query_args('post', 'category', $this->get_settings());

        // The Query
        $query = new \WP_Query($query_args);


        $filter_list = $settings['category'];

        ?>

<?php if ( $settings['tp_design_style']  == 'layout-2' ): 
	$this->add_render_attribute('title_args', 'class', 'tp-section-title');
?>

<div class="tp-blog-2__area tp-blog-2__space">
	<div class="container">
		<?php if ( !empty($settings['tp_section_section_title_show']) ) : ?>
			<div class="row">
				<div class="col-xl-12">
					<div class="tp-blog-2__section-title pb-50 text-center">
						<?php if ( !empty($settings['tp_section_sub_title']) ) : ?>
							<span class="tp-section-subtitle"><?php echo tp_kses( $settings['tp_section_sub_title'] ); ?></span>
						<?php endif; ?>
						<?php
							if ( !empty($settings['tp_section_title' ]) ) :
								printf( '<%1$s %2$s>%3$s</%1$s>',
								tag_escape( $settings['tp_section_title_tag'] ),
								$this->get_render_attribute_string( 'title_args' ),
								tp_kses( $settings['tp_section_title' ] )
								);
							endif;
							?>
					</div>
				</div>
			</div>
		<?php endif; ?>
		<div class="row">
			<?php if ($query->have_posts()) : 
				$i = 0;
				while ($query->have_posts()) : 
				$query->the_post();
				global $post;
				$categories = get_the_category($post->ID);
				$i++;
			?>
				<div class="col-xl-<?php echo esc_attr($settings['tp_col_for_desktop']); ?> col-lg-<?php echo esc_attr($settings['tp_col_for_laptop']); ?> col-md-<?php echo esc_attr($settings['tp_col_for_tablet']); ?> col-<?php echo esc_attr($settings['tp_col_for_mobile']); ?> mb-30 wow tpfadeUp" data-wow-duration=".9s"
					data-wow-delay=".3s">
					<div class="tp-blog-2__item">
						<?php if(has_post_thumbnail()) : ?>
							<div class="tp-blog-2__thumb p-relative">
								<?php the_post_thumbnail(); ?>
								<div class="tp-blog-2__icon">
									<a class="popup-image" href="<?php echo esc_url(get_the_post_thumbnail_url($post->ID)); ?>">
										<i class="fa-sharp fa-solid fa-plus"></i>
									</a>
								</div>
							</div>
						<?php endif; ?>
						<div class="tp-blog-2__content">
							<div class="tp-blog-2__tag">
								<span><i class="flaticon-tag"></i><?php echo esc_html($categories[0]->name); ?></span>
							</div>
							<a href="<?php the_permalink(); ?>">
								<h4 class="tp-blog-2__title-sm"><?php echo wp_trim_words(get_the_title(), $settings['tp_blog_title_word'], ''); ?></h4>
							</a>
							<span class="tp-blog-2__meta"><?php the_time( get_option('date_format') ); ?></span>
							<?php if(!empty($settings['tp_post_button'])) : ?>
								<a href="<?php the_permalink(); ?>">
									<div class="tp-blog-2__link text-center">
										<span><?php echo tp_kses($settings['tp_post_button']); ?><i class="flaticon-arrow-right"></i></span>
									</div>
								</a>
							<?php endif; ?>
						</div>
					</div>
				</div>
			<?php endwhile; wp_reset_query(); endif; ?>
		</div>
	</div>
</div>

<?php elseif ( $settings['tp_design_style']  == 'layout-3' ) : 
	$this->add_render_attribute('title_args', 'class', 'tp-section-title');	
?>

<div class="tp-blog-2__area tp-blog-2__space">
	<div class="container">
	<?php if ( !empty($settings['tp_section_section_title_show']) ) : ?>
		<div class="row">
			<div class="col-xl-12">
				<div class="tp-blog-2__section-title pb-50 text-center">
					<?php if ( !empty($settings['tp_section_sub_title']) ) : ?>
						<span class="tp-section-subtitle"><?php echo tp_kses( $settings['tp_section_sub_title'] ); ?></span>
					<?php endif; ?>
					<?php
						if ( !empty($settings['tp_section_title' ]) ) :
							printf( '<%1$s %2$s>%3$s</%1$s>',
							tag_escape( $settings['tp_section_title_tag'] ),
							$this->get_render_attribute_string( 'title_args' ),
							tp_kses( $settings['tp_section_title' ] )
							);
						endif;
						?>
				</div>
			</div>
		</div>
		<?php endif; ?>
		<div class="row">
		<?php if ($query->have_posts()) : 
				$i = 0;
				while ($query->have_posts()) : 
				$query->the_post();
				global $post;
				$categories = get_the_category($post->ID);
				$i++;
			?>
			<div class="col-xl-<?php echo esc_attr($settings['tp_col_for_desktop']); ?> col-lg-<?php echo esc_attr($settings['tp_col_for_laptop']); ?> col-md-<?php echo esc_attr($settings['tp_col_for_tablet']); ?> col-<?php echo esc_attr($settings['tp_col_for_mobile']); ?> mb-30 wow tpfadeUp" data-wow-duration=".9s"
			data-wow-delay=".3s">
				<div class="tp-blog-2__item">
					<?php if(has_post_thumbnail()) : ?>
						<a href="<?php the_permalink(); ?>">
							<div class="tp-blog-2__thumb p-relative">
								<?php the_post_thumbnail(); ?>
							</div>
						</a>
					<?php endif; ?>
					<div class="tp-blog-2__content">
						<div class="tp-blog-2__tag">
							<span><i class="flaticon-tag"></i><?php echo esc_html($categories[0]->name); ?></span>
						</div>
						<a href="<?php the_permalink(); ?>"><h4 class="tp-blog-2__title-sm"><?php echo wp_trim_words(get_the_title(), $settings['tp_blog_title_word'], ''); ?></h4></a>
						<span class="tp-blog-2__meta-3"><?php the_time( get_option('date_format') ); ?></span>
						<a href="<?php the_permalink(); ?>">
							<div class="tp-blog-2__link text-center">
								<span><?php echo tp_kses($settings['tp_post_button']); ?><i class="flaticon-arrow-right"></i></span>
							</div>
						</a>
					</div>
				</div>
			</div>
			<?php endwhile; wp_reset_query(); endif; ?>
		</div>
	</div>
</div>


<?php else : 
	$this->add_render_attribute('title_args', 'class', 'tp-section-title');	
?>

<div class="tp-blog__area tp-blog__space">
            <div class="container">
			<?php if ( !empty($settings['tp_section_section_title_show']) ) : ?>
                <div class="row">
                    <div class="col-xl-12">
                        <div class="tp-blog__section-title pb-50 text-center">
							<?php if ( !empty($settings['tp_section_sub_title']) ) : ?>
                            	<span class="tp-section-subtitle"><?php echo tp_kses( $settings['tp_section_sub_title'] ); ?></span>
							<?php endif; ?>
                            <?php
							if ( !empty($settings['tp_section_title' ]) ) :
								printf( '<%1$s %2$s>%3$s</%1$s>',
								tag_escape( $settings['tp_section_title_tag'] ),
								$this->get_render_attribute_string( 'title_args' ),
								tp_kses( $settings['tp_section_title' ] )
								);
							endif;
							?>
                        </div>
                    </div>
                </div>
				<?php endif; ?>
                <div class="row">
				<?php if ($query->have_posts()) : 
					$i = 0;
					while ($query->have_posts()) : 
					$query->the_post();
					global $post;
					$categories = get_the_category($post->ID);
					$i++;
				?>
                    <div class="col-xl-4 col-lg-4 col-md-6 mb-30 wow tpfadeUp" data-wow-duration=".9s" data-wow-delay=".3s">
                        <div class="tp-blog__item">
							<?php if(has_post_thumbnail()) : ?>
                            	<?php the_post_thumbnail(); ?>
							<?php endif; ?>
                            <div class="tp-blog__img-text">
                                <a href="<?php the_permalink(); ?>"><span><i class="flaticon-tag"></i><?php echo esc_html($categories[0]->name); ?></span></a>
                            </div>
                            <div class="tp-blog__content">
                                <a href="<?php the_permalink(); ?>">
                                    <h4 class="tp-blog__title-sm"><?php echo wp_trim_words(get_the_title(), $settings['tp_blog_title_word'], ''); ?></h4>
                                </a>
                                <span><?php the_time( get_option('date_format') ); ?></span>
                                <div class="tp-blog__link">
                                    <a href="<?php the_permalink(); ?>"><?php echo tp_kses($settings['tp_post_button']); ?><i class="far fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; wp_reset_query(); endif; ?>
                </div>
            </div>
        </div>

<?php endif;
	}

}

$widgets_manager->register( new TP_Blog_Post() );