<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;
use TPCore\Elementor\Controls\Group_Control_TPBGGradient;
use TPCore\Elementor\Controls\Group_Control_TPGradient;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_About extends Widget_Base {

    use \TPCore\Widgets\TPCoreElementFunctions;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'about';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'About', 'tp-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tpcore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'tpcore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

    protected function register_controls(){
        $this->register_controls_section();
        $this->style_tab_content();
    }  

	protected function register_controls_section() {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tp-core'),
            ]
        );
        $this->add_control(
            'tp_design_style',
            [
                'label' => esc_html__('Select Layout', 'tp-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tp-core'),
                    'layout-2' => esc_html__('Layout 2', 'tp-core'),
                    'layout-3' => esc_html__('Layout 3', 'tp-core'),
                    'layout-4' => esc_html__('Layout 4', 'tp-core'),
                    'layout-5' => esc_html__('Layout 5', 'tp-core'),
                    'layout-6' => esc_html__('Layout 6', 'tp-core'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        $this->tp_section_title_render_controls('about', 'Section Title', 'Sub Title', 'your title here', $default_description = 'Hic nesciunt galisum aut dolorem aperiam eum soluta quod ea cupiditate.',['layout-1', 'layout-2','layout-3','layout-4','layout-5']);

   
        $this->start_controls_section(
         'about_features_list_sec',
             [
               'label' => esc_html__( 'Features List', 'tpcore' ),
               'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
               'condition' => [
                    'tp_design_style' => ['layout-1', 'layout-2', 'layout-3','layout-4','layout-5']
               ]
             ]
        );
        
        
 
        // repeater for about features list with text , testarea and icon
        $repeater = new Repeater();

        $repeater->add_control(
            'tp_box_icon_type',
            [
                'label' => esc_html__('Select Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                    'svg' => esc_html__('SVG', 'tpcore'),
                ]
            ]
        );
        $repeater->add_control(
            'tp_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'tpcore'),
                'condition' => [
                    'tp_box_icon_type' => 'svg'
                ]
            ]
        );

        $repeater->add_control(
            'tp_box_icon_image',
            [
                'label' => esc_html__('Upload Icon Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_box_icon_type' => 'image'
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'tp_box_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tp_box_icon_type' => 'icon'
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'tp_box_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tp_box_icon_type' => 'icon'
                    ]
                ]
            );
        }
        
        $repeater->add_control(
            'tp_about_features_list_title',
            [
                'label' => esc_html__('Title', 'tp-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Title', 'tp-core'),
                'title' => esc_html__('Enter title', 'tp-core'),
                'label_block' => true
                
            ]
        );
        $repeater->add_control(
            'tp_about_features_list_description',
            [
                'label' => esc_html__('Description', 'tp-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Description', 'tp-core'),
                'title' => esc_html__('Enter description', 'tp-core'),
                'label_block' => true
            ]
        );

        $this->add_control(
            'tp_about_features_list',
            [
                'label' => esc_html__('Features List', 'tp-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tp_about_features_list_title' => esc_html__('Custom shortcodes', 'tp-core'),
                        'tp_about_features_list_description' => esc_html__('No matter how much you know
                        about a part icular medical', 'tp-core'),
                    ],
                    [
                        'tp_about_features_list_title' => esc_html__('IT Consultant & Tech', 'tp-core'),
                        'tp_about_features_list_description' => esc_html__('No matter how much you know
                        about a part icular medical', 'tp-core'),
                    ]
                ],
                'title_field' => '{{{ tp_about_features_list_title }}}',
            ]
        );

        $this->end_controls_section();
        

        // tp_btn_button_group
        $this->start_controls_section(
            'tp_btn_button_group',
            [
                'label' => esc_html__('Button', 'tp-core'),

            ]
        );

        $this->add_control(
            'tp_button_style',
            [
                'label' => esc_html__('Select Button Style', 'tp-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'tp-btn-blue-lg' => esc_html__('Style 1', 'tp-core'),
                    'tp-btn-inner' => esc_html__('Style 2', 'tp-core'),
                ],
                'default' => 'tp-btn-blue-lg',
                'condition' => [
                    'tp_design_style' => ['layout-4']
                ]
            ]
        );

        $this->add_control(
            'tp_btn_button_show',
            [
                'label' => esc_html__( 'Show Button', 'tp-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'tp-core' ),
                'label_off' => esc_html__( 'Hide', 'tp-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'tp_btn_text',
            [
                'label' => esc_html__('Button Text', 'tp-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Button Text', 'tp-core'),
                'title' => esc_html__('Enter button text', 'tp-core'),
                'label_block' => true,
                'condition' => [
                    'tp_btn_button_show' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'tp_btn_link_type',
            [
                'label' => esc_html__('Button Link Type', 'tp-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
                'condition' => [
                    'tp_btn_button_show' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'tp_btn_link',
            [
                'label' => esc_html__('Button link', 'tp-core'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'tp-core'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'tp_btn_link_type' => '1',
                    'tp_btn_button_show' => 'yes'
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'tp_btn_page_link',
            [
                'label' => esc_html__('Select Button Page', 'tp-core'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => tp_get_all_pages(),
                'condition' => [
                    'tp_btn_link_type' => '2',
                    'tp_btn_button_show' => 'yes'
                ]
            ]
        );
        $this->end_controls_section();

        // _tp_image
		$this->start_controls_section(
            '_tp_image',
            [
                'label' => esc_html__('Thumbnail', 'tp-core'),
            ]
        );
        $this->add_control(
            'tp_image',
            [
                'label' => esc_html__( 'Choose Image', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'tp_image_2',
            [
                'label' => esc_html__( 'Choose Image 2', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-1','layout-2','layout-3','layout-5']
                ]
            ]
        );
        $this->add_control(
            'tp_image_3',
            [
                'label' => esc_html__( 'Choose Image 3', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-3']
                ]
            ]
        );

        $this->add_control(
            'tp_image_4',
            [
                'label' => esc_html__( 'Choose Image 4', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-3']
                ]
            ]
        );


        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'tp_image_size',
                'default' => 'full',
                'exclude' => [
                    'custom'
                ]
            ]
        );

       
        $this->end_controls_section();
        // progress bar section
        $this->start_controls_section(
            'tp_about_progress_bar',
                [
                'label' => esc_html__( 'Progress Bar', 'tpcore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => ['layout-1', 'layout-3','layout-4','layout-5']
                ]
            ]
        );
        $this->add_control(
            'extra_condition_prograss_bar',
            [
                'label' => __( 'Field condition', 'tpcore' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'tpcore' ),
                    'style_2' => __( 'Style 2', 'tpcore' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );


        $this->add_control(
            'tp_about_progress_bar_title',
            [
                'label' => esc_html__( 'Progress Bar Title', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
        $this->add_control(
            'tp_about_progress_bar_value',
            [
                'label' => esc_html__( 'Progress Bar Value', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
        $this->add_control(
            'tp_about_progress_bar_title_2',
            [
                'label' => esc_html__( 'Progress Bar Title 2', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'extra_condition_prograss_bar' => 'style_2'
                ]
            ]
        );
        $this->add_control(
            'tp_about_progress_bar_value_2',
            [
                'label' => esc_html__( 'Progress Bar Value 2', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'extra_condition_prograss_bar' => 'style_2'
                ]
            ]
        );
        $this->end_controls_section();

        // client section
        $this->start_controls_section(
            'tp_about_client',
                [
                'label' => esc_html__( 'Client', 'tpcore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => ['layout-1','layout-5']
                ]
            ]
        );
        $this->add_control(
            'tp_about_client_title',
            [
                'label' => esc_html__( 'Client Title', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
        $this->add_control(
            'tp_about_client_subtitle',
            [
                'label' => esc_html__( 'Client subtitle', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
        //client image
        $this->add_control(
            'tp_about_client_image',
            [
                'label' => esc_html__( 'Choose Image', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // client image size
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'tp_about_client_image_size',
                'default' => 'full',
                'exclude' => [
                    'custom'
                ]
            ]
        );
        $this->end_controls_section();

        // shape section
        $this->start_controls_section(
            'tp_about_shape',
                [
                'label' => esc_html__( 'Shape', 'tpcore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => ['layout-2','layout-4','layout-5']
                ]
            ]
        );

        $this->add_control(
            'tp_about_shape_switch',
            [
            'label'        => esc_html__( 'Shape On/Off', 'tpcore' ),
            'type'         => \Elementor\Controls_Manager::SWITCHER,
            'label_on'     => esc_html__( 'Show', 'tpcore' ),
            'label_off'    => esc_html__( 'Hide', 'tpcore' ),
            'return_value' => 'yes',
            'default'      => '1',
            ]
        );

        $this->end_controls_section();

         // Extra About Section
         $this->start_controls_section(
            'tp_extra_about',
            [
                'label' => esc_html__('About Extra Info', 'tp-core'),
                'condition' => [
                    'tp_design_style' => ['layout-2','layout-3','layout-4','layout-5']
                ]
            ]
        );
        $this->add_control(
            'extra_condition',
            [
                'label' => __( 'Field condition', 'tpcore' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'tpcore' ),
                    'style_2' => __( 'Style 2', 'tpcore' ),
                    'style_3' => __( 'Style 3', 'tpcore' ),
                    'style_4' => __( 'Style 4', 'tpcore' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

       
        $this->add_control(
            'tp_extra_about_big_title',
            [
                'label' => esc_html__('Extra About BIg Title', 'tp-core'),
                'type' => Controls_Manager::TEXT,
                'title' => esc_html__('Enter Extra About Big Title', 'tp-core'),
                'label_block' => true,
                'condition' => [
                    'tp_design_style' => ['layout-2','layout-3'],
                    'extra_condition' => ['style_1']
                ]
            ]
        );

        $this->add_control(
            'tp_box_icon_type',
            [
                'label' => esc_html__('Select Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                    'svg' => esc_html__('SVG', 'tpcore'),
                ],
                'condition' => [
                    'extra_condition' => ['style_2']
                ]
            ]
        );
        $this->add_control(
            'tp_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'tpcore'),
                'condition' => [
                    'tp_box_icon_type' => 'svg',
                    'extra_condition' => ['style_2']
                ]
            ]
        );

        $this->add_control(
            'tp_box_icon_image',
            [
                'label' => esc_html__('Upload Icon Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_box_icon_type' => 'image',
                    'extra_condition' => ['style_2']
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $this->add_control(
                'tp_box_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                        'extra_condition' => ['style_2']
                    ]
                ]
            );
        } else {
            $this->add_control(
                'tp_box_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                        'extra_condition' => ['style_2']
                    ]
                ]
            );
        }


        $this->add_control(
            'tp_extra_about_big_discription',
            [
                'label' => esc_html__('Extra About Discription', 'tp-core'),
                'type' => Controls_Manager::TEXTAREA,
                'title' => esc_html__('Enter Extra About Big Discription', 'tp-core'),
                'label_block' => true,
                'condition' => [
                    'tp_design_style' => ['layout-2','layout-3'],
                    'extra_condition' => ['style_2']
                ]
            ]
        );

        $this->add_control(
            'tp_extra_about_count',
            [
                'label' => esc_html__('Extra About count', 'tp-core'),
                'type' => Controls_Manager::TEXT,
                'title' => esc_html__('Enter Extra About count', 'tp-core'),
                'label_block' => true,
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                    'extra_condition' => ['style_1']
                ]
            ]
        );

        $this->add_control(
            'tp_extra_about_title',
            [
                'label' => esc_html__('Extra About Title', 'tp-core'),
                'type' => Controls_Manager::TEXTAREA,
                'title' => esc_html__('Enter Extra About Date', 'tp-core'),
                'label_block' => true,
                'condition' => [
                    'tp_design_style' => ['layout-2'],
                    'extra_condition' => ['style_1']
                ]
            ]
        );

        $this->add_control(
            'tp_extra_about_title_2',
            [
                'label' => esc_html__('Extra About Title 2', 'tp-core'),
                'type' => Controls_Manager::TEXTAREA,
                'title' => esc_html__('Enter Extra About Date', 'tp-core'),
                'label_block' => true,
                'condition' => [
                    'tp_design_style' => ['layout-4'],
                    'extra_condition' => ['style_3', 'style_4']
                ]
            ]
        );

        $this->add_control(
            'tp_extra_about_cta_title',
            [
                'label' => esc_html__('Cta About Title', 'tp-core'),
                'type' => Controls_Manager::TEXT,
                'title' => esc_html__('Enter Extra About Date', 'tp-core'),
                'label_block' => true,
                'condition' => [
                    'extra_condition' => ['style_4']
                ]
            ]
        );
        $this->add_control(
            'tp_extra_about_cta_phone',
            [
                'label' => esc_html__('Cta About phone', 'tp-core'),
                'type' => Controls_Manager::TEXT,
                'title' => esc_html__('Enter Extra About Date', 'tp-core'),
                'label_block' => true,
                'condition' => [
                    'extra_condition' => ['style_4']
                ]
            ]
        );

        $this->end_controls_section();

        // tp_video
        $this->start_controls_section(
            'tp_video',
            [
                'label' => esc_html__('Video', 'tpcore'),
                'condition' => [
                    'tp_design_style' => ['layout-1','layout-2','layout-4']
                ]
            ]
        );

        $this->add_control(
            'tp_video_url',
            [
                'label' => esc_html__('Video URL', 'tpcore'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'https://www.youtube.com/watch?v=_RpLvsA1SNM',
                'label_block' => true,
                'description' => __("We recommended to put video url form video website such as 'youtube', 'vimeo'.", 'tpcore')
            ]
        );

		$this->add_control(
            'tp_thumbnail_image',
            [
                'label' => esc_html__( 'Choose Video thumbnail', 'tp-core' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => ['layout-5']
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'tp_thumbnail_size',
                'default' => 'full',
                'exclude' => [
                    'custom'
                ],
                'condition' => [
                    'tp_design_style' => ['layout-5']
                ]
            ]
        );

        $this->end_controls_section();

	}

    

    // style_tab_content
    protected function style_tab_content(){
        $this->tp_section_style_controls('about_section', 'Section - Style', '.tp-el-section'); 
        $this->tp_basic_style_controls('section_sub_title', 'Section - Sub Title', '.tp-el-sub-title');
        $this->tp_link_controls_style('about_btn', 'About - Button', '.tp-el-btn');
    }

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

<?php if ( $settings['tp_design_style']  == 'layout-5' ): 
     if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_image_2']['url']) ) {
        $tp_image_2 = !empty($settings['tp_image_2']['id']) ? wp_get_attachment_image_url( $settings['tp_image_2']['id'], $settings['tp_image_size_size']) : $settings['tp_image_2']['url'];
        $tp_image_alt_2 = get_post_meta($settings["tp_image_2"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_about_client_image']['url']) ) {
        $tp_about_client_image = !empty($settings['tp_about_client_image']['id']) ? wp_get_attachment_image_url( $settings['tp_about_client_image']['id'], $settings['tp_about_client_image_size_size']) : $settings['tp_about_client_image']['url'];
        $tp_about_client_image_alt = get_post_meta($settings["tp_about_client_image"]["id"], "_wp_attachment_image_alt", true);
    }
    
    // Link
    if ('2' == $settings['tp_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
    } else {
        if ( ! empty( $settings['tp_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
        }
    }

    $this->add_render_attribute('title_args', 'class', 'tp-section-title');
?>
   <div class="tp-about__area tp-about__space">
            <div class="container">
                <div class="row align-items-xl-start align-items-center">
                    <div class="col-xl-5 col-lg-5 wow tpfadeLeft" data-wow-duration=".9s"
                    data-wow-delay=".3s">
                        <div class="tp-about-us__main-thumb p-relative">
                        <?php if(!empty($tp_image)) : ?>
                            <img src="<?php echo esc_url($tp_image); ?>" alt="<?php echo esc_attr($tp_image_alt); ?>">
                            <?php endif; ?>
                            <?php if(!empty($tp_image_2)) : ?>
                            <div class="tp-about-us__thumb-sm">
                                <img src="<?php echo esc_url($tp_image_2); ?>" alt="<?php echo esc_attr($tp_image_alt_2); ?>">
                            </div>
                            <?php endif; ?>
                            <?php if ( !empty($settings['tp_about_shape_switch']) ) : ?>
                            <div class="tp-about-us__thumb-border"></div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-xl-7 col-lg-7 wow tpfadeRight" data-wow-duration=".9s"
                    data-wow-delay=".7s">
                        <div class="tp-about__right-side tp-about__right-box">
                            <div class="tp-about__section-title pb-25">
                            <?php if ( !empty($settings['tp_about_sub_title']) ) : ?>
                                <span class="tp-section-subtitle-2"><?php echo tp_kses( $settings['tp_about_sub_title'] ); ?></span>
                                <?php endif; ?>
                                <?php if ( !empty($settings['tp_about_title' ]) ) :
                                printf( '<%1$s %2$s>%3$s</%1$s>',
                                tag_escape( $settings['tp_about_title_tag'] ),
                                $this->get_render_attribute_string( 'title_args' ),
                                tp_kses( $settings['tp_about_title' ] )
                                );
                            endif; ?>
                            </div>
                            <div class="tp-about__content">
                            <?php if ( !empty($settings['tp_about_description']) ) : ?>
                                <div class="tp-about__text">
                                    <p><?php echo tp_kses( $settings['tp_about_description'] ); ?></p>
                                </div>
                                <?php endif; ?>
                                <div class="tp-about__wraper pb-40 d-flex justify-content-between">
                                <?php 
                            if ( !empty($settings['tp_about_features_list']) ) :
                                foreach ( $settings['tp_about_features_list'] as $item ) :
                                    $title = $item['tp_about_features_list_title'];
                                    $description = $item['tp_about_features_list_description']; 
                            ?>
                                    <div class="tp-about__list-item d-flex align-items-start">
                                        <div class="tp-about__list-icon">
                                            <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                            <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                            <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                            <?php endif; ?>
                                            <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                            <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                            <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                                alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                            <?php endif; ?>
                                            <?php else : ?>
                                            <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                            <?php echo $item['tp_box_icon_svg']; ?>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="tp-about__list-content">
                                        <?php  if ( !empty('tp_about_features_list_title') ) : ?>
                                            <h4 class="tp-about__title-sm"><?php echo tp_kses( $item['tp_about_features_list_title'] ); ?></h4>
                                            <?php endif; ?>
                                            <?php  if ( !empty('tp_about_features_list_description') ) : ?>
                                                <p><?php echo tp_kses( $item['tp_about_features_list_description'] ); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php endforeach; endif; ?> 
                                </div>
                                <div class="tp-about-progress">
                                    <div class="tp-about-progress-item fix">
                                    <?php if ( !empty($settings['tp_about_progress_bar_title']) ) : ?>
                                        <h4><?php echo tp_kses($settings['tp_about_progress_bar_title']); ?></h4>
                                        <?php endif; ?>
                                        <span class="progress-count"><?php echo tp_kses($settings['tp_about_progress_bar_value']); ?><?php echo esc_html("%","tpcore") ?></span>
                                        <div class="progress">
                                            <div class="progress-bar wow slideInLeft" data-wow-duration="1s"
                                                data-wow-delay=".3s" role="progressbar" data-width="<?php echo esc_attr($settings['tp_about_progress_bar_value']); ?>%"
                                                aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"
                                                style="width: 58%; visibility: visible; animation-duration: 1s; animation-delay: 0.3s; animation-name: slideInLeft;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tp-about__bottom d-flex">
                                    <div class="tp-about__contact-us">
                                    <?php if ( !empty($settings['tp_extra_about_cta_title']) ) : ?>
                                        <span><?php echo tp_kses($settings['tp_extra_about_cta_title']); ?></span>
                                        <?php endif; ?>    
                                        <?php if ( !empty($settings['tp_extra_about_cta_phone']) ) : ?>  
                                        <a href="tel:<?php echo esc_attr($settings['tp_extra_about_cta_phone']); ?>"><?php echo tp_kses($settings['tp_extra_about_cta_phone']); ?></a>         
                                        <?php endif; ?>                         
                                    </div>
                                    <div class="tp-about__author-box d-flex align-items-center">
                                    <?php if(!empty($tp_about_client_image)) : ?>
                                        <div class="tp-about__author-thumb pr-25">
                                            <img src="<?php echo esc_url($tp_about_client_image); ?>" alt="<?php echo esc_attr($tp_about_client_image_alt); ?>">
                                        </div>
                                        <?php endif; ?>
                                        <div class="tp-about__author-info">
                                        <?php if(!empty($settings['tp_about_client_title'])) : ?>
                                            <h5 class="tp-about__author-name"><?php echo tp_kses($settings['tp_about_client_title']); ?></h5>
                                            <?php endif; ?>
                                            <?php if(!empty($settings['tp_about_client_subtitle'])) : ?>
                                            <span><?php echo tp_kses($settings['tp_about_client_subtitle']); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<?php elseif ( $settings['tp_design_style']  == 'layout-4' ): 
     if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }
    
    // Link
    if ('2' == $settings['tp_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
    } else {
        if ( ! empty( $settings['tp_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
        }
    }

    $this->add_render_attribute('title_args', 'class', 'tp-section-title');
?>

<div class="tp-about-4__area tp-about-4__space p-relative fix grey-bg">
    <div class="tp-about-4__bg" data-background="<?php echo esc_url($tp_image); ?>">
        <div class="tp-about-4__bg-text d-none d-lg-block">
        <?php if ( !empty($settings['tp_extra_about_title_2']) ) : ?>
            <span><?php echo tp_kses($settings['tp_extra_about_title_2']); ?></span>
            <?php endif; ?>
            <?php if(!empty($settings['tp_video_url'])) : ?>
            <div class="tp-about-4__play-btn">
                <a class="popup-video" href="<?php echo esc_url($settings['tp_video_url']); ?>"><i class="fa-sharp fa-solid fa-play"></i></a>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php if ( !empty($settings['tp_about_shape_switch']) ) : ?>
    <div class="tp-about-4__shape d-none d-xxl-block">
        <img src="<?php echo get_template_directory_uri() ?>/assets/img/about/about-shape-4.png" alt="">               
    </div>
    <?php endif; ?>
    <div class="container">
        <div class="row">
            <div class="offset-xl-6 offset-lg-6 col-xl-6 col-lg-6 wow tpfadeRight" data-wow-duration=".9s"
            data-wow-delay=".5s">
                <div class="tp-about-4__left-side">
                <?php if ( !empty($settings['tp_about_section_title_show']) ) : ?>
                    <div class="tp-about-4__section-title">
                    <?php if ( !empty($settings['tp_about_sub_title']) ) : ?>
                        <span class="tp-section-subtitle-3"><?php echo tp_kses( $settings['tp_about_sub_title'] ); ?></span>
                        <?php endif; ?>
                        <?php if ( !empty($settings['tp_about_title' ]) ) :
                                printf( '<%1$s %2$s>%3$s</%1$s>',
                                tag_escape( $settings['tp_about_title_tag'] ),
                                $this->get_render_attribute_string( 'title_args' ),
                                tp_kses( $settings['tp_about_title' ] )
                                );
                            endif; ?>
                    </div>
                <?php endif; ?>
                    <div class="tp-about-4__content">
                    <?php if ( !empty($settings['tp_about_description']) ) : ?>
                        <div class="tp-about-4__text">
                            <p><?php echo tp_kses( $settings['tp_about_description'] ); ?></p>
                        </div>
                        <?php endif; ?>                                
                        <div class="tp-about-4__wraper pb-45 d-flex justify-content-between">
                            <div class="tp-about-4__list-item d-flex align-items-start">
                            <?php 
                            if ( !empty($settings['tp_about_features_list']) ) :
                                foreach ( $settings['tp_about_features_list'] as $item ) :
                                    $title = $item['tp_about_features_list_title'];
                                    $description = $item['tp_about_features_list_description']; 
                            ?>
                                <div class="tp-about-4__list-icon">
                                    <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                        <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                        <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                        <?php endif; ?>
                                        <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                        <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                        <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                            alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                        <?php endif; ?>
                                        <?php else : ?>
                                        <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                        <?php echo $item['tp_box_icon_svg']; ?>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                                <div class="tp-about-4__list-content">
                                <?php  if ( !empty('tp_about_features_list_title') ) : ?>
                                    <h4 class="tp-about-4__title-sm"><?php echo tp_kses( $item['tp_about_features_list_title'] ); ?></h4>
                                    <?php endif;?>
                                    <?php  if ( !empty('tp_about_features_list_description') ) : ?>
                                    <p><?php echo tp_kses( $item['tp_about_features_list_description'] ); ?></p>
                                    <?php endif;?>
                                </div>
                            </div>
                            <?php endforeach; endif; ?>
                        </div>   
                        <div class="tp-about-4__progress mb-40">
                            <div class="tp-about-4__progress-item fix">
                            <?php if ( !empty($settings['tp_about_progress_bar_title']) ) : ?>
                                <h4><?php echo tp_kses($settings['tp_about_progress_bar_title']); ?></h4>
                                <?php endif; ?>
                                <span class="progress-count"><?php echo tp_kses($settings['tp_about_progress_bar_value']); ?><?php echo esc_html("%","tpcore") ?></span>
                                <div class="progress">
                                    <div class="progress-bar wow slideInLeft" data-wow-duration="1s"
                                        data-wow-delay=".3s" role="progressbar" data-width="<?php echo esc_attr($settings['tp_about_progress_bar_value']); ?>%"
                                        aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"
                                        style="width: 58%; visibility: visible; animation-duration: 1s; animation-delay: 0.3s; animation-name: slideInLeft;">
                                    </div>
                                </div>
                            </div>
                            <div class="tp-about-4__progress-item fix">
                            <?php if ( !empty($settings['tp_about_progress_bar_title_2']) ) : ?>
                                <h4><?php echo tp_kses($settings['tp_about_progress_bar_title_2']); ?></h4>
                                <?php endif; ?>
                                <span class="progress-count"><?php echo tp_kses($settings['tp_about_progress_bar_value_2']); ?><?php echo esc_html("%","tpcore") ?></span>
                                <div class="progress">
                                    <div class="progress-bar wow slideInLeft" data-wow-duration="1s"
                                        data-wow-delay=".3s" role="progressbar" data-width="<?php echo esc_attr($settings['tp_about_progress_bar_value_2']); ?>%"
                                        aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"
                                        style="width: 58%; visibility: visible; animation-duration: 1s; animation-delay: 0.3s; animation-name: slideInLeft;">
                                    </div>
                                </div>
                            </div>
                        </div>         
                        <?php if ( !empty($settings['tp_btn_text']) ) : ?>                    
                        <div class="tp-about-4__btn">
                            <a <?php echo $this->get_render_attribute_string( 'tp-button-arg' ); ?>><?php echo tp_kses($settings['tp_btn_text']); ?></a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php elseif ( $settings['tp_design_style']  == 'layout-3' ): 
     if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_image_2']['url']) ) {
        $tp_image_2 = !empty($settings['tp_image_2']['id']) ? wp_get_attachment_image_url( $settings['tp_image_2']['id'], $settings['tp_image_size_size']) : $settings['tp_image_2']['url'];
        $tp_image_alt_2 = get_post_meta($settings["tp_image_2"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_image_3']['url']) ) {
        $tp_image_3 = !empty($settings['tp_image_3']['id']) ? wp_get_attachment_image_url( $settings['tp_image_3']['id'], $settings['tp_image_size_size']) : $settings['tp_image_3']['url'];
        $tp_image_alt_3 = get_post_meta($settings["tp_image_3"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_image_4']['url']) ) {
        $tp_image_4 = !empty($settings['tp_image_4']['id']) ? wp_get_attachment_image_url( $settings['tp_image_4']['id'], $settings['tp_image_size_size']) : $settings['tp_image_4']['url'];
        $tp_image_alt_4 = get_post_meta($settings["tp_image_4"]["id"], "_wp_attachment_image_alt", true);
    }

    // Link
    if ('2' == $settings['tp_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
    } else {
        if ( ! empty( $settings['tp_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
        }
    }

    $this->add_render_attribute('title_args', 'class', 'tp-section-title');
?>


<div class="tp-about-3__area tp-about-3__pb">
            <div class="container">
                <div class="row align-items-xl-start align-items-center">
                    <div class="col-xl-5 col-lg-5 wow tpfadeLeft" data-wow-duration=".9s"
                    data-wow-delay=".3s">
                        <div class="tp-about-3__main-thumb p-relative">
                        <?php if(!empty($tp_image)) : ?>
                            <img src="<?php echo esc_url($tp_image); ?>" alt="<?php echo esc_attr($tp_image_alt); ?>">
                        <?php endif; ?>
                        <?php if(!empty($tp_image_2)) : ?>
                            <div class="tp-about-3__thumb-sm">
                                <img src="<?php echo esc_url($tp_image_2); ?>" alt="<?php echo esc_attr($tp_image_alt_2); ?>">
                            </div>
                            <?php endif; ?>
                            <div class="tp-about-3__circle-box">
                            <?php if(!empty($tp_image_3)) : ?>
                                <img src="<?php echo esc_url($tp_image_3); ?>" alt="<?php echo esc_attr($tp_image_alt_3); ?>">
                                <?php endif; ?>
                                <?php if(!empty($tp_image_4)) : ?>
                                <div class="tp-about-3__circle-text">
                                    <img src="<?php echo esc_url($tp_image_4); ?>" alt="<?php echo esc_attr($tp_image_alt_4); ?>">
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-7 col-lg-7 wow tpfadeRight" data-wow-duration=".9s"
                    data-wow-delay=".9s">
                        <div class="tp-about-3__left-side">
                            <div class="tp-about-3__section-title">
                            <?php if ( !empty($settings['tp_about_section_title_show']) ) : ?>
                                <span class="tp-section-subtitle-3"><?php echo tp_kses( $settings['tp_about_sub_title'] ); ?></span>
                                <?php endif; ?>
                                <?php if ( !empty($settings['tp_about_title' ]) ) :
                                printf( '<%1$s %2$s>%3$s</%1$s>',
                                tag_escape( $settings['tp_about_title_tag'] ),
                                $this->get_render_attribute_string( 'title_args' ),
                                tp_kses( $settings['tp_about_title' ] )
                                );
                            endif; ?>
                            </div>
                            <div class="tp-about-3__content">
                            <?php if ( !empty($settings['tp_about_description']) ) : ?>
                                <div class="tp-about-3__text">
                                    <p><?php echo tp_kses( $settings['tp_about_description'] ); ?></p>
                                </div>
                                <?php endif; ?>
                                <?php if ( !empty($settings['tp_extra_about_big_discription']) ) : ?>
                                 <div class="tp-about-3__text-2 d-flex align-items-center">
                                    <span>
                                        <?php if($settings['tp_box_icon_type'] == 'icon') : ?>
                                            <?php if (!empty($settings['tp_box_icon']) || !empty($settings['tp_box_selected_icon']['value'])) : ?>
                                            <?php tp_render_icon($settings, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                            <?php endif; ?>
                                            <?php elseif( $settings['tp_box_icon_type'] == 'image' ) : ?>
                                            <?php if (!empty($settings['tp_box_icon_image']['url'])): ?>
                                            <img src="<?php echo $settings['tp_box_icon_image']['url']; ?>"
                                                alt="<?php echo get_post_meta(attachment_url_to_postid($settings['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                            <?php endif; ?>
                                            <?php else : ?>
                                            <?php if (!empty($settings['tp_box_icon_svg'])): ?>
                                            <?php echo $settings['tp_box_icon_svg']; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </span>
                                    <p><?php echo tp_kses( $settings['tp_extra_about_big_discription'] ); ?></p>
                                </div>
                                <?php endif; ?>
                                <div class="tp-about-3__progress">
                                    <div class="tp-about-3__progress-item fix">
                                    <?php if ( !empty($settings['tp_about_progress_bar_title']) ) : ?>
                                        <h4><?php echo tp_kses($settings['tp_about_progress_bar_title']); ?></h4>
                                        <?php endif; ?>
                                        <span class="progress-count"><?php echo tp_kses($settings['tp_about_progress_bar_value']); ?><?php echo esc_html("%","tpcore") ?></span>
                                        <div class="progress">
                                            <div class="progress-bar wow slideInLeft" data-wow-duration="1s"
                                                data-wow-delay=".3s" role="progressbar" data-width="<?php echo esc_attr($settings['tp_about_progress_bar_value']); ?>%"
                                                aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"
                                                style="width: 58%; visibility: visible; animation-duration: 1s; animation-delay: 0.3s; animation-name: slideInLeft;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tp-about-3__wraper pb-40 d-flex justify-content-between">
                                <?php if ( !empty($settings['tp_about_features_list']) ) :
                                foreach ( $settings['tp_about_features_list'] as $item ) :
                                    $title = $item['tp_about_features_list_title'];
                                    $description = $item['tp_about_features_list_description']; 
                                    ?>
                                    <div class="tp-about-3__list-item d-flex about-items-start">
                                        <div class="tp-about-3__list-icon">
                                        <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                            <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                            <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                            <?php endif; ?>
                                            <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                            <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                            <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                                alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                            <?php endif; ?>
                                            <?php else : ?>
                                            <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                            <?php echo $item['tp_box_icon_svg']; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        </div>
                                        <div class="tp-about-3__list-content">
                                        <?php  if ( !empty('tp_about_features_list_title') ) : ?>
                                            <h4 class="tp-about-3__title-sm"><?php echo tp_kses( $item['tp_about_features_list_title'] ); ?></h4>
                                            <?php endif;?>
                                            <?php  if ( !empty('tp_about_features_list_description') ) : ?>
                                            <p><?php echo tp_kses( $item['tp_about_features_list_description'] ); ?></p>
                                            <?php endif;?>
                                        </div>
                                    </div>
                                    <?php endforeach; endif; ?>
                                </div>      
                                <?php if ( !empty($settings['tp_btn_text']) ) : ?>                          
                                <div class="tp-about-3__btn">
                                    <a <?php echo $this->get_render_attribute_string( 'tp-button-arg' ); ?>><?php echo tp_kses($settings['tp_btn_text']); ?></a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<?php elseif ( $settings['tp_design_style']  == 'layout-2' ): 
    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_image_2']['url']) ) {
        $tp_image_2 = !empty($settings['tp_image_2']['id']) ? wp_get_attachment_image_url( $settings['tp_image_2']['id'], $settings['tp_image_size_size']) : $settings['tp_image_2']['url'];
        $tp_image_alt_2 = get_post_meta($settings["tp_image_2"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_about_client_image']['url']) ) {
        $tp_about_client_image = !empty($settings['tp_about_client_image']['id']) ? wp_get_attachment_image_url( $settings['tp_about_client_image']['id'], $settings['tp_about_client_image_size_size']) : $settings['tp_about_client_image']['url'];
        $tp_about_client_image_alt = get_post_meta($settings["tp_about_client_image"]["id"], "_wp_attachment_image_alt", true);
    }

    // Link
    if ('2' == $settings['tp_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
    } else {
        if ( ! empty( $settings['tp_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn');
        }
    }

    $this->add_render_attribute('title_args', 'class', 'tp-section-title');
?>
 <div class="tp-about-2__area fix p-relative">
            <?php if ( !empty($settings['tp_extra_about_big_title']) ) : ?>
            <div class="tp-about-2__text-box d-none d-xl-block">
                <h5 class="tp-about-2__big-text"><?php echo tp_kses( $settings['tp_extra_about_big_title'] ); ?></h5>
            </div>
            <?php endif; ?>
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-5 col-lg-5 wow tpfadeLeft" data-wow-duration=".9s"
                    data-wow-delay=".3s">
                        <div class="tp-about-2__main-thumb p-relative text-center text-lg-end">
                            <?php if(!empty($tp_image)) : ?>
                                <img src="<?php echo esc_url($tp_image); ?>" alt="<?php echo esc_attr($tp_image_alt); ?>">
                            <?php endif; ?>
                            <div class="tp-about-2__thumb-sm">
                                <?php if(!empty($tp_image_2)) : ?>
                                    <img src="<?php echo esc_url($tp_image_2); ?>" alt="<?php echo esc_attr($tp_image_alt_2); ?>">
                                <?php endif; ?>
                                <?php if(!empty($settings['tp_video_url'])) : ?>
                                <div class="tp-about-2__icon">
                                    <a class="popup-video" href="<?php echo esc_url($settings['tp_video_url']); ?>">
                                        <i class="fas fa-play"></i>
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>
                            <?php if ( !empty($settings['tp_about_shape_switch']) ) : ?>
                            <div class="tp-about-2__thumb-border"></div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-xl-7 col-lg-7 wow tpfadeRight" data-wow-duration=".9s"
                    data-wow-delay=".9s">
                        <div class="tp-about-2__right-box">
                            <div class="tp-about-2__section-title pb-25">
                                <?php if ( !empty($settings['tp_about_sub_title']) ) : ?>
                                    <span class="tp-section-subtitle-2"><?php echo tp_kses( $settings['tp_about_sub_title'] ); ?></span>
                                <?php endif; ?>
                                <?php if ( !empty($settings['tp_about_title' ]) ) :
                                printf( '<%1$s %2$s>%3$s</%1$s>',
                                tag_escape( $settings['tp_about_title_tag'] ),
                                $this->get_render_attribute_string( 'title_args' ),
                                tp_kses( $settings['tp_about_title' ] )
                                );
                            endif; ?>
                            </div>
                            <?php if ( !empty($settings['tp_about_description']) ) : ?>
                                <div class="tp-about-2__text">
                                    <p><?php echo tp_kses( $settings['tp_about_description'] ); ?></p>
                                </div>
                            <?php endif; ?>
                            <div class="tp-about-2__wraper pb-40 d-flex justify-content-between">
                            <?php 
                            if ( !empty($settings['tp_about_features_list']) ) :
                                foreach ( $settings['tp_about_features_list'] as $item ) :
                                    $title = $item['tp_about_features_list_title'];
                                    $description = $item['tp_about_features_list_description']; 
                            ?>
                                <div class="tp-about-2__list-item d-flex align-items-start">
                                    <div class="tp-about-2__list-icon">
                                        <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                        <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                        <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                        <?php endif; ?>
                                        <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                        <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                        <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                            alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                        <?php endif; ?>
                                        <?php else : ?>
                                        <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                        <?php echo $item['tp_box_icon_svg']; ?>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="tp-about-2__list-content">
                                    <?php  if ( !empty('tp_about_features_list_title') ) : ?>
                                        <h4 class="tp-about-2__title-sm"><?php echo tp_kses( $item['tp_about_features_list_title'] ); ?></h4>
                                    <?php endif; ?>
                                    <?php  if ( !empty('tp_about_features_list_description') ) : ?>
                                        <p><?php echo tp_kses( $item['tp_about_features_list_description'] ); ?></p>
                                    <?php endif; ?>
                                    </div>
                                </div>
                                <?php endforeach; endif; ?>                              
                            </div>
                            <div class="tp-about-2__bottom d-flex">
                            <?php if ( !empty($settings['tp_btn_text']) ) : ?>
                                <div class="tp-about-2__btn">
                                    <a <?php echo $this->get_render_attribute_string( 'tp-button-arg' ); ?>><?php echo tp_kses($settings['tp_btn_text']); ?></a>
                                </div>
                            <?php endif; ?>
                                <div class="tp-about-2__fact d-flex align-items-center">
                                <?php if ( !empty($settings['tp_extra_about_count']) ) : ?>
                                    <h5 class="tp-about-2__fact-number"><?php echo tp_kses( $settings['tp_extra_about_count'] ); ?></h5>
                                <?php endif; ?>
                                <?php if ( !empty($settings['tp_extra_about_title']) ) : ?>
                                    <span><?php echo tp_kses( $settings['tp_extra_about_title'] ); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<?php else:

    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_image_2']['url']) ) {
        $tp_image_2 = !empty($settings['tp_image_2']['id']) ? wp_get_attachment_image_url( $settings['tp_image_2']['id'], $settings['tp_image_size_size']) : $settings['tp_image_2']['url'];
        $tp_image_alt_2 = get_post_meta($settings["tp_image_2"]["id"], "_wp_attachment_image_alt", true);
    }
    if ( !empty($settings['tp_about_client_image']['url']) ) {
        $tp_about_client_image = !empty($settings['tp_about_client_image']['id']) ? wp_get_attachment_image_url( $settings['tp_about_client_image']['id'], $settings['tp_about_client_image_size_size']) : $settings['tp_about_client_image']['url'];
        $tp_about_client_image_alt = get_post_meta($settings["tp_about_client_image"]["id"], "_wp_attachment_image_alt", true);
    }


    // Link
    if ('2' == $settings['tp_btn_link_type']) {
        $this->add_render_attribute('tp-button-arg', 'href', get_permalink($settings['tp_btn_page_link']));
        $this->add_render_attribute('tp-button-arg', 'target', '_self');
        $this->add_render_attribute('tp-button-arg', 'rel', 'nofollow');
        $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn tp-el-btn');
    } else {
        if ( ! empty( $settings['tp_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'tp-button-arg', $settings['tp_btn_link'] );
            $this->add_render_attribute('tp-button-arg', 'class', 'tp-btn tp-el-btn');
        }
    }

    $this->add_render_attribute('title_args', 'class', 'tp-section-title');
?>

<div class="tp-about__area tp-about__space">
    <div class="container">
        <div class="row align-items-xl-start align-items-center">
            <div class="col-xl-7 col-lg-7 wow tpfadeLeft" data-wow-duration=".9s"
            data-wow-delay=".3s">
                <div class="tp-about__left-side">
                    <?php if ( !empty($settings['tp_about_section_title_show']) ) : ?>
                    <div class="tp-about__section-title pb-25">
                        <?php if ( !empty($settings['tp_about_sub_title']) ) : ?>
                            <span class="tp-section-subtitle"><?php echo tp_kses( $settings['tp_about_sub_title'] ); ?></span>
                        <?php endif; ?>
                        <?php if ( !empty($settings['tp_about_title' ]) ) :
                                printf( '<%1$s %2$s>%3$s</%1$s>',
                                tag_escape( $settings['tp_about_title_tag'] ),
                                $this->get_render_attribute_string( 'title_args' ),
                                tp_kses( $settings['tp_about_title' ] )
                                );
                            endif; ?>
                    </div>
                    <?php endif; ?>
                    <div class="tp-about__content">
                    <?php if ( !empty($settings['tp_about_description']) ) : ?>
                        <div class="tp-about__text">
                            <p><?php echo tp_kses( $settings['tp_about_description'] ); ?></p>
                        </div>
                        <?php endif; ?>
                        <div class="tp-about__wraper pb-40 d-flex justify-content-between">
                            <?php 
                            if ( !empty($settings['tp_about_features_list']) ) :
                                foreach ( $settings['tp_about_features_list'] as $item ) :
                                    $title = $item['tp_about_features_list_title'];
                                    $description = $item['tp_about_features_list_description']; 
                            ?>
                            <div class="tp-about__list-item d-flex align-items-start">
                                <div class="tp-about__list-icon">
                                    <?php if($item['tp_box_icon_type'] == 'icon') : ?>
                                    <?php if (!empty($item['tp_box_icon']) || !empty($item['tp_box_selected_icon']['value'])) : ?>
                                    <?php tp_render_icon($item, 'tp_box_icon', 'tp_box_selected_icon'); ?>
                                    <?php endif; ?>
                                    <?php elseif( $item['tp_box_icon_type'] == 'image' ) : ?>
                                    <?php if (!empty($item['tp_box_icon_image']['url'])): ?>
                                    <img src="<?php echo $item['tp_box_icon_image']['url']; ?>"
                                        alt="<?php echo get_post_meta(attachment_url_to_postid($item['tp_box_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
                                    <?php endif; ?>
                                    <?php else : ?>
                                    <?php if (!empty($item['tp_box_icon_svg'])): ?>
                                    <?php echo $item['tp_box_icon_svg']; ?>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                                <div class="tp-about__list-content">
                                    <?php  if ( !empty('tp_about_features_list_title') ) : ?>
                                    <h4 class="tp-about__title-sm"><?php echo tp_kses( $item['tp_about_features_list_title'] ); ?></h4>
                                    <?php endif;?>
                                    <?php  if ( !empty('tp_about_features_list_description') ) : ?>
                                        <p><?php echo tp_kses( $item['tp_about_features_list_description'] ); ?></p>
                                    <?php endif;?>
                                </div>
                            </div>
                            <?php endforeach; endif; ?>
                        </div>
                        <div class="tp-about-progress">
                            <div class="tp-about-progress-item fix">
                            <?php if ( !empty($settings['tp_about_progress_bar_title']) ) : ?>
                                <h4><?php echo tp_kses($settings['tp_about_progress_bar_title']); ?></h4>
                                <?php endif; ?>
                                <span class="progress-count"><?php echo tp_kses($settings['tp_about_progress_bar_value']); ?><?php echo esc_html("%","tpcore") ?></span>
                                <div class="progress">
                                    <div class="progress-bar wow slideInLeft" data-wow-duration="1s"
                                        data-wow-delay=".3s" role="progressbar" data-width="<?php echo esc_attr($settings['tp_about_progress_bar_value']); ?>%"
                                        aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"
                                        style="width: 58%; visibility: visible; animation-duration: 1s; animation-delay: 0.3s; animation-name: slideInLeft;">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tp-about__bottom d-flex">
                        <?php if ( !empty($settings['tp_btn_text']) ) : ?>
                            <div class="tp-about__btn">
                                <a <?php echo $this->get_render_attribute_string( 'tp-button-arg' ); ?>><?php echo tp_kses($settings['tp_btn_text']); ?></a>
                            </div>
                            <?php endif; ?>

                            <div class="tp-about__author-box d-flex align-items-center">
                            <?php if(!empty($tp_about_client_image)) : ?>
                                <div class="tp-about__author-thumb pr-25">
                                    <img src="<?php echo esc_url($tp_about_client_image); ?>" alt="<?php echo esc_attr($tp_about_client_image_alt); ?>">
                                </div>
                                <?php endif; ?>
                                <div class="tp-about__author-info">
                                <?php if(!empty($settings['tp_about_client_title'])) : ?>
                                    <h5 class="tp-about__author-name"><?php echo tp_kses($settings['tp_about_client_title']); ?></h5>
                                    <?php endif; ?>
                                    <?php if(!empty($settings['tp_about_client_subtitle'])) : ?>
                                    <span><?php echo tp_kses($settings['tp_about_client_subtitle']); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-5 col-lg-5 wow tpfadeRight" data-wow-duration=".9s"
            data-wow-delay=".9s">
                <div class="tp-about__main-thumb text-lg-end text-center p-relative">
                <?php if(!empty($tp_image)) : ?>
                    <img src="<?php echo esc_url($tp_image); ?>" alt="<?php echo esc_attr($tp_image_alt); ?>">
                    <?php endif; ?>
                    <?php if(!empty($tp_image_2)) : ?>
                    <div class="tp-about__thumb-sm">
                        <img src="<?php echo esc_url($tp_image_2); ?>" alt="<?php echo esc_attr($tp_image_alt_2); ?>">
                    </div>
                    <?php endif; ?>
                    <?php if(!empty($settings['tp_video_url'])) : ?>
                    <div class="tp-about__icon d-none d-lg-block">
                        <a class="popup-video" href="<?php echo esc_url($settings['tp_video_url']); ?>">
                            <i class="fas fa-play"></i>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>




<?php endif; 
	}
}

$widgets_manager->register( new TP_About() );
