<?php
/*
Plugin Name: Elfsight Logo Showcase CC
Description: Showcase logos of your clients, partners, brands and vendors on your website.
Plugin URI: https://elfsight.com/logo-showcase-widget/codecanyon/?utm_source=markets&utm_medium=codecanyon&utm_campaign=logo-showcase&utm_content=plugin-site
Version: 1.1.1
Author: Elfsight
Author URI: https://elfsight.com/?utm_source=markets&utm_medium=codecanyon&utm_campaign=logo-showcase&utm_content=plugins-list
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');

$elfsight_logo_showcase_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_logo_showcase_config = json_decode(file_get_contents($elfsight_logo_showcase_config_path), true);

new ElfsightLogoShowcasePlugin(
    array(
        'name' => esc_html__('Logo Showcase'),
        'description' => esc_html__('Showcase logos of your clients, partners, brands and vendors on your website.'),
        'slug' => 'elfsight-logo-showcase',
        'version' => '1.1.1',
        'text_domain' => 'elfsight-logo-showcase',

        'editor_settings' => $elfsight_logo_showcase_config['settings'],
        'editor_preferences' => $elfsight_logo_showcase_config['preferences'],

        'plugin_name' => esc_html__('Elfsight Logo Showcase'),
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),
        'menu_icon' => plugins_url('assets/img/menu-icon.svg', __FILE__),

        'product_url' => esc_url('https://codecanyon.net/item/elfsight-logo-showcase/25357329?ref=Elfsight'),
        'update_url' => esc_url('https://a.elfsight.com/updates/v1/'),
        'helpscout_plugin_id' => 110713
    )
);

?>
