<?php

namespace Square\Types;

use Square\Core\Json\JsonSerializableType;
use Square\Core\Json\JsonProperty;

class InventoryAdjustmentGroup extends JsonSerializableType
{
    /**
     * A unique ID generated by Square for the
     * `InventoryAdjustmentGroup`.
     *
     * @var ?string $id
     */
    #[JsonProperty('id')]
    private ?string $id;

    /**
     * @var ?string $rootAdjustmentId The inventory adjustment of the composed variation.
     */
    #[JsonProperty('root_adjustment_id')]
    private ?string $rootAdjustmentId;

    /**
     * Representative `from_state` for adjustments within the group. For example, for a group adjustment from `IN_STOCK` to `SOLD`,
     * there can be two component adjustments in the group: one from `IN_STOCK`to `COMPOSED` and the other one from `COMPOSED` to `SOLD`.
     * Here, the representative `from_state` for the `InventoryAdjustmentGroup` is `IN_STOCK`.
     * See [InventoryState](#type-inventorystate) for possible values
     *
     * @var ?value-of<InventoryState> $fromState
     */
    #[JsonProperty('from_state')]
    private ?string $fromState;

    /**
     * Representative `to_state` for adjustments within group. For example, for a group adjustment from `IN_STOCK` to `SOLD`,
     * the two component adjustments in the group can be from `IN_STOCK` to `COMPOSED` and from `COMPOSED` to `SOLD`.
     * Here, the representative `to_state` of the `InventoryAdjustmentGroup` is `SOLD`.
     * See [InventoryState](#type-inventorystate) for possible values
     *
     * @var ?value-of<InventoryState> $toState
     */
    #[JsonProperty('to_state')]
    private ?string $toState;

    /**
     * @param array{
     *   id?: ?string,
     *   rootAdjustmentId?: ?string,
     *   fromState?: ?value-of<InventoryState>,
     *   toState?: ?value-of<InventoryState>,
     * } $values
     */
    public function __construct(
        array $values = [],
    ) {
        $this->id = $values['id'] ?? null;
        $this->rootAdjustmentId = $values['rootAdjustmentId'] ?? null;
        $this->fromState = $values['fromState'] ?? null;
        $this->toState = $values['toState'] ?? null;
    }

    /**
     * @return ?string
     */
    public function getId(): ?string
    {
        return $this->id;
    }

    /**
     * @param ?string $value
     */
    public function setId(?string $value = null): self
    {
        $this->id = $value;
        return $this;
    }

    /**
     * @return ?string
     */
    public function getRootAdjustmentId(): ?string
    {
        return $this->rootAdjustmentId;
    }

    /**
     * @param ?string $value
     */
    public function setRootAdjustmentId(?string $value = null): self
    {
        $this->rootAdjustmentId = $value;
        return $this;
    }

    /**
     * @return ?value-of<InventoryState>
     */
    public function getFromState(): ?string
    {
        return $this->fromState;
    }

    /**
     * @param ?value-of<InventoryState> $value
     */
    public function setFromState(?string $value = null): self
    {
        $this->fromState = $value;
        return $this;
    }

    /**
     * @return ?value-of<InventoryState>
     */
    public function getToState(): ?string
    {
        return $this->toState;
    }

    /**
     * @param ?value-of<InventoryState> $value
     */
    public function setToState(?string $value = null): self
    {
        $this->toState = $value;
        return $this;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return $this->toJson();
    }
}
