<?php

namespace Square\GiftCards\Requests;

use Square\Core\Json\JsonSerializableType;
use Square\Core\Json\JsonProperty;

class GetGiftCardFromNonceRequest extends JsonSerializableType
{
    /**
     * The payment token of the gift card to retrieve. Payment tokens are generated by the
     * Web Payments SDK or In-App Payments SDK.
     *
     * @var string $nonce
     */
    #[JsonProperty('nonce')]
    private string $nonce;

    /**
     * @param array{
     *   nonce: string,
     * } $values
     */
    public function __construct(
        array $values,
    ) {
        $this->nonce = $values['nonce'];
    }

    /**
     * @return string
     */
    public function getNonce(): string
    {
        return $this->nonce;
    }

    /**
     * @param string $value
     */
    public function setNonce(string $value): self
    {
        $this->nonce = $value;
        return $this;
    }
}
