(function($){"use strict";var CharitableDashboard={chartInstance:null,init:function(){this.bindEvents();this.initComponents();this.hideInitialLoadingSpinner();this.hideSpinnersOnPageLoad();var self=this;setTimeout((function(){$("#charitable-dashboard-v2").addClass("charitable-dashboard-loaded");$("body.charitable_page_charitable-dashboard").addClass("charitable-dashboard-loaded")}),1e4)},bindEvents:function(){$(document).on("click",".charitable-dashboard-v2-toggle",this.handleToggleClick);$(document).on("change","#time-period-filter",this.handleTimePeriodChange);$(document).on("click",".charitable-dashboard-v2-enhance-grid-button",this.handleEnhanceButtonClick)},initComponents:function(){this.showChartLoadingState();this.showLoadingStats();this.setInitialDropdownValue()},handleToggleClick:function(e){e.preventDefault();var $section=$(this).closest(".charitable-dashboard-v2-collapsible");var $content=$section.find(".charitable-dashboard-v2-section-content");if($section.hasClass("charitable-dashboard-v2-collapsed")){$section.removeClass("charitable-dashboard-v2-collapsed");$content.css("max-height","")}else{var currentHeight=$content[0].scrollHeight;$content.css("max-height",currentHeight+"px");$content[0].offsetHeight;$section.addClass("charitable-dashboard-v2-collapsed")}},handleTimePeriodChange:function(e){e.preventDefault();var timePeriod=$(this).val();CharitableDashboard.setCookie("charitable_dashboard_time_period",timePeriod,30);CharitableDashboard.updatePrintButtonDateRange(timePeriod);CharitableDashboard.showLoadingStates();CharitableDashboard.updateDashboardData(timePeriod)},showLoadingStates:function(){$(".charitable-dashboard-v2-stats-row").addClass("charitable-dashboard-v2-loading");$(".charitable-dashboard-v2-header-bar-chart").addClass("charitable-dashboard-v2-loading")},hideLoadingStates:function(){$(".charitable-dashboard-v2-stats-row").removeClass("charitable-dashboard-v2-loading");$(".charitable-dashboard-v2-stats-row").addClass("charitable-dashboard-stats-loaded");$(".charitable-dashboard-v2-header-bar-chart").removeClass("charitable-dashboard-v2-loading")},updateDashboardData:function(timePeriod){var self=this;var clearCache=window.location.search.indexOf("charitable_clear_stats_cache=1")!==-1;$.ajax({url:charitable_dashboard_reporting.ajax_url,type:"POST",data:{action:"charitable_dashboard_data",time_period:timePeriod,nonce:charitable_dashboard_reporting.dashboard_nonce,charitable_clear_stats_cache:clearCache?"1":"0"},success:function(response){if(response.success){self.updateStatsRow(response.data.stats);self.updateChart(response.data.chart)}else{console.error("Charitable Dashboard: Error updating data:",response.data);self.showError("Failed to update dashboard data: "+response.data)}},error:function(xhr,status,error){console.error("Charitable Dashboard: AJAX error:",error);self.showError("Network error: "+error)},complete:function(){self.hideLoadingStates();self.hideChartLoadingState()}})},updateStatsRow:function(stats){function decodeHtmlEntities(str){var textarea=document.createElement("textarea");textarea.innerHTML=str;return textarea.value}var donationsChangeHtml="";if(stats.donations_change&&stats.donations_change!==""){var changeValue=parseFloat(stats.donations_change.replace("%",""));var isZero=changeValue===0;var isPositive=stats.donations_change.indexOf("+")===0||stats.donations_change.indexOf("-")!==0&&changeValue>0;var isNegative=stats.donations_change.indexOf("-")===0&&changeValue<0;var svgId="mask0_1904_1526_"+Date.now()+"_1";var svgColor=isZero?"#000000":isPositive?"#31944D":"#DC2626";var svgPath=isPositive||isZero?"M1.82849 9.52507L1.07562 8.804L5.05505 4.96689L7.20609 7.02708L10.0024 4.37458H8.60426V3.34448H11.8308V6.43477H10.7553V5.09565L7.20609 8.49497L5.05505 6.43477L1.82849 9.52507Z":"M1.82849 3.47493L1.07562 4.196L5.05505 8.03311L7.20609 5.97292L10.0024 8.62542H8.60426V9.65552H11.8308V6.56523H10.7553V7.90435L7.20609 4.50503L5.05505 6.56523L1.82849 3.47493Z";var changeClass=isZero?"charitable-dashboard-v2-stat-change-zero":isPositive?"charitable-dashboard-v2-stat-change-positive":"charitable-dashboard-v2-stat-change-negative";donationsChangeHtml='<span class="charitable-dashboard-v2-stat-change '+changeClass+'">'+'<svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">'+'<mask id="'+svgId+'" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="13" height="13">'+'<rect y="0.25415" width="12.9062" height="12.3612" fill="#D9D9D9"></rect>'+"</mask>"+'<g mask="url(#'+svgId+')">'+'<path d="'+svgPath+'" fill="'+svgColor+'"></path>'+"</g>"+"</svg>"+stats.donations_change+"</span>"}$(".charitable-dashboard-v2-stat-item").eq(0).find(".charitable-dashboard-v2-stat-amount").html(decodeHtmlEntities(stats.total_donations)+donationsChangeHtml);var avgChangeHtml="";if(stats.avg_change&&stats.avg_change!==""){var changeValue=parseFloat(stats.avg_change.replace("%",""));var isZero=changeValue===0;var isPositive=stats.avg_change.indexOf("+")===0||stats.avg_change.indexOf("-")!==0&&changeValue>0;var isNegative=stats.avg_change.indexOf("-")===0&&changeValue<0;var svgId="mask0_1904_1526_"+Date.now()+"_2";var svgColor=isZero?"#000000":isPositive?"#31944D":"#DC2626";var svgPath=isPositive||isZero?"M1.82849 9.52507L1.07562 8.804L5.05505 4.96689L7.20609 7.02708L10.0024 4.37458H8.60426V3.34448H11.8308V6.43477H10.7553V5.09565L7.20609 8.49497L5.05505 6.43477L1.82849 9.52507Z":"M1.82849 3.47493L1.07562 4.196L5.05505 8.03311L7.20609 5.97292L10.0024 8.62542H8.60426V9.65552H11.8308V6.56523H10.7553V7.90435L7.20609 4.50503L5.05505 6.56523L1.82849 3.47493Z";var changeClass=isZero?"charitable-dashboard-v2-stat-change-zero":isPositive?"charitable-dashboard-v2-stat-change-positive":"charitable-dashboard-v2-stat-change-negative";avgChangeHtml='<span class="charitable-dashboard-v2-stat-change '+changeClass+'">'+'<svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">'+'<mask id="'+svgId+'" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="13" height="13">'+'<rect y="0.25415" width="12.9062" height="12.3612" fill="#D9D9D9"></rect>'+"</mask>"+'<g mask="url(#'+svgId+')">'+'<path d="'+svgPath+'" fill="'+svgColor+'"></path>'+"</g>"+"</svg>"+stats.avg_change+"</span>"}$(".charitable-dashboard-v2-stat-item").eq(1).find(".charitable-dashboard-v2-stat-amount").html(decodeHtmlEntities(stats.avg_donations)+avgChangeHtml);$(".charitable-dashboard-v2-stat-item").eq(2).find(".charitable-dashboard-v2-stat-amount").text(stats.total_donors);$(".charitable-dashboard-v2-stat-item").eq(3).find(".charitable-dashboard-v2-stat-amount").text(decodeHtmlEntities(stats.total_refunds))},updateChart:function(chartData){if(this.chartInstance){this.chartInstance.updateOptions({series:[{name:"Donations",data:chartData.donation_axis}],xaxis:{categories:chartData.date_axis}})}else{this.initHeadlineChartWithData(chartData)}},showError:function(message){console.error("Charitable Dashboard Error:",message)},showChartLoadingState:function(){$(".charitable-dashboard-v2-header-bar-chart").addClass("charitable-dashboard-v2-loading")},showLoadingStats:function(){$(".charitable-dashboard-v2-stat-item").eq(0).find(".charitable-dashboard-v2-stat-amount").html("-");$(".charitable-dashboard-v2-stat-item").eq(1).find(".charitable-dashboard-v2-stat-amount").html("-");$(".charitable-dashboard-v2-stat-item").eq(2).find(".charitable-dashboard-v2-stat-amount").text("-");$(".charitable-dashboard-v2-stat-item").eq(3).find(".charitable-dashboard-v2-stat-amount").text("-")},hideChartLoadingState:function(){$(".charitable-dashboard-v2-header-bar-chart").removeClass("charitable-dashboard-v2-loading")},setInitialDropdownValue:function(){var savedTimePeriod=this.getCookie("charitable_dashboard_time_period");if(savedTimePeriod&&$('#time-period-filter option[value="'+savedTimePeriod+'"]').length>0){$("#time-period-filter").val(savedTimePeriod);$(".charitable-dashboard-v2-stats-row").addClass("charitable-dashboard-v2-loading");var self=this;setTimeout((function(){self.updateDashboardData(savedTimePeriod)}),500)}else{var self=this;setTimeout((function(){self.updateDashboardData("last-7-days")}),500)}},setCookie:function(name,value,days){var expires="";if(days){var date=new Date;date.setTime(date.getTime()+days*24*60*60*1e3);expires="; expires="+date.toUTCString()}var userId=typeof charitable_dashboard_reporting!=="undefined"&&charitable_dashboard_reporting.user_id?charitable_dashboard_reporting.user_id:"0";document.cookie=name+"_user_"+userId+"="+value+expires+"; path=/"},getCookie:function(name){var userId=typeof charitable_dashboard_reporting!=="undefined"&&charitable_dashboard_reporting.user_id?charitable_dashboard_reporting.user_id:"0";var nameEQ=name+"_user_"+userId+"=";var ca=document.cookie.split(";");for(var i=0;i<ca.length;i++){var c=ca[i];while(c.charAt(0)===" "){c=c.substring(1,c.length)}if(c.indexOf(nameEQ)===0){return c.substring(nameEQ.length,c.length)}}return null},initHeadlineChartWithData:function(chartData){this.createChart(chartData)},initHeadlineChart:function(){if($("#charitable-dashboard-v2-headline-graph").length===0){console.warn("Charitable Dashboard: Chart container not found");return}if(typeof charitable_dashboard_reporting==="undefined"){console.warn("Charitable Dashboard: Chart data not available");return}var chartData={donation_axis:charitable_dashboard_reporting.headline_chart_options.donation_axis,date_axis:charitable_dashboard_reporting.headline_chart_options.date_axis};this.createChart(chartData)},createChart:function(chartData){if($("#charitable-dashboard-v2-headline-graph").length===0){console.warn("Charitable Dashboard: Chart container not found");return}if(typeof ApexCharts==="undefined"){console.warn("Charitable Dashboard: ApexCharts library not loaded");return}var enableToolTips=false;if(typeof charitable_dashboard_reporting!=="undefined"&&typeof charitable_dashboard_reporting.headline_chart_options!=="undefined"&&charitable_dashboard_reporting.headline_chart_options.enable_tooltips!==false){enableToolTips=true}var headlineChartOptions={chart:{type:"area",width:"100%",height:300,foreColor:"#757781",toolbar:{autoSelected:"pan",show:false},events:{}},series:[{name:"Donations",data:chartData.donation_axis}],colors:["#5AA15226"],grid:{borderColor:"#C9D4CA",clipMarkers:false,yaxis:{lines:{show:true}}},stroke:{width:3,colors:["#5AA152"]},fill:{type:"solid"},tooltip:{enabled:enableToolTips,theme:"dark"},dataLabels:{enabled:false},markers:{size:5,colors:["#FFFFFF"],strokeColor:"#5AA152",strokeWidth:4},xaxis:{categories:chartData.date_axis},yaxis:{labels:{formatter:function(value){var decimalCount=typeof charitable_dashboard_reporting.decimal_count!=="undefined"?charitable_dashboard_reporting.decimal_count:2;return charitable_dashboard_reporting.currency_symbol+value.toFixed(decimalCount)}},min:0}};try{var betaHeadlineChart=new ApexCharts(document.querySelector("#charitable-dashboard-v2-headline-graph"),headlineChartOptions);betaHeadlineChart.render();CharitableDashboard.chartInstance=betaHeadlineChart}catch(error){console.error("Charitable Dashboard: Error initializing chart:",error)}},initWidgets:function(){},handleEnhanceButtonClick:function(e){e.preventDefault();var $button=$(this);var action=$button.data("action");var slug=$button.data("slug");var basename=$button.data("basename");var type=$button.data("type");var setupUrl=$button.data("setup-url");var originalState={text:$button.text(),class:$button.attr("class")};switch(action){case"install":CharitableDashboard.handlePluginInstall($button,slug,type,originalState);break;case"activate":CharitableDashboard.handlePluginActivate($button,basename||slug,type,originalState);break;case"install_addon":CharitableDashboard.handleAddonInstall($button,slug,type,originalState);break;case"activate_addon":CharitableDashboard.handleAddonActivate($button,slug,type,originalState);break;case"upgrade":var upgradeUrl=$button.data("upgrade-url");if(upgradeUrl){window.open(upgradeUrl,"_blank")}break;case"setup":if(setupUrl){window.location.href=setupUrl}break}},handlePluginInstall:function($button,slug,type,originalState){$button.text("Installing...").prop("disabled",true);$.ajax({url:ajaxurl,type:"POST",data:{action:"charitable_install_plugin",nonce:charitable_admin.nonce,slug:slug},success:function(response){if(response.success){$button.text("Activate").addClass("charitable-dashboard-v2-activate-button").prop("disabled",false);$button.attr("data-action","activate").data("action","activate")}else{var errorMessage="Installation failed";if(response.data&&response.data.message){errorMessage=response.data.message}else if(response.message){errorMessage=response.message}CharitableDashboard.handleError($button,originalState,errorMessage)}},error:function(){CharitableDashboard.handleError($button,originalState,"Network error. Please try again.")}})},handlePluginActivate:function($button,basename,type,originalState){$button.text("Activating...").prop("disabled",true);$.ajax({url:ajaxurl,type:"POST",data:{action:"charitable_activate_plugin",nonce:charitable_admin.nonce,basename:basename},success:function(response){if(response.success){$button.text("Setup").removeClass("charitable-dashboard-v2-activate-button").addClass("charitable-dashboard-v2-setup-button").prop("disabled",false);$button.attr("data-action","setup").data("action","setup");if(response.data&&response.data.setup){$button.attr("data-setup-url",response.data.setup).data("setup-url",response.data.setup)}else if(response.data&&response.data.settings){$button.attr("data-setup-url",response.data.settings).data("setup-url",response.data.settings)}}else{var errorMessage="Activation failed";if(response.data&&response.data.message){errorMessage=response.data.message}else if(response.message){errorMessage=response.message}CharitableDashboard.handleError($button,originalState,errorMessage)}},error:function(){CharitableDashboard.handleError($button,originalState,"Network error. Please try again.")}})},handleAddonInstall:function($button,slug,type,originalState){$button.text("Installing...").prop("disabled",true);$.ajax({url:ajaxurl,type:"POST",data:{action:"charitable_install_charitable_addon",nonce:charitable_admin.nonce,slug:slug},success:function(response){if(response.success){if(response.data.redirect_url){window.location.href=response.data.redirect_url}else{$button.text("Activate").addClass("charitable-dashboard-v2-activate-button").prop("disabled",false);$button.attr("data-action","activate_addon").data("action","activate_addon")}}else{var errorMessage="Installation failed";if(response.data&&response.data.message){errorMessage=response.data.message}else if(response.message){errorMessage=response.message}CharitableDashboard.handleError($button,originalState,errorMessage)}},error:function(){CharitableDashboard.handleError($button,originalState,"Network error. Please try again.")}})},handleAddonActivate:function($button,slug,type,originalState){$button.text("Activating...").prop("disabled",true);$.ajax({url:ajaxurl,type:"POST",data:{action:"charitable_activate_charitable_addon",nonce:charitable_admin.nonce,slug:slug},success:function(response){if(response.success){if(response.data.redirect_url){window.location.href=response.data.redirect_url}else{var buttonText=response.data.button_text||"Installed";var buttonClass=response.data.button_class||"charitable-dashboard-v2-installed-button";var buttonAction=response.data.button_action||"installed";var isDisabled=response.data.button_disabled||false;$button.text(buttonText).removeClass("charitable-dashboard-v2-activate-button").addClass(buttonClass).prop("disabled",isDisabled).attr("data-action",buttonAction).data("action",buttonAction)}}else{var errorMessage="Activation failed";if(response.data&&response.data.message){errorMessage=response.data.message}else if(response.message){errorMessage=response.message}CharitableDashboard.handleError($button,originalState,errorMessage)}},error:function(){CharitableDashboard.handleError($button,originalState,"Network error. Please try again.")}})},handleError:function($button,originalState,errorMessage){var $errorElement=$('<div class="charitable-dashboard-v2-error-message" style="color: #d63638; font-size: 12px; margin-top: 5px;">'+errorMessage+"</div>");$button.after($errorElement);$button.text(originalState.text).attr("class",originalState.class).prop("disabled",false);setTimeout((function(){$errorElement.fadeOut((function(){$errorElement.remove()}))}),5e3)},hideInitialLoadingSpinner:function(){var self=this;$(document).ready((function(){setTimeout((function(){self.hideSpinners()}),100);self.waitForDashboardContent()}))},waitForDashboardContent:function(){var self=this;var attempts=0;var maxAttempts=50;var checkForContent=function(){attempts++;var hasContent=$("#charitable-dashboard-v2 .charitable-dashboard-v2-content").length>0||$("#charitable-dashboard-report-container").length>0||$(".charitable-dashboard-report").length>0;if(hasContent||attempts>=maxAttempts){self.hideSpinners()}else{setTimeout(checkForContent,100)}};checkForContent()},hideSpinners:function(){$("#charitable-dashboard-v2").addClass("charitable-dashboard-loaded");$("body.charitable_page_charitable-dashboard").addClass("charitable-dashboard-loaded")},hideSpinnersOnPageLoad:function(){var self=this;setTimeout((function(){self.hideSpinners()}),500)},updatePrintButtonDateRange:function(timePeriod){var dateRange=this.getDateRangeForPeriod(timePeriod);$('#charitable-dashboard-v2-print input[name="start_date"]').val(dateRange.start_date);$('#charitable-dashboard-v2-print input[name="end_date"]').val(dateRange.end_date);$('#charitable-dashboard-v2-print input[name="days"]').val(timePeriod)},getDateRangeForPeriod:function(timePeriod){var today=new Date;var startDate,endDate;switch(timePeriod){case"last-7-days":startDate=new Date(today.getTime()-7*24*60*60*1e3);break;case"last-14-days":startDate=new Date(today.getTime()-14*24*60*60*1e3);break;case"last-30-days":startDate=new Date(today.getTime()-30*24*60*60*1e3);break;case"last-3-months":startDate=new Date(today.getTime()-90*24*60*60*1e3);break;case"last-6-months":startDate=new Date(today.getTime()-180*24*60*60*1e3);break;case"last-year":startDate=new Date(today.getTime()-365*24*60*60*1e3);break;default:startDate=new Date(today.getTime()-7*24*60*60*1e3)}endDate=today;return{start_date:this.formatDateForPrint(startDate),end_date:this.formatDateForPrint(endDate)}},formatDateForPrint:function(date){var year=date.getFullYear();var month=String(date.getMonth()+1).padStart(2,"0");var day=String(date.getDate()).padStart(2,"0");return year+"-"+month+"-"+day}};$(document).ready((function(){CharitableDashboard.init();initProgressCircles();initTabSwitching()}));function initProgressCircles(){const progressCircles=document.querySelectorAll(".progress-circle");progressCircles.forEach((circle=>{const progress=parseInt(circle.getAttribute("data-progress"))||0;const svg=circle.querySelector("svg");const progressCircle=svg.querySelector("circle:last-child");if(progressCircle){const radius=18;const circumference=2*Math.PI*radius;progressCircle.style.strokeDasharray=circumference;const offset=circumference-progress/100*circumference;progressCircle.style.strokeDashoffset=offset;progressCircle.style.transform="rotate(-90deg)";progressCircle.style.transformOrigin="20px 20px"}}))}function initTabSwitching(){const tabNavItems=document.querySelectorAll(".charitable-dashboard-v2-tab-nav-item");const tabContents=document.querySelectorAll(".charitable-dashboard-v2-tab-content");tabNavItems.forEach((tab=>{tab.addEventListener("click",(function(e){e.preventDefault();const targetTab=this.getAttribute("data-tab");tabNavItems.forEach((item=>item.classList.remove("charitable-dashboard-v2-tab-nav-active")));tabContents.forEach((content=>content.classList.remove("charitable-dashboard-v2-tab-content-active")));this.classList.add("charitable-dashboard-v2-tab-nav-active");const targetContent=document.querySelector(`.charitable-dashboard-v2-tab-content[data-tab="${targetTab}"]`);if(targetContent){targetContent.classList.add("charitable-dashboard-v2-tab-content-active")}if(targetTab==="top-campaigns"){setTimeout((()=>{initProgressCircles()}),100)}}))}))}})(jQuery);