<?php $single_layout = esc_attr(get_option('blogsqode_singlepage_layout'));	?>

<article id="single-layout-<?php echo $single_layout; ?>" <?php post_class(); ?>>

	<div class="blogsqode-entry-header alignwide">

		<?php the_title( '<h2 class="entry-title blogsqode-single-post-title">', '</h2>' ); 

		if($single_layout === '2' || $single_layout === '3' ){ 

			echo user_detail_meta_func();	

		}

		if($single_layout === '5'){
			?>
			<div class="single_blog_wrapper">
				<div class="single_blog_detail single_blog_category">
					<?php
					$post_type = get_post_type();
					$taxonomies = get_object_taxonomies($post_type);
					if (!empty($taxonomies)) {
						$taxonomy = $taxonomies[0];
						$post_categories = get_the_terms(get_the_ID(), $taxonomy);
						if ($post_categories && !is_wp_error($post_categories)) {
							if (esc_attr(get_option('blogsqode_single_category_allow')) === 'Unable') {
								$category = current($post_categories);
								$cat_link = get_term_link($category);
								echo '<a href="' . esc_url($cat_link) . '" class="blogsqode_post_cat">' . esc_html__($category->name, "blogsqode") . '</a>';
							}
						}
					}					
					?>
				</div>
				<div class="single_blog_detail single_blog_date">
					<?php if(esc_attr(get_option('blogsqode_single_blog_date_allow')) === 'Unable'){ 
						echo '<p class="blogsqode-post-date ">'.get_the_date().'</p>';
					} ?>
				</div>
				<div class="single_blog_detail single_blog_comment">
					<?php
					if(esc_attr(get_option('blogsqode_single_comment_count_allow')) === 'Unable'){
						echo '<p class="blogsqode-comments-number">'.get_comments_number().' Comment</p>';
					} ?>
				</div>
			</div>
			<?php
		}
		?>

		<div class="blog-single-thumbnail-wrap" style="background-image: url('<?php echo get_the_post_thumbnail_url(); ?>');">
			<?php if($single_layout === '4'){ ?>
				<div class="blogsqode_l4_taxonomies">
					<?php
					$post_type = get_post_type();
					$taxonomies = get_object_taxonomies($post_type);
					if (!empty($taxonomies)) {
						$taxonomy = $taxonomies[0];
						$post_categories = get_the_terms(get_the_ID(), $taxonomy);
						if ($post_categories && !is_wp_error($post_categories)) {
							if (esc_attr(get_option('blogsqode_single_category_allow')) === 'Unable') {
								$category = current($post_categories);
								$cat_link = get_term_link($category);
								echo '<a href="' . esc_url($cat_link) . '" class="blogsqode_post_cat">' . esc_html__($category->name, "blogsqode") . '</a>';
							}
						}
					}
					?>
					<?php if(esc_attr(get_option('blogsqode_single_blog_date_allow')) === 'Unable'){ 
						echo '<p class="blogsqode-post-date ">'.get_the_date().'</p>';
					} ?>
				</div>
			<?php } ?>
		</div>
		
		<?php if($single_layout === '1'){ 
			echo user_detail_meta_func();			
		} ?>

		<?php if($single_layout === '5'){ ?>
			<div class="blog_author_name">
				<?php
				if(esc_attr(get_option('blogsqode_single_author_name_allow')) === 'Unable'){
					echo '<h3 class="blogsqode-author-name">'.esc_html__('By ','blogsqode' ).get_the_author_meta('display_name').'</h3>';
				}
				?>
			</div>
		<?php } ?>
	</div><!-- .blogsqode-entry-header -->

	<?php if($single_layout === '4'){ ?>
		<div class="blogsqode-author-wrapper">
			<div class="author_detail_wrap">
				<div class="user_image">
					<?php if(esc_attr(get_option('blogsqode_single_auhtor_thumb_allow')) === 'Unable'){
						if(($avatar = get_avatar(get_the_author_meta(get_the_ID()))) !== FALSE): 
							echo $avatar; 
						else: ?>
							<img src="<?php echo esc_url('/images/no-image-default.jpg'); ?>">
						<?php endif; 
					}
					?> 
				</div>
				<div class="blogsqode-author-wrap">
					<?php
					if(esc_attr(get_option('blogsqode_single_author_name_allow')) === 'Unable'){
						echo '<h3 class="blogsqode-author-name">'.get_the_author_meta('display_name').'</h3>';
					}
					?>
				</div>
			</div>
			<div class="blogsqode-comments">
				<?php
				if(esc_attr(get_option('blogsqode_single_comment_count_allow')) === 'Unable'){
					echo '<p class="blogsqode-comments-number">'.get_comments_number().' Comment</p>';
				} ?>
			</div>
		</div>
	<?php }	?>

	<div class="blogsqode-entry-content">
		<?php
		the_content();
		wp_link_pages(
			array(
				'before'   => '<nav class="page-links" aria-label="' . esc_attr__( 'Page', 'blogsqode' ) . '">',
				'after'    => '</nav>',
				/* translators: %: Page number. */
				'pagelink' => esc_html__( 'Page %', 'blogsqode' ),
			)
		);
		?>
	</div><!-- .blogsqode-entry-content -->

	<div class="blogsqode-tag-social">
		<?php 	if(esc_attr(get_option('blogsqode_single_tags_allow')) === 'Unable' && $single_layout === '1'){
			echo blogsqode_single_tags(); 
		} 

		if(esc_attr(get_option('blogsqode_single_sharebutton_allow')) === 'Unable' && $single_layout === '1' || $single_layout === '2'){	
			$permalink = get_the_permalink();
			echo '<div class="blogsqode-single-social-share"><h3>'.esc_html__("Share:", "blogsqode").'</h3>';
			
			$fb_icon = get_option('facebook_social_icon');
			if ($fb_icon) {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=' . esc_url($permalink) . '"><img src="' . esc_url($fb_icon) . '" alt="fb-share-icon" /></a>';
			} else {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=' . esc_url($permalink) . '"><svg class="svg-fill-color" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_20_1230)"><path d="M11.6663 11.2498H13.7497L14.583 7.9165H11.6663V6.24984C11.6663 5.3915 11.6663 4.58317 13.333 4.58317H14.583V1.78317C14.3113 1.74734 13.2855 1.6665 12.2022 1.6665C9.93967 1.6665 8.33301 3.04734 8.33301 5.58317V7.9165H5.83301V11.2498H8.33301V18.3332H11.6663V11.2498Z" fill="#6F39FD"/></g><defs><clipPath id="clip0_20_1230"><rect width="20" height="20" fill="white"/></clipPath></defs></svg></a>';
			}
			
			$tw_icon = get_option('twitter_social_icon');
			if ($tw_icon) {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://twitter.com/intent/tweet?text='.get_the_title()." ".esc_url($permalink).'"><img src="' . esc_url($tw_icon) . '" alt="twitter-share-icon" /></a>';
			} else {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://twitter.com/intent/tweet?text='.get_the_title()." ".esc_url($permalink).'"><svg class="svg-fill-color" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_20_1237)"><path d="M18.4683 4.71327C17.8321 4.99468 17.1574 5.1795 16.4666 5.26161C17.1947 4.82613 17.7397 4.14078 17.9999 3.33327C17.3166 3.73994 16.5674 4.02494 15.7866 4.17911C15.2621 3.61792 14.5669 3.24574 13.809 3.12043C13.0512 2.99511 12.2732 3.12368 11.596 3.48615C10.9187 3.84862 10.3802 4.42468 10.0642 5.12477C9.74812 5.82486 9.67221 6.60976 9.84825 7.35744C8.46251 7.28798 7.10686 6.92787 5.86933 6.30049C4.63179 5.67311 3.54003 4.79248 2.66492 3.71577C2.35516 4.24781 2.19238 4.85263 2.19326 5.46827C2.19326 6.67661 2.80826 7.74411 3.74326 8.36911C3.18993 8.35169 2.64878 8.20226 2.16492 7.93327V7.9766C2.16509 8.78136 2.44356 9.56128 2.95313 10.1842C3.46269 10.807 4.17199 11.2345 4.96075 11.3941C4.4471 11.5333 3.90851 11.5538 3.38576 11.4541C3.60814 12.1468 4.04159 12.7526 4.62541 13.1867C5.20924 13.6208 5.9142 13.8614 6.64159 13.8749C5.91866 14.4427 5.0909 14.8624 4.20566 15.1101C3.32041 15.3577 2.39503 15.4285 1.48242 15.3183C3.0755 16.3428 4.93 16.8867 6.82409 16.8849C13.2349 16.8849 16.7408 11.5741 16.7408 6.96827C16.7408 6.81827 16.7366 6.66661 16.7299 6.51827C17.4123 6.02508 18.0013 5.41412 18.4691 4.71411L18.4683 4.71327Z" fill="#6F39FD"/></g><defs><clipPath id="clip0_20_1237"><rect width="20" height="20" fill="white"/></clipPath></defs></svg></a>';
			}

			$insta_icon = get_option('instagram_social_icon');
			if ($insta_icon) {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.instagram.com/sharer/sharer.php?u=' . esc_url($permalink) . '"><img src="' . esc_url($insta_icon) . '" alt="insta-share-icon" /></a>';
			} else {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.instagram.com/sharer/sharer.php?u=' . esc_url($permalink) . '"><svg class="svg-fill-color" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.00033 0.666504C11.2645 0.666504 11.547 0.674837 12.4353 0.716504C13.3228 0.758171 13.927 0.897337 14.4587 1.104C15.0087 1.31567 15.472 1.60234 15.9353 2.06484C16.3591 2.48142 16.687 2.98533 16.8962 3.5415C17.102 4.07234 17.242 4.67734 17.2837 5.56484C17.3228 6.45317 17.3337 6.73567 17.3337 8.99984C17.3337 11.264 17.3253 11.5465 17.2837 12.4348C17.242 13.3223 17.102 13.9265 16.8962 14.4582C16.6876 15.0147 16.3596 15.5187 15.9353 15.9348C15.5186 16.3584 15.0148 16.6863 14.4587 16.8957C13.9278 17.1015 13.3228 17.2415 12.4353 17.2832C11.547 17.3223 11.2645 17.3332 9.00033 17.3332C6.73616 17.3332 6.45366 17.3248 5.56533 17.2832C4.67783 17.2415 4.07366 17.1015 3.54199 16.8957C2.9856 16.6869 2.4816 16.359 2.06533 15.9348C1.6415 15.5183 1.3136 15.0144 1.10449 14.4582C0.897826 13.9273 0.758659 13.3223 0.716992 12.4348C0.677825 11.5465 0.666992 11.264 0.666992 8.99984C0.666992 6.73567 0.675325 6.45317 0.716992 5.56484C0.758659 4.6765 0.897826 4.07317 1.10449 3.5415C1.31302 2.98499 1.641 2.48094 2.06533 2.06484C2.48172 1.64086 2.98568 1.31295 3.54199 1.104C4.07366 0.897337 4.67699 0.758171 5.56533 0.716504C6.45366 0.677337 6.73616 0.666504 9.00033 0.666504ZM9.00033 4.83317C7.89526 4.83317 6.83545 5.27216 6.05405 6.05356C5.27265 6.83496 4.83366 7.89477 4.83366 8.99984C4.83366 10.1049 5.27265 11.1647 6.05405 11.9461C6.83545 12.7275 7.89526 13.1665 9.00033 13.1665C10.1054 13.1665 11.1652 12.7275 11.9466 11.9461C12.728 11.1647 13.167 10.1049 13.167 8.99984C13.167 7.89477 12.728 6.83496 11.9466 6.05356C11.1652 5.27216 10.1054 4.83317 9.00033 4.83317ZM14.417 4.62484C14.417 4.34857 14.3072 4.08362 14.1119 3.88827C13.9165 3.69292 13.6516 3.58317 13.3753 3.58317C13.0991 3.58317 12.8341 3.69292 12.6388 3.88827C12.4434 4.08362 12.3337 4.34857 12.3337 4.62484C12.3337 4.9011 12.4434 5.16606 12.6388 5.36141C12.8341 5.55676 13.0991 5.6665 13.3753 5.6665C13.6516 5.6665 13.9165 5.55676 14.1119 5.36141C14.3072 5.16606 14.417 4.9011 14.417 4.62484ZM9.00033 6.49984C9.66337 6.49984 10.2993 6.76323 10.7681 7.23207C11.2369 7.70091 11.5003 8.3368 11.5003 8.99984C11.5003 9.66288 11.2369 10.2988 10.7681 10.7676C10.2993 11.2364 9.66337 11.4998 9.00033 11.4998C8.33728 11.4998 7.7014 11.2364 7.23256 10.7676C6.76372 10.2988 6.50033 9.66288 6.50033 8.99984C6.50033 8.3368 6.76372 7.70091 7.23256 7.23207C7.7014 6.76323 8.33728 6.49984 9.00033 6.49984Z" fill="#6F39FD"/></svg></a>';
			}

			$ln_icon = get_option('linkedin_social_icon');
			if ($ln_icon) {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.linkedin.com/uas/login?session_redirect='.get_the_title()." ".esc_url($permalink).'"><img src="' . esc_url($ln_icon) . '" alt="linkedin-share-icon" /></a>';
			} else {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.linkedin.com/uas/login?session_redirect='.get_the_title()." ".esc_url($permalink).'"><svg class="svg-fill-color" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_20_1244)"><path d="M5.78353 4.16652C5.78331 4.60855 5.6075 5.03239 5.29478 5.34479C4.98207 5.6572 4.55806 5.83258 4.11603 5.83236C3.674 5.83214 3.25017 5.65633 2.93776 5.34361C2.62536 5.0309 2.44997 4.60688 2.4502 4.16486C2.45042 3.72283 2.62622 3.29899 2.93894 2.98659C3.25166 2.67419 3.67567 2.4988 4.1177 2.49902C4.55972 2.49924 4.98356 2.67505 5.29596 2.98777C5.60837 3.30049 5.78375 3.7245 5.78353 4.16652ZM5.83353 7.06652H2.5002V17.4999H5.83353V7.06652ZM11.1002 7.06652H7.78353V17.4999H11.0669V12.0249C11.0669 8.97486 15.0419 8.69152 15.0419 12.0249V17.4999H18.3335V10.8915C18.3335 5.74986 12.4502 5.94152 11.0669 8.46652L11.1002 7.06652Z" fill="#6F39FD"/></g><defs><clipPath id="clip0_20_1244"><rect width="20" height="20" fill="white"/></clipPath></defs></svg></a>';
			}
		
			$pn_icon = get_option('pinterest_social_icon');
			if ($pn_icon) {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://pinterest.com/pin/create/button/?url=' . esc_url($permalink) . '"><img src="' . esc_url($pn_icon) . '" alt="pinterest-share-icon" /></a>';
			} else {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://pinterest.com/pin/create/button/?url=' . esc_url($permalink) . '"><svg class="svg-fill-color" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.401 1.6665C6.97491 1.6665 3.58887 3.95058 3.58887 7.64718C3.58887 9.99804 4.91123 11.3338 5.71266 11.3338C6.04325 11.3338 6.23359 10.4121 6.23359 10.1516C6.23359 9.84109 5.44217 9.17991 5.44217 7.88761C5.44217 5.20282 7.48582 3.29942 10.1305 3.29942C12.4046 3.29942 14.0876 4.59172 14.0876 6.96596C14.0876 8.73913 13.3763 12.0651 11.0722 12.0651C10.2407 12.0651 9.52947 11.464 9.52947 10.6025C9.52947 9.3402 10.411 8.11802 10.411 6.81569C10.411 4.60508 7.27545 5.0058 7.27545 7.67723C7.27545 8.23823 7.34557 8.85934 7.59602 9.37025C7.1352 11.3538 6.19352 14.3091 6.19352 16.3527C6.19352 16.9838 6.28368 17.6049 6.34378 18.2361C6.45732 18.363 6.40055 18.3496 6.57419 18.2862C8.2572 15.9821 8.19709 15.5312 8.95845 12.5159C9.36918 13.2973 10.4311 13.718 11.2726 13.718C14.8189 13.718 16.4118 10.2618 16.4118 7.14628C16.4118 3.83037 13.5466 1.6665 10.401 1.6665Z" fill="#6F39FD"/></svg></a>';
			}

			$wp_icon = get_option('whatsapp_social_icon');
			if ($wp_icon) {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://web.whatsapp.com/send?text=' . esc_url($permalink) . '" data-action="share/whatsapp/share"><img src="' . esc_url($wp_icon) . '" alt="whatsapp-share-icon" /></a>';
			} else {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://web.whatsapp.com/send?text=' . esc_url($permalink) . '" data-action="share/whatsapp/share"><svg class="svg-fill-color" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_20_1256)"><path d="M1.67034 18.3332L2.797 14.1932C2.05462 12.9205 1.66458 11.4732 1.667 9.99984C1.667 5.39734 5.39784 1.6665 10.0003 1.6665C14.6028 1.6665 18.3337 5.39734 18.3337 9.99984C18.3337 14.6023 14.6028 18.3332 10.0003 18.3332C8.52765 18.3355 7.08088 17.9458 5.80867 17.204L1.67034 18.3332ZM6.99284 6.08984C6.88522 6.09652 6.78007 6.12486 6.68367 6.17317C6.59327 6.22436 6.51075 6.28836 6.43867 6.36317C6.33867 6.45734 6.282 6.539 6.22117 6.61817C5.91318 7.019 5.74751 7.51102 5.75034 8.0165C5.752 8.42484 5.85867 8.82234 6.02534 9.194C6.36617 9.94567 6.927 10.7415 7.66784 11.479C7.84617 11.6565 8.02034 11.8348 8.20784 12.0007C9.12733 12.8102 10.223 13.394 11.4078 13.7057L11.882 13.7782C12.0362 13.7865 12.1903 13.7748 12.3453 13.7673C12.588 13.7548 12.825 13.6891 13.0395 13.5748C13.1778 13.5015 13.2428 13.4648 13.3587 13.3915C13.3587 13.3915 13.3945 13.3682 13.4628 13.3165C13.5753 13.2332 13.6445 13.174 13.7378 13.0765C13.807 13.0048 13.867 12.9207 13.9128 12.8248C13.9778 12.689 14.0428 12.4298 14.0695 12.214C14.0895 12.049 14.0837 11.959 14.0812 11.9032C14.0778 11.814 14.0037 11.7215 13.9228 11.6823L13.4378 11.4648C13.4378 11.4648 12.7128 11.149 12.2703 10.9473C12.2237 10.927 12.1737 10.9154 12.1228 10.9132C12.0658 10.9073 12.0082 10.9137 11.9539 10.932C11.8995 10.9502 11.8498 10.9799 11.8078 11.019V11.0173C11.8037 11.0173 11.7478 11.0648 11.1453 11.7948C11.1108 11.8413 11.0631 11.8764 11.0085 11.8957C10.9539 11.915 10.8948 11.9176 10.8387 11.9032C10.7844 11.8887 10.7312 11.8703 10.6795 11.8482C10.5762 11.8048 10.5403 11.7882 10.4695 11.7573L10.4653 11.7557C9.9886 11.5475 9.54719 11.2664 9.157 10.9223C9.052 10.8307 8.9545 10.7307 8.8545 10.634C8.52665 10.32 8.24093 9.96485 8.0045 9.57734L7.95534 9.49817C7.92002 9.44497 7.89147 9.38759 7.87034 9.32734C7.83867 9.20484 7.92117 9.1065 7.92117 9.1065C7.92117 9.1065 8.12367 8.88484 8.21784 8.76484C8.29625 8.6651 8.3694 8.56135 8.437 8.454C8.53534 8.29567 8.56617 8.13317 8.5145 8.00734C8.28117 7.43734 8.0395 6.86984 7.79117 6.3065C7.742 6.19484 7.59617 6.11484 7.46367 6.099C7.41867 6.094 7.37367 6.089 7.32867 6.08567C7.21676 6.08011 7.10462 6.08122 6.99284 6.089V6.08984Z" fill="#6F39FD"/></g><defs><clipPath id="clip0_20_1256"><rect width="20" height="20" fill="white"/></clipPath></defs></svg></a>';
			}

			$sp_icon = get_option('snapchat_social_icon');
			if ($sp_icon) {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.snapchat.com/scan?attachmentUrl=' . esc_url($permalink) . '"><img src="' . esc_url($sp_icon) . '" alt="snapchat-share-icon" /></a>';
			} else {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.snapchat.com/scan?attachmentUrl=' . esc_url($permalink) . '"><svg class="svg-fill-color" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_20_1263)"><path d="M9.89262 18.1367C8.90096 18.1367 8.23929 17.6692 7.64846 17.2567C7.22929 16.9592 6.83512 16.6767 6.37096 16.5983C6.14996 16.5603 5.92603 16.5419 5.70179 16.5433C5.30846 16.5433 4.99596 16.6025 4.77346 16.6475C4.63179 16.6725 4.51346 16.6958 4.42012 16.6958C4.32346 16.6958 4.20096 16.6692 4.15346 16.5058C4.11179 16.3725 4.08596 16.2458 4.06012 16.1233C3.99346 15.815 3.93762 15.6258 3.82179 15.6067C2.58096 15.4175 1.83846 15.1317 1.69346 14.7933C1.68179 14.7567 1.66762 14.7183 1.66762 14.6892C1.65929 14.585 1.73429 14.5 1.83846 14.4808C2.82262 14.3175 3.70679 13.7942 4.45346 12.9325C5.03346 12.2633 5.31596 11.6167 5.34179 11.5467C5.34179 11.5383 5.34929 11.5383 5.34929 11.5383C5.49096 11.2458 5.52012 10.9967 5.43429 10.7925C5.27512 10.4092 4.74679 10.2458 4.38679 10.1342C4.29429 10.1092 4.21596 10.0792 4.14929 10.0567C3.84096 9.93417 3.32762 9.67333 3.39512 9.31333C3.44346 9.05333 3.78846 8.8675 4.07096 8.8675C4.14929 8.8675 4.21596 8.87917 4.27096 8.90917C4.58762 9.05333 4.87346 9.1275 5.11846 9.1275C5.42346 9.1275 5.56846 9.0125 5.60512 8.97583C5.59736 8.811 5.58764 8.64627 5.57596 8.48167C5.50096 7.34417 5.41596 5.9325 5.77596 5.12333C6.85762 2.70083 9.15346 2.50667 9.83346 2.50667L10.1301 2.5H10.1718C10.851 2.5 13.1468 2.68917 14.2285 5.11583C14.5926 5.925 14.5035 7.34083 14.4285 8.47417L14.4218 8.53C14.4135 8.68167 14.4026 8.82667 14.3951 8.97583C14.4326 9.005 14.566 9.11667 14.841 9.12C15.0793 9.11333 15.3393 9.035 15.636 8.90083C15.7181 8.86532 15.8065 8.84662 15.896 8.84583C16.0001 8.84583 16.1043 8.87083 16.1935 8.90083H16.201C16.4501 8.99417 16.6135 9.16833 16.6135 9.35083C16.621 9.52167 16.4868 9.78167 15.8518 10.0383C15.7851 10.0633 15.7068 10.0942 15.6143 10.1158C15.261 10.2242 14.7335 10.395 14.566 10.7742C14.4735 10.9742 14.511 11.2308 14.6518 11.52C14.6518 11.5283 14.6593 11.5283 14.6593 11.5283C14.7001 11.6317 15.7735 14.0692 18.1626 14.4667C18.2115 14.4749 18.2557 14.5005 18.2871 14.5388C18.3185 14.5771 18.335 14.6255 18.3335 14.675C18.3335 14.7117 18.326 14.7492 18.3076 14.7825C18.1626 15.1242 17.4268 15.4025 16.1785 15.5958C16.0635 15.6142 16.0076 15.8042 15.941 16.1125C15.9143 16.241 15.8831 16.3686 15.8476 16.495C15.811 16.6175 15.7326 16.6842 15.5993 16.6842H15.5801C15.4951 16.6842 15.3801 16.6733 15.2276 16.6433C14.9222 16.5783 14.6107 16.5459 14.2985 16.5467C14.0793 16.5467 13.8526 16.5658 13.6301 16.6025C13.1693 16.6775 12.7718 16.9633 12.3518 17.2608C11.7543 17.6692 11.0893 18.1367 10.1043 18.1367H9.89262Z" fill="#6F39FD"/></g><defs><clipPath id="clip0_20_1263"><rect width="20" height="20" fill="white"/></clipPath></defs></svg></a>';
			}

			$wc_icon = get_option('wechat_social_icon');
			if ($wc_icon) {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://api.qrserver.com/v1/create-qr-code/?size=154x154&data='.esc_url($permalink).'"><img src="' . esc_url($wc_icon) . '" alt="wechat-icon" /></a>';
			} else {
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://api.qrserver.com/v1/create-qr-code/?size=154x154&data='.esc_url($permalink).'"><svg class="svg-fill-color" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_20_1270)"><path d="M15.478 11.4258C15.6757 11.4232 15.8645 11.3436 16.0043 11.2038C16.1441 11.064 16.2238 10.8752 16.2263 10.6775C16.2263 10.2625 15.8938 9.92917 15.478 9.92917C15.0622 9.92917 14.7297 10.2625 14.7297 10.6775C14.7297 11.0942 15.063 11.4258 15.478 11.4258ZM11.7905 11.4258C11.9882 11.4232 12.177 11.3436 12.3168 11.2038C12.4566 11.064 12.5363 10.8752 12.5388 10.6775C12.5388 10.2625 12.2055 9.92917 11.7905 9.92917C11.3738 9.92917 11.0422 10.2625 11.0422 10.6775C11.0422 11.0942 11.3747 11.4258 11.7905 11.4258ZM17.263 15.6258C17.2096 15.6555 17.167 15.7013 17.1412 15.7567C17.1155 15.8121 17.1079 15.8742 17.1197 15.9342C17.1197 15.9742 17.1197 16.015 17.1405 16.0567C17.2222 16.4042 17.3855 16.9575 17.3855 16.9783C17.3855 17.0392 17.4063 17.08 17.4063 17.1217C17.4063 17.1458 17.4016 17.1697 17.3923 17.192C17.383 17.2143 17.3695 17.2346 17.3523 17.2516C17.3352 17.2686 17.3149 17.2821 17.2926 17.2913C17.2702 17.3004 17.2463 17.3051 17.2222 17.305C17.1805 17.305 17.1605 17.285 17.1197 17.265L15.9122 16.5683C15.824 16.5198 15.726 16.4919 15.6255 16.4867C15.5647 16.4867 15.503 16.4867 15.4622 16.5067C14.8888 16.6708 14.2955 16.7525 13.6613 16.7525C10.6113 16.7525 8.15551 14.705 8.15551 12.165C8.15551 9.62583 10.6113 7.5775 13.6613 7.5775C16.7105 7.5775 19.1663 9.62583 19.1663 12.165C19.1663 13.5375 18.4297 14.7867 17.263 15.6267V15.6258ZM13.8938 6.74917C13.8161 6.74658 13.7383 6.74519 13.6605 6.745C10.1822 6.745 7.32217 9.12833 7.32217 12.1658C7.32217 12.6275 7.38884 13.0742 7.51217 13.4992H7.43801C6.70989 13.4918 5.9859 13.3887 5.28467 13.1925C5.22301 13.1717 5.16134 13.1717 5.09967 13.1717C4.97652 13.1743 4.85629 13.2097 4.75134 13.2742L3.29467 14.1117C3.25301 14.1325 3.21217 14.1533 3.17134 14.1533C3.11187 14.1527 3.05502 14.1288 3.01296 14.0867C2.9709 14.0447 2.94699 13.9878 2.94634 13.9283C2.94634 13.8667 2.96634 13.8258 2.98717 13.7642C3.00717 13.7442 3.19217 13.0692 3.29467 12.6608C3.29467 12.6192 3.31467 12.5583 3.31467 12.5175C3.31445 12.4461 3.29771 12.3756 3.26576 12.3117C3.23381 12.2479 3.18752 12.1922 3.13051 12.1492C1.71467 11.1467 0.833008 9.655 0.833008 7.99833C0.833008 4.95417 3.80801 2.5 7.45801 2.5C10.5955 2.5 13.233 4.3075 13.8938 6.74833V6.74917ZM9.59884 7.0975C10.0763 7.0975 10.4538 6.7 10.4538 6.2425C10.4538 5.765 10.0763 5.3875 9.59884 5.3875C9.12134 5.3875 8.74384 5.765 8.74384 6.2425C8.74384 6.72 9.12134 7.0975 9.59884 7.0975ZM5.21551 7.0975C5.69301 7.0975 6.07134 6.7 6.07134 6.2425C6.07134 5.765 5.69301 5.3875 5.21551 5.3875C4.73884 5.3875 4.36051 5.765 4.36051 6.2425C4.36051 6.72 4.73884 7.0975 5.21551 7.0975Z" fill="#6F39FD"/></g><defs><clipPath id="clip0_20_1270"><rect width="20" height="20" fill="white"/></clipPath></defs></svg></a>';
			}

			echo '</div>';
		} ?>
	</div>



	<?php if($single_layout === '2'){
		?>

		<div class="blogsqode_tag_cat_wrap">
			<div class="post_cats">
				<?php
				$post_type = get_post_type();
				$taxonomies = get_object_taxonomies($post_type);
				if (!empty($taxonomies)) {
					$taxonomy = $taxonomies[0];
					$post_categories = get_the_terms(get_the_ID(), $taxonomy);
					if ($post_categories && !is_wp_error($post_categories)) {
						if (esc_attr(get_option('blogsqode_single_category_allow')) === 'Unable') {
							echo '<h3>'.esc_html__('Categories:', 'blogsqode').'</h3>';
							foreach ($post_categories as $category) {
								$cat_link = get_term_link($category);
								echo '<a href="' . esc_url($cat_link) . '" class="blogsqode_post_cat">' . esc_html__($category->name, "blogsqode") . '</a>';
							}
						}
					}
				}				
				?>
			</div>
			<div class="post_tags">
				<?php echo blogsqode_single_tags(); ?>
			</div>

		</div>

	<?php } 

	if($single_layout === '3'){ ?>
		<div class="blogsqode_tag_cat_wrap">
			<div class="post_cats">
				<?php
				$post_type = get_post_type();
				$taxonomies = get_object_taxonomies($post_type);
				if (!empty($taxonomies)) {
					$taxonomy = $taxonomies[0];
					$post_categories = get_the_terms(get_the_ID(), $taxonomy);
					if ($post_categories && !is_wp_error($post_categories)) {
						if (esc_attr(get_option('blogsqode_single_category_allow')) === 'Unable') {
							echo '<h3>'.esc_html__('Categories:', 'blogsqode').'</h3>';
							foreach ($post_categories as $category) {
								$cat_link = get_term_link($category);
								echo '<a href="' . esc_url($cat_link) . '" class="blogsqode_post_cat">' . esc_html__($category->name, "blogsqode") . '</a>';
							}
						}
					}
				}	
				?>
			</div>
			<div class="single_blog_share_box_lyt_3">
				<?php
				$templates = new Blogsqode_Public_Templates(); 
				$social_html = $templates->get_social_sharing_html();
			  
				echo $social_html;
				echo '<h3>'.esc_html__('Share', 'blogsqode').'</h3>';
				?>
			</div>
		</div>
		<?php
	} ?>

	<?php if($single_layout === '4'){ ?>

		<div class="single_blog_tag_box_lyt_4">
			<?php 	if(esc_attr(get_option('blogsqode_single_tags_allow')) === 'Unable'){
				echo blogsqode_single_tags(); 
			} ?>
		</div>
		<div class="single_blog_share_box_lyt_4">
			<?php if(esc_attr(get_option('blogsqode_single_sharebutton_allow')) === 'Unable'){	
				$permalink = get_the_permalink();
				echo '<div class="blogsqode-single-social-share"><h3>'.esc_html__("Share:", "blogsqode").'</h3>';
				$fb_icon = get_option('facebook_social_icon')?:BLOGSQODE_IMG_PATH.'/facebook.svg';

				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u='.esc_url($permalink).'">'.esc_html__('Facebook', 'blogsqode').'</a>';

				$tw_icon = get_option('twitter_social_icon')?:BLOGSQODE_IMG_PATH.'/twitter.svg';
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://twitter.com/intent/tweet?text='.get_the_title()." ".esc_url($permalink).'">'.esc_html__('Twitter', 'blogsqode').'</a>';

				$insta_icon = get_option('instagram_social_icon')?:BLOGSQODE_IMG_PATH.'/instagram.svg';
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://instagram.com/intent/tweet?text='.get_the_title()." ".esc_url($permalink).'">'.esc_html__('Instagram', 'blogsqode').'</a>';

				$ln_icon = get_option('linkedin_social_icon')?:BLOGSQODE_IMG_PATH.'/linkedin.svg';
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.linkedin.com/uas/login?session_redirect='.get_the_title()." ".esc_url($permalink).'">'.esc_html__('Linkedin', 'blogsqode').'</a>';

				$wp_icon = get_option('whatsapp_social_icon')?:BLOGSQODE_IMG_PATH.'/whatsapp.svg';
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://web.whatsapp.com/send?text='.esc_url($permalink).'" data-action="share/whatsapp/share">'.esc_html__('Whatsapp', 'blogsqode').'</a>';

				$pn_icon = get_option('pinterest_social_icon')?:BLOGSQODE_IMG_PATH.'/pinterest.svg';
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://pinterest.com/pin/create/button/?url='.esc_url($permalink).'" data-action="share/pinterest/share">'.esc_html__('Pinterest', 'blogsqode').'</a>';

				$sp_icon = get_option('snapchat_social_icon')?:BLOGSQODE_IMG_PATH.'/snapchat.svg';
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://www.snapchat.com/scan?attachmentUrl=' . esc_url($permalink) . '" data-action="share/snapchat/share">'.esc_html__('Snapchat', 'blogsqode').'</a>';

				$wc_icon = get_option('wechat_social_icon')?:BLOGSQODE_IMG_PATH.'/wechat.svg';
				echo '<a class="blogsqode-social-icon" target="_blank" href="https://api.qrserver.com/v1/create-qr-code/?size=154x154&data='.esc_url($permalink).'" data-action="share/wechat/share">'.esc_html__('Wechat', 'blogsqode').'</a>';

				echo '</div>';
			} ?>
		</div>
		<?php
	} 
	if($single_layout === '5'){
		if(esc_attr(get_option('blogsqode_single_tags_allow')) === 'Unable'){
			echo '<div class="tags tags-layout-5">'.blogsqode_single_tags().'</div>'; 
		} 
		if(esc_attr(get_option('blogsqode_single_sharebutton_allow')) === 'Unable'){	
			$permalink = get_the_permalink();
			echo '<div class="blogsqode-single-social-share">';

			$fb_icon = get_option('facebook_social_icon')?:BLOGSQODE_IMG_PATH.'/facebook.svg';
			echo '<a class="blogsqode-social-icon facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u='.esc_url($permalink).'"><svg width="24" height="24" viewBox="0 0 10 18" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.66683 10.25H8.75016L9.5835 6.91663H6.66683V5.24996C6.66683 4.39163 6.66683 3.58329 8.3335 3.58329H9.5835V0.783293C9.31183 0.747459 8.286 0.666626 7.20266 0.666626C4.94016 0.666626 3.3335 2.04746 3.3335 4.58329V6.91663H0.833496V10.25H3.3335V17.3333H6.66683V10.25Z" fill="#ffffff"/>
			</svg></a>';

			$pn_icon = get_option('pinterest_social_icon')?:BLOGSQODE_IMG_PATH.'/pinterest.svg';
			echo '<a class="blogsqode-social-icon pinterest" target="_blank" href="https://pinterest.com/pin/create/button/?url='.esc_url($permalink).'"><svg width="24" height="24" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M10.4005 1.66663C6.97442 1.66663 3.58838 3.9507 3.58838 7.6473C3.58838 9.99816 4.91074 11.3339 5.71217 11.3339C6.04276 11.3339 6.2331 10.4122 6.2331 10.1518C6.2331 9.84122 5.44169 9.18004 5.44169 7.88773C5.44169 5.20294 7.48533 3.29954 10.1301 3.29954C12.4041 3.29954 14.0871 4.59185 14.0871 6.96608C14.0871 8.73925 13.3758 12.0652 11.0717 12.0652C10.2402 12.0652 9.52898 11.4641 9.52898 10.6026C9.52898 9.34032 10.4106 8.11814 10.4106 6.81582C10.4106 4.6052 7.27496 5.00592 7.27496 7.67735C7.27496 8.23835 7.34508 8.85946 7.59553 9.37037C7.13471 11.3539 6.19303 14.3092 6.19303 16.3528C6.19303 16.984 6.28319 17.6051 6.3433 18.2362C6.45683 18.3631 6.40006 18.3497 6.57371 18.2863C8.25671 15.9822 8.1966 15.5314 8.95796 12.516C9.36869 13.2974 10.4306 13.7181 11.2721 13.7181C14.8184 13.7181 16.4113 10.262 16.4113 7.14641C16.4113 3.83049 13.5461 1.66663 10.4005 1.66663Z" fill="#ffffff"/>
			</svg></a>';

			$tw_icon = get_option('twitter_social_icon twitter')?:BLOGSQODE_IMG_PATH.'/twitter.svg';
			echo '<a class="blogsqode-social-icon twitter" target="_blank" href="https://twitter.com/intent/tweet?text='.get_the_title()." ".esc_url($permalink).'"><svg width="24" height="24" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M18.4683 4.71327C17.8321 4.99468 17.1574 5.1795 16.4666 5.26161C17.1947 4.82613 17.7397 4.14078 17.9999 3.33327C17.3166 3.73994 16.5674 4.02494 15.7866 4.17911C15.2621 3.61792 14.5669 3.24574 13.809 3.12043C13.0512 2.99511 12.2732 3.12368 11.596 3.48615C10.9187 3.84862 10.3802 4.42468 10.0642 5.12477C9.74812 5.82486 9.67221 6.60976 9.84825 7.35744C8.46251 7.28798 7.10686 6.92787 5.86933 6.30049C4.63179 5.67311 3.54003 4.79248 2.66492 3.71577C2.35516 4.24781 2.19238 4.85263 2.19326 5.46827C2.19326 6.6766 2.80826 7.74411 3.74326 8.36911C3.18993 8.35169 2.64878 8.20226 2.16492 7.93327V7.9766C2.16509 8.78136 2.44356 9.56129 2.95313 10.1842C3.46269 10.807 4.17199 11.2345 4.96075 11.3941C4.4471 11.5333 3.90851 11.5538 3.38576 11.4541C3.60814 12.1468 4.04159 12.7526 4.62541 13.1867C5.20924 13.6208 5.9142 13.8614 6.64159 13.8749C5.91866 14.4427 5.0909 14.8624 4.20566 15.1101C3.32041 15.3577 2.39503 15.4285 1.48242 15.3183C3.0755 16.3428 4.93 16.8867 6.82409 16.8849C13.2349 16.8849 16.7408 11.5741 16.7408 6.96827C16.7408 6.81827 16.7366 6.66661 16.7299 6.51827C17.4123 6.02508 18.0013 5.41412 18.4691 4.71411L18.4683 4.71327Z" fill="#ffffff"/>
			</svg></a>';

			$ln_icon = get_option('linkedin_social_icon')?:BLOGSQODE_IMG_PATH.'/linkedin.svg';
			echo '<a class="blogsqode-social-icon linkedin" target="_blank" href="https://www.linkedin.com/uas/login?session_redirect='.get_the_title()." ".esc_url($permalink).'"><svg width="24" height="24" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M5.78353 4.16665C5.78331 4.60867 5.6075 5.03251 5.29478 5.34491C4.98207 5.65732 4.55806 5.8327 4.11603 5.83248C3.674 5.83226 3.25017 5.65645 2.93776 5.34373C2.62536 5.03102 2.44997 4.60701 2.4502 4.16498C2.45042 3.72295 2.62622 3.29912 2.93894 2.98671C3.25166 2.67431 3.67567 2.49892 4.1177 2.49915C4.55972 2.49937 4.98356 2.67517 5.29596 2.98789C5.60837 3.30061 5.78375 3.72462 5.78353 4.16665ZM5.83353 7.06665H2.5002V17.5H5.83353V7.06665ZM11.1002 7.06665H7.78353V17.5H11.0669V12.025C11.0669 8.97498 15.0419 8.69165 15.0419 12.025V17.5H18.3335V10.8916C18.3335 5.74998 12.4502 5.94165 11.0669 8.46665L11.1002 7.06665Z" fill="#ffffff"/>
			</svg></a>';

			$wp_icon = get_option('whatsapp_social_icon')?:BLOGSQODE_IMG_PATH.'/whatsapp.svg';
			echo '<a class="blogsqode-social-icon whatsapp" target="_blank" href="https://web.whatsapp.com/send?text='.esc_url($permalink).'" data-action="share/whatsapp/share"><svg width="24" height="24" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1.66985 18.3333L2.79652 14.1933C2.05413 12.9207 1.6641 11.4733 1.66652 9.99996C1.66652 5.39746 5.39735 1.66663 9.99985 1.66663C14.6023 1.66663 18.3332 5.39746 18.3332 9.99996C18.3332 14.6025 14.6023 18.3333 9.99985 18.3333C8.52716 18.3357 7.0804 17.9459 5.80818 17.2041L1.66985 18.3333ZM6.99235 6.08996C6.88473 6.09664 6.77958 6.12499 6.68318 6.17329C6.59278 6.22448 6.51026 6.28848 6.43818 6.36329C6.33818 6.45746 6.28152 6.53913 6.22068 6.61829C5.91269 7.01912 5.74702 7.51114 5.74985 8.01663C5.75152 8.42496 5.85818 8.82246 6.02485 9.19413C6.36568 9.94579 6.92652 10.7416 7.66735 11.4791C7.84568 11.6566 8.01985 11.835 8.20735 12.0008C9.12684 12.8103 10.2226 13.3942 11.4073 13.7058L11.8815 13.7783C12.0357 13.7866 12.1898 13.775 12.3448 13.7675C12.5875 13.7549 12.8245 13.6892 13.039 13.575C13.1774 13.5016 13.2424 13.465 13.3582 13.3916C13.3582 13.3916 13.394 13.3683 13.4623 13.3166C13.5749 13.2333 13.644 13.1741 13.7374 13.0766C13.8065 13.005 13.8665 12.9208 13.9123 12.825C13.9773 12.6891 14.0423 12.43 14.069 12.2141C14.089 12.0491 14.0832 11.9591 14.0807 11.9033C14.0773 11.8141 14.0032 11.7216 13.9224 11.6825L13.4373 11.465C13.4373 11.465 12.7123 11.1491 12.2698 10.9475C12.2232 10.9271 12.1732 10.9155 12.1223 10.9133C12.0653 10.9074 12.0077 10.9139 11.9534 10.9321C11.8991 10.9504 11.8493 10.98 11.8073 11.0191V11.0175C11.8032 11.0175 11.7473 11.065 11.1448 11.795C11.1103 11.8414 11.0626 11.8765 11.008 11.8958C10.9534 11.9151 10.8943 11.9177 10.8382 11.9033C10.7839 11.8888 10.7307 11.8704 10.679 11.8483C10.5757 11.805 10.5398 11.7883 10.469 11.7575L10.4648 11.7558C9.98811 11.5476 9.5467 11.2665 9.15652 10.9225C9.05152 10.8308 8.95402 10.7308 8.85402 10.6341C8.52616 10.3202 8.24044 9.96497 8.00402 9.57746L7.95485 9.49829C7.91953 9.4451 7.89098 9.38771 7.86985 9.32746C7.83818 9.20496 7.92068 9.10663 7.92068 9.10663C7.92068 9.10663 8.12318 8.88496 8.21735 8.76496C8.29576 8.66523 8.36891 8.56148 8.43652 8.45413C8.53485 8.29579 8.56568 8.13329 8.51402 8.00746C8.28068 7.43746 8.03902 6.86996 7.79068 6.30663C7.74152 6.19496 7.59568 6.11496 7.46318 6.09913C7.41818 6.09413 7.37318 6.08913 7.32818 6.08579C7.21627 6.08023 7.10413 6.08135 6.99235 6.08913V6.08996Z" fill="#ffffff"/>
			</svg></a>';

			echo '</div>';
		} 
		?>

		<?php
	}

	?>

</article>

<?php 
function user_detail_meta_func(){

	$single_layout = esc_attr(get_option('blogsqode_singlepage_layout'));
	$blog_date_allow = esc_attr(get_option('blogsqode_single_blog_date_allow'));
	$author_name_allow = esc_attr(get_option('blogsqode_single_author_name_allow'));
	ob_start();
	if($single_layout === '1'){
		?>
		<div class="blogsqode-single-post-foot">
			<div class="blogsqode-author-wrap">
				<?php if(esc_attr(get_option('blogsqode_single_auhtor_thumb_allow')) === 'Unable'){
					if(($avatar = get_avatar(get_the_author_meta(get_the_ID()))) !== FALSE): 
						echo $avatar; 
					else: ?>
						<img src="/images/no-image-default.jpg">
					<?php endif; 
				}
				?> 
				<div class="blogsqode-authorname-date">
					<?php

					if($author_name_allow === 'Unable' && $blog_date_allow === 'Unable'){
						echo '<h3 class="blogsqode-author-name">'.get_the_author_meta('display_name').'</h3>';
					} else {
						echo '<h3 class="blogsqode-author-name">'.get_the_author_meta('display_name').'</h3>';
					}

					if($blog_date_allow === 'Unable'){
						echo '<p class="blogsqode-post-date">'.get_the_date().'</p>';
					}
					?>
				</div>
			</div>

			<div class="blogsqode-single-count-cat">
				<?php
				if(esc_attr(get_option('blogsqode_single_comment_count_allow')) === 'Unable'){
					echo '<p class="blogsqode-comments-number">'.get_comments_number().' Comment</p>';
				}
				$cats = get_the_category();
				if (!empty($cats)) {
					$cats = get_the_category();
					$cat = $cats[0];
					if(esc_attr(get_option('blogsqode_single_category_allow')) === 'Unable' ){
						$cat_link = get_category_link($cat->term_id);
						echo '<a href="'.esc_url($cat_link).'" class="blogsqode_post_cat">'.esc_html__($cat->cat_name, "blogsqode").'</a>'; 
					}
				}
				?>
			</div>
		</div>
	<?php } else if($single_layout === '2' || $single_layout === '3'){
		?>
		<div class="single_blog_wrapper">
			<div class="user_detail_left_content">
				<div class="user_image">
					<?php if(esc_attr(get_option('blogsqode_single_auhtor_thumb_allow')) === 'Unable'){
						if(($avatar = get_avatar(get_the_author_meta(get_the_ID()))) !== FALSE): 
							echo $avatar; 
						else: ?>
							<img src="/images/no-image-default.jpg">
						<?php endif; 
					}
					?> 
				</div> 
				<div class="user_name">
					<?php
					if($author_name_allow === 'Unable'){
						echo '<h3 class="blogsqode-author-name">'.get_the_author_meta('display_name').'</h3>';
					}
					?>
				</div>
			</div>
			<div class="user_detail_right_content">
				<div class="single_blog_date">
					<?php 
					if($blog_date_allow === 'Unable'){
						echo '<p class="blogsqode-post-date">'.get_the_date().'</p>';
					} ?>
				</div>
				<div class="single_blog_comment">
					<?php 	if(esc_attr(get_option('blogsqode_single_comment_count_allow')) === 'Unable'){
						echo '<p class="blogsqode-comments-number">'.get_comments_number().' Comment</p>';
					} ?>
				</div>
			</div>
		</div>
		<?php
	}

	return ob_get_clean();
}

function blogsqode_single_tags(){
	global $single_layout;
	$single_layout = $single_layout;
	ob_start();
	if($single_layout === '4' || $single_layout === '5'){ 
		echo '<div class="blogsqode-single-tags"><div class="blogsqode-tag-heading"><h3>'.esc_html__("Tags:", "blogsqode").'</h3></div>';
	} else {
		echo '<div class="blogsqode-single-tags"><h3>'.esc_html__("Tags:", "blogsqode").'</h3>';
	}

	$post_type = get_post_type();
	$post_tags = array();
	$taxonomies = get_object_taxonomies($post_type, 'names');
	foreach ($taxonomies as $taxonomy) {
		if ($taxonomy !== 'category' && !is_taxonomy_hierarchical($taxonomy)) {
			$terms = get_the_terms(get_the_ID(), $taxonomy);
			if ($terms && !is_wp_error($terms)) {
				$post_tags = array_merge($post_tags, $terms);
			}
		}
	}
	if ($single_layout === '4' || $single_layout === '5') {
		echo '<div class="blogsqode_single_tags_4">';
	}
	if ($post_tags !== false) { 
		foreach ($post_tags as $tag) {
			$tag_link = get_term_link($tag);
			echo '<a href="' . esc_url($tag_link) . '" class="blogsqode-single-tags-link">' . esc_html__($tag->name, "blogsqode") . '</a>';
		}
	}

	if($single_layout === '4' || $single_layout === '5'){
		echo '</div>';
	}
	echo '</div>';
	$return = ob_get_clean();
	return $return;
}