<?php
/**
 * The public-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-specific stylesheet and JavaScript.
 *
 * @package    Blogsqode
 * @subpackage Blogsqode/public
 * @author     The_Krishna
 */
class Blogsqode_Public extends Blogsqode_Public_Templates {
	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    2.0.0
	 */
	public function __construct() {
		add_shortcode( 'blogsqode_blog_list', array( $this, 'blogsqode_views' ) );
		add_shortcode( 'blogsqode_blog_list_with_sidebar', array( $this, 'blogsqode_with_sidebar_views' ) );
		add_shortcode( 'blogsqode_slider', array( $this, 'blogsqode_slider_views' ) );
		add_shortcode( 'blogsqode_slider_with_sidebar', array( $this, 'blogsqode_slider_views_with_sidebar' ) );
		add_action( 'wp_enqueue_scripts', array($this, 'add_blogsqode_public_scripts_func'), 999 );

		add_action('wp_ajax_blogsqode_loadmore', array( $this, 'blogsqode_views_ajax' )); 
		add_action('wp_ajax_nopriv_blogsqode_loadmore', array( $this, 'blogsqode_views_ajax' ));

		add_action('wp_ajax_blogsqode_pagination_tab_on', array( $this, 'blogsqode_pag_tab_on' )); 
		add_action('wp_ajax_nopriv_blogsqode_pagination_tab_on', array( $this, 'blogsqode_pag_tab_on' ));

		add_action('wp_ajax_blogsqode_pag_tab_on_with_sidebar', array( $this, 'blogsqode_views_ajax_with_sidebar_pag_tab_on' )); 
		add_action('wp_ajax_nopriv_blogsqode_pag_tab_on_with_sidebar', array( $this, 'blogsqode_views_ajax_with_sidebar_pag_tab_on' ));

		add_action('wp_ajax_blogsqode_loadmore_with_sidebar_tab_off', array( $this, 'blogsqode_views_ajax_loadmore_with_sidebar_tab_off' )); 
		add_action('wp_ajax_blogsqode_loadmore_with_sidebar_tab_off', array( $this, 'blogsqode_views_ajax_loadmore_with_sidebar_tab_off' ));

		$design_mode = esc_attr(get_option('blogsqode_single_post_design_mode'));
		if($design_mode === 'Unable'){
			add_filter('template_include', array($this, 'blogsqode_templates'));
		}
	}
	
	function blogsqode_templates( $template ) {
		$post_types = get_option('blogsqode_selected_post_type', 'post');
		if (is_singular($post_types)) {
			$template = BLOGSQODE_PLUGIN_PATH.'/public/single/single-blogsqode.php';
		}
		return $template;
	}

	 /**
	 * Enqueue a script with jQuery as a dependency.
	 */

	function add_blogsqode_public_scripts_func( $hook_suffix ) {
	 	global $wp_query;
	 	$version = BLOGSQODE_VERSION;
	 	$design_mode = esc_attr(get_option('blogsqode_single_post_design_mode'));	 	
	 		wp_enqueue_style( 'blogsqode-public-styles', plugins_url( '/assets/css/blogsqode-public.css', __FILE__ ), array(), $version, 'all' );
			wp_enqueue_style('blogsqode-slick-styles', plugins_url('/assets/css/slick.css', __FILE__));
	 		wp_enqueue_script('jquery');
			wp_enqueue_script('blogsqode-slick-script', plugins_url('/assets/js/slick.min.js', __FILE__), array('jquery'), '', true);
			wp_enqueue_script('mixitup-script', plugins_url('/assets/js/mixitup.min.js', __FILE__), array('jquery'), '', true);
			wp_enqueue_script('blogsqode-public-scripts', plugins_url('/assets/js/blogsqode-public.js', __FILE__ ), array( 'jquery' ), $version, true);		
			wp_enqueue_script('matchheight-js', plugins_url('/assets/js/jquery.matchHeight-min.js', __FILE__ ), true);		
			$plugin_base_url = plugins_url( 'public/assets/js/', dirname( __FILE__ ) );
		?>
		<script src="<?php echo esc_url( $plugin_base_url . 'jquery.min.mix.js' ); ?>"></script>
		<script src="<?php echo esc_url( $plugin_base_url . 'jPages.min.js' ); ?>"></script>
		<script src="<?php echo esc_url( $plugin_base_url . 'jquery.mixitup.min.js' ); ?>"></script>

		<!-- first pagination general layout without sidebar -->
		<?php
			$posts_per_page = (esc_attr(get_option('blogsqode_blogs_per_page'))) ?: 12;
			$intpostperpage = (int) filter_var($posts_per_page, FILTER_SANITIZE_NUMBER_INT);
		?>
		<script>
			jQuery(document).ready(function($) {
				var pagination = $('.pagination');
				var postsPerPage = <?php echo $intpostperpage; ?>;

				function setPagination() {
					pagination.jPages({
						containerID: 'blog-no-sidebar',
						perPage: postsPerPage,
						startPage: 1,
						startRange: 1,
						midRange: 3,
						endRange: 1,
						first: false,
						last: false,
						animation: 'none',
						callback: function() {
							pagination.find('a').addClass('custom-pagination-link');
							pagination.find('.jp-previous').empty().append('<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.42331 10.6733C8.25856 10.8381 7.99144 10.8381 7.82669 10.6733L4.45169 7.29831C4.28694 7.13356 4.28694 6.86644 4.45169 6.70169L7.82669 3.32669C7.99144 3.16194 8.25856 3.16194 8.42331 3.32669C8.58806 3.49144 8.58806 3.75856 8.42331 3.92331L5.34662 7L8.42331 10.0767C8.58806 10.2414 8.58806 10.5086 8.42331 10.6733Z" fill="#14141F"/></svg>');
							pagination.find('.jp-next').empty().append('<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.57669 3.32669C5.74144 3.16194 6.00856 3.16194 6.17331 3.32669L9.54831 6.70169C9.71306 6.86644 9.71306 7.13356 9.54831 7.29831L6.17331 10.6733C6.00856 10.8381 5.74144 10.8381 5.57669 10.6733C5.41194 10.5086 5.41194 10.2414 5.57669 10.0767L8.65338 7L5.57669 3.92331C5.41194 3.75856 5.41194 3.49144 5.57669 3.32669Z" fill="#14141F"/></svg>');
						}
					}); 
				}
				function destroyPagination() {
					pagination.jPages('destroy');
				};
				setPagination();
				$('#blog-no-sidebar').mixItUp({
					callbacks: {
						onMixLoad: function(state,futureState ){
						},
						onMixStart: function(state,futureState ){
							destroyPagination();
						},
						onMixEnd: function(state, futureState){
							setPagination();
						},
						animation: {
							enable: false
						},
					}
				});
			});
		</script>

		<!-- second pagination general layout with sidebar -->
		<?php
			$posts_per_page_with = (esc_attr(get_option('blogsqode_blogs_per_page_with_sidebar'))) ?: 12;
			$intpostperpage_with = (int) filter_var($posts_per_page_with, FILTER_SANITIZE_NUMBER_INT);
		?>
		<script>
			jQuery(document).ready(function($) {
				var pagination = $('.pagination');
				var postsPerPage2 = <?php echo $intpostperpage_with; ?>;
				function setPagination() {
					pagination.jPages({
						containerID: 'blog-with-sidebar',
						perPage: postsPerPage2,
						startPage: 1,
						startRange: 1,
						midRange: 3,
						endRange: 1,
						first: false,
						last: false,
						animation: 'none',
						callback: function() {
							pagination.find('a').addClass('custom-pagination-link');
							pagination.find('.jp-previous').empty().append('<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.42331 10.6733C8.25856 10.8381 7.99144 10.8381 7.82669 10.6733L4.45169 7.29831C4.28694 7.13356 4.28694 6.86644 4.45169 6.70169L7.82669 3.32669C7.99144 3.16194 8.25856 3.16194 8.42331 3.32669C8.58806 3.49144 8.58806 3.75856 8.42331 3.92331L5.34662 7L8.42331 10.0767C8.58806 10.2414 8.58806 10.5086 8.42331 10.6733Z" fill="#14141F"/></svg>');
							pagination.find('.jp-next').empty().append('<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.57669 3.32669C5.74144 3.16194 6.00856 3.16194 6.17331 3.32669L9.54831 6.70169C9.71306 6.86644 9.71306 7.13356 9.54831 7.29831L6.17331 10.6733C6.00856 10.8381 5.74144 10.8381 5.57669 10.6733C5.41194 10.5086 5.41194 10.2414 5.57669 10.0767L8.65338 7L5.57669 3.92331C5.41194 3.75856 5.41194 3.49144 5.57669 3.32669Z" fill="#14141F"/></svg>');

						}
					}); 
				}
				function destroyPagination() {
					pagination.jPages('destroy');
				};
				setPagination();
				$('#blog-with-sidebar').mixItUp({
					callbacks: {
						onMixLoad: function(state,futureState ){
						},
						onMixStart: function(state,futureState ){
							destroyPagination();
						},
						onMixEnd: function(state, futureState){
							setPagination();
						},
						animation: {
							enable: false
						},
					}
				});
			});
		</script>

		<!-- first load more general layout without sidebar -->
		<?php
			$posts_per_page2 = esc_attr(get_option('blogsqode_blogs_per_page', 12));
			$intpostperpage2 = (int) filter_var($posts_per_page2, FILTER_SANITIZE_NUMBER_INT);
		?>
		<script>
			document.addEventListener('DOMContentLoaded', function () {
				var postsPerPage = <?php echo json_encode($posts_per_page2); ?>;
				var changeNum = <?php echo json_encode($intpostperpage2); ?>;
				var $list = $(".blog-listing-inner-no-sidebar .mix").hide(),
				$curr;
				var num = postsPerPage;
				var changeNum = changeNum;
				$(".filter-btn-unable").on("click", function () {
					var $this = $(this);
					$this.addClass("active").siblings().removeClass("active");
					$curr = $list.filter("." + this.id).hide();
					$curr.slice(0, num).show();
					$list.not($curr).hide();
					if ($curr.filter(":hidden").length === 0) {
						$(".load_more_posts_unable").hide(); 
					} else {
						$(".load_more_posts_unable").show(); 
					}
				}).filter(".active").click();
				$(".load_more_posts_unable").on("click", function () {
					$curr.filter(":hidden").slice(0, changeNum).slideDown();
					if ($curr.filter(":hidden").length === 0) {
						$(".load_more_posts_unable").hide(); 
					}
				});
			});
		</script>

		<!-- first load more general layout with sidebar -->
		<?php
			$posts_per_page3 = (esc_attr(get_option('blogsqode_blogs_per_page_with_sidebar'))) ?: 12;
			$intpostperpage3 = (int) filter_var($posts_per_page3, FILTER_SANITIZE_NUMBER_INT);
		?>
		<script>
			document.addEventListener('DOMContentLoaded', function () {
				var postsPerPage = <?php echo json_encode($posts_per_page3); ?>;
				var changeNum = <?php echo json_encode($intpostperpage3); ?>;
				var $list = $(".blog-listing-with-sidebar-views .mix").hide(),
				$curr;
				var num = postsPerPage;
				var changeNum = changeNum;
				$(".filter-btn-load-btn-tab-on").on("click", function () {
					var $this = $(this);
					$this.addClass("active").siblings().removeClass("active");
					$curr = $list.filter("." + this.id).hide();
					$curr.slice(0, num).show();
					$list.not($curr).hide();
					if ($curr.filter(":hidden").length === 0) {
						$(".load_more_posts_with_sidebar1").hide(); 
					} else {
						$(".load_more_posts_with_sidebar1").show(); 
					}
				}).filter(".active").click();
				$(".load_more_posts_with_sidebar1").on("click", function () {
					$curr.filter(":hidden").slice(0, changeNum).slideDown();
					if ($curr.filter(":hidden").length === 0) {
						$(".load_more_posts_with_sidebar1").hide(); 
					}
				});
			});
		</script>

		<?php
			wp_localize_script( 'blogsqode-public-scripts', 'blogsqode_loadmore_params', array(
			'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php', 
			'posts' => json_encode( $wp_query->query_vars ),
			'current_page' => get_query_var( 'paged' ) ? get_query_var('paged') : 1,
			'max_page' => $wp_query->max_num_pages
			) );

			wp_localize_script( 'blogsqode-public-scripts', 'blogsqode_loadmore_params_with_sidebar', array(
				'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php', 
				'posts' => json_encode( $wp_query->query_vars ), 
				'current_page' => get_query_var( 'paged' ) ? get_query_var('paged') : 1,
				'max_page' => $wp_query->max_num_pages
			) );

			$layout = isset($_POST['layout']) ? $_POST['layout'] : '1';
			wp_localize_script(
				'blogsqode-public-scripts',
				'blogsqode_ajax',
				array(
					'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php', 
					'layout' => $layout, 
				)
			);
			
	}

	/* general layout with default sidebar */
	public function blogsqode_setting_arr_func(){
		$settings = array();
		$settings['blogsqode_dark_mode']  = esc_attr(get_option('blogsqode_dark_mode'));
		$blogsqode_post_type = get_option('blogsqode_post_type');
		if (is_array($blogsqode_post_type)) {
			$settings['blogsqode_post_type'] = implode(',', $blogsqode_post_type);
		} else {
			$settings['blogsqode_post_type'] = esc_attr($blogsqode_post_type);
		}
		$settings['blogsqode_category_filter_options_on_off'] = esc_attr(get_option('blogsqode_category_filter_options_on_off'));
		$settings['blogsqode_category_filter_options_on_off'] = esc_attr(get_option('blogsqode_category_filter_options_on_off'));
		$settings['blogsqode_category_filter_allow']  = esc_attr(get_option('blogsqode_category_filter_allow'));
		$settings['blogsqode_blog_post_grid']  = esc_attr(get_option('blogsqode_blog_post_grid'));
		$settings['blogsqode_short_desc_allow']  = strtolower(esc_attr(get_option('blogsqode_short_desc_allow')));
		$settings['blogsqode_auhtor_thumb_allow']  = strtolower(esc_attr(get_option('blogsqode_auhtor_thumb_allow')));
		$settings['blogsqode_author_name_allow']  = strtolower(esc_attr(get_option('blogsqode_author_name_allow')));
		$settings['blogsqode_blog_date_allow']  = strtolower(esc_attr(get_option('blogsqode_blog_date_allow')));
		$settings['blogsqode_comment_count_allow']  = strtolower(esc_attr(get_option('blogsqode_comment_count_allow')));
		$settings['blogsqode_read_time_allow']  = strtolower(esc_attr(get_option('blogsqode_read_time_allow')));
		$settings['blogsqode_category_allow']  = strtolower(esc_attr(get_option('blogsqode_category_allow')));
		$settings['blogsqode_read_more_btn_allow']  = strtolower(esc_attr(get_option('blogsqode_read_more_btn_allow')));
		$settings['blogsqode_read_more_button_layout']  = esc_attr(get_option('blogsqode_read_more_button_layout'));
		$settings['coming_soon_layout_bg_color']  = esc_attr(get_option('coming_soon_layout_bg_color'));
		return $settings;
	}
	
	public function blogsqode_views($atts){

		if ( ! isset( $atts['layout'] ) ) {
			return '<p>The layout attribute is required for the [blogsqode_blog_list] shortcode.</p>';
		}
		$atts = shortcode_atts( array(
            'page_id' => 0,
            'layout' => 1, 
        ), $atts );
		$page_id = $atts['page_id'];
		$layout = isset($atts['layout']) ? $atts['layout'] : 1;

		ob_start();
	 	$settings = self::blogsqode_setting_arr_func();
		$bg_color = $settings['coming_soon_layout_bg_color'];
		?>
		<script>
			document.documentElement.style.setProperty('--bg-color', '<?php echo $bg_color; ?>');
		</script>
		<?php 
		$category_id = isset($_POST['category']) ? intval($_POST['category']) : 0;
	 	$posts_per_page = (esc_attr(get_option('blogsqode_blogs_per_page')))?:12;
	 	$intpostperpage = (int) filter_var($posts_per_page, FILTER_SANITIZE_NUMBER_INT);  
	 	$paged = (int) filter_var(self::blogsqode_paged(), FILTER_SANITIZE_NUMBER_INT);  
		$selected_category  = get_option('blogsqode_category_filter_options');
		$pagination_type = (esc_attr(get_option('blogsqode_blog_pagination_option'))) ?: 'pagination';
	 	$args           = array(
			'post_type' => get_option('blogsqode_post_type', 'post'),
			'posts_per_page' => $intpostperpage,
	 		'paged'          => $paged,
	 		'orderby'        => 'date',
	 		'order'          => 'DESC',
	 	);
		$category_tab_enabled = get_option('blogsqode_category_filter_options_on_off');

		if ($category_tab_enabled === "Unable" && $pagination_type === 'load_more_button') {
			$selected_post_types = get_option('blogsqode_post_type', array('post'));
			$post_types = get_post_types(array('public' => true), 'objects');
			echo '<div id="category-filter" class="category-general-filter-all category-filter-all slick-slider">';
				echo '<a class="category-name active filter-btn-unable cat-name-active" id="mix" data-category-id="" data-layout="' . esc_attr($layout) . '" data-filter=".mix">All</a>';
					$selected_categories = get_option('blogsqode_category_filter_options', array());
					foreach ($post_types as $post_type) {
						if ($post_type->name !== 'attachment' && in_array($post_type->name, $selected_post_types)) {
							$taxonomies = get_object_taxonomies($post_type->name);
							if (!empty($taxonomies)) {
								foreach ($taxonomies as $taxonomy) {
									$categories = get_terms(array(
										'taxonomy'   => $taxonomy,
										'hide_empty' => false,
										'include'    => $selected_categories, 
									));
									foreach ($categories as $category) {
										echo '<a class="category-name filter-btn-unable" id="' . $category->slug . '" data-category-id="' . $category->term_id . '" data-layout="' . esc_attr($layout) . '" data-post-type="' . esc_attr($post_type->name) . '" data-filter=".' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</a>';
									}
								}
							}
						}
					}
			echo '</div>';				
		
			$selected_post_types = get_option('blogsqode_post_type', 'post');
			$selected_categories = get_option('blogsqode_category_filter_options');

			if (!empty($selected_categories) && !empty($selected_post_types)) {
				$tax_query = array('relation' => 'OR'); 
				foreach ($selected_categories as $category_id) {
					foreach ($selected_post_types as $post_type) {
						$post_type_taxonomies = get_object_taxonomies($post_type);
						if (!empty($post_type_taxonomies)) {
							foreach ($post_type_taxonomies as $taxonomy) {
								$category = get_term($category_id, $taxonomy);
								if (!is_wp_error($category) && $category !== null) {
									$tax_query[] = array(
										'taxonomy' => $taxonomy,
										'field'    => 'term_id',
										'terms'    => $category_id,
									);
								}
							}
						}
					}
				}
				$paged = get_query_var('paged') ? get_query_var('paged') : 1;
				$args = array(
					'post_type'      => $selected_post_types,
					'posts_per_page' => -1,
					'paged'          => $paged,
					'orderby'        => 'date',
					'order'          => 'DESC',
					'tax_query'      => $tax_query,
				);
		
			$loop = new WP_Query($args);
			$max_num_pages = $loop->max_num_pages;
			$pagination_type           = (esc_attr(get_option('blogsqode_blog_pagination_option'))) ?: 'pagination';
			if ($loop->have_posts()) {
				echo '<div class="blogsqode-blog-wrap blog-listing blog-listing-load-more-unable-no-sidebar blog-listing-posts">';
					echo '<div class="blog-listing-inner-no-sidebar selected-layout layout-' . esc_attr($layout) . ' post-grid-' . esc_attr($settings['blogsqode_blog_post_grid']) . '">';
						while ($loop->have_posts()) : 
							$loop->the_post();
							$post_id = get_the_ID();
							if ($layout === '1') {
								echo $this->layout_one($settings, $layout);
							} elseif ($layout === '2' || $layout === '3') {
								echo $this->layout_two($settings, $layout);
							} elseif ($layout === '4') {
								echo $this->layout_four($settings, $layout);
							} elseif ($layout === '5') {
								echo $this->layout_five($settings, $layout);
							} elseif ($layout === '6') {
								echo $this->layout_six($settings, $layout);
							} elseif ($layout === '7') {
								echo $this->layout_seven($settings, $layout);
							} elseif ($layout === '8') {
								echo $this->layout_eight($settings, $layout);
							} elseif ($layout === '9') {
								echo $this->layout_nine($settings, $layout);
							} elseif ($layout === '10') {
								echo $this->layout_ten($settings, $layout);
							} elseif ($layout === '11') {
								echo $this->layout_eleven($settings, $layout);
							} elseif ($layout === '12') {
								echo $this->layout_twelve($settings, $layout);
							} elseif ($layout === '13') {
								echo $this->layout_thirteen($settings, $layout);
							} elseif ($layout === '14') {
								echo $this->layout_fourteen($settings, $layout);
							} elseif ($layout === '15') {
								echo $this->layout_fifteen($settings, $layout);
							} elseif ($layout === '16') {
								echo $this->layout_sixteen($settings, $layout);
							} elseif ($layout === '17') {
								echo $this->layout_seventeen($settings, $layout);
							} elseif ($layout === '18') {
								echo $this->layout_eighteen($settings, $layout);
							} elseif ($layout === '19') {
								echo $this->layout_nineteen($settings, $layout);
							} elseif ($layout === '20') {
								echo $this->layout_twenty($settings, $layout);
							} elseif ($layout === '21') {
								echo $this->layout_twentyone($settings, $layout);
							} elseif ($layout === '22') {
								echo $this->layout_twentytwo($settings, $layout);
							} elseif ($layout === '23') {
								echo $this->layout_twentythree($settings, $layout);
							} elseif ($layout === '24') {
								echo $this->layout_twentyfour($settings, $layout);
							} elseif ($layout === '25') {
								echo $this->layout_twentyfive($settings, $layout);
							} elseif ($layout === '26') {
								echo $this->layout_twentysix($settings, $layout);
							} elseif ($layout === '27') {
								echo $this->layout_twentyseven($settings, $layout);
							} elseif ($layout === '28') {
								echo $this->layout_twentyeight($settings, $layout);
							} elseif ($layout === '29') {
								echo $this->layout_twentynine($settings, $layout);
							} elseif ($layout === '30') {
								echo $this->layout_thirty($settings, $layout);
							}
						endwhile;
						wp_reset_query();
					echo '</div>';
				echo '</div>';			
		
			}}
		}
		if ($category_tab_enabled === "Disable" && $pagination_type === 'load_more_button') {	
			$loop = new WP_Query($args);
				$max_num_pages = $loop->max_num_pages;
				$pagination_type           = (esc_attr(get_option('blogsqode_blog_pagination_option'))) ?: 'pagination';
				if ($loop->have_posts()) {
					echo '<div class="blogsqode-blog-wrap blog-listing blog-listing-posts">';
						echo '<div class="blog-listing-inner selected-layout layout-' . esc_attr($layout) . ' post-grid-' . esc_attr($settings['blogsqode_blog_post_grid']) . '">';
							while ($loop->have_posts()) : 
								$loop->the_post();
								$post_id = get_the_ID();
								if ($layout === '1') {
									echo $this->layout_one($settings, $layout);
								} elseif ($layout === '2' || $layout === '3') {
									echo $this->layout_two($settings, $layout);
								} elseif ($layout === '4') {
									echo $this->layout_four($settings, $layout);
								} elseif ($layout === '5') {
									echo $this->layout_five($settings, $layout);
								} elseif ($layout === '6') {
									echo $this->layout_six($settings, $layout);
								} elseif ($layout === '7') {
									echo $this->layout_seven($settings, $layout);
								} elseif ($layout === '8') {
									echo $this->layout_eight($settings, $layout);
								} elseif ($layout === '9') {
									echo $this->layout_nine($settings, $layout);
								} elseif ($layout === '10') {
									echo $this->layout_ten($settings, $layout);
								} elseif ($layout === '11') {
									echo $this->layout_eleven($settings, $layout);
								} elseif ($layout === '12') {
									echo $this->layout_twelve($settings, $layout);
								} elseif ($layout === '13') {
									echo $this->layout_thirteen($settings, $layout);
								} elseif ($layout === '14') {
									echo $this->layout_fourteen($settings, $layout);
								} elseif ($layout === '15') {
									echo $this->layout_fifteen($settings, $layout);
								} elseif ($layout === '16') {
									echo $this->layout_sixteen($settings, $layout);
								} elseif ($layout === '17') {
									echo $this->layout_seventeen($settings, $layout);
								} elseif ($layout === '18') {
									echo $this->layout_eighteen($settings, $layout);
								} elseif ($layout === '19') {
									echo $this->layout_nineteen($settings, $layout);
								} elseif ($layout === '20') {
									echo $this->layout_twenty($settings, $layout);
								} elseif ($layout === '21') {
									echo $this->layout_twentyone($settings, $layout);
								} elseif ($layout === '22') {
									echo $this->layout_twentytwo($settings, $layout);
								} elseif ($layout === '23') {
									echo $this->layout_twentythree($settings, $layout);
								} elseif ($layout === '24') {
									echo $this->layout_twentyfour($settings, $layout);
								} elseif ($layout === '25') {
									echo $this->layout_twentyfive($settings, $layout);
								} elseif ($layout === '26') {
									echo $this->layout_twentysix($settings, $layout);
								} elseif ($layout === '27') {
									echo $this->layout_twentyseven($settings, $layout);
								} elseif ($layout === '28') {
									echo $this->layout_twentyeight($settings, $layout);
								} elseif ($layout === '29') {
									echo $this->layout_twentynine($settings, $layout);
								} elseif ($layout === '30') {
									echo $this->layout_thirty($settings, $layout);
								}
							endwhile;
							wp_reset_query();
						echo '</div>';
					echo '</div>';			
				}
		}
		if ($category_tab_enabled === "Unable" && $pagination_type === 'pagination') {
			$selected_post_types = get_option('blogsqode_post_type', array('post'));
			$post_types = get_post_types(array('public' => true), 'objects');
			echo '<div id="category-filter cat-fil-1" class="category-general-filter-all category-filter-all slick-slider">';
				echo '<a class="category-name filter filter-btn cat-name-active filter-btn-unable-pagination" data-category-id="" data-layout="' . esc_attr($layout) . '" data-filter="all">All</a>';
					$selected_categories = get_option('blogsqode_category_filter_options', array());
					foreach ($post_types as $post_type) {
						if ($post_type->name !== 'attachment' && in_array($post_type->name, $selected_post_types)) {
							$taxonomies = get_object_taxonomies($post_type->name);
							if (!empty($taxonomies)) {
								foreach ($taxonomies as $taxonomy) {
									$categories = get_terms(array(
										'taxonomy'   => $taxonomy,
										'hide_empty' => false,
										'include'    => $selected_categories, 
									));
									foreach ($categories as $category) {
										echo '<a class="category-name filter filter-btn filter-btn-unable-pagination" data-category-id="' . $category->term_id . '" data-layout="' . esc_attr($layout) . '" data-post-type="' . esc_attr($post_type->name) . '" data-filter=".' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</a>';
									}
								}
							}
						}
					}
			echo '</div>';				
				
			$selected_categories = get_option('blogsqode_category_filter_options');
			if (!empty($selected_categories)) {
				?>
				<div class="blogsqode-blog-wrap blog-listing blog-listing-pagination-with-tab blog-listing-load-more-unable-no-sidebar blog-listing-posts">
				<?php
				echo '<div id="blog-no-sidebar" class="blog-listing-inner blog-listing-inner-no-sidebar selected-layout category-' . $category_id . ' layout-' . esc_attr($layout) . ' post-grid-' . esc_attr($settings['blogsqode_blog_post_grid']) . '">';
					foreach ($selected_categories as $category_id) {
							$post_type = get_option('blogsqode_post_type', 'post');
							$post_type_taxonomies = get_object_taxonomies($post_type);
							$args = array(
								'post_type' => $post_type,
								'orderby'   => 'date',
								'order'     => 'DESC',
								'tax_query' => array(),
							);
							if (!empty($post_type_taxonomies)) {
								foreach ($post_type_taxonomies as $taxonomy) {
									$category = get_term($category_id, $taxonomy);
									if (!is_wp_error($category) && $category !== null) {
										$args['tax_query'][] = array(
											'taxonomy' => $taxonomy,
											'field'    => 'term_id',
											'terms'    => $category_id,
										);
										$loop = new WP_Query($args);
										if ($loop->have_posts()) {
											while ($loop->have_posts()) :
											$loop->the_post();
											$post_id = get_the_ID();
											if ($layout === '1') {
												echo $this->layout_one($settings, $layout);
											} elseif ($layout === '2' || $layout === '3') {
												echo $this->layout_two($settings, $layout);
											} elseif ($layout === '4') {
												echo $this->layout_four($settings, $layout);
											} elseif ($layout === '5') {
												echo $this->layout_five($settings, $layout);
											} elseif ($layout === '6') {
												echo $this->layout_six($settings, $layout);
											} elseif ($layout === '7') {
												echo $this->layout_seven($settings, $layout);
											} elseif ($layout === '8') {
												echo $this->layout_eight($settings, $layout);
											} elseif ($layout === '9') {
												echo $this->layout_nine($settings, $layout);
											} elseif ($layout === '10') {
												echo $this->layout_ten($settings, $layout);
											} elseif ($layout === '11') {
												echo $this->layout_eleven($settings, $layout);
											} elseif ($layout === '12') {
												echo $this->layout_twelve($settings, $layout);
											} elseif ($layout === '13') {
												echo $this->layout_thirteen($settings, $layout);
											} elseif ($layout === '14') {
												echo $this->layout_fourteen($settings, $layout);
											} elseif ($layout === '15') {
												echo $this->layout_fifteen($settings, $layout);
											} elseif ($layout === '16') {
												echo $this->layout_sixteen($settings, $layout);
											} elseif ($layout === '17') {
												echo $this->layout_seventeen($settings, $layout);
											} elseif ($layout === '18') {
												echo $this->layout_eighteen($settings, $layout);
											} elseif ($layout === '19') {
												echo $this->layout_nineteen($settings, $layout);
											} elseif ($layout === '20') {
												echo $this->layout_twenty($settings, $layout);
											} elseif ($layout === '21') {
												echo $this->layout_twentyone($settings, $layout);
											} elseif ($layout === '22') {
												echo $this->layout_twentytwo($settings, $layout);
											} elseif ($layout === '23') {
												echo $this->layout_twentythree($settings, $layout);
											} elseif ($layout === '24') {
												echo $this->layout_twentyfour($settings, $layout);
											} elseif ($layout === '25') {
												echo $this->layout_twentyfive($settings, $layout);
											} elseif ($layout === '26') {
												echo $this->layout_twentysix($settings, $layout);
											} elseif ($layout === '27') {
												echo $this->layout_twentyseven($settings, $layout);
											} elseif ($layout === '28') {
												echo $this->layout_twentyeight($settings, $layout);
											} elseif ($layout === '29') {
												echo $this->layout_twentynine($settings, $layout);
											} elseif ($layout === '30') {
												echo $this->layout_thirty($settings, $layout);
											}
											endwhile;
											wp_reset_postdata();
										}		
									}
								}
							}
					}
					echo '</div>';
				echo '</div>';
			}	
			?>
			<div id="pagination" class="pagination blogsqode-navigation pagination-tab"></div>
			<?php		
		}
		if ($category_tab_enabled === "Disable" && $pagination_type === 'pagination') {	
				$loop = new WP_Query($args);
					$max_num_pages = $loop->max_num_pages;
					$pagination_type           = (esc_attr(get_option('blogsqode_blog_pagination_option'))) ?: 'pagination';
					if ($loop->have_posts()) {
						echo '<div class="blogsqode-blog-wrap blog-listing blog-listing-posts">';
							echo '<div class="selected-layout layout-' . esc_attr($layout) . ' post-grid-' . esc_attr($settings['blogsqode_blog_post_grid']) . '">';
								while ($loop->have_posts()) : 
									$loop->the_post();
									$post_id = get_the_ID();
									if ($layout === '1') {
										echo $this->layout_one($settings, $layout);
									} elseif ($layout === '2' || $layout === '3') {
										echo $this->layout_two($settings, $layout);
									} elseif ($layout === '4') {
										echo $this->layout_four($settings, $layout);
									} elseif ($layout === '5') {
										echo $this->layout_five($settings, $layout);
									} elseif ($layout === '6') {
										echo $this->layout_six($settings, $layout);
									} elseif ($layout === '7') {
										echo $this->layout_seven($settings, $layout);
									} elseif ($layout === '8') {
										echo $this->layout_eight($settings, $layout);
									} elseif ($layout === '9') {
										echo $this->layout_nine($settings, $layout);
									} elseif ($layout === '10') {
										echo $this->layout_ten($settings, $layout);
									} elseif ($layout === '11') {
										echo $this->layout_eleven($settings, $layout);
									} elseif ($layout === '12') {
										echo $this->layout_twelve($settings, $layout);
									} elseif ($layout === '13') {
										echo $this->layout_thirteen($settings, $layout);
									} elseif ($layout === '14') {
										echo $this->layout_fourteen($settings, $layout);
									} elseif ($layout === '15') {
										echo $this->layout_fifteen($settings, $layout);
									} elseif ($layout === '16') {
										echo $this->layout_sixteen($settings, $layout);
									} elseif ($layout === '17') {
										echo $this->layout_seventeen($settings, $layout);
									} elseif ($layout === '18') {
										echo $this->layout_eighteen($settings, $layout);
									} elseif ($layout === '19') {
										echo $this->layout_nineteen($settings, $layout);
									} elseif ($layout === '20') {
										echo $this->layout_twenty($settings, $layout);
									} elseif ($layout === '21') {
										echo $this->layout_twentyone($settings, $layout);
									} elseif ($layout === '22') {
										echo $this->layout_twentytwo($settings, $layout);
									} elseif ($layout === '23') {
										echo $this->layout_twentythree($settings, $layout);
									} elseif ($layout === '24') {
										echo $this->layout_twentyfour($settings, $layout);
									} elseif ($layout === '25') {
										echo $this->layout_twentyfive($settings, $layout);
									} elseif ($layout === '26') {
										echo $this->layout_twentysix($settings, $layout);
									} elseif ($layout === '27') {
										echo $this->layout_twentyseven($settings, $layout);
									} elseif ($layout === '28') {
										echo $this->layout_twentyeight($settings, $layout);
									} elseif ($layout === '29') {
										echo $this->layout_twentynine($settings, $layout);
									} elseif ($layout === '30') {
										echo $this->layout_thirty($settings, $layout);
									}
								endwhile;
								wp_reset_query();
							echo '</div>';
						echo '</div>';			
					}
		}
		if($pagination_type === 'pagination' && $category_tab_enabled === "Disable"){
			echo self::blogsqode_numeric_posts_nav($max_num_pages,$paged);
		}
		elseif($category_tab_enabled === "Unable" && $pagination_type === 'load_more_button'){
			echo '<div class="load_more_posts_unable" data-layout="' . esc_attr($layout) . '" data-pages="'.esc_attr($max_num_pages).'">'.esc_html__("Load More", "blogsqode").'</div>';
		}
		elseif($category_tab_enabled === "Disable"){
			echo '<div class="load_more_posts_tab_off" data-layout="' . esc_attr($layout) . '" data-pages="'.esc_attr($max_num_pages).'">'.esc_html__("Load More", "blogsqode").'</div>';
		}	
		$content = ob_get_clean();
		return $content;
	}

	public static function blogsqode_numeric_posts_nav($max_pages, $paged) {
		$paginate = get_option('blogsqode_pagination_layout');
		$l_class = 'paginate'.$paginate;
		/** Stop execution if there's only 1 page */
		if( $max_pages <= 1 )
			return;

		$paged = $paged ? absint( $paged ) : 1;
		$max   = intval( $max_pages );

		/** Add current page to the array */
		if ( $paged >= 1 )
			$links[] = $paged;

		/** Add the pages around the current page to the array */
		if ( $paged >= 3 ) {
			$links[] = $paged - 1;
			$links[] = $paged - 2;
		}

		if ( ( $paged + 2 ) <= $max ) {
			$links[] = $paged + 2;
			$links[] = $paged + 1;
		}
		$pagination_layout = get_option('blogsqode_pagination_layout');
		echo '<div class="blogsqode-navigation blogsqode-navigation1 paginate-layout-'.esc_attr($pagination_layout).'"><ul>' . "\n";

		/** Previous Post Link */
		if ( $paged > 1 ){
			printf( '<li><a class="blogsqode_previous_link" href="%s"><span class=%s></span></a></li>' . "\n",  esc_url( get_pagenum_link( $paged-1 ) ), esc_attr($l_class));
		}

		/** Link to first page, plus ellipses if necessary */
		if ( ! in_array( 1, $links ) ) {
			$class = 1 == $paged ? ' class=active' : '';

			printf( '<li%s><a href="%s"><span class=%s></span> %s</a></li>' . "\n", esc_attr($class), esc_url( get_pagenum_link( 1 ) ),esc_attr($l_class), esc_html__('1', 'blogsqode') );

			if ( ! in_array( 2, $links ) )
				echo '<li>…</li>';
		}

		/** Link to current page, plus 2 pages in either direction if necessary */
		sort( $links );
		foreach ( (array) $links as $link ) {
			$class = $paged == $link ? ' class=active' : '';
			printf( '<li%s><a href="%s"><span class=%s></span> %s</a></li>' . "\n", esc_attr($class), esc_url( get_pagenum_link( $link ) ),esc_attr($l_class), esc_html__($link, 'blogsqode') );
		}

		/** Link to last page, plus ellipses if necessary */
		if ( ! in_array( $max, $links ) ) {
			if ( ! in_array( $max - 1, $links ) )
				echo '<li>…</li>' . "\n";

			$class = $paged == $max ? ' class=active' : '';
			printf( '<li%s><a href="%s"><span class=%s></span> %s</a></li>' . "\n", esc_attr($class), esc_url( get_pagenum_link( $max ) ),esc_attr($l_class), esc_html__($max, 'blogsqode') );
		}

		/** Next Post Link */
		if($paged < $max){
			printf( '<li><a class="blogsqode_next_link" href="%s"><span class=%s></span></a></li>' . "\n",  esc_url( get_pagenum_link( $paged+1 ) ),esc_attr($l_class) );
		}

		echo '</ul></div>' . "\n";

	}

	/* general layout without sidebar */
	public function blogsqode_setting_arr_func_with_sidebar(){
		$settings = array();
		$settings['blogsqode_dark_mode_with_sidebar']  = esc_attr(get_option('blogsqode_dark_mode_with_sidebar'));
		$blogsqode_post_type_with_sidebar = get_option('blogsqode_post_type_with_sidebar');
		if (is_array($blogsqode_post_type_with_sidebar)) {
			$settings['blogsqode_post_type_with_sidebar'] = implode(',', $blogsqode_post_type_with_sidebar);
		} else {
			$settings['blogsqode_post_type_with_sidebar'] = esc_attr($blogsqode_post_type_with_sidebar);
		}
		$settings['blogsqode_category_filter_options_on_off_with_general'] = esc_attr(get_option('blogsqode_category_filter_options_on_off_with_general'));
		$settings['blogsqode_category_filter_allow_with_sidebar']  = esc_attr(get_option('blogsqode_category_filter_allow_with_sidebar'));
		$settings['blogsqode_blog_post_grid_with_sidebar']  = esc_attr(get_option('blogsqode_blog_post_grid_with_sidebar'));
		$settings['blogsqode_short_desc_allow_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_short_desc_allow_with_sidebar')));
		$settings['blogsqode_auhtor_thumb_allow_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_auhtor_thumb_allow_with_sidebar')));
		$settings['blogsqode_author_name_allow_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_author_name_allow_with_sidebar')));
		$settings['blogsqode_blog_date_allow_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_blog_date_allow_with_sidebar')));
		$settings['blogsqode_comment_count_allow_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_comment_count_allow_with_sidebar')));
		$settings['blogsqode_read_time_allow_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_read_time_allow_with_sidebar')));
		$settings['blogsqode_category_allow_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_category_allow_with_sidebar')));
		$settings['blogsqode_read_more_btn_allow_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_read_more_btn_allow_with_sidebar')));
		$settings['blogsqode_read_more_button_layout']  = esc_attr(get_option('blogsqode_read_more_button_layout'));
		$settings['coming_soon_layout_bg_color_with_sidebar']  = esc_attr(get_option('coming_soon_layout_bg_color_with_sidebar'));
		return $settings;
	}

	public function blogsqode_with_sidebar_views($atts){

		if ( ! isset( $atts['layout'] ) ) {
			return '<p>The layout attribute is required for the [blogsqode_blog_list] shortcode.</p>';
		}
		$atts = shortcode_atts( array(
            'layout' => 1, 
        ), $atts );
		$layout = isset($atts['layout']) ? $atts['layout'] : 1;

		ob_start();
	 	$settings = self::blogsqode_setting_arr_func_with_sidebar();
		$bg_color = $settings['coming_soon_layout_bg_color_with_sidebar'];
		?>
		<script>
			document.documentElement.style.setProperty('--secondary-bg-color', '<?php echo $bg_color; ?>');
		</script>
		
		<?php 
		$category_id = isset($_POST['category']) ? intval($_POST['category']) : 0;
	 	$posts_per_page = (esc_attr(get_option('blogsqode_blogs_per_page_with_sidebar')))?:12;
	 	$intpostperpage = (int) filter_var($posts_per_page, FILTER_SANITIZE_NUMBER_INT); 
		$paged = (int) filter_var(self::blogsqode_paged(), FILTER_SANITIZE_NUMBER_INT);  
		$selected_category  = get_option('blogsqode_category_filter_options_with_sidebar');
		$pagination_type = (esc_attr(get_option('blogsqode_blog_pagination_option_with_sidebar'))) ?: 'pagination';
	 	$args           = array(
			'post_type' => get_option('blogsqode_post_type_with_sidebar', 'post'),
			'posts_per_page' => $intpostperpage,
	 		'paged'          => $paged,
	 		'orderby'        => 'date',
	 		'order'          => 'DESC',
	 	);
	
		global $with_sidebar;
		$layout_class = $with_sidebar ? '2' : esc_attr(get_option($settings['blogsqode_blog_post_grid_with_sidebar']));
		$category_tab_enabled_with_sidebar = get_option('blogsqode_category_filter_options_on_off_with_general');
		if ($category_tab_enabled_with_sidebar === "Unable" && $pagination_type === 'load_more_button') {
			$selected_post_types = get_option('blogsqode_post_type_with_sidebar', array('post'));
			$post_types = get_post_types(array('public' => true), 'objects');

			echo '<div id="category-filter" class="category-general-filter category-filter-all slick-slider">';
				echo '<a id="mix" class="category-name active filter-btn-load-btn-tab-on cat-name-active" data-category-id="" data-layout="' . esc_attr($layout) . '" data-filter=".mix">All</a>';
					$selected_categories = get_option('blogsqode_category_filter_options_with_sidebar', array());
					foreach ($post_types as $post_type) {
						if ($post_type->name !== 'attachment' && in_array($post_type->name, $selected_post_types)) {
							$taxonomies = get_object_taxonomies($post_type->name);
							if (!empty($taxonomies)) {
								foreach ($taxonomies as $taxonomy) {
									$categories = get_terms(array(
										'taxonomy'   => $taxonomy,
										'hide_empty' => false,
										'include'    => $selected_categories, 
									));
									foreach ($categories as $category) {
										echo '<a id="' . $category->slug . '" class="category-name filter-btn-load-btn-tab-on" data-category-id="' . $category->term_id . '" data-layout="' . esc_attr($layout) . '" data-post-type="' . esc_attr($post_type->name) . '" data-filter=".' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</a>';
									}
								}
							}
						}
					}
			echo '</div>';				
	
			$selected_post_types = get_option('blogsqode_post_type_with_sidebar', 'post');
			$selected_categories = get_option('blogsqode_category_filter_options_with_sidebar');
			
			if (!empty($selected_categories) && !empty($selected_post_types)) {
				$tax_query = array('relation' => 'OR'); 
				foreach ($selected_categories as $category_id) {
					foreach ($selected_post_types as $post_type) {
						$post_type_taxonomies = get_object_taxonomies($post_type);
						if (!empty($post_type_taxonomies)) {
							foreach ($post_type_taxonomies as $taxonomy) {
								$category = get_term($category_id, $taxonomy);
								if (!is_wp_error($category) && $category !== null) {
									$tax_query[] = array(
										'taxonomy' => $taxonomy,
										'field'    => 'term_id',
										'terms'    => $category_id,
									);
								}
							}
						}
					}
				}
				$paged = get_query_var('paged') ? get_query_var('paged') : 1;
				$args = array(
					'post_type'      => $selected_post_types,
					'posts_per_page' => -1,
					'paged'          => $paged,
					'orderby'        => 'date',
					'order'          => 'DESC',
					'tax_query'      => $tax_query,
				);
		

			$loop = new WP_Query($args);
			$max_num_pages = $loop->max_num_pages;
			$pagination_type           = (esc_attr(get_option('blogsqode_blog_pagination_option_with_sidebar'))) ?: 'pagination';
			if ($loop->have_posts()) {
				echo '<div class="blogsqode-blog-wrap blog-listing blog-listing-with-sidebar blog-listing-load-more-on">';
					echo '<div class="blog-listing-with-sidebar-views blog-listing-inner blog-listing-inners selected-layout category-' . $category_id . ' layout-' . esc_attr($layout) . ' post-grid-2">';
						while ($loop->have_posts()) : 
							$loop->the_post();
							$post_id = get_the_ID();
							if ($layout === '1') {
								echo $this->layout_one($settings, $layout);
							} elseif ($layout === '2' || $layout === '3') {
								echo $this->layout_two($settings, $layout);
							} elseif ($layout === '4') {
								echo $this->layout_four($settings, $layout);
							} elseif ($layout === '5') {
								echo $this->layout_five($settings, $layout);
							} elseif ($layout === '6') {
								echo $this->layout_six($settings, $layout);
							} elseif ($layout === '7') {
								echo $this->layout_seven($settings, $layout);
							} elseif ($layout === '8') {
								echo $this->layout_eight($settings, $layout);
							} elseif ($layout === '9') {
								echo $this->layout_nine($settings, $layout);
							} elseif ($layout === '10') {
								echo $this->layout_ten($settings, $layout);
							} elseif ($layout === '11') {
								echo $this->layout_eleven($settings, $layout);
							} elseif ($layout === '12') {
								echo $this->layout_twelve($settings, $layout);
							} elseif ($layout === '13') {
								echo $this->layout_thirteen($settings, $layout);
							} elseif ($layout === '14') {
								echo $this->layout_fourteen($settings, $layout);
							} elseif ($layout === '15') {
								echo $this->layout_fifteen($settings, $layout);
							} elseif ($layout === '16') {
								echo $this->layout_sixteen($settings, $layout);
							} elseif ($layout === '17') {
								echo $this->layout_seventeen($settings, $layout);
							} elseif ($layout === '18') {
								echo $this->layout_eighteen($settings, $layout);
							} elseif ($layout === '19') {
								echo $this->layout_nineteen($settings, $layout);
							} elseif ($layout === '20') {
								echo $this->layout_twenty($settings, $layout);
							} elseif ($layout === '21') {
								echo $this->layout_twentyone($settings, $layout);
							} elseif ($layout === '22') {
								echo $this->layout_twentytwo($settings, $layout);
							} elseif ($layout === '23') {
								echo $this->layout_twentythree($settings, $layout);
							} elseif ($layout === '24') {
								echo $this->layout_twentyfour($settings, $layout);
							} elseif ($layout === '25') {
								echo $this->layout_twentyfive($settings, $layout);
							} elseif ($layout === '26') {
								echo $this->layout_twentysix($settings, $layout);
							} elseif ($layout === '27') {
								echo $this->layout_twentyseven($settings, $layout);
							} elseif ($layout === '28') {
								echo $this->layout_twentyeight($settings, $layout);
							} elseif ($layout === '29') {
								echo $this->layout_twentynine($settings, $layout);
							} elseif ($layout === '30') {
								echo $this->layout_thirty($settings, $layout);
							}
						endwhile;
						wp_reset_query();
					echo '</div>';
				echo '</div>';		
					}	
			}
		}
		if ($category_tab_enabled_with_sidebar === "Disable" && $pagination_type === 'load_more_button') {	
			$loop = new WP_Query($args);
				$max_num_pages = $loop->max_num_pages;
				$pagination_type           = (esc_attr(get_option('blogsqode_blog_pagination_option_with_sidebar'))) ?: 'pagination';
				if ($loop->have_posts()) {
					echo '<div class="blogsqode-blog-wrap blog-listing blog-listing-with-sidebar blog-listing-first">';
						echo '<div class="blog-listing-inner blog-listing-inners selected-layout layout-' . esc_attr($layout) . ' post-grid-2">';
							while ($loop->have_posts()) : 
								$loop->the_post();
								$post_id = get_the_ID();
								if ($layout === '1') {
									echo $this->layout_one($settings, $layout);
								} elseif ($layout === '2' || $layout === '3') {
									echo $this->layout_two($settings, $layout);
								} elseif ($layout === '4') {
									echo $this->layout_four($settings, $layout);
								} elseif ($layout === '5') {
									echo $this->layout_five($settings, $layout);
								} elseif ($layout === '6') {
									echo $this->layout_six($settings, $layout);
								} elseif ($layout === '7') {
									echo $this->layout_seven($settings, $layout);
								} elseif ($layout === '8') {
									echo $this->layout_eight($settings, $layout);
								} elseif ($layout === '9') {
									echo $this->layout_nine($settings, $layout);
								} elseif ($layout === '10') {
									echo $this->layout_ten($settings, $layout);
								} elseif ($layout === '11') {
									echo $this->layout_eleven($settings, $layout);
								} elseif ($layout === '12') {
									echo $this->layout_twelve($settings, $layout);
								} elseif ($layout === '13') {
									echo $this->layout_thirteen($settings, $layout);
								} elseif ($layout === '14') {
									echo $this->layout_fourteen($settings, $layout);
								} elseif ($layout === '15') {
									echo $this->layout_fifteen($settings, $layout);
								} elseif ($layout === '16') {
									echo $this->layout_sixteen($settings, $layout);
								} elseif ($layout === '17') {
									echo $this->layout_seventeen($settings, $layout);
								} elseif ($layout === '18') {
									echo $this->layout_eighteen($settings, $layout);
								} elseif ($layout === '19') {
									echo $this->layout_nineteen($settings, $layout);
								} elseif ($layout === '20') {
									echo $this->layout_twenty($settings, $layout);
								} elseif ($layout === '21') {
									echo $this->layout_twentyone($settings, $layout);
								} elseif ($layout === '22') {
									echo $this->layout_twentytwo($settings, $layout);
								} elseif ($layout === '23') {
									echo $this->layout_twentythree($settings, $layout);
								} elseif ($layout === '24') {
									echo $this->layout_twentyfour($settings, $layout);
								} elseif ($layout === '25') {
									echo $this->layout_twentyfive($settings, $layout);
								} elseif ($layout === '26') {
									echo $this->layout_twentysix($settings, $layout);
								} elseif ($layout === '27') {
									echo $this->layout_twentyseven($settings, $layout);
								} elseif ($layout === '28') {
									echo $this->layout_twentyeight($settings, $layout);
								} elseif ($layout === '29') {
									echo $this->layout_twentynine($settings, $layout);
								} elseif ($layout === '30') {
									echo $this->layout_thirty($settings, $layout);
								}
							endwhile;
							wp_reset_query();
						echo '</div>';
					echo '</div>';			
				}
		}
		if ($category_tab_enabled_with_sidebar === "Unable" && $pagination_type === 'pagination') {
			$selected_post_types = get_option('blogsqode_post_type_with_sidebar', array('post'));
			$post_types = get_post_types(array('public' => true), 'objects');
			echo '<div id="category-filter cat-fil-2" class="category-general-filter category-filter-tab category-filter-all slick-slider">';
				echo '<a class="category-name filter filter-btn filter-btn-pag-tab-on cat-name-active" data-category-id="" data-layout="' . esc_attr($layout) . '" data-filter="all">All</a>';
					$selected_categories = get_option('blogsqode_category_filter_options_with_sidebar', array());
					foreach ($post_types as $post_type) {
						if ($post_type->name !== 'attachment' && in_array($post_type->name, $selected_post_types)) {
							$taxonomies = get_object_taxonomies($post_type->name);
							if (!empty($taxonomies)) {
								foreach ($taxonomies as $taxonomy) {
									$categories = get_terms(array(
										'taxonomy'   => $taxonomy,
										'hide_empty' => false,
										'include'    => $selected_categories, 
									));
									foreach ($categories as $category) {
										echo '<a class="category-name filter filter-btn filter-btn-pag-tab-on" data-category-id="' . $category->term_id . '" data-layout="' . esc_attr($layout) . '" data-post-type="' . esc_attr($post_type->name) . '" data-filter=".' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</a>';
									}
								}
							}
						}
					}
			echo '</div>';				
			$selected_categories = get_option('blogsqode_category_filter_options_with_sidebar');
			if (!empty($selected_categories)) {
				?>
				<div class="blogsqode-blog-wrap blog-listing blog-listing-with-sidebar blog-listing-first">
				<?php
					echo '<div id="blog-with-sidebar" class="blog-listing-inner blog-listing-inners selected-layout category-' . $category_id . ' layout-' . esc_attr($layout) . ' post-grid-2">';			
					foreach ($selected_categories as $category_id) {
						$post_type = get_option('blogsqode_post_type_with_sidebar', 'post');
						$post_type_taxonomies = get_object_taxonomies($post_type);
						$args = array(
							'post_type' => $post_type,
							'orderby'   => 'date',
							'order'     => 'DESC',
							'tax_query' => array(),
						);
						if (!empty($post_type_taxonomies)) {
							foreach ($post_type_taxonomies as $taxonomy) {
								$category = get_term($category_id, $taxonomy);
								if (!is_wp_error($category) && $category !== null) {
									$args['tax_query'][] = array(
										'taxonomy' => $taxonomy,
										'field'    => 'term_id',
										'terms'    => $category_id,
									);
									$loop = new WP_Query($args);
									if ($loop->have_posts()) {
										while ($loop->have_posts()) :
										$loop->the_post();
										$post_id = get_the_ID();
										if ($layout === '1') {
											echo $this->layout_one($settings, $layout);
										} elseif ($layout === '2' || $layout === '3') {
											echo $this->layout_two($settings, $layout);
										} elseif ($layout === '4') {
											echo $this->layout_four($settings, $layout);
										} elseif ($layout === '5') {
											echo $this->layout_five($settings, $layout);
										} elseif ($layout === '6') {
											echo $this->layout_six($settings, $layout);
										} elseif ($layout === '7') {
											echo $this->layout_seven($settings, $layout);
										} elseif ($layout === '8') {
											echo $this->layout_eight($settings, $layout);
										} elseif ($layout === '9') {
											echo $this->layout_nine($settings, $layout);
										} elseif ($layout === '10') {
											echo $this->layout_ten($settings, $layout);
										} elseif ($layout === '11') {
											echo $this->layout_eleven($settings, $layout);
										} elseif ($layout === '12') {
											echo $this->layout_twelve($settings, $layout);
										} elseif ($layout === '13') {
											echo $this->layout_thirteen($settings, $layout);
										} elseif ($layout === '14') {
											echo $this->layout_fourteen($settings, $layout);
										} elseif ($layout === '15') {
											echo $this->layout_fifteen($settings, $layout);
										} elseif ($layout === '16') {
											echo $this->layout_sixteen($settings, $layout);
										} elseif ($layout === '17') {
											echo $this->layout_seventeen($settings, $layout);
										} elseif ($layout === '18') {
											echo $this->layout_eighteen($settings, $layout);
										} elseif ($layout === '19') {
											echo $this->layout_nineteen($settings, $layout);
										} elseif ($layout === '20') {
											echo $this->layout_twenty($settings, $layout);
										} elseif ($layout === '21') {
											echo $this->layout_twentyone($settings, $layout);
										} elseif ($layout === '22') {
											echo $this->layout_twentytwo($settings, $layout);
										} elseif ($layout === '23') {
											echo $this->layout_twentythree($settings, $layout);
										} elseif ($layout === '24') {
											echo $this->layout_twentyfour($settings, $layout);
										} elseif ($layout === '25') {
											echo $this->layout_twentyfive($settings, $layout);
										} elseif ($layout === '26') {
											echo $this->layout_twentysix($settings, $layout);
										} elseif ($layout === '27') {
											echo $this->layout_twentyseven($settings, $layout);
										} elseif ($layout === '28') {
											echo $this->layout_twentyeight($settings, $layout);
										} elseif ($layout === '29') {
											echo $this->layout_twentynine($settings, $layout);
										} elseif ($layout === '30') {
											echo $this->layout_thirty($settings, $layout);
										}
										endwhile;
										wp_reset_postdata();
									}		
								}
							}
						}
					}
					echo '</div>';
				echo '</div>';
			}			
				?>
					<div id="pagination2" class="pagination blogsqode-navigation pagination-with-tab"></div>
				<?php
		}
		if ($category_tab_enabled_with_sidebar === "Disable" && $pagination_type === 'pagination') {	
				$loop = new WP_Query($args);
					$max_num_pages = $loop->max_num_pages;
					$pagination_type           = (esc_attr(get_option('blogsqode_blog_pagination_option_with_sidebar'))) ?: 'pagination';
					if ($loop->have_posts()) {
						echo '<div class="blogsqode-blog-wrap blog-listing blog-listing-with-sidebar blog-listing-first">';
							echo '<div class="blog-listing-inner blog-listing-inners selected-layout layout-' . esc_attr($layout) . ' post-grid-2">';
								while ($loop->have_posts()) : 
									$loop->the_post();
									$post_id = get_the_ID();
									if ($layout === '1') {
										echo $this->layout_one($settings, $layout);
									} elseif ($layout === '2' || $layout === '3') {
										echo $this->layout_two($settings, $layout);
									} elseif ($layout === '4') {
										echo $this->layout_four($settings, $layout);
									} elseif ($layout === '5') {
										echo $this->layout_five($settings, $layout);
									} elseif ($layout === '6') {
										echo $this->layout_six($settings, $layout);
									} elseif ($layout === '7') {
										echo $this->layout_seven($settings, $layout);
									} elseif ($layout === '8') {
										echo $this->layout_eight($settings, $layout);
									} elseif ($layout === '9') {
										echo $this->layout_nine($settings, $layout);
									} elseif ($layout === '10') {
										echo $this->layout_ten($settings, $layout);
									} elseif ($layout === '11') {
										echo $this->layout_eleven($settings, $layout);
									} elseif ($layout === '12') {
										echo $this->layout_twelve($settings, $layout);
									} elseif ($layout === '13') {
										echo $this->layout_thirteen($settings, $layout);
									} elseif ($layout === '14') {
										echo $this->layout_fourteen($settings, $layout);
									} elseif ($layout === '15') {
										echo $this->layout_fifteen($settings, $layout);
									} elseif ($layout === '16') {
										echo $this->layout_sixteen($settings, $layout);
									} elseif ($layout === '17') {
										echo $this->layout_seventeen($settings, $layout);
									} elseif ($layout === '18') {
										echo $this->layout_eighteen($settings, $layout);
									} elseif ($layout === '19') {
										echo $this->layout_nineteen($settings, $layout);
									} elseif ($layout === '20') {
										echo $this->layout_twenty($settings, $layout);
									} elseif ($layout === '21') {
										echo $this->layout_twentyone($settings, $layout);
									} elseif ($layout === '22') {
										echo $this->layout_twentytwo($settings, $layout);
									} elseif ($layout === '23') {
										echo $this->layout_twentythree($settings, $layout);
									} elseif ($layout === '24') {
										echo $this->layout_twentyfour($settings, $layout);
									} elseif ($layout === '25') {
										echo $this->layout_twentyfive($settings, $layout);
									} elseif ($layout === '26') {
										echo $this->layout_twentysix($settings, $layout);
									} elseif ($layout === '27') {
										echo $this->layout_twentyseven($settings, $layout);
									} elseif ($layout === '28') {
										echo $this->layout_twentyeight($settings, $layout);
									} elseif ($layout === '29') {
										echo $this->layout_twentynine($settings, $layout);
									} elseif ($layout === '30') {
										echo $this->layout_thirty($settings, $layout);
									}
								endwhile;
								wp_reset_query();
							echo '</div>';
						echo '</div>';			
					}
		}
		if($pagination_type === 'pagination' && $category_tab_enabled_with_sidebar === "Disable"){
			echo self::blogsqode_numeric_posts_nav_with_sidebar($max_num_pages,$paged);
		}
		elseif($category_tab_enabled_with_sidebar === "Unable" && $pagination_type === 'load_more_button'){
			echo '<div class="load_more_posts_with_sidebar1" data-layout="' . esc_attr($layout) . '" data-pages="'.esc_attr($max_num_pages).'">'.esc_html__("Load More", "blogsqode").'</div>';
		}
		elseif($category_tab_enabled_with_sidebar === "Disable"){
			echo '<div class="load_more_posts_with_sidebar3" data-layout="' . esc_attr($layout) . '" data-pages="'.esc_attr($max_num_pages).'">'.esc_html__("Load More", "blogsqode").'</div>';
		}	
		$content = ob_get_clean();
		return $content;
	}
	
	public static function blogsqode_numeric_posts_nav_with_sidebar($max_pages, $paged) {
		$paginate = get_option('blogsqode_pagination_layout');
		$l_class = 'paginate'.$paginate;
		/** Stop execution if there's only 1 page */
		if( $max_pages <= 1 )
			return;

		$paged = $paged ? absint( $paged ) : 1;
		$max   = intval( $max_pages );

		/** Add current page to the array */
		if ( $paged >= 1 )
			$links[] = $paged;

		/** Add the pages around the current page to the array */
		if ( $paged >= 3 ) {
			$links[] = $paged - 1;
			$links[] = $paged - 2;
		}

		if ( ( $paged + 2 ) <= $max ) {
			$links[] = $paged + 2;
			$links[] = $paged + 1;
		}
		$pagination_layout = get_option('blogsqode_pagination_layout');
		echo '<div class="blogsqode-navigation blogsqode-navigation-with-sidebar paginate-layout-'.esc_attr($pagination_layout).'"><ul>' . "\n";

		/** Previous Post Link */
		if ( $paged > 1 ){
			printf( '<li><a class="blogsqode_previous_link" href="%s"><span class=%s></span></a></li>' . "\n",  esc_url( get_pagenum_link( $paged-1 ) ), esc_attr($l_class));
		}

		/** Link to first page, plus ellipses if necessary */
		if ( ! in_array( 1, $links ) ) {
			$class = 1 == $paged ? ' class=active' : '';

			printf( '<li%s><a href="%s"><span class=%s></span> %s</a></li>' . "\n", esc_attr($class), esc_url( get_pagenum_link( 1 ) ),esc_attr($l_class), esc_html__('1', 'blogsqode') );

			if ( ! in_array( 2, $links ) )
				echo '<li>…</li>';
		}

		/** Link to current page, plus 2 pages in either direction if necessary */
		sort( $links );
		foreach ( (array) $links as $link ) {
			$class = $paged == $link ? ' class=active' : '';
			printf( '<li%s><a href="%s"><span class=%s></span> %s</a></li>' . "\n", esc_attr($class), esc_url( get_pagenum_link( $link ) ),esc_attr($l_class), esc_html__($link, 'blogsqode') );
		}

		/** Link to last page, plus ellipses if necessary */
		if ( ! in_array( $max, $links ) ) {
			if ( ! in_array( $max - 1, $links ) )
				echo '<li>…</li>' . "\n";

			$class = $paged == $max ? ' class=active' : '';
			printf( '<li%s><a href="%s"><span class=%s></span> %s</a></li>' . "\n", esc_attr($class), esc_url( get_pagenum_link( $max ) ),esc_attr($l_class), esc_html__($max, 'blogsqode') );
		}

		/** Next Post Link */
		if($paged < $max){
			printf( '<li><a class="blogsqode_next_link" href="%s"><span class=%s></span></a></li>' . "\n",  esc_url( get_pagenum_link( $paged+1 ) ),esc_attr($l_class) );
		}

		echo '</ul></div>' . "\n";

	}

	/* blogsqode views ajax with sidebar */
	public function blogsqode_views_ajax_with_sidebar_pag_tab_on(){
		$settings = self::blogsqode_setting_arr_func_with_sidebar();
		$posts_per_page = (esc_attr(get_option('blogsqode_blogs_per_page_with_sidebar')))?:12;
		$intpostperpage = (int) filter_var($posts_per_page, FILTER_SANITIZE_NUMBER_INT);
		$paged = (int) filter_var($_POST['page'], FILTER_SANITIZE_NUMBER_INT);
		$layout = $_POST['layout'];
		$post_type = get_option('blogsqode_post_type_with_sidebar', 'post');
		$category_id = isset($_POST['category']) ? intval($_POST['category']) : 0;
		$args = array(
			'post_type' => $post_type,
			'posts_per_page' => $intpostperpage,
			'paged'          => $paged,
			'orderby'        => 'date',
			'order'          => 'DESC',
			
		);
		$category_tab_enabled = get_option('blogsqode_category_filter_options_on_off_with_general');
		$category_filter_enabled = esc_attr(get_option('blogsqode_category_filter_allow_with_sidebar'));
			$taxonomies = get_object_taxonomies($post_type);
			if ($category_id !== 0 && !empty($taxonomies)) {
				$tax_query = array('relation' => 'OR');
				foreach ($taxonomies as $taxonomy) {
					$tax_query[] = array(
						'taxonomy' => $taxonomy,
						'field'    => 'term_id',
						'terms'    => $category_id,
					);
				}
				$args['tax_query'] = $tax_query;
			}
		$loop = new WP_Query($args);
		$max_num_pages = $loop->max_num_pages;
		$output = '';
		$output .= '<div class="blog-listing-inner blog-listing-inners">';
		if ($loop->have_posts()) {
			while ( $loop->have_posts() ) :
				$loop->the_post();
				$post_id = get_the_ID();
				if($layout === '1'){
					$output .= $this->layout_one($settings, $layout);							
				} else if($layout === '2' || $layout === '3'){
					$output .= $this->layout_two($settings, $layout);							
				} else if($layout === '4'){
					$output .= $this->layout_four($settings, $layout);
				} else if($layout === '5'){
					$output .= $this->layout_five($settings, $layout);
				}else if($layout === '6'){
					$output .= $this->layout_six($settings, $layout);
				}else if($layout === '7'){
					$output .= $this->layout_seven($settings, $layout);
				}else if($layout === '8'){
					$output .= $this->layout_eight($settings, $layout);
				}else if($layout === '9'){
					$output .= $this->layout_nine($settings, $layout);
				}else if($layout === '10'){
					$output .= $this->layout_ten($settings, $layout);
				}else if($layout === '11'){
					$output .= $this->layout_eleven($settings, $layout);
				}else if($layout === '12'){
					$output .= $this->layout_twelve($settings, $layout);
				} else if($layout === '13'){
					$output .= $this->layout_thirteen($settings, $layout);
				} else if($layout === '14'){
					$output .= $this->layout_fourteen($settings, $layout);
				} else if($layout === '15'){
					$output .= $this->layout_fifteen($settings, $layout);
				} else if($layout === '16'){
					$output .= $this->layout_sixteen($settings, $layout);
				} else if($layout === '17'){
					$output .= $this->layout_seventeen($settings, $layout);
				} else if($layout === '18'){
					$output .= $this->layout_eighteen($settings, $layout);
				} else if($layout === '19'){
					$output .= $this->layout_nineteen($settings, $layout);
				} else if($layout === '20'){
					$output .= $this->layout_twenty($settings, $layout);
				} else if($layout === '21'){
					$output .= $this->layout_twentyone($settings, $layout);
				} else if($layout === '22'){
					$output .= $this->layout_twentytwo($settings, $layout);
				} else if($layout === '23'){
					$output .= $this->layout_twentythree($settings, $layout);
				} else if($layout === '24'){
					$output .= $this->layout_twentyfour($settings, $layout);
				} else if($layout === '25'){
					$output .= $this->layout_twentyfive($settings, $layout);
				} else if($layout === '26'){
					$output .= $this->layout_twentysix($settings, $layout);
				} else if($layout === '27'){
					$output .= $this->layout_twentyseven($settings, $layout);
				} else if($layout === '28'){
					$output .= $this->layout_twentyeight($settings, $layout);
				} else if($layout === '29'){
					$output .= $this->layout_twentynine($settings, $layout);
				} else if($layout === '30'){
					$output .= $this->layout_thirty($settings, $layout);
				}
			endwhile;
		}
		wp_reset_postdata();
		wp_reset_query();
		$output .= '</div>';
		$maxPage = $loop->max_num_pages;
		die(json_encode(array('output' => $output, 'maxPage' => $maxPage, 'categoryID' => $category_id)));
	}

	/* load more work when category tab bar off */
	public function blogsqode_views_ajax_loadmore_with_sidebar_tab_off(){
		$settings = self::blogsqode_setting_arr_func_with_sidebar();
		$posts_per_page = (esc_attr(get_option('blogsqode_blogs_per_page_with_sidebar')))?:12;
		$intpostperpage = (int) filter_var($posts_per_page, FILTER_SANITIZE_NUMBER_INT);
		$paged = (int) filter_var($_POST['page'], FILTER_SANITIZE_NUMBER_INT);
		$layout = $_POST['layout'];
		$post_type = get_option('blogsqode_post_type_with_sidebar', 'post');
		$category_id = isset($_POST['category']) ? intval($_POST['category']) : 0;
		$args = array(
			'post_type' => $post_type,
			'posts_per_page' => $intpostperpage,
			'paged'          => $paged,
			'orderby'        => 'date',
			'order'          => 'DESC',	
		);
		$category_tab_enabled = get_option('blogsqode_category_filter_options_on_off_with_general');
		$category_filter_enabled = esc_attr(get_option('blogsqode_category_filter_allow_with_sidebar'));
		if($category_tab_enabled === 'Unable' || $category_filter_enabled === "Disable" ||  $category_filter_enabled === "Unable"){
			$taxonomies = get_object_taxonomies($post_type);
			if ($category_id !== 0 && !empty($taxonomies)) {
				$tax_query = array('relation' => 'OR');
				foreach ($taxonomies as $taxonomy) {
					$tax_query[] = array(
						'taxonomy' => $taxonomy,
						'field'    => 'term_id',
						'terms'    => $category_id,
					);
				}
				$args['tax_query'] = $tax_query;
			}
		}
		$loop = new WP_Query($args);
		$max_num_pages = $loop->max_num_pages;
		$output = '';
		$output .= '<div class="blog-listing-inner blog-listing-inners">';
		if ($loop->have_posts()) {
			while ( $loop->have_posts() ) :
				$loop->the_post();
				$post_id = get_the_ID();
				if($layout === '1'){
					$output .= $this->layout_one($settings, $layout);							
				} else if($layout === '2' || $layout === '3'){
					$output .= $this->layout_two($settings, $layout);							
				} else if($layout === '4'){
					$output .= $this->layout_four($settings, $layout);
				} else if($layout === '5'){
					$output .= $this->layout_five($settings, $layout);
				}else if($layout === '6'){
					$output .= $this->layout_six($settings, $layout);
				}else if($layout === '7'){
					$output .= $this->layout_seven($settings, $layout);
				}else if($layout === '8'){
					$output .= $this->layout_eight($settings, $layout);
				}else if($layout === '9'){
					$output .= $this->layout_nine($settings, $layout);
				}else if($layout === '10'){
					$output .= $this->layout_ten($settings, $layout);
				}else if($layout === '11'){
					$output .= $this->layout_eleven($settings, $layout);
				}else if($layout === '12'){
					$output .= $this->layout_twelve($settings, $layout);
				} else if($layout === '13'){
					$output .= $this->layout_thirteen($settings, $layout);
				} else if($layout === '14'){
					$output .= $this->layout_fourteen($settings, $layout);
				} else if($layout === '15'){
					$output .= $this->layout_fifteen($settings, $layout);
				} else if($layout === '16'){
					$output .= $this->layout_sixteen($settings, $layout);
				} else if($layout === '17'){
					$output .= $this->layout_seventeen($settings, $layout);
				} else if($layout === '18'){
					$output .= $this->layout_eighteen($settings, $layout);
				} else if($layout === '19'){
					$output .= $this->layout_nineteen($settings, $layout);
				} else if($layout === '20'){
					$output .= $this->layout_twenty($settings, $layout);
				} else if($layout === '21'){
					$output .= $this->layout_twentyone($settings, $layout);
				} else if($layout === '22'){
					$output .= $this->layout_twentytwo($settings, $layout);
				} else if($layout === '23'){
					$output .= $this->layout_twentythree($settings, $layout);
				} else if($layout === '24'){
					$output .= $this->layout_twentyfour($settings, $layout);
				} else if($layout === '25'){
					$output .= $this->layout_twentyfive($settings, $layout);
				} else if($layout === '26'){
					$output .= $this->layout_twentysix($settings, $layout);
				} else if($layout === '27'){
					$output .= $this->layout_twentyseven($settings, $layout);
				} else if($layout === '28'){
					$output .= $this->layout_twentyeight($settings, $layout);
				} else if($layout === '29'){
					$output .= $this->layout_twentynine($settings, $layout);
				} else if($layout === '30'){
					$output .= $this->layout_thirty($settings, $layout);
				}
			endwhile;
		}
		wp_reset_postdata();
		wp_reset_query();
		$output .= '</div>';
		die($output);
	}

	/* blogsqode views ajax */
	public function blogsqode_views_ajax(){
			$settings = self::blogsqode_setting_arr_func();
			$posts_per_page = (esc_attr(get_option('blogsqode_blogs_per_page')))?:'12';
			$intpostperpage = (int) filter_var($posts_per_page, FILTER_SANITIZE_NUMBER_INT);  
			$paged = (int) filter_var($_POST['page'], FILTER_SANITIZE_NUMBER_INT);  
			$category_id = isset($_POST['category']) ? intval($_POST['category']) : 0;
			$layout = $_POST['layout']; 
			$args           = array(
				'post_type' => get_option('blogsqode_post_type', 'post'),
				'posts_per_page' => $intpostperpage,
				'paged'          => $paged,
				'orderby'        => 'date',
				'order'          => 'DESC',
			);
			$category_tab_enabled = get_option('blogsqode_category_filter_options_on_off');
			$category_filter_enabled = esc_attr(get_option('blogsqode_category_filter_allow'));
				$taxonomies = get_object_taxonomies($post_type);
				if ($category_id !== 0 && !empty($taxonomies)) {
					$tax_query = array('relation' => 'OR');
					foreach ($taxonomies as $taxonomy) {
						$tax_query[] = array(
							'taxonomy' => $taxonomy,
							'field'    => 'term_id',
							'terms'    => $category_id,
						);
					}
					$args['tax_query'] = $tax_query;
				}
			$loop = new WP_Query( $args );
			$max_num_pages = $loop->max_num_pages;
			$output = '';
			$output .= '<div class="blog-listing blog-listing-inner blog-listing-inner-no-sidebar">';
			if ( $loop->have_posts() ) {
				while ( $loop->have_posts() ) :
					$loop->the_post();
					$post_id = get_the_ID();
					if($layout === '1'){
						$output .= $this->layout_one($settings, $layout);							
					} else if($layout === '2' || $layout === '3'){
						$output .= $this->layout_two($settings, $layout);							
					} else if($layout === '4'){
						$output .= $this->layout_four($settings, $layout);
					} else if($layout === '5'){
						$output .= $this->layout_five($settings, $layout);
					}else if($layout === '6'){
						$output .= $this->layout_six($settings, $layout);
					}else if($layout === '7'){
						$output .= $this->layout_seven($settings, $layout);
					}else if($layout === '8'){
						$output .= $this->layout_eight($settings, $layout);
					}else if($layout === '9'){
						$output .= $this->layout_nine($settings, $layout);
					}else if($layout === '10'){
						$output .= $this->layout_ten($settings, $layout);
					}else if($layout === '11'){
						$output .= $this->layout_eleven($settings, $layout);
					}else if($layout === '12'){
						$output .= $this->layout_twelve($settings, $layout);
					} else if($layout === '13'){
						$output .= $this->layout_thirteen($settings, $layout);
					} else if($layout === '14'){
						$output .= $this->layout_fourteen($settings, $layout);
					} else if($layout === '15'){
						$output .= $this->layout_fifteen($settings, $layout);
					} else if($layout === '16'){
						$output .= $this->layout_sixteen($settings, $layout);
					} else if($layout === '17'){
						$output .= $this->layout_seventeen($settings, $layout);
					} else if($layout === '18'){
						$output .= $this->layout_eighteen($settings, $layout);
					} else if($layout === '19'){
						$output .= $this->layout_nineteen($settings, $layout);
					} else if($layout === '20'){
						$output .= $this->layout_twenty($settings, $layout);
					} else if($layout === '21'){
						$output .= $this->layout_twentyone($settings, $layout);
					} else if($layout === '22'){
						$output .= $this->layout_twentytwo($settings, $layout);
					} else if($layout === '23'){
						$output .= $this->layout_twentythree($settings, $layout);
					} else if($layout === '24'){
						$output .= $this->layout_twentyfour($settings, $layout);
					} else if($layout === '25'){
						$output .= $this->layout_twentyfive($settings, $layout);
					} else if($layout === '26'){
						$output .= $this->layout_twentysix($settings, $layout);
					} else if($layout === '27'){
						$output .= $this->layout_twentyseven($settings, $layout);
					} else if($layout === '28'){
						$output .= $this->layout_twentyeight($settings, $layout);
					} else if($layout === '29'){
						$output .= $this->layout_twentynine($settings, $layout);
					} else if($layout === '30'){
						$output .= $this->layout_thirty($settings, $layout);
					}
				endwhile;?>
			<?php 
			}
			wp_reset_postdata();
			wp_reset_query();
			$output .= '</div>';
			die($output);
	}
	
	public function blogsqode_pag_tab_on(){
		$settings = self::blogsqode_setting_arr_func();
		$posts_per_page = (esc_attr(get_option('blogsqode_blogs_per_page')))?:'12';
		$intpostperpage = (int) filter_var($posts_per_page, FILTER_SANITIZE_NUMBER_INT);  
		$paged = (int) filter_var($_POST['page'], FILTER_SANITIZE_NUMBER_INT);  
		$category_id = isset($_POST['category']) ? intval($_POST['category']) : 0;
		$layout = $_POST['layout']; 
		$post_type = get_option('blogsqode_post_type', 'post');
		$args           = array(
			'post_type' => $post_type,
			'posts_per_page' => $intpostperpage,
			'paged'          => $paged,
			'orderby'        => 'date',
			'order'          => 'DESC',
		);
		$category_tab_enabled = get_option('blogsqode_category_filter_options_on_off');
		$category_filter_enabled = esc_attr(get_option('blogsqode_category_filter_allow'));
			$taxonomies = get_object_taxonomies($post_type);
			if ($category_id !== 0 && !empty($taxonomies)) {
				$tax_query = array('relation' => 'OR');
				foreach ($taxonomies as $taxonomy) {
					$tax_query[] = array(
						'taxonomy' => $taxonomy,
						'field'    => 'term_id',
						'terms'    => $category_id,
					);
				}
				$args['tax_query'] = $tax_query;
			}
		$loop = new WP_Query( $args );
		$max_num_pages = $loop->max_num_pages;
		$output = '';
		$output .= '<div class="blog-listing-inner blog-listing-inner-no-sidebar">';
		if ( $loop->have_posts() ) {
			while ( $loop->have_posts() ) :
				$loop->the_post();
				$post_id = get_the_ID();
				if($layout === '1'){
					$output .= $this->layout_one($settings, $layout);							
				} else if($layout === '2' || $layout === '3'){
					$output .= $this->layout_two($settings, $layout);							
				} else if($layout === '4'){
					$output .= $this->layout_four($settings, $layout);
				} else if($layout === '5'){
					$output .= $this->layout_five($settings, $layout);
				}else if($layout === '6'){
					$output .= $this->layout_six($settings, $layout);
				}else if($layout === '7'){
					$output .= $this->layout_seven($settings, $layout);
				}else if($layout === '8'){
					$output .= $this->layout_eight($settings, $layout);
				}else if($layout === '9'){
					$output .= $this->layout_nine($settings, $layout);
				}else if($layout === '10'){
					$output .= $this->layout_ten($settings, $layout);
				}else if($layout === '11'){
					$output .= $this->layout_eleven($settings, $layout);
				}else if($layout === '12'){
					$output .= $this->layout_twelve($settings, $layout);
				} else if($layout === '13'){
					$output .= $this->layout_thirteen($settings, $layout);
				} else if($layout === '14'){
					$output .= $this->layout_fourteen($settings, $layout);
				} else if($layout === '15'){
					$output .= $this->layout_fifteen($settings, $layout);
				} else if($layout === '16'){
					$output .= $this->layout_sixteen($settings, $layout);
				} else if($layout === '17'){
					$output .= $this->layout_seventeen($settings, $layout);
				} else if($layout === '18'){
					$output .= $this->layout_eighteen($settings, $layout);
				} else if($layout === '19'){
					$output .= $this->layout_nineteen($settings, $layout);
				} else if($layout === '20'){
					$output .= $this->layout_twenty($settings, $layout);
				} else if($layout === '21'){
					$output .= $this->layout_twentyone($settings, $layout);
				} else if($layout === '22'){
					$output .= $this->layout_twentytwo($settings, $layout);
				} else if($layout === '23'){
					$output .= $this->layout_twentythree($settings, $layout);
				} else if($layout === '24'){
					$output .= $this->layout_twentyfour($settings, $layout);
				} else if($layout === '25'){
					$output .= $this->layout_twentyfive($settings, $layout);
				} else if($layout === '26'){
					$output .= $this->layout_twentysix($settings, $layout);
				} else if($layout === '27'){
					$output .= $this->layout_twentyseven($settings, $layout);
				} else if($layout === '28'){
					$output .= $this->layout_twentyeight($settings, $layout);
				} else if($layout === '29'){
					$output .= $this->layout_twentynine($settings, $layout);
				} else if($layout === '30'){
					$output .= $this->layout_thirty($settings, $layout);
				}
			endwhile;?>
		<?php 
			}
			wp_reset_postdata();
			wp_reset_query();
			$output .= '</div>';
			$maxPage = $loop->max_num_pages;
			die(json_encode(array('output' => $output, 'maxPage' => $maxPage, 'categoryID' => $category_id)));
	}

	/**
		 * Return page
		 *
		 * @return $paged
	*/

	public static function blogsqode_paged() {
		if ( isset( $_SERVER['REQUEST_URI'] ) || strstr( sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ), 'paged' ) || strstr( sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ), 'page' ) ) {
			if ( isset( $_REQUEST['paged'] ) ) { //phpcs:ignore
				$paged = intval( $_REQUEST['paged'] ); //phpcs:ignore
			} else {
				if ( isset( $_SERVER['REQUEST_URI'] ) ) {
					$uri = explode( '/', sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) ) );
				}
				$uri   = array_reverse( $uri );
				$paged = $uri[1];
			}
		} else {
			$paged = 1;
		}
		/* Pagination issue on home page */
		if ( is_front_page() ) {
			$paged = get_query_var( 'page' ) ? intval( get_query_var( 'page' ) ) : 1;
		} else {
			$paged = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
		}
		return $paged;
	}

	/**
	 * Return page
	 *
	 * @return $paged
	*/
	
	/* slider layout without sidebar */
	public function blogsqode_setting_arr_func_slider_layout(){
		$settings = array();
		$blogsqode_post_type_no_sidebar = get_option('blogsqode_post_type_no_sidebar');
		if (is_array($blogsqode_post_type_no_sidebar)) {
			$settings['blogsqode_post_type_no_sidebar'] = implode(',', $blogsqode_post_type_no_sidebar);
		} else {
			$settings['blogsqode_post_type_no_sidebar'] = esc_attr($blogsqode_post_type_no_sidebar);
		}
		$settings['blogsqode_category_filter_options_on_off_no_sidebar'] = esc_attr(get_option('blogsqode_category_filter_options_on_off_no_sidebar'));
		$settings['blogsqode_dark_mode_for_slider']  = esc_attr(get_option('blogsqode_dark_mode_for_slider'));
		$settings['blogsqode_blog_post_grid']  = esc_attr(get_option('blogsqode_blog_post_grid'));
		$settings['blogsqode_short_desc_allow_slider']  = strtolower(esc_attr(get_option('blogsqode_short_desc_allow_slider')));
		$settings['blogsqode_auhtor_thumb_allow_slider']  = strtolower(esc_attr(get_option('blogsqode_auhtor_thumb_allow_slider')));
		$settings['blogsqode_author_name_allow_slider']  = strtolower(esc_attr(get_option('blogsqode_author_name_allow_slider')));
		$settings['blogsqode_blog_date_allow_slider']  = strtolower(esc_attr(get_option('blogsqode_blog_date_allow_slider')));
		$settings['blogsqode_comment_count_allow_slider']  = strtolower(esc_attr(get_option('blogsqode_comment_count_allow_slider')));
		$settings['blogsqode_read_time_allow_slider']  = strtolower(esc_attr(get_option('blogsqode_read_time_allow_slider')));
		$settings['blogsqode_category_allow_slider']  = strtolower(esc_attr(get_option('blogsqode_category_allow_slider')));
		$settings['blogsqode_read_more_btn_allow_slider']  = strtolower(esc_attr(get_option('blogsqode_read_more_btn_allow_slider')));
		$settings['blogsqode_read_more_button_layout']  = esc_attr(get_option('blogsqode_read_more_button_layout'));
		$settings['coming_soon_slider_layout_bg_color'] = esc_attr(get_option('coming_soon_slider_layout_bg_color'));
		return $settings;
	}

	public function blogsqode_slider_views($atts){

		if ( ! isset( $atts['layout'] ) ) {
			return '<p>The layout attribute is required for the [blogsqode_slider] shortcode.</p>';
		}
		$atts = shortcode_atts( array(
			'layout' => 1, 
		), $atts );
		$layout = isset($atts['layout']) ? $atts['layout'] : 1;
	
		ob_start();
		$settings = self::blogsqode_setting_arr_func_slider_layout();
		$bg_color = $settings['coming_soon_slider_layout_bg_color'];

		?>
		
		<script>
			document.documentElement.style.setProperty('--slider-bg-color', '<?php echo $bg_color; ?>');
		</script>

		<?php
		$paged = (int) filter_var(self::blogsqode_paged(), FILTER_SANITIZE_NUMBER_INT);  
		$post_type_any = get_option('blogsqode_post_type_no_sidebar', 'post');
		$args = array(
			'post_type'     => $post_type_any,
			'paged'         => $paged,
			'orderby'       => 'date',
			'order'         => 'DESC',
		);
		$slider_type = esc_attr(get_option('blogsqode_select_slider_type'));
		$category_filter_enabled = get_option('blogsqode_category_filter_options_on_off_no_sidebar');

		if($category_filter_enabled === 'Unable' && $slider_type === 'General' && $slider_type !== 'Category'){
			if ($category_filter_enabled !== 'Disable') {
				$selected_post_types = get_option('blogsqode_post_type_no_sidebar', array('post'));
				$post_types = get_post_types(array('public' => true), 'objects');
				echo '<div id="category-filter" class="category-slider-filter2 category-multiple-slide category-filter-all slick-slider">';
					echo '<a class="category-name filter-btn cat-name-active" data-category-id="" data-layout="' . esc_attr($layout) . '" data-filter=".mix">All</a>';
					$selected_categories = get_option('blogsqode_category_filter_options_slider', array());
					foreach ($post_types as $post_type) {
						if ($post_type->name !== 'attachment' && in_array($post_type->name, $selected_post_types)) {
							$taxonomies = get_object_taxonomies($post_type->name);
							if (!empty($taxonomies)) {
								foreach ($taxonomies as $taxonomy) {
									$categories = get_terms(array(
										'taxonomy'   => $taxonomy,
										'hide_empty' => false,
									));
									foreach ($categories as $category) {
										if (in_array($category->term_id, $selected_categories)) {
											echo '<a class="category-name filter-btn" data-category-id="' . $category->term_id . '" data-layout="' . esc_attr($layout) . '" data-post-type="' . esc_attr($post_type->name) . '" data-filter=".' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</a>';
										}
									}
								}
							}
						}
					}
				echo '</div>';
			}
		}
		if($category_filter_enabled === 'Unable' && $slider_type === 'Category' && $slider_type !== 'General'){
			if ($category_filter_enabled !== 'Disable') {
				$selected_post_types = get_option('blogsqode_post_type_no_sidebar', array('post'));
				$post_types = get_post_types(array('public' => true), 'objects');
				echo '<div id="category-filter" class="category-slider-filter2 category-multiple-slide category-filter-all slick-slider">';
					echo '<a class="category-name  cat-name-active" data-category-id="" data-layout="' . esc_attr($layout) . '" data-filter=".mix">All</a>';
					$selected_categories = get_option('blogsqode_category_filter_options_slider', array());
					foreach ($post_types as $post_type) {
						if ($post_type->name !== 'attachment' && in_array($post_type->name, $selected_post_types)) {
							$taxonomies = get_object_taxonomies($post_type->name);
							if (!empty($taxonomies)) {
								foreach ($taxonomies as $taxonomy) {
									$categories = get_terms(array(
										'taxonomy'   => $taxonomy,
										'hide_empty' => false,
									));
									foreach ($categories as $category) {
										if (in_array($category->term_id, $selected_categories)) {
											echo '<a class="category-name " data-category-id="' . $category->term_id . '" data-layout="' . esc_attr($layout) . '" data-post-type="' . esc_attr($post_type->name) . '" data-filter=".' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</a>';
										}
									}
								}
							}
						}
					}
				echo '</div>';
			}
		}
		if($category_filter_enabled === 'Disable' && $slider_type === 'General'){
            if ($slider_type === 'General') {
                $loop = new WP_Query($args);
                if ($loop->have_posts()) { ?>
                    <div class="blogsqode-blog-wrap blog-listing-slider blog-slider-layout-bg">
                        <div class="slick-slider blogsqode-slick-slider selected-layout layout-<?php echo esc_attr($layout); ?> post-grid-<?php echo esc_attr($settings['blogsqode_blog_post_grid']); ?>">
                            <?php 
                            while ($loop->have_posts()) :
                                $loop->the_post();
                                $post_id = get_the_ID();
                                if ($layout === '1') {
                                    echo $this->layout_one($settings, $layout);
                                } elseif ($layout === '2' || $layout === '3') {
                                    echo $this->layout_two($settings, $layout);
                                } elseif ($layout === '4') {
                                    echo $this->layout_four($settings, $layout);
                                } elseif ($layout === '5') {
                                    echo $this->layout_five($settings, $layout);
                                } elseif ($layout === '6') {
                                    echo $this->layout_six($settings, $layout);
                                } elseif ($layout === '7') {
                                    echo $this->layout_seven($settings, $layout);
                                } elseif ($layout === '8') {
                                    echo $this->layout_eight($settings, $layout);
                                } elseif ($layout === '9') {
                                    echo $this->layout_nine($settings, $layout);
                                } elseif ($layout === '10') {
                                    echo $this->layout_ten($settings, $layout);
                                } elseif ($layout === '11') {
                                    echo $this->layout_eleven($settings, $layout);
                                } elseif ($layout === '12') {
                                    echo $this->layout_twelve($settings, $layout);
                                } elseif ($layout === '13') {
                                    echo $this->layout_thirteen($settings, $layout);
                                } elseif ($layout === '14') {
                                    echo $this->layout_fourteen($settings, $layout);
                                } elseif ($layout === '15') {
                                    echo $this->layout_fifteen($settings, $layout);
                                } elseif ($layout === '16') {
                                    echo $this->layout_sixteen($settings, $layout);
                                } elseif ($layout === '17') {
                                    echo $this->layout_seventeen($settings, $layout);
                                } elseif ($layout === '18') {
                                    echo $this->layout_eighteen($settings, $layout);
                                } elseif ($layout === '19') {
                                    echo $this->layout_nineteen($settings, $layout);
                                } elseif ($layout === '20') {
                                    echo $this->layout_twenty($settings, $layout);
                                } elseif ($layout === '21') {
                                    echo $this->layout_twentyone($settings, $layout);
                                } elseif ($layout === '22') {
                                    echo $this->layout_twentytwo($settings, $layout);
                                } elseif ($layout === '23') {
                                    echo $this->layout_twentythree($settings, $layout);
                                } elseif ($layout === '24') {
                                    echo $this->layout_twentyfour($settings, $layout);
                                } elseif ($layout === '25') {
                                    echo $this->layout_twentyfive($settings, $layout);
                                } elseif ($layout === '26') {
                                    echo $this->layout_twentysix($settings, $layout);
                                } elseif ($layout === '27') {
                                    echo $this->layout_twentyseven($settings, $layout);
                                } elseif ($layout === '28') {
                                    echo $this->layout_twentyeight($settings, $layout);
                                } elseif ($layout === '29') {
                                    echo $this->layout_twentynine($settings, $layout);
                                } elseif ($layout === '30') {
                                    echo $this->layout_thirty($settings, $layout);
                                }
                            endwhile;
                            wp_reset_postdata();
                            wp_reset_query(); ?>
                        </div>
                    </div>
                <?php }
            }
        }
		elseif ($category_filter_enabled === 'Unable' && $slider_type === 'General') {
			if ($slider_type === 'General') {
				$selected_categories = get_option('blogsqode_category_filter_options_slider');
				if (!empty($selected_categories)) {
					?>
					<div class="blogsqode-blog-wrap blog-listing-slider-1 blog-listing-slider blog-slider-layout-bg ">
						<?php
						echo '<div class="blog-item slick-slider blogsqode-slick-slider blog-slick-slider-with-sidebar2 selected-layout layout-' . esc_attr($layout) . ' post-grid-' . esc_attr($settings['blogsqode_blog_post_grid']) . ' ">';
								foreach ($selected_categories as $category_id) {
									$post_type = get_option('blogsqode_post_type_no_sidebar', 'post');
									$post_type_taxonomies = get_object_taxonomies($post_type);
									$args = array(
										'post_type' => $post_type,
										'orderby'   => 'date',
										'order'     => 'DESC',
										'tax_query' => array(),
									);
									if (!empty($post_type_taxonomies)) {
										foreach ($post_type_taxonomies as $taxonomy) {
											$category = get_term($category_id, $taxonomy);
											if (!is_wp_error($category) && $category !== null) {
												$args['tax_query'][] = array(
													'taxonomy' => $taxonomy,
													'field'    => 'term_id',
													'terms'    => $category_id,
												);
												$loop = new WP_Query($args);
												if ($loop->have_posts()) {
													while ($loop->have_posts()) :
													$loop->the_post();
													$post_id = get_the_ID();
													if ($layout === '1') {
														echo $this->layout_one($settings, $layout);
													} elseif ($layout === '2' || $layout === '3') {
														echo $this->layout_two($settings, $layout);
													} elseif ($layout === '4') {
														echo $this->layout_four($settings, $layout);
													} elseif ($layout === '5') {
														echo $this->layout_five($settings, $layout);
													} elseif ($layout === '6') {
														echo $this->layout_six($settings, $layout);
													} elseif ($layout === '7') {
														echo $this->layout_seven($settings, $layout);
													} elseif ($layout === '8') {
														echo $this->layout_eight($settings, $layout);
													} elseif ($layout === '9') {
														echo $this->layout_nine($settings, $layout);
													} elseif ($layout === '10') {
														echo $this->layout_ten($settings, $layout);
													} elseif ($layout === '11') {
														echo $this->layout_eleven($settings, $layout);
													} elseif ($layout === '12') {
														echo $this->layout_twelve($settings, $layout);
													} elseif ($layout === '13') {
														echo $this->layout_thirteen($settings, $layout);
													} elseif ($layout === '14') {
														echo $this->layout_fourteen($settings, $layout);
													} elseif ($layout === '15') {
														echo $this->layout_fifteen($settings, $layout);
													} elseif ($layout === '16') {
														echo $this->layout_sixteen($settings, $layout);
													} elseif ($layout === '17') {
														echo $this->layout_seventeen($settings, $layout);
													} elseif ($layout === '18') {
														echo $this->layout_eighteen($settings, $layout);
													} elseif ($layout === '19') {
														echo $this->layout_nineteen($settings, $layout);
													} elseif ($layout === '20') {
														echo $this->layout_twenty($settings, $layout);
													} elseif ($layout === '21') {
														echo $this->layout_twentyone($settings, $layout);
													} elseif ($layout === '22') {
														echo $this->layout_twentytwo($settings, $layout);
													} elseif ($layout === '23') {
														echo $this->layout_twentythree($settings, $layout);
													} elseif ($layout === '24') {
														echo $this->layout_twentyfour($settings, $layout);
													} elseif ($layout === '25') {
														echo $this->layout_twentyfive($settings, $layout);
													} elseif ($layout === '26') {
														echo $this->layout_twentysix($settings, $layout);
													} elseif ($layout === '27') {
														echo $this->layout_twentyseven($settings, $layout);
													} elseif ($layout === '28') {
														echo $this->layout_twentyeight($settings, $layout);
													} elseif ($layout === '29') {
														echo $this->layout_twentynine($settings, $layout);
													} elseif ($layout === '30') {
														echo $this->layout_thirty($settings, $layout);
													}
													endwhile;
													wp_reset_postdata();
												}		
											}
										}
									}
								}
						echo '</div>';
					echo '</div>';
				}		
			}						
		}
		elseif($category_filter_enabled === 'Disable' && $slider_type === 'Category'){
			if ($slider_type  === 'Category' && esc_attr(get_option('blogsqode_select_slider_type')) === 'Category') {
				$selected_categories = get_option('blogsqode_category_filter_options_slider');
				if (!empty($selected_categories)) {
					foreach ($selected_categories as $category_id) {
						$post_type = get_option('blogsqode_post_type_no_sidebar', 'post');
						$post_type_taxonomies = get_object_taxonomies($post_type);
						if (!empty($post_type_taxonomies)) {
							foreach ($post_type_taxonomies as $taxonomy) {
								$category = get_term($category_id, $taxonomy);
								if (!is_wp_error($category) && $category !== null) {
									$args['tax_query'] = array(
										array(
											'taxonomy' => $taxonomy,
											'field'    => 'term_id',
											'terms'    => $category_id,
										),
									);
									$loop = new WP_Query($args);
									if ($loop->have_posts()) {
										?>
										<div class="blogsqode-blog-wrap blog-listing-slider blog-slider-layout-bg">
											<div class="slick-slider blogsqode-slick-slider selected-layout layout-<?php echo esc_attr($layout); ?> post-grid-<?php echo esc_attr($settings['blogsqode_blog_post_grid']); ?>">
												<?php
												while ($loop->have_posts()) :
													$loop->the_post();
													$post_id = get_the_ID();
													if ($layout === '1') {
														echo $this->layout_one($settings, $layout);
													} elseif ($layout === '2' || $layout === '3') {
														echo $this->layout_two($settings, $layout);
													} elseif ($layout === '4') {
														echo $this->layout_four($settings, $layout);
													} elseif ($layout === '5') {
														echo $this->layout_five($settings, $layout);
													} elseif ($layout === '6') {
														echo $this->layout_six($settings, $layout);
													} elseif ($layout === '7') {
														echo $this->layout_seven($settings, $layout);
													} elseif ($layout === '8') {
														echo $this->layout_eight($settings, $layout);
													} elseif ($layout === '9') {
														echo $this->layout_nine($settings, $layout);
													} elseif ($layout === '10') {
														echo $this->layout_ten($settings, $layout);
													} elseif ($layout === '11') {
														echo $this->layout_eleven($settings, $layout);
													} elseif ($layout === '12') {
														echo $this->layout_twelve($settings, $layout);
													} elseif ($layout === '13') {
														echo $this->layout_thirteen($settings, $layout);
													} elseif ($layout === '14') {
														echo $this->layout_fourteen($settings, $layout);
													} elseif ($layout === '15') {
														echo $this->layout_fifteen($settings, $layout);
													} elseif ($layout === '16') {
														echo $this->layout_sixteen($settings, $layout);
													} elseif ($layout === '17') {
														echo $this->layout_seventeen($settings, $layout);
													} elseif ($layout === '18') {
														echo $this->layout_eighteen($settings, $layout);
													} elseif ($layout === '19') {
														echo $this->layout_nineteen($settings, $layout);
													} elseif ($layout === '20') {
														echo $this->layout_twenty($settings, $layout);
													} elseif ($layout === '21') {
														echo $this->layout_twentyone($settings, $layout);
													} elseif ($layout === '22') {
														echo $this->layout_twentytwo($settings, $layout);
													} elseif ($layout === '23') {
														echo $this->layout_twentythree($settings, $layout);
													} elseif ($layout === '24') {
														echo $this->layout_twentyfour($settings, $layout);
													} elseif ($layout === '25') {
														echo $this->layout_twentyfive($settings, $layout);
													} elseif ($layout === '26') {
														echo $this->layout_twentysix($settings, $layout);
													} elseif ($layout === '27') {
														echo $this->layout_twentyseven($settings, $layout);
													} elseif ($layout === '28') {
														echo $this->layout_twentyeight($settings, $layout);
													} elseif ($layout === '29') {
														echo $this->layout_twentynine($settings, $layout);
													} elseif ($layout === '30') {
														echo $this->layout_thirty($settings, $layout);
													}
												endwhile;
												wp_reset_postdata();
												wp_reset_query(); ?>
											</div>
										</div>
									<?php
									}
								}
							}
						}
					}
				}
			}
		}
		elseif ($category_filter_enabled === 'Unable' && $slider_type === 'Category') {
			if ($slider_type === 'Category' && esc_attr(get_option('blogsqode_select_slider_type')) === 'Category') {
				$selected_categories = get_option('blogsqode_category_filter_options_slider');
				if (!empty($selected_categories)) {
					foreach ($selected_categories as $category_id) {
						$post_type = get_option('blogsqode_post_type_no_sidebar', 'post');
						$post_type_taxonomies = get_object_taxonomies($post_type);
						$args = array(
							'post_type' => $post_type,
							'orderby'   => 'date',
							'order'     => 'DESC',
							'tax_query' => array(),
						);
						if (!empty($post_type_taxonomies)) {
							foreach ($post_type_taxonomies as $taxonomy) {
								$category = get_term($category_id, $taxonomy);
								if (!is_wp_error($category) && $category !== null) {
									$args['tax_query'][] = array(
										'taxonomy' => $taxonomy,
										'field'    => 'term_id',
										'terms'    => $category_id,
									);
								$loop = new WP_Query($args);
									if ($loop->have_posts()) {
									?>
									<div class="blogsqode-blog-wrap blog-listing-slider blog-listing-slider-2 blog-slider-layout-bg">
										<div class="blog-item mix <?php echo esc_html($category->slug); ?> slick-slider blogsqode-slick-slider blog-slick-slider-with-sidebar3 selected-layout layout-<?php echo esc_attr($layout); ?> post-grid-<?php echo esc_attr($settings['blogsqode_blog_post_grid']); ?>">
											<?php
												while ($loop->have_posts()) :
													$loop->the_post();
													$post_id = get_the_ID();
													if ($layout === '1') {
														echo $this->layout_one($settings, $layout);
													} elseif ($layout === '2' || $layout === '3') {
														echo $this->layout_two($settings, $layout);
													} elseif ($layout === '4') {
														echo $this->layout_four($settings, $layout);
													} elseif ($layout === '5') {
														echo $this->layout_five($settings, $layout);
													} elseif ($layout === '6') {
														echo $this->layout_six($settings, $layout);
													} elseif ($layout === '7') {
														echo $this->layout_seven($settings, $layout);
													} elseif ($layout === '8') {
														echo $this->layout_eight($settings, $layout);
													} elseif ($layout === '9') {
														echo $this->layout_nine($settings, $layout);
													} elseif ($layout === '10') {
														echo $this->layout_ten($settings, $layout);
													} elseif ($layout === '11') {
														echo $this->layout_eleven($settings, $layout);
													} elseif ($layout === '12') {
														echo $this->layout_twelve($settings, $layout);
													} elseif ($layout === '13') {
														echo $this->layout_thirteen($settings, $layout);
													} elseif ($layout === '14') {
														echo $this->layout_fourteen($settings, $layout);
													} elseif ($layout === '15') {
														echo $this->layout_fifteen($settings, $layout);
													} elseif ($layout === '16') {
														echo $this->layout_sixteen($settings, $layout);
													} elseif ($layout === '17') {
														echo $this->layout_seventeen($settings, $layout);
													} elseif ($layout === '18') {
														echo $this->layout_eighteen($settings, $layout);
													} elseif ($layout === '19') {
														echo $this->layout_nineteen($settings, $layout);
													} elseif ($layout === '20') {
														echo $this->layout_twenty($settings, $layout);
													} elseif ($layout === '21') {
														echo $this->layout_twentyone($settings, $layout);
													} elseif ($layout === '22') {
														echo $this->layout_twentytwo($settings, $layout);
													} elseif ($layout === '23') {
														echo $this->layout_twentythree($settings, $layout);
													} elseif ($layout === '24') {
														echo $this->layout_twentyfour($settings, $layout);
													} elseif ($layout === '25') {
														echo $this->layout_twentyfive($settings, $layout);
													} elseif ($layout === '26') {
														echo $this->layout_twentysix($settings, $layout);
													} elseif ($layout === '27') {
														echo $this->layout_twentyseven($settings, $layout);
													} elseif ($layout === '28') {
														echo $this->layout_twentyeight($settings, $layout);
													} elseif ($layout === '29') {
														echo $this->layout_twentynine($settings, $layout);
													} elseif ($layout === '30') {
														echo $this->layout_thirty($settings, $layout);
													}
												endwhile;
												wp_reset_postdata();
											?>
										</div>
									</div>
									<?php
									}
								}
							}
						}
					}
				}
			}
		}
		$content = ob_get_clean();
		return $content;
	}

	/* slider with default sidebar */
	public function blogsqode_setting_arr_func_slider_layout_with_sidebar(){
		$settings = array();
		$blogsqode_post_type_slider_with_sidebar_2 = get_option('blogsqode_post_type_slider_with_sidebar_2');
		if (is_array($blogsqode_post_type_slider_with_sidebar_2)) {
			$settings['blogsqode_post_type_slider_with_sidebar_2'] = implode(',', $blogsqode_post_type_slider_with_sidebar_2);
		} else {
			$settings['blogsqode_post_type_slider_with_sidebar_2'] = esc_attr($blogsqode_post_type_slider_with_sidebar_2);
		}
		$settings['blogsqode_category_filter_options_on_off_with_sidebar'] = esc_attr(get_option('blogsqode_category_filter_options_on_off_with_sidebar'));
		$settings['blogsqode_dark_mode_for_slider_with_sidebar']  = esc_attr(get_option('blogsqode_dark_mode_for_slider_with_sidebar'));
		$settings['blogsqode_short_desc_allow_slider_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_short_desc_allow_slider_with_sidebar')));
		$settings['blogsqode_auhtor_thumb_allow_slider_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_auhtor_thumb_allow_slider_with_sidebar')));
		$settings['blogsqode_author_name_allow_slider_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_author_name_allow_slider_with_sidebar')));
		$settings['blogsqode_blog_date_allow_slider_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_blog_date_allow_slider_with_sidebar')));
		$settings['blogsqode_comment_count_allow_slider_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_comment_count_allow_slider_with_sidebar')));
		$settings['blogsqode_read_time_allow_slider_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_read_time_allow_slider_with_sidebar')));
		$settings['blogsqode_category_allow_slider_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_category_allow_slider_with_sidebar')));
		$settings['blogsqode_read_more_btn_allow_slider_with_sidebar']  = strtolower(esc_attr(get_option('blogsqode_read_more_btn_allow_slider_with_sidebar')));
		$settings['blogsqode_read_more_button_layout']  = esc_attr(get_option('blogsqode_read_more_button_layout'));
		$settings['coming_soon_slider_layout_with_sidebar_bg_color'] = esc_attr(get_option('coming_soon_slider_layout_with_sidebar_bg_color'));
		return $settings;
	}

	public function blogsqode_slider_views_with_sidebar($atts){
	
		if ( ! isset( $atts['layout'] ) ) {
			return '<p>The layout attribute is required for the [blogsqode_slider_with_sidebar] shortcode.</p>';
		}
		$atts = shortcode_atts( array(
			'layout' => 1, 
		), $atts );
		$layout = isset($atts['layout']) ? $atts['layout'] : 1;
	
		ob_start();
		$settings = self::blogsqode_setting_arr_func_slider_layout_with_sidebar();
		$bg_color = $settings['coming_soon_slider_layout_with_sidebar_bg_color'];
		?>
		<script>
		document.documentElement.style.setProperty('--slider-secondary-bg-color', '<?php echo $bg_color; ?>');
		</script>
		<?php
		$paged = (int) filter_var(self::blogsqode_paged(), FILTER_SANITIZE_NUMBER_INT);  
		$post_type_any = get_option('blogsqode_post_type_slider_with_sidebar', 'post');
		$args = array(
			'post_type'     => $post_type_any,
			'paged'         => $paged,
			'orderby'       => 'date',
			'order'         => 'DESC',
		);
		$slider_type = esc_attr(get_option('blogsqode_select_slider_type_with_sidebar'));
		$category_filter_enabled = get_option('blogsqode_category_filter_options_on_off_with_sidebar');
		if($category_filter_enabled === 'Unable' && $slider_type === 'General' && $slider_type !== 'Category'){
			if ($category_filter_enabled !== 'Disable') {
				$selected_post_types = get_option('blogsqode_post_type_slider_with_sidebar', array('post'));
				$post_types = get_post_types(array('public' => true), 'objects');
				echo '<div id="category-filter" class="category-slider-filter2 cat-with-slide category-filter-all slick-slider">';
					echo '<a class="category-name filter-btn cat-name-active" data-category-id="" data-layout="' . esc_attr($layout) . '" data-filter=".mix">All</a>';
						$selected_categories = get_option('blogsqode_category_filter_options_slider_with_sidebar', array());
						foreach ($post_types as $post_type) {
							if ($post_type->name !== 'attachment' && in_array($post_type->name, $selected_post_types)) {
								$taxonomies = get_object_taxonomies($post_type->name);
								if (!empty($taxonomies)) {
									foreach ($taxonomies as $taxonomy) {
										$categories = get_terms(array(
											'taxonomy'   => $taxonomy,
											'hide_empty' => false,
										));
										foreach ($categories as $category) {
											if (in_array($category->term_id, $selected_categories)) {
												echo '<a class="category-name filter-btn" data-category-id="' . $category->term_id . '" data-layout="' . esc_attr($layout) . '" data-post-type="' . esc_attr($post_type->name) . '" data-filter=".' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</a>';
											}
										}
									}
								}
							}
						}
				echo '</div>';
			}
		}
		if($category_filter_enabled === 'Unable' && $slider_type === 'Category' && $slider_type !== 'General'){
			if ($category_filter_enabled !== 'Disable') {
				$selected_post_types = get_option('blogsqode_post_type_slider_with_sidebar', array('post'));
				$post_types = get_post_types(array('public' => true), 'objects');
				echo '<div id="category-filter" class="category-slider-filter2 cat-with-slide category-filter-all slick-slider">';
					echo '<a class="category-name  cat-name-active" data-category-id="" data-layout="' . esc_attr($layout) . '" data-filter=".mix">All</a>';
						$selected_categories = get_option('blogsqode_category_filter_options_slider_with_sidebar', array());
						foreach ($post_types as $post_type) {
							if ($post_type->name !== 'attachment' && in_array($post_type->name, $selected_post_types)) {
								$taxonomies = get_object_taxonomies($post_type->name);
								if (!empty($taxonomies)) {
									foreach ($taxonomies as $taxonomy) {
										$categories = get_terms(array(
											'taxonomy'   => $taxonomy,
											'hide_empty' => false,
										));
										foreach ($categories as $category) {
											if (in_array($category->term_id, $selected_categories)) {
												echo '<a class="category-name " data-category-id="' . $category->term_id . '" data-layout="' . esc_attr($layout) . '" data-post-type="' . esc_attr($post_type->name) . '" data-filter=".' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</a>';
											}
										}
									}
								}
							}
						}
				echo '</div>';
			}
		}
		if($category_filter_enabled === 'Disable' && $slider_type === 'General'){
            if ($slider_type === 'General') {
                $loop = new WP_Query($args);
                if ($loop->have_posts()) { ?>
                    <div class="blogsqode-blog-wrap blog-listing-slider blog-listing-slider-with blog-slider-layout-bg-with-sidebar">
                        <div class="slick-slider blog-slick-slider-with-sidebar selected-layout layout-<?php echo esc_attr($layout); ?> post-grid-2">
                            <?php 
                            while ($loop->have_posts()) :
                                $loop->the_post();
                                $post_id = get_the_ID();
                                if ($layout === '1') {
                                    echo $this->layout_one($settings, $layout);
                                } elseif ($layout === '2' || $layout === '3') {
                                    echo $this->layout_two($settings, $layout);
                                } elseif ($layout === '4') {
                                    echo $this->layout_four($settings, $layout);
                                } elseif ($layout === '5') {
                                    echo $this->layout_five($settings, $layout);
                                } elseif ($layout === '6') {
                                    echo $this->layout_six($settings, $layout);
                                } elseif ($layout === '7') {
                                    echo $this->layout_seven($settings, $layout);
                                } elseif ($layout === '8') {
                                    echo $this->layout_eight($settings, $layout);
                                } elseif ($layout === '9') {
                                    echo $this->layout_nine($settings, $layout);
                                } elseif ($layout === '10') {
                                    echo $this->layout_ten($settings, $layout);
                                } elseif ($layout === '11') {
                                    echo $this->layout_eleven($settings, $layout);
                                } elseif ($layout === '12') {
                                    echo $this->layout_twelve($settings, $layout);
                                } elseif ($layout === '13') {
                                    echo $this->layout_thirteen($settings, $layout);
                                } elseif ($layout === '14') {
                                    echo $this->layout_fourteen($settings, $layout);
                                } elseif ($layout === '15') {
                                    echo $this->layout_fifteen($settings, $layout);
                                } elseif ($layout === '16') {
                                    echo $this->layout_sixteen($settings, $layout);
                                } elseif ($layout === '17') {
                                    echo $this->layout_seventeen($settings, $layout);
                                } elseif ($layout === '18') {
                                    echo $this->layout_eighteen($settings, $layout);
                                } elseif ($layout === '19') {
                                    echo $this->layout_nineteen($settings, $layout);
                                } elseif ($layout === '20') {
                                    echo $this->layout_twenty($settings, $layout);
                                } elseif ($layout === '21') {
                                    echo $this->layout_twentyone($settings, $layout);
                                } elseif ($layout === '22') {
                                    echo $this->layout_twentytwo($settings, $layout);
                                } elseif ($layout === '23') {
                                    echo $this->layout_twentythree($settings, $layout);
                                } elseif ($layout === '24') {
                                    echo $this->layout_twentyfour($settings, $layout);
                                } elseif ($layout === '25') {
                                    echo $this->layout_twentyfive($settings, $layout);
                                } elseif ($layout === '26') {
                                    echo $this->layout_twentysix($settings, $layout);
                                } elseif ($layout === '27') {
                                    echo $this->layout_twentyseven($settings, $layout);
                                } elseif ($layout === '28') {
                                    echo $this->layout_twentyeight($settings, $layout);
                                } elseif ($layout === '29') {
                                    echo $this->layout_twentynine($settings, $layout);
                                } elseif ($layout === '30') {
                                    echo $this->layout_thirty($settings, $layout);
                                }
                            endwhile;
                            wp_reset_postdata();
                            wp_reset_query(); ?>
                        </div>
                    </div>
                <?php }
            }
        }
		elseif ($category_filter_enabled === 'Unable' && $slider_type === 'General') {
			if ($slider_type === 'General') {
				$selected_categories = get_option('blogsqode_category_filter_options_slider_with_sidebar');
				if (!empty($selected_categories)) {
					?>
					<div class="blogsqode-blog-wrap blog-listing-slider-1 blog-listing-slider-with blog-slider-layout-bg-with-sidebar ">
						<?php
						echo '<div class="blog-item slick-slider blog-slick-slider-with-sidebar blog-slick-slider-with-sidebar2 selected-layout layout-' . esc_attr($layout) . ' post-grid-2">';
											
							foreach ($selected_categories as $category_id) {
								$post_type = get_option('blogsqode_post_type_slider_with_sidebar', 'post');
								$post_type_taxonomies = get_object_taxonomies($post_type);
								$args = array(
									'post_type' => $post_type,
									'orderby'   => 'date',
									'order'     => 'DESC',
									'tax_query' => array(),
								);
								if (!empty($post_type_taxonomies)) {
									foreach ($post_type_taxonomies as $taxonomy) {
										$category = get_term($category_id, $taxonomy);
										if (!is_wp_error($category) && $category !== null) {
											$args['tax_query'][] = array(
												'taxonomy' => $taxonomy,
												'field'    => 'term_id',
												'terms'    => $category_id,
											);
											$loop = new WP_Query($args);
											if ($loop->have_posts()) {
												while ($loop->have_posts()) :
												$loop->the_post();
												$post_id = get_the_ID();
												if ($layout === '1') {
													echo $this->layout_one($settings, $layout);
												} elseif ($layout === '2' || $layout === '3') {
													echo $this->layout_two($settings, $layout);
												} elseif ($layout === '4') {
													echo $this->layout_four($settings, $layout);
												} elseif ($layout === '5') {
													echo $this->layout_five($settings, $layout);
												} elseif ($layout === '6') {
													echo $this->layout_six($settings, $layout);
												} elseif ($layout === '7') {
													echo $this->layout_seven($settings, $layout);
												} elseif ($layout === '8') {
													echo $this->layout_eight($settings, $layout);
												} elseif ($layout === '9') {
													echo $this->layout_nine($settings, $layout);
												} elseif ($layout === '10') {
													echo $this->layout_ten($settings, $layout);
												} elseif ($layout === '11') {
													echo $this->layout_eleven($settings, $layout);
												} elseif ($layout === '12') {
													echo $this->layout_twelve($settings, $layout);
												} elseif ($layout === '13') {
													echo $this->layout_thirteen($settings, $layout);
												} elseif ($layout === '14') {
													echo $this->layout_fourteen($settings, $layout);
												} elseif ($layout === '15') {
													echo $this->layout_fifteen($settings, $layout);
												} elseif ($layout === '16') {
													echo $this->layout_sixteen($settings, $layout);
												} elseif ($layout === '17') {
													echo $this->layout_seventeen($settings, $layout);
												} elseif ($layout === '18') {
													echo $this->layout_eighteen($settings, $layout);
												} elseif ($layout === '19') {
													echo $this->layout_nineteen($settings, $layout);
												} elseif ($layout === '20') {
													echo $this->layout_twenty($settings, $layout);
												} elseif ($layout === '21') {
													echo $this->layout_twentyone($settings, $layout);
												} elseif ($layout === '22') {
													echo $this->layout_twentytwo($settings, $layout);
												} elseif ($layout === '23') {
													echo $this->layout_twentythree($settings, $layout);
												} elseif ($layout === '24') {
													echo $this->layout_twentyfour($settings, $layout);
												} elseif ($layout === '25') {
													echo $this->layout_twentyfive($settings, $layout);
												} elseif ($layout === '26') {
													echo $this->layout_twentysix($settings, $layout);
												} elseif ($layout === '27') {
													echo $this->layout_twentyseven($settings, $layout);
												} elseif ($layout === '28') {
													echo $this->layout_twentyeight($settings, $layout);
												} elseif ($layout === '29') {
													echo $this->layout_twentynine($settings, $layout);
												} elseif ($layout === '30') {
													echo $this->layout_thirty($settings, $layout);
												}
												endwhile;
												wp_reset_postdata();
											}		
										}
									}
								}
							}
						echo '</div>';
					echo '</div>';
				}		
			}						
		}
		elseif($category_filter_enabled === 'Disable' && $slider_type === 'Category'){
			if ($slider_type  === 'Category' && esc_attr(get_option('blogsqode_select_slider_type_with_sidebar')) === 'Category') {
				$selected_categories = get_option('blogsqode_category_filter_options_slider_with_sidebar');
				if (!empty($selected_categories)) {
					foreach ($selected_categories as $category_id) {
						$post_type = get_option('blogsqode_post_type_slider_with_sidebar', 'post');
						$post_type_taxonomies = get_object_taxonomies($post_type);
						if (!empty($post_type_taxonomies)) {
							foreach ($post_type_taxonomies as $taxonomy) {
								$category = get_term($category_id, $taxonomy);
								if (!is_wp_error($category) && $category !== null) {
									$args['tax_query'] = array(
										array(
											'taxonomy' => $taxonomy,
											'field'    => 'term_id',
											'terms'    => $category_id,
										),
									);
									$loop = new WP_Query($args);
									if ($loop->have_posts()) {
										?>
										<div class="blogsqode-blog-wrap blog-listing-slider-with blog-slider-layout-bg-with-sidebar">
											<div class="slick-slider blog-slick-slider-with-sidebar selected-layout layout-<?php echo esc_attr($layout); ?> post-grid-2">
												<?php
												while ($loop->have_posts()) :
													$loop->the_post();
													$post_id = get_the_ID();
													if ($layout === '1') {
														echo $this->layout_one($settings, $layout);
													} elseif ($layout === '2' || $layout === '3') {
														echo $this->layout_two($settings, $layout);
													} elseif ($layout === '4') {
														echo $this->layout_four($settings, $layout);
													} elseif ($layout === '5') {
														echo $this->layout_five($settings, $layout);
													} elseif ($layout === '6') {
														echo $this->layout_six($settings, $layout);
													} elseif ($layout === '7') {
														echo $this->layout_seven($settings, $layout);
													} elseif ($layout === '8') {
														echo $this->layout_eight($settings, $layout);
													} elseif ($layout === '9') {
														echo $this->layout_nine($settings, $layout);
													} elseif ($layout === '10') {
														echo $this->layout_ten($settings, $layout);
													} elseif ($layout === '11') {
														echo $this->layout_eleven($settings, $layout);
													} elseif ($layout === '12') {
														echo $this->layout_twelve($settings, $layout);
													} elseif ($layout === '13') {
														echo $this->layout_thirteen($settings, $layout);
													} elseif ($layout === '14') {
														echo $this->layout_fourteen($settings, $layout);
													} elseif ($layout === '15') {
														echo $this->layout_fifteen($settings, $layout);
													} elseif ($layout === '16') {
														echo $this->layout_sixteen($settings, $layout);
													} elseif ($layout === '17') {
														echo $this->layout_seventeen($settings, $layout);
													} elseif ($layout === '18') {
														echo $this->layout_eighteen($settings, $layout);
													} elseif ($layout === '19') {
														echo $this->layout_nineteen($settings, $layout);
													} elseif ($layout === '20') {
														echo $this->layout_twenty($settings, $layout);
													} elseif ($layout === '21') {
														echo $this->layout_twentyone($settings, $layout);
													} elseif ($layout === '22') {
														echo $this->layout_twentytwo($settings, $layout);
													} elseif ($layout === '23') {
														echo $this->layout_twentythree($settings, $layout);
													} elseif ($layout === '24') {
														echo $this->layout_twentyfour($settings, $layout);
													} elseif ($layout === '25') {
														echo $this->layout_twentyfive($settings, $layout);
													} elseif ($layout === '26') {
														echo $this->layout_twentysix($settings, $layout);
													} elseif ($layout === '27') {
														echo $this->layout_twentyseven($settings, $layout);
													} elseif ($layout === '28') {
														echo $this->layout_twentyeight($settings, $layout);
													} elseif ($layout === '29') {
														echo $this->layout_twentynine($settings, $layout);
													} elseif ($layout === '30') {
														echo $this->layout_thirty($settings, $layout);
													}
												endwhile;
												wp_reset_postdata();
												wp_reset_query(); ?>
											</div>
										</div>
									<?php
									}
								}
							}
						}
					}
				}
			}
		}
		elseif ($category_filter_enabled === 'Unable' && $slider_type === 'Category') {
			if ($slider_type === 'Category' && esc_attr(get_option('blogsqode_select_slider_type_with_sidebar')) === 'Category') {
				$selected_categories = get_option('blogsqode_category_filter_options_slider_with_sidebar');
				if (!empty($selected_categories)) {
					foreach ($selected_categories as $category_id) {
						$post_type = get_option('blogsqode_post_type_slider_with_sidebar', 'post');
						$post_type_taxonomies = get_object_taxonomies($post_type);
						$args = array(
							'post_type' => $post_type,
							'orderby'   => 'date',
							'order'     => 'DESC',
							'tax_query' => array(),
						);
						if (!empty($post_type_taxonomies)) {
							foreach ($post_type_taxonomies as $taxonomy) {
								$category = get_term($category_id, $taxonomy);
								if (!is_wp_error($category) && $category !== null) {
									$args['tax_query'][] = array(
										'taxonomy' => $taxonomy,
										'field'    => 'term_id',
										'terms'    => $category_id,
									);
									$loop = new WP_Query($args);
									if ($loop->have_posts()) {
										?>
										<div class="blogsqode-blog-wrap blog-listing-slider-2 blog-listing-slider-with blog-slider-layout-bg-with-sidebar ">
											<div class="blog-item mix <?php echo esc_html($category->slug); ?> slick-slider blog-slick-slider-with-sidebar blog-slick-slider-with-sidebar3 selected-layout layout-<?php echo esc_attr($layout); ?> post-grid-2">
											<?php
												while ($loop->have_posts()) :
													$loop->the_post();
													$post_id = get_the_ID();
													if ($layout === '1') {
														echo $this->layout_one($settings, $layout);
													} elseif ($layout === '2' || $layout === '3') {
														echo $this->layout_two($settings, $layout);
													} elseif ($layout === '4') {
														echo $this->layout_four($settings, $layout);
													} elseif ($layout === '5') {
														echo $this->layout_five($settings, $layout);
													} elseif ($layout === '6') {
														echo $this->layout_six($settings, $layout);
													} elseif ($layout === '7') {
														echo $this->layout_seven($settings, $layout);
													} elseif ($layout === '8') {
														echo $this->layout_eight($settings, $layout);
													} elseif ($layout === '9') {
														echo $this->layout_nine($settings, $layout);
													} elseif ($layout === '10') {
														echo $this->layout_ten($settings, $layout);
													} elseif ($layout === '11') {
														echo $this->layout_eleven($settings, $layout);
													} elseif ($layout === '12') {
														echo $this->layout_twelve($settings, $layout);
													} elseif ($layout === '13') {
														echo $this->layout_thirteen($settings, $layout);
													} elseif ($layout === '14') {
														echo $this->layout_fourteen($settings, $layout);
													} elseif ($layout === '15') {
														echo $this->layout_fifteen($settings, $layout);
													} elseif ($layout === '16') {
														echo $this->layout_sixteen($settings, $layout);
													} elseif ($layout === '17') {
														echo $this->layout_seventeen($settings, $layout);
													} elseif ($layout === '18') {
														echo $this->layout_eighteen($settings, $layout);
													} elseif ($layout === '19') {
														echo $this->layout_nineteen($settings, $layout);
													} elseif ($layout === '20') {
														echo $this->layout_twenty($settings, $layout);
													} elseif ($layout === '21') {
														echo $this->layout_twentyone($settings, $layout);
													} elseif ($layout === '22') {
														echo $this->layout_twentytwo($settings, $layout);
													} elseif ($layout === '23') {
														echo $this->layout_twentythree($settings, $layout);
													} elseif ($layout === '24') {
														echo $this->layout_twentyfour($settings, $layout);
													} elseif ($layout === '25') {
														echo $this->layout_twentyfive($settings, $layout);
													} elseif ($layout === '26') {
														echo $this->layout_twentysix($settings, $layout);
													} elseif ($layout === '27') {
														echo $this->layout_twentyseven($settings, $layout);
													} elseif ($layout === '28') {
														echo $this->layout_twentyeight($settings, $layout);
													} elseif ($layout === '29') {
														echo $this->layout_twentynine($settings, $layout);
													} elseif ($layout === '30') {
														echo $this->layout_thirty($settings, $layout);
													}
												endwhile;
												wp_reset_postdata();
												?>
											</div>
										</div>
										<?php
									}
								}
							}
						}
					}
				}
			}
		}
		$content = ob_get_clean();
		return $content;
	}

}
new Blogsqode_Public();

