<?php
/**
 * Plugin Name: BlogSqode WP Post Design
 * Plugin URI: https://codecanyon.net/item/blogsqode-blog-design-for-wordpress/37513771
 * Description: Provides a Various Layouts for blogs.
 * Version: 2.0.0
 * Author: The_Krishna
 * Author URI: https://themeforest.net/user/the_krishna
 * Text Domain: blogsqode 
 *
 * @package Blogsqode
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


if ( ! defined( 'BLOGSQODE_PLUGIN_FILE' ) ) {
	define( 'BLOGSQODE_PLUGIN_FILE', plugin_dir_url( __FILE__ ) );
}
if ( ! defined( 'BLOGSQODE_PLUGIN_PATH' ) ) {
    define( 'BLOGSQODE_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
}
if( !defined('BLOGSQODE_IMG_PATH')){
    define( 'BLOGSQODE_IMG_PATH',  plugin_dir_url( __FILE__ ).'public/assets/images' );
}
/**
 * Currently plugin version.
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'BLOGSQODE_VERSION', '3.0.0' );


add_action('wp_footer', 'add_scripts_in_footer_func');
function add_scripts_in_footer_func(){
    if(!is_single()){
        $dark_mode = strtolower(get_option("blogsqode_dark_mode"));
        $post_grid = strtolower(get_option("blogsqode_blog_post_grid"));
        $dark_mode_slider = strtolower(get_option("blogsqode_dark_mode_for_slider")); 
        $dark_mode_slider_with_slider = strtolower(get_option("blogsqode_dark_mode_for_slider_with_sidebar")); 
        $dark_mode_with_sidebar = strtolower(get_option("blogsqode_dark_mode_with_sidebar"));  
        ?> 
        <script type="text/javascript">
            "use strict";
            const darkModeEnabled = localStorage.getItem('darkmode') === 'unable';
            jQuery('.blog-listing').addClass('dark-mode-<?php echo esc_js($dark_mode); ?>');
            jQuery('.blog-listing').addClass('post-grid-<?php echo esc_js($post_grid); ?>');
            jQuery('.blog-listing-slider').addClass('dark-mode-<?php echo esc_js($dark_mode_slider); ?>');
            jQuery('.blog-listing-slider-with').addClass('dark-mode-<?php echo esc_js($dark_mode_slider_with_slider); ?>');
            jQuery('.blog-listing-with-sidebar').addClass('dark-mode-<?php echo esc_js($dark_mode_with_sidebar); ?>');
        </script>
        <?php
    }
}

if (!function_exists('is_plugin_active')) {
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');
}

require_once('admin/blogsqode-admin.php');
require_once('admin/settings/elementor/blogsqode-widgets.php');
require_once('admin/settings/wpbackery/blogsqode-backery-shortcode.php');
require_once('admin/settings/wpbackery/blogsqode-backery-blockquote.php');

require_once('public/class-blogsqode-blog-templates.php');
require_once('public/class-blogsqode-blog-public.php');

add_action('wp_head', 'color');
function color() {
   ?> 
   <style>
    :root{
        --bg-color:  <?php echo esc_attr(get_option('coming_soon_layout_bg_color')); ?>
    }
</style>
   <?php 
}

/* save selected post type no sidebar */
add_action('admin_init', 'save_selected_post_type');
function save_selected_post_type() {
    if (isset($_POST['blogsqode_post_type']) && is_array($_POST['blogsqode_post_type'])) {
        $selected_post_types = array_map('sanitize_text_field', $_POST['blogsqode_post_type']);
        update_option('blogsqode_selected_post_type', $selected_post_types);
    }
}

/* save select post type with sidebar */
add_action('admin_init' , 'save_select_post_type_with_sidebar');
function save_select_post_type_with_sidebar(){
    if (isset($_POST['blogsqode_post_type_with_sidebar']) && is_array($_POST['blogsqode_post_type_with_sidebar'])) {
        $selected_post_types = array_map('sanitize_text_field', $_POST['blogsqode_post_type_with_sidebar']);
        update_option('blogsqode_selected_post_type_with_sidebar', $selected_post_types);
    }
}

/* save select post type without slider */
add_action('admin_init' , 'save_select_post_type_no_slider');
function save_select_post_type_no_slider(){
    if (isset($_POST['blogsqode_post_type_no_sidebar']) && is_array($_POST['blogsqode_post_type_no_sidebar'])) {
        $selected_post_types = array_map('sanitize_text_field', $_POST['blogsqode_post_type_no_sidebar']);
        update_option('blogsqode_post_type_no_sidebar', $selected_post_types);
    }
}

/* save select post type with slider */
add_action('admin_init' , 'save_select_post_type_with_slider_sidebar');
function save_select_post_type_with_slider_sidebar(){
    if (isset($_POST['blogsqode_post_type_slider_with_sidebar']) && is_array($_POST['blogsqode_post_type_slider_with_sidebar'])) {
        $selected_post_types = array_map('sanitize_text_field', $_POST['blogsqode_post_type_slider_with_sidebar']);
        update_option('blogsqode_post_type_slider_with_sidebar', $selected_post_types);
    }
}
