<?php
/**
 * Shortcode
 *
 * Create a Shortcode in WPBakery
 *
 * @category   Wordpress
 * @since      Class available since Release 2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) { 
    exit; // Exit if accessed directly.
}

if ( is_plugin_active( 'js_composer/js_composer.php' ) && ! class_exists( 'BlogsqodeShortcode' ) ) {

    class BlogsqodeShortcode {

        function __construct() {
            add_action( 'init', array( $this, 'create_shortcode' ), 999 );            
            add_shortcode( 'blogsqode_blog_shortcode', array( $this, 'render_shortcode' ) );
            add_shortcode( 'blogsqode_blog_with_sidebar_shortcode', array( $this, 'render_blogsqode_blog_list_with_sidebar_shortcode' ) );
            add_shortcode( 'blogsqode_slider_shortcode', array( $this, 'render_slider_shortcode' ) );
            add_shortcode( 'blogsqode_slider_with_sidebar_shortcode', array( $this, 'render_slider_with_sidebar_shortcode' ) );
        }        
        public function create_shortcode() {
            // Stop all if VC is not enabled
            if ( ! defined( 'WPB_VC_VERSION' ) ) {
                return;
            }        
           
            $layout_options = array();
            for ($i = 1; $i <= 30; $i++) {
                $layout_options[esc_html__('Layout ', 'blogsqode') . $i] = (string) $i;
            }

            vc_map( array(
                'name'          => esc_html__( 'Blogsqode Blog Shortcode 1', 'blogsqode' ),
                'base'          => 'blogsqode_blog_shortcode',
                'description'   => esc_html__( '', 'blogsqode' ),
                'category'      => esc_html__( 'Blogsqode Blog', 'blogsqode' ),                
                'params' => array(
    
                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Shortcode', 'blogsqode' ),
                        'param_name'    => 'blogsqode_shortcode',
                        'value'         => esc_html__( 'blogsqode_blog_list', 'blogsqode' ),
                    ),

                    array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Select Layout', 'blogsqode' ),
                        'param_name'  => 'layout',
                        'value'       => $layout_options,
                    ),

                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Element ID', 'blogsqode' ),
                        'param_name'    => 'element_id',
                        'value'         => esc_html__( '', 'blogsqode' ),
                        'description'   => esc_html__( 'Enter element ID (Note: make sure it is unique and valid).', 'blogsqode' ),
                        'group'         => esc_html__( 'Extra', 'blogsqode' ),
                    ),

                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Extra class name', 'blogsqode' ),
                        'param_name'    => 'extra_class',
                        'value'         => esc_html__( '', 'blogsqode' ),
                        'description'   => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'blogsqode' ),
                        'group'         => esc_html__( 'Extra', 'blogsqode' ),
                    ),               
                ),
            ));         
              
            vc_map( array(
                'name'          => esc_html__( 'Blogsqode Blog Shortcode 2', 'blogsqode' ),
                'base'          => 'blogsqode_blog_with_sidebar_shortcode',
                'description'   => esc_html__( '', 'blogsqode' ),
                'category'      => esc_html__( 'Blogsqode Blog', 'blogsqode' ),                
                'params' => array(
    
                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Shortcode', 'blogsqode' ),
                        'param_name'    => 'blogsqode_shortcode',
                        'value'         => esc_html__( 'blogsqode_blog_list_with_sidebar', 'blogsqode' ),
                        'description'   => esc_html__( 'Add shortcode', 'blogsqode' ),
                    ),

                    array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Select Layout', 'blogsqode' ),
                        'param_name'  => 'layout',
                        'value'       => $layout_options,
                    ),

                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Element ID', 'blogsqode' ),
                        'param_name'    => 'element_id',
                        'value'         => esc_html__( '', 'blogsqode' ),
                        'description'   => esc_html__( 'Enter element ID (Note: make sure it is unique and valid).', 'blogsqode' ),
                        'group'         => esc_html__( 'Extra', 'blogsqode' ),
                    ),

                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Extra class name', 'blogsqode' ),
                        'param_name'    => 'extra_class',
                        'value'         => esc_html__( '', 'blogsqode' ),
                        'description'   => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'blogsqode' ),
                        'group'         => esc_html__( 'Extra', 'blogsqode' ),
                    ),               
                ),
            ));  
            
            vc_map( array(
                'name'          => esc_html__( 'Blogsqode Blog Shortcode 3', 'blogsqode' ),
                'base'          => 'blogsqode_slider_shortcode',
                'description'   => esc_html__( '', 'blogsqode' ),
                'category'      => esc_html__( 'Blogsqode Blog', 'blogsqode' ),                
                'params' => array(
    
                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Shortcode', 'blogsqode' ),
                        'param_name'    => 'blogsqode_shortcode',
                        'value'         => esc_html__( 'blogsqode_slider', 'blogsqode' ),
                        'description'   => esc_html__( 'Add shortcode', 'blogsqode' ),
                    ),

                    array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Select Layout', 'blogsqode' ),
                        'param_name'  => 'layout',
                        'value'       => $layout_options,
                    ),

                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Element ID', 'blogsqode' ),
                        'param_name'    => 'element_id',
                        'value'         => esc_html__( '', 'blogsqode' ),
                        'description'   => esc_html__( 'Enter element ID (Note: make sure it is unique and valid).', 'blogsqode' ),
                        'group'         => esc_html__( 'Extra', 'blogsqode' ),
                    ),

                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Extra class name', 'blogsqode' ),
                        'param_name'    => 'extra_class',
                        'value'         => esc_html__( '', 'blogsqode' ),
                        'description'   => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'blogsqode' ),
                        'group'         => esc_html__( 'Extra', 'blogsqode' ),
                    ),               
                ),
            ));  

            vc_map( array(
                'name'          => esc_html__( 'Blogsqode Blog Shortcode 4', 'blogsqode' ),
                'base'          => 'blogsqode_slider_with_sidebar_shortcode',
                'description'   => esc_html__( '', 'blogsqode' ),
                'category'      => esc_html__( 'Blogsqode Blog', 'blogsqode' ),                
                'params' => array(
    
                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Shortcode', 'blogsqode' ),
                        'param_name'    => 'blogsqode_shortcode',
                        'value'         => esc_html__( 'blogsqode_slider_with_sidebar', 'blogsqode' ),
                        'description'   => esc_html__( 'Add shortcode', 'blogsqode' ),
                    ),

                    array(
                        'type'        => 'dropdown',
                        'heading'     => esc_html__( 'Select Layout', 'blogsqode' ),
                        'param_name'  => 'layout',
                        'value'       => $layout_options,
                    ),

                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Element ID', 'blogsqode' ),
                        'param_name'    => 'element_id',
                        'value'         => esc_html__( '', 'blogsqode' ),
                        'description'   => esc_html__( 'Enter element ID (Note: make sure it is unique and valid).', 'blogsqode' ),
                        'group'         => esc_html__( 'Extra', 'blogsqode' ),
                    ),

                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Extra class name', 'blogsqode' ),
                        'param_name'    => 'extra_class',
                        'value'         => esc_html__( '', 'blogsqode' ),
                        'description'   => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'blogsqode' ),
                        'group'         => esc_html__( 'Extra', 'blogsqode' ),
                    ),               
                ),
            ));  
            
        }
        public function render_shortcode( $atts, $content, $tag ) {
            $atts = shortcode_atts( array(
                'blogsqode_shortcode'   => '',
                'extra_class'           => '',
                'element_id'            => '',
                'layout'                => '1',  
            ), $atts );

            $layout = intval( $atts['layout'] );
            if ($layout < 1 || $layout > 30) {
                $layout = 1;
            }

            $extra_class = esc_attr( $atts['extra_class'] );
            $element_id = esc_attr( $atts['element_id'] );
        
            $output = '';
            $output .= '<div class="blogsqode_shortcode ' . $extra_class . '" id="' . $element_id . '" >';
            $output .= do_shortcode( '[blogsqode_blog_list layout="' . $layout . '"]' );
            $output .= '</div>';

            return $output;                  
        }
        public function render_blogsqode_blog_list_with_sidebar_shortcode( $atts, $content, $tag ) {
            $atts = shortcode_atts( array(
                'blogsqode_shortcode'   => '',
                'extra_class'           => '',
                'element_id'            => '',
                'layout'                => '1',  
            ), $atts );
        
            $layout = intval( $atts['layout'] );
            if ($layout < 1 || $layout > 30) {
                $layout = 1;
            }

            $extra_class = esc_attr( $atts['extra_class'] );
            $element_id = esc_attr( $atts['element_id'] );
        
            $output = '';
            $output .= '<div class="blogsqode_shortcode ' . $extra_class . '" id="' . $element_id . '" >';
            $output .= do_shortcode( '[blogsqode_blog_list_with_sidebar layout="' . $layout . '"]' );
            $output .= '</div>';
            return $output;                  
        }

        public function render_slider_shortcode( $atts, $content, $tag ) {
            $atts = shortcode_atts( array(
                'blogsqode_shortcode'   => '',
                'extra_class'           => '',
                'element_id'            => '',
                'layout'                => '1',  
            ), $atts );
        
            $layout = intval( $atts['layout'] );
            if ($layout < 1 || $layout > 30) {
                $layout = 1;
            }

            $extra_class = esc_attr( $atts['extra_class'] );
            $element_id = esc_attr( $atts['element_id'] );
        
            $output = '';
            $output .= '<div class="blogsqode_shortcode ' . $extra_class . '" id="' . $element_id . '" >';
            $output .= do_shortcode( '[blogsqode_slider layout="' . $layout . '"]' );
            $output .= '</div>';

            return $output;                  
        }

        public function render_slider_with_sidebar_shortcode( $atts, $content, $tag ) {
            $atts = shortcode_atts( array(
                'blogsqode_shortcode'   => '',
                'extra_class'           => '',
                'element_id'            => '',
                'layout'                => '1',  
            ), $atts );
        
            $layout = intval( $atts['layout'] );
            if ($layout < 1 || $layout > 30) {
                $layout = 1;
            }

            $extra_class = esc_attr( $atts['extra_class'] );
            $element_id = esc_attr( $atts['element_id'] );
        
            $output = '';
            $output .= '<div class="blogsqode_shortcode ' . $extra_class . '" id="' . $element_id . '" >';
            $output .= do_shortcode( '[blogsqode_slider_with_sidebar layout="' . $layout . '"]' );
            $output .= '</div>';

            return $output;                  
        }

    }
    new BlogsqodeShortcode();
}
