<?php

/**
 * Used Code :'blogsqode-shortcode-widget.php'.
 * Create Custom Shortcode Elementor.
 */

namespace Elementor;
if(is_plugin_active('elementor/elementor.php')) {
	class Blogsqode_Shortcode_Widget_2 extends Widget_Base {


		public function get_name() {
			return 'blogsqode_blog_list_with_sidebar_shortcode';
		}

		public function get_title() {
			return esc_html__( 'Blogsqode Shortcode 2', 'blogsqode' );
		}

		protected function register_controls() {

			$this->start_controls_section(
				'content_section',
				[
					'label' => esc_html__( 'Content', 'blogsqode' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'blogsqode_blog_list_with_sidebar_shortcode', [
					'label' => esc_html__( 'Shortcode', 'blogsqode' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html( '[blogsqode_blog_list_with_sidebar]' , 'blogsqode' ),
					'label_block' => true,
				]
			);
			
			$this->add_control(
                'select_layout',
                [
                    'label' => __('Select Layout', 'blogsqode'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => $this->get_layout_options(),
                ]
            );

			$this->end_controls_section();
		}

		protected function render() {
			$settings = $this->get_settings_for_display();
			$shortcode = sprintf('[blogsqode_blog_list_with_sidebar layout=%s]', $settings['select_layout']);
            echo do_shortcode($shortcode);
		}
		private function get_layout_options()
		{
			$options = [];
			for ($i = 1; $i <= 30; $i++) {
				$options[$i] = 'Layout ' . $i;
			}
			return $options;
		}
	}
}
