<?php
/**
 * Blogsqode General Settings
 *
 * @package Blogsqode\Admin
 */

defined( 'ABSPATH' ) || exit;

if ( class_exists( 'Blogsqode_Settings_General', false ) ) {
	return new Blogsqode_Settings_General();
}
include_once dirname( __FILE__ ) . '/class-blogsqode-setting-page.php';

/**
 * Blogsqode_Admin_Settings_General.
 */
class Blogsqode_Settings_General extends Blogsqode_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'general';
		$this->label = esc_html__( 'General', 'blogsqode' );

		parent::__construct();
	}

	/**
	 * Get settings or the default section.
	 *
	 * @return array
	 */
	protected function get_settings_for_default_section() {

		$settings =
		array(

			array(
				'title' => esc_html__( 'Blogs Page', 'blogsqode' ),
				'type'  => 'title',
				'desc'  => wp_kses_post( '* kindly use this <span>[blogsqode_blog_list layout=x]</span> you only need to change the number from 1 to 30 instead of X in the shortcode inside any page, post, section.', 'blogsqode' ),
				'id'    => 'blog_page_settings',
				'desc_tip' => false,
			),

			array(
				'title'    => esc_html__( 'Enable Dark Mode', 'blogsqode' ),
				'desc'     => esc_html__( 'Enable dark mode for changing color', 'blogsqode' ),
				'id'       => 'blogsqode_dark_mode',
				'default'  => 'Disable',
				'type'     => 'switchbox',
				'desc_tip' => esc_html__( 'Theme color will be change after enable it.', 'blogsqode' ),
			),
			
			array(
				'title' => esc_html__( 'Choose Primary Color', 'blogsqode' ),
				'desc'     => esc_html__( 'Enable If you want to display your blog bg in your blog list page.', 'blogsqode' ),
				'id' => 'coming_soon_layout_bg_color',
				'type' => 'color',
				'default' => '#6f39fd',
				'desc_tip' => true,
			),

			array(
				'title'    => esc_html__( 'Select Post Type', 'blogsqode' ),
				'id'       => 'blogsqode_post_type',
				'type'     => 'checkboxes',
				'class'    => 'blogsqode-enhanced-select',
				'options'  => get_post_type_options(), 
				'desc_tip' => true,
			),
			
			array(
				'title'    => esc_html__( 'Category Filter Options', 'blogsqode' ),
				'desc'     => esc_html__( 'Select categories for the filter dropdown.', 'blogsqode' ),
				'id'       => 'blogsqode_category_filter_options',
				'type'     => 'multiselect',
				'class'    => 'blogsqode-enhanced-select chosen-select',
				'css'      => 'min-width: 350px;',
				'options'  => $this->get_categories_options(),
				'desc_tip' => true,
			),
			
			array(
				'title'    => esc_html__( 'Category Tab Bar', 'blogsqode' ),
				'desc'     => esc_html__( 'Select categories for the filter dropdown.', 'blogsqode' ),
				'id'       => 'blogsqode_category_filter_options_on_off',
				'default'  => 'Disable',
				'type'     => 'switchbox',
				'desc_tip' => true,
			),
			
			array(
				'title'    => esc_html__( 'Post Grid', 'blogsqode' ),
				'desc'     => esc_html__( 'Select Column for Blogs.', 'blogsqode' ),
				'id'       => 'blogsqode_blog_post_grid',
				'default'  => '3',
				'type'     => 'select',
				'class'    => 'blogsqode-enhanced-select',
				'css'      => 'min-width: 350px;',
				'desc_tip' => true,
				'options'  => array(
					'2'	   => esc_html__( '2 Posts per Column', 'blogsqode' ),
					'3'    => esc_html__( '3 Posts per Column', 'blogsqode' ),
					'4'    => esc_html__( '4 Posts per Column', 'blogsqode' ),
				),
			),
			
			array(
				'title'             => esc_html__( 'Post Per Page', 'blogsqode' ),
				'desc'              => esc_html__( 'This sets the number of blogs per page.', 'blogsqode' ),
				'id'                => 'blogsqode_blogs_per_page',
				'css'               => 'width:50px;',
				'default'           => '9',
				'desc_tip'          => true,
				'type'              => 'number',
				'custom_attributes' => array(
					'min'  => 3,  
				),
			),

			array(
				'title'    => esc_html__( 'Pagination Option', 'blogsqode' ),
				'desc'     => esc_html__( 'Select a way of Paginate blog Page.', 'blogsqode' ),
				'id'       => 'blogsqode_blog_pagination_option',
				'default'  => 'pagination',
				'type'     => 'select',
				'class'    => 'blogsqode-enhanced-select',
				'css'      => 'min-width: 350px;',
				'desc_tip' => true,
				'options'  => array(
					'pagination'	   => esc_html__( 'Pagination With Numeric', 'blogsqode' ),
					'load_more_button'    => esc_html__( 'Load More Button with Ajax', 'blogsqode' ),

				),
			),

			array(
				'title'    => esc_html__( 'Layout', 'blogsqode' ),
				'desc'     => esc_html__( 'This option allows you to select layout options. After selecting a layout, you can view the layout preview and generate a shortcode based on the selected layout.', 'blogsqode' ),
				'id'       => 'blogsqode_blog_layout',
				'default'  => '1',
				'type'     => 'select',
				'class'    => 'blogsqode-enhanced-select',
				'css'      => 'min-width: 350px;display:block;margin-bottom:5px;',
				'desc_tip' => esc_html__( 'This option lets you set layout for blogs.', 'blogsqode' ),
				'options'  => array(
					'1'        => array(esc_html__( 'Layout 1', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-1.png'),
					'2'        => array(esc_html__( 'Layout 2', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-2.png'),
					'3'        => array(esc_html__( 'Layout 3', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-3.png'),
					'4'        => array(esc_html__( 'Layout 4', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-4.png'),
					'5'        => array(esc_html__( 'Layout 5', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-5.png'),
					'6'        => array(esc_html__( 'Layout 6', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-6.png'),
					'7'        => array(esc_html__( 'Layout 7', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-7.png'),
					'8'        => array(esc_html__( 'Layout 8', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-8.png'),
					'9'        => array(esc_html__( 'Layout 9', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-9.png'),
					'10'       => array(esc_html__( 'Layout 10', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-10.png'),
					'11'       => array(esc_html__( 'Layout 11', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-11.png'),
					'12'       => array(esc_html__( 'Layout 12', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-12.png'),
					'13'       => array(esc_html__( 'Layout 13', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-13.png'),
					'14'       => array(esc_html__( 'Layout 14', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-14.png'),
					'15'       => array(esc_html__( 'Layout 15', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-15.png'),
					'16'       => array(esc_html__( 'Layout 16', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-16.png'),
					'17'       => array(esc_html__( 'Layout 17', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-17.png'),
					'18'       => array(esc_html__( 'Layout 18', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-18.png'),
					'19'       => array(esc_html__( 'Layout 19', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-19.png'),
					'20'       => array(esc_html__( 'Layout 20', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-20.png'),
					'21'       => array(esc_html__( 'Layout 21', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-21.png'),
					'22'       => array(esc_html__( 'Layout 22', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-22.png'),
					'23'       => array(esc_html__( 'Layout 23', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-23.png'),
					'24'       => array(esc_html__( 'Layout 24', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-24.png'),
					'25'       => array(esc_html__( 'Layout 25', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-25.png'),
					'26'       => array(esc_html__( 'Layout 26', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-26.png'),
					'27'       => array(esc_html__( 'Layout 27', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-27.png'),
					'28'       => array(esc_html__( 'Layout 28', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-28.png'),
					'29'       => array(esc_html__( 'Layout 29', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-29.png'),
					'30'       => array(esc_html__( 'Layout 30', 'blogsqode' ), BLOGSQODE_PLUGIN_FILE.'images/blog-layout-30.png'),
				),
			),
			
			array(
				'title'    => esc_html__( '', 'blogsqode' ),
				'desc'     => esc_html__( 'This Preview is for layout.', 'blogsqode' ),
				'id'       => 'blogsqode_blog_layout_preview',
				'type'     => 'preview_design',
				'class'    => 'blogsqode-preview-design',
				'css'      => 'display:inline-block;',
				'desc_tip' => true,
			),
		
			array(
				'type' => 'sectionend',
				'id'   => 'blog_page_settings',
			),

			array(
				'title' => esc_html__( 'Enable/Disable options', 'blogsqode' ),
				'type'  => 'title',
				'desc'  => esc_html__('This section is specially for Enable/Disable in Blog List page.','blogsqode'),
				'id'    => 'enable_disable_options',
			),

			array(
				'title'    => esc_html__( 'Short Description', 'blogsqode' ),
				'desc'     => esc_html__( 'Enable If you want to display your blog short description in your blog list page.', 'blogsqode' ),
				'desc_tip' => true,
				'id'       => 'blogsqode_short_desc_allow',
				'default'  => 'Unable',
				'type'     => 'switchbox',
			),

			array(
				'title'    => esc_html__( 'Author Thumbnail', 'blogsqode' ),
				'desc'     => esc_html__( 'Enable If you want to display your blog author thumbnail in your blog list page.', 'blogsqode' ),
				'desc_tip' => true,
				'id'       => 'blogsqode_auhtor_thumb_allow',
				'default'  => 'Unable',
				'type'     => 'switchbox',
			),

			array(
				'title'    => esc_html__( 'Author Name', 'blogsqode' ),
				'desc'     => esc_html__( 'Enable If you want to display your blog author name in your blog list page.', 'blogsqode' ),
				'desc_tip' => true,
				'id'       => 'blogsqode_author_name_allow',
				'default'  => 'Unable',
				'type'     => 'switchbox',
			),

			array(
				'title'    => esc_html__( 'Blog Date', 'blogsqode' ),
				'desc'     => esc_html__( 'Enable If you want to display your blog date in your blog list page.', 'blogsqode' ),
				'desc_tip' => true,
				'id'       => 'blogsqode_blog_date_allow',
				'default'  => 'Unable',
				'type'     => 'switchbox',
			),

			array(
				'title'    => esc_html__( 'Comments Count', 'blogsqode' ),
				'desc'     => esc_html__( 'Enable If you want to display your blog comment count in your blog list page.', 'blogsqode' ),
				'desc_tip' => true,
				'id'       => 'blogsqode_comment_count_allow',
				'default'  => 'Unable',
				'type'     => 'switchbox',
			),

			array(
				'title'    => esc_html__( 'Read Time', 'blogsqode' ),
				'desc'     => esc_html__( 'Enable If you want to display your blog read time in your blog list page.', 'blogsqode' ),
				'desc_tip' => true,
				'id'       => 'blogsqode_read_time_allow',
				'default'  => 'Disable',
				'type'     => 'switchbox',
			),

			array(
				'title'    => esc_html__( 'Category', 'blogsqode' ),
				'desc'     => esc_html__( 'Enable If you want to display your blog category in your blog list page.', 'blogsqode' ),
				'desc_tip' => true,
				'id'       => 'blogsqode_category_allow',
				'default'  => 'Unable',
				'type'     => 'switchbox',
			),

			array(
				'title'    => esc_html__( 'Read More Button', 'blogsqode' ),
				'desc'     => esc_html__( 'Enable If you want to display your blog read more button in your blog list page.', 'blogsqode' ),
				'desc_tip' => true,
				'id'       => 'blogsqode_read_more_btn_allow',
				'default'  => 'Unable',
				'type'     => 'switchbox',
			),

			array(
				'type' => 'sectionend',
				'id'   => 'enable_disable_options',
			),

		);

return apply_filters( 'blogsqode_general_settings', $settings );
}

// get catgory option filter category
public function get_categories_options() {
    $selected_post_types = get_option('blogsqode_post_type');
    
	if (!is_array($selected_post_types)) {
        $selected_post_types = array('post'); 
    }
    $options = array();
    foreach ($selected_post_types as $post_type) {
        $taxonomies = get_object_taxonomies($post_type);
        if (!empty($taxonomies)) {
            foreach ($taxonomies as $taxonomy) {
				if ($taxonomy !== 'post_tag') {
					$categories = get_terms(array(
						'taxonomy'   => $taxonomy,
						'hide_empty' => false,
					));
					foreach ($categories as $category) {
						if (is_object($category) && property_exists($category, 'term_id')) {
							$options[$category->term_id] = $category->name;
						}
					}
				}
            }
        }
    }
    return $options;
}

}

return new Blogsqode_Settings_General();

// selecting post type
function get_post_type_options() {
    $post_types = get_post_types(array('public' => true), 'objects');
    $options = array();
    foreach ($post_types as $post_type) {
        if ($post_type->name !== 'attachment' && $post_type->name !== 'page') {
            $options[$post_type->name] = $post_type->label;
        }
    }
    return $options;
}
