jQuery(document).ready(function($){
	"use strict";
	$('select').on('change', function() {
		var id = $(this).attr('id')+"_preview";
		var img_url = $('option:selected', this).data('img');
		$("#"+id+' .preview_image').attr("src",img_url);
	});

	$('#blogsqode_blog_layout, #blogsqode_blog_layout_slider, #blogsqode_blog_layout_with_sidebar, #blogsqode_blog_layout_slider_sidebar').on('change', function () {
		var img_url = $('option:selected', this).data('img');
		var layout_id = $(this).attr('id');
		var option_selected_value = $(this).val();
		var shortcode = '';
	
		switch (layout_id) {
			case 'blogsqode_blog_layout':
				$("#blogsqode_blog_layout_preview").attr("src", img_url);
				shortcode = '[blogsqode_blog_list layout=' + option_selected_value + ']';
				break;
			case 'blogsqode_blog_layout_slider':
				$("#preview_image_blogsqode_blog_layout_slider").attr("src", img_url);
				shortcode = '[blogsqode_slider layout=' + option_selected_value + ']';
				break;
			case 'blogsqode_blog_layout_with_sidebar':
				$("#preview_image_blogsqode_blog_layout_with_sidebar").attr("src", img_url);
				shortcode = '[blogsqode_blog_list_with_sidebar layout=' + option_selected_value + ']';
				break;
			case 'blogsqode_blog_layout_slider_sidebar':
				$("#preview_image_blogsqode_blog_layout_slider_sidebar").attr("src", img_url);
				shortcode = '[blogsqode_slider_with_sidebar layout=' + option_selected_value + ']';
				break;
			default:
				break;
		}
		if (shortcode) {
			$('#shortcode-text').text(shortcode);
		}
	});

	$('body').on('click', '.blogsqode-upload', function(e) {
		
		e.preventDefault();

		var activeFileUploadContext = $(this).parent();

		var customFileFrame = wp.media.frames.customHeader = wp.media({
			title: $(this).data('choose'),
			button: { text: $(this).data('update') }
		});

		customFileFrame.on('select', function() {
			var attachment = customFileFrame.state().get("selection").first();
			$('input', activeFileUploadContext).val(attachment.attributes.url).trigger('change');
			$('.blogsqode-upload', activeFileUploadContext).hide();
			$('.blogsqode-upload-remove', activeFileUploadContext).show();
		});

		customFileFrame.open();
	});

	$('body').on('click', '.blogsqode-upload-remove', function(e) {

		e.preventDefault();

		var activeFileUploadContext = $(this).parent();
		$('input', activeFileUploadContext).val('');
		$(this).prev().fadeIn('slow');
		$(this).fadeOut('slow');
	});

	$(window).on('load', function(){
		jQuery('.blogsqode-settings-content .notice').remove();
	});
});

jQuery(document).ready(function($) {
    $('.chosen-select').chosen();
});

jQuery(document).ready(function($) {
    $('.wp-color-picker').wpColorPicker();
});

function copyToClipboard() {
	var codeElement = document.getElementById('shortcode-text');
	var range = document.createRange();
	range.selectNode(codeElement);
	window.getSelection().removeAllRanges();
	window.getSelection().addRange(range);
	document.execCommand('copy');
	window.getSelection().removeAllRanges();
	var copyButton = document.querySelector('.copy-button');
	var originalText = copyButton.textContent;
	copyButton.textContent = 'Copied!';
	setTimeout(function() {
		copyButton.textContent = originalText;
	}, 1000); 
}