<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Background;
use \Elementor\Control_Media;
use \Elementor\Repeater;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Utils;
use TPCore\Elementor\Controls\Group_Control_TPBGGradient;
use TPCore\Elementor\Controls\Group_Control_TPGradient;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Slider extends Widget_Base {

    use \TPCore\Widgets\TPCoreElementFunctions;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tp-slider';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Slider', 'tp-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tpcore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'tp-core' ];
	}


    protected static function get_profile_names()
    {
        return [
            'apple' => esc_html__('Apple', 'tp-core'),
            'behance' => esc_html__('Behance', 'tp-core'),
            'bitbucket' => esc_html__('BitBucket', 'tp-core'),
            'codepen' => esc_html__('CodePen', 'tp-core'),
            'delicious' => esc_html__('Delicious', 'tp-core'),
            'deviantart' => esc_html__('DeviantArt', 'tp-core'),
            'digg' => esc_html__('Digg', 'tp-core'),
            'dribbble' => esc_html__('Dribbble', 'tp-core'),
            'email' => esc_html__('Email', 'tp-core'),
            'facebook' => esc_html__('Facebook', 'tp-core'),
            'flickr' => esc_html__('Flicker', 'tp-core'),
            'foursquare' => esc_html__('FourSquare', 'tp-core'),
            'github' => esc_html__('Github', 'tp-core'),
            'houzz' => esc_html__('Houzz', 'tp-core'),
            'instagram' => esc_html__('Instagram', 'tp-core'),
            'jsfiddle' => esc_html__('JS Fiddle', 'tp-core'),
            'linkedin' => esc_html__('LinkedIn', 'tp-core'),
            'medium' => esc_html__('Medium', 'tp-core'),
            'pinterest' => esc_html__('Pinterest', 'tp-core'),
            'product-hunt' => esc_html__('Product Hunt', 'tp-core'),
            'reddit' => esc_html__('Reddit', 'tp-core'),
            'slideshare' => esc_html__('Slide Share', 'tp-core'),
            'snapchat' => esc_html__('Snapchat', 'tp-core'),
            'soundcloud' => esc_html__('SoundCloud', 'tp-core'),
            'spotify' => esc_html__('Spotify', 'tp-core'),
            'stack-overflow' => esc_html__('StackOverflow', 'tp-core'),
            'tripadvisor' => esc_html__('TripAdvisor', 'tp-core'),
            'tumblr' => esc_html__('Tumblr', 'tp-core'),
            'twitch' => esc_html__('Twitch', 'tp-core'),
            'twitter' => esc_html__('Twitter', 'tp-core'),
            'vimeo' => esc_html__('Vimeo', 'tp-core'),
            'vk' => esc_html__('VK', 'tp-core'),
            'website' => esc_html__('Website', 'tp-core'),
            'whatsapp' => esc_html__('WhatsApp', 'tp-core'),
            'wordpress' => esc_html__('WordPress', 'tp-core'),
            'xing' => esc_html__('Xing', 'tp-core'),
            'yelp' => esc_html__('Yelp', 'tp-core'),
            'youtube' => esc_html__('YouTube', 'tp-core'),
        ];
    }


	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
    protected function register_controls(){
        $this->register_controls_section();
        $this->style_tab_content();
    }  

	protected function register_controls_section() {
		

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tp_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->end_controls_section();

		
		$this->start_controls_section(
            'tp_main_slider',
            [
                'label' => esc_html__('Main Slider', 'tpcore'),
                'description' => esc_html__( 'Control all the style settings from Style tab', 'tpcore' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'repeater_condition',
            [
                'label' => __( 'Field condition', 'tpcore' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'tpcore' ),
                    'style_2' => __( 'Style 2', 'tpcore' ),
                    'style_3' => __( 'Style 3', 'tpcore' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );


        $repeater->add_control(
            'tp_box_icon_type',
            [
                'label' => esc_html__('Select Icon Type', 'tpcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'tpcore'),
                    'icon' => esc_html__('Icon', 'tpcore'),
                    'svg' => esc_html__('SVG', 'tpcore'),
                ],
                'condition' => [
                    'repeater_condition' => ['style_3'],
                ]
            ]
        );
        $repeater->add_control(
            'tp_box_icon_svg',
            [
                'show_label' => false,
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => esc_html__('SVG Code Here', 'tpcore'),
                'condition' => [
                    'tp_box_icon_type' => 'svg',
                    'repeater_condition' => ['style_3'],
                ]
            ]
        );

        $repeater->add_control(
            'tp_box_icon_image',
            [
                'label' => esc_html__('Upload Icon Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_box_icon_type' => 'image',
                    'repeater_condition' => ['style_3'],
                ]
            ]
        );

        if (tp_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'tp_box_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                        'repeater_condition' => ['style_3'],
                    ]
                ]
            );
        } else {
            $repeater->add_control(
                'tp_box_selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-star',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'tp_box_icon_type' => 'icon',
                        'repeater_condition' => ['style_3'],
                    ]
                ]
            );
        }


        $repeater->add_control(
            'tp_slider_image',
            [
                'label' => esc_html__('Upload Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );

        $repeater->add_control(
            'tp_slider_bg_image',
            [
                'label' => esc_html__('Upload Background Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'repeater_condition' => 'style_3'
                ]
            ]
        );

        $repeater->add_control(
            'tp_slider_sub_title',
            [
                'label' => esc_html__('Sub Title', 'tpcore'),
                'description' => tp_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Subtitle',
                'placeholder' => esc_html__('Type Before Heading Text', 'tpcore'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'tp_slider_title',
            [
                'label' => esc_html__('Title', 'tpcore'),
                'description' => tp_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Grow business.', 'tpcore'),
                'placeholder' => esc_html__('Type Heading Text', 'tpcore'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'tp_slider_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'tpcore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'tpcore'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'tpcore'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'tpcore'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'tpcore'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'tpcore'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'tpcore'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $repeater->add_control(
            'tp_slider_description',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'description' => tp_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('There are many variations of passages of Lorem Ipsum available but the majority have suffered alteration.', 'tpcore'),
                'placeholder' => esc_html__('Type section description here', 'tpcore'),
            ]
        );


        $repeater->add_control(
         'tp_slider_background_text',
         [
           'label'   => esc_html__( 'Backround Text', 'tpcore' ),
           'default' => 'POOREX',
           'type'    => \Elementor\Controls_Manager::TEXT,
           'condition' => [
                'repeater_condition' => 'style_2'
            ]
         ]
        );


        
		$repeater->add_control(
            'tp_slider_shape_switch',
            [
                'label' => esc_html__( 'Enable Shape ?', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'tpcore' ),
                'label_off' => esc_html__( 'No', 'tpcore' ),
                'return_value' => 'yes',
                'default' => 'no',
                'separator' => 'before',
                'condition' => [
                    'repeater_condition' => 'style_1',
                ],
            ]
        );
        
		$repeater->add_control(
            'tp_slider_bubble_switch',
            [
                'label' => esc_html__( 'Enable Bubble ?', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'tpcore' ),
                'label_off' => esc_html__( 'No', 'tpcore' ),
                'return_value' => 'yes',
                'default' => 'no',
                'separator' => 'before',
                'condition' => [
                    'repeater_condition' => 'style_2',
                ],
            ]
        );

        
        
		$repeater->add_control(
            'tp_btn_link_switcher',
            [
                'label' => esc_html__( 'Add Button link', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'tpcore' ),
                'label_off' => esc_html__( 'No', 'tpcore' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );


        $repeater->add_control(
            'tp_btn_btn_text',
            [
                'label' => esc_html__('Button Text', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Button Text', 'tpcore'),
                'title' => esc_html__('Enter button text', 'tpcore'),
                'label_block' => true,
                'condition' => [
                    'tp_btn_link_switcher' => 'yes',
                ],
            ]
        );
        $repeater->add_control(
            'tp_btn_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'condition' => [
                    'tp_btn_link_switcher' => 'yes',
                ]
            ]
        );
        
        $repeater->add_control(
            'tp_btn_link',
            [
                'label' => esc_html__( 'Button Link link', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'tpcore' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'tp_btn_link_type' => '1',
                    'tp_btn_link_switcher' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            'tp_btn_page_link',
            [
                'label' => esc_html__( 'Select Button Link Page', 'tpcore' ),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => tp_get_all_pages(),
                'condition' => [
                    'tp_btn_link_type' => '2',
                    'tp_btn_link_switcher' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'slider_list',
            [
                'label' => esc_html__('Slider List', 'tpcore'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tp_slider_title' => esc_html__('Grow business.', 'tpcore')
                    ],
                    [
                        'tp_slider_title' => esc_html__('Development.', 'tpcore')
                    ],
                    [
                        'tp_slider_title' => esc_html__('Marketing.', 'tpcore')
                    ],
                ],
                'title_field' => '{{{ tp_slider_title }}}',
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail', // // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'exclude' => ['custom'],
                // 'default' => 'tp-portfolio-thumb',
            ]
        );
        $this->end_controls_section();

        
	}

    
    protected function style_tab_content(){
        $this->tp_section_style_controls('banner_section', 'Section Style', '.ele-section');
        $this->tp_icon_style('banner_icon', 'Banner - Icon/Image/SVG', '.tp-banner-icon');
        $this->tp_basic_style_controls('banner_sub_title', 'Sub Heading Style', '.ele-sub-heading');
        $this->tp_basic_style_controls('banner_title', 'Heading Style', '.ele-heading');
        $this->tp_basic_style_controls('banner_des', 'Content Style', '.ele-description');
        $this->tp_basic_style_controls('banner_list', 'Features Style', '.ele-features');
        $this->tp_link_controls_style('banner_btn_1', 'Button Style 1', '.ele-btn-1');
    }

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *Video Youtube link

	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

<?php if ( $settings['tp_design_style']  == 'layout-2' ): ?>

<!-- hero area start -->
<div class="tp-slider-3__area p-relative">
            <div class="tp-slider-3__icon smooth">
                <a href="#service" class="arrow-scroll-btn"><i class="flaticon-down-arrow"></i></a>
            </div>
            <div class="tp-slider-3__arrow-box">
                <button class="test-prev">
                    <svg id="body" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="67" height="24" viewBox="0 0 67 24">
                        <g id="hero_area" data-name="hero area">
                          <g id="slider_arrow" data-name="slider arrow">
                            <g id="next">
                              <image id="right-arrow" width="67" height="24" xlink:href="data:img/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEMAAAAYCAYAAAChg0BHAAABwElEQVRYheXZzatNYRTH8c+90WXgZXAJJTMKJddbCRmQkZn/xlzJwMR/wcRA6ooRQoiJtygvMxTFwC3u0aq162l33XPOwLPZ5zvaa59O5/f8Wnvt3/OcqcFgYAwuYQfO4sE4X/wfWDGGxss4k9eLODWpZszjZF4v4Pxf1NQZo5hRGvED+/Csh14MNeMGThT18b4aEUwv89l8YcR3HMT9Sro6YanOWIXr2QWNEQfwos9GBO1X60o8xu6sv+DwJBhhic64VRjRdMSbDnR1QjMzVuMhjmQds2HNJBkhO2Mt7hQdETniKo5ic8f6ahAN8RM3Y2a8xPbiRxeHvGX6yvtY9GxrcZNoRDAbnbE1N12b8makzHN4jY0dC6zBFH5FnGherVtwD2FM3LiG0723oUWZM9bhLnZm/QFz+PwvCK1BO3Stx/PikXmXWeNTL1ffoj0sv7Z2pdvwCBs6VVmJP510zWTw2pN1PDLH8LZvBpQsd+w3kzNkLutv2I9X1VVWYtgZ6HRu3JoOiWG6Cx/7YkDJsIAVafQQnmYdAe0J9taTWI9R0uZCGnI769ivXOjD4tuMeiAchsTG7Ur+VXCxnsRK4DeksGLGpvQizQAAAABJRU5ErkJggg=="/>
                            </g>
                          </g>
                        </g>
                      </svg>                      
                    <span><?php echo esc_html__("P",'tpcore') ?></span></button>
                <button class="test-next">
                    <span><?php echo esc_html__("N",'tpcore') ?></span>
                    <svg id="body2" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="66" height="24" viewBox="0 0 66 24">
                        <g id="hero_area2" data-name="hero area">
                          <g id="slider_arrow2" data-name="slider arrow">
                            <g id="prev">
                              <image id="right-arrow2" width="66" height="24" xlink:href="data:img/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAAAYCAYAAABOQSt5AAABZUlEQVRYheWYsUoDQRCGPzWtNsFGCPgAFmKiEgniCwiWop1l8gYarJJ3sfAlLAIhEGICiohgaydERGxcGZnAulyyKgR19ofh9o69292P+dnZm3HOYVD7wClwrteorIK4B5a13QTqsRdmpz+nX9GxN+gJ0IhOQjLCaFTdZ9UnrdMyCIlaAKORKgiJw6/ASAEEGTZppgqCmE1SAsEkm6QGQmLXOfcc2iSnu+gmfLTfzFQS2ZLqsQ+cAUfaQ2oOJ5VlC9j6azOesobAgj+EgDBZY39XYocKsAfMaepY1wOwChx46+xaPXTFdAFsa59bAZP7+bf+pfLAAFjSyUt7B3ixevrMkhzLex4E2T02gEcM/48IJYu/Aeb1+R2wAryO+qWQEYtA24MgmVD0IZAACLFDFyjofV+Lx2HY0bI1QjtcA2thJoxkNSMKGXYojYOA4YzoAOvaHujuMBYChjPiCngCLoFyDALAO8rQx5NO39/uAAAAAElFTkSuQmCC"/>
                            </g>
                          </g>
                        </g>
                      </svg>
                </button> 
            </div>
            <div class="tp-slider-3__wrapper">
                <div class="swiper-container tp-slider-3__active">
                    <div class="swiper-wrapper">
                    <?php foreach ($settings['slider_list'] as $item) : 
                        $this->add_render_attribute('title_args', 'class', 'tp-slider-3-title pb-30 tp-el-title ele-heading');

                        if ( !empty($item['tp_slider_image']['url']) ) {
                            $tp_slider_image_url = !empty($item['tp_slider_image']['id']) ? wp_get_attachment_image_url( $item['tp_slider_image']['id'], $settings['thumbnail_size']) : $item['tp_slider_image']['url'];
                            $tp_slider_image_alt = get_post_meta($item["tp_slider_image"]["id"], "_wp_attachment_image_alt", true);
                        }

                        // btn Link
                        if ('2' == $item['tp_btn_link_type']) {
                            $link = get_permalink($item['tp_btn_page_link']);
                            $target = '_self';
                            $rel = 'nofollow';
                        } else {
                            $link = !empty($item['tp_btn_link']['url']) ? $item['tp_btn_link']['url'] : '';
                            $target = !empty($item['tp_btn_link']['is_external']) ? '_blank' : '';
                            $rel = !empty($item['tp_btn_link']['nofollow']) ? 'nofollow' : '';
                        }
                        ?>
                        <div class="swiper-slide">
                            <div class="tp-slider-3__bg z-index fix p-relative" data-background="<?php echo esc_url($tp_slider_image_url); ?>">
                            <?php if (!empty($item['tp_slider_shape_switch'])) : ?>
                                <div class="tp-slider-3__shape">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/slider/slider-shape-3-1.png" alt="">
                                </div>
                                <?php endif; ?>
                                <?php if (!empty($item['tp_slider_background_text'])) : ?>
                                <div class="tp-slider-3__text">
                                    <h3 class="tp-slider-3__big-text"><?php echo tp_kses( $item['tp_slider_background_text'] ); ?></h3>
                                </div>
                                <?php endif; ?>
                                <div class="container">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="tp-slider-3__content text-center">
                                            <?php if (!empty($item['tp_slider_sub_title'])) : ?>
                                            <span class="tp-slider-3-subtitle"><?php echo tp_kses( $item['tp_slider_sub_title'] ); ?></span>
                                            <?php endif; ?>
                                                <?php
                                                if ($item['tp_slider_title_tag']) :
                                                    printf('<%1$s %2$s>%3$s</%1$s>',
                                                        tag_escape($item['tp_slider_title_tag']),
                                                        $this->get_render_attribute_string('title_args'),
                                                        tp_kses($item['tp_slider_title'])
                                                    );
                                                endif; ?>
                                                <?php if (!empty($item['tp_btn_link_switcher'])) : ?>
                                                <a class="tp-btn theme-2-bg" target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>"><?php echo tp_kses($item['tp_btn_btn_text']); ?></a>
                                            <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?> 
                    </div>
                </div>
            </div>
        </div>


<?php else: 
    if ( !empty($settings['tp_image']['url']) ) {
        $tp_image = !empty($settings['tp_image']['id']) ? wp_get_attachment_image_url( $settings['tp_image']['id'], $settings['tp_image_size_size']) : $settings['tp_image']['url'];
        $tp_image_alt = get_post_meta($settings["tp_image"]["id"], "_wp_attachment_image_alt", true);
    }


    if ( ! empty( $settings['tp_slider_mouse_link']['url'] ) ) {
        $this->add_link_attributes( 'tp-button-text-arg', $settings['tp_slider_mouse_link'] );
        $this->add_link_attributes( 'tp-button-arg', $settings['tp_slider_mouse_link'] );
        $this->add_render_attribute('tp-button-arg', 'class', 'mouse-scroll-icon mouse-scroll-icon-4');
    }

    $bloginfo = get_bloginfo( 'name' );
?>

<div class="tp-slider__area p-relative">
    <div class="tp-slider__arrow-box">
        <div class="slider-prev">
            <button>
                <svg id="body" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="67" height="24" viewBox="0 0 67 24">
                    <g id="hero">
                        <g id="slider">
                        <g id="next">
                            <image id="right-arrow" width="67" height="24" xlink:href="data:img/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEMAAAAYCAYAAAChg0BHAAABwElEQVRYheXZzatNYRTH8c+90WXgZXAJJTMKJddbCRmQkZn/xlzJwMR/wcRA6ooRQoiJtygvMxTFwC3u0aq162l33XPOwLPZ5zvaa59O5/f8Wnvt3/OcqcFgYAwuYQfO4sE4X/wfWDGGxss4k9eLODWpZszjZF4v4Pxf1NQZo5hRGvED+/Csh14MNeMGThT18b4aEUwv89l8YcR3HMT9Sro6YanOWIXr2QWNEQfwos9GBO1X60o8xu6sv+DwJBhhic64VRjRdMSbDnR1QjMzVuMhjmQds2HNJBkhO2Mt7hQdETniKo5ic8f6ahAN8RM3Y2a8xPbiRxeHvGX6yvtY9GxrcZNoRDAbnbE1N12b8makzHN4jY0dC6zBFH5FnGherVtwD2FM3LiG0723oUWZM9bhLnZm/QFz+PwvCK1BO3Stx/PikXmXWeNTL1ffoj0sv7Z2pdvwCBs6VVmJP510zWTw2pN1PDLH8LZvBpQsd+w3kzNkLutv2I9X1VVWYtgZ6HRu3JoOiWG6Cx/7YkDJsIAVafQQnmYdAe0J9taTWI9R0uZCGnI769ivXOjD4tuMeiAchsTG7Ur+VXCxnsRK4DeksGLGpvQizQAAAABJRU5ErkJggg=="/>
                        </g>
                        </g>
                    </g>
                    </svg>                        
            </button>
        </div>
        <div class="slider-next">
            <button>
                <svg id="body2" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="67" height="24" viewBox="0 0 67 24">
                    <g id="hero2">
                        <g id="slider2">
                        <g id="next_copy" data-name="next copy">
                            <image id="right-arrow2" width="67" height="24" xlink:href="data:img/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEMAAAAYCAYAAAChg0BHAAABrUlEQVRYheXZT0tVYRDH8U8pVJILIZMWaYsIjRZp6A1rIaSBtK130Stw3yJa9EbaRKsSIiIE+yMJKhW4kKCihRgoGIE3HpgbD7fUu8krz/munjnM4cz5MTPPPOccqdfrCmQM9/ARd1t9vVLFeIqbsX6EO63cdPT/xtQ27uNnPPw2nrUSSKmZkbiIdzge9myWLf+k1MxIrGAis6dCkF0pWYzEfDTTzbAn9yqZksskZxBvcDKuvcA0tnOnqoghBJlDT9hLGMGvhkPpZZLzAaNZyVzC89yhSmIkVtEdvSRxHW9xIhmdkTY3Yr3T3lgPhK94jMs4hit4jWupZ6yhvwIiNLPTVBmfkhhb6Doc8bWV9STG+dhmOlCFreU70jvPZNPptzSPVGlrzXmCW2m0wGdcxZfOwxPfgXAKCzgbD0sj+zh+qNjQ1RtT6EDYqTSGsNFwqMqc0Rsn2IYQK7GlbuROVSiTc3iZlcYiatn3jj+ULsaFmDC7w16IHvGXEArvGaexHE1TZMTIXlN2qT1jGO+bhKjtd9woVYwHOBPrV7v1iGZK7RkP0Re/CtIH4f3Bb9DhZBVrqhtZAAAAAElFTkSuQmCC"/>
                        </g>
                        </g>
                    </g>
                    </svg>
            </button>                   
        </div>
    </div>
    <div class="tp-slider__wrapper">
        <div class="swiper-container tp-slider__active">
            <div class="swiper-wrapper">
            <?php foreach ($settings['slider_list'] as $item) : 
                $this->add_render_attribute('title_args', 'class', 'tp-slider-title pb-30');

                if ( !empty($item['tp_slider_image']['url']) ) {
                    $tp_slider_image_url = !empty($item['tp_slider_image']['id']) ? wp_get_attachment_image_url( $item['tp_slider_image']['id'], $settings['thumbnail_size']) : $item['tp_slider_image']['url'];
                    $tp_slider_image_alt = get_post_meta($item["tp_slider_image"]["id"], "_wp_attachment_image_alt", true);
                }

                // btn Link
                if ('2' == $item['tp_btn_link_type']) {
                    $link = get_permalink($item['tp_btn_page_link']);
                    $target = '_self';
                    $rel = 'nofollow';
                } else {
                    $link = !empty($item['tp_btn_link']['url']) ? $item['tp_btn_link']['url'] : '';
                    $target = !empty($item['tp_btn_link']['is_external']) ? '_blank' : '';
                    $rel = !empty($item['tp_btn_link']['nofollow']) ? 'nofollow' : '';
                }
                ?>
                <div class="swiper-slide">
                    <div class="tp-slider__bg d-flex align-items-center p-relative" data-background="<?php echo esc_url($tp_slider_image_url); ?>">
                    <?php if (!empty($item['tp_slider_shape_switch'])) : ?>
                        <div class="tp-slider__shape z-index">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/img/slider/slider-shape-1.png" alt="">
                        </div>
                        <div class="tp-slider__shape-2" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/slider/slider-shape-2.png"></div>
                        <div class="tp-slider__shape-3">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/img/slider/slider-shape-3.png" alt="">
                        </div>
                        <div class="tp-slider__shape-4">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/img/slider/slider-shape-4.png" alt="">
                        </div>
                        <?php endif; ?>
                        <div class="container">
                            <div class="row">
                                <div class="col-12">
                                    <div class="tp-slider__content-wrap z-index">
                                        <div class="tp-slider__content">
                                        <?php if (!empty($item['tp_slider_sub_title'])) : ?>
                                            <span class="tp-slider-subtitle"><?php echo tp_kses( $item['tp_slider_sub_title'] ); ?></span>
                                            <?php endif; ?>
                                            <?php
                                                if ($item['tp_slider_title_tag']) :
                                                    printf('<%1$s %2$s>%3$s</%1$s>',
                                                        tag_escape($item['tp_slider_title_tag']),
                                                        $this->get_render_attribute_string('title_args'),
                                                        tp_kses($item['tp_slider_title'])
                                                    );
                                                endif; ?>
                                            <?php if (!empty($item['tp_btn_link_switcher'])) : ?>
                                                <a class="tp-btn theme-2-bg" target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>"><?php echo tp_kses($item['tp_btn_btn_text']); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?> 
            </div>
        </div>
    </div>
</div>






<!-- hero area start -->

<!-- hero area end -->


<?php endif; 
		
	}

}

$widgets_manager->register( new TP_Slider() );