<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Gallery_Slider extends Widget_Base {

    use \TPCore\Widgets\TPCoreElementFunctions;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tp-gallery-slider';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Gallery', 'tpcore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tp-icon';
	}

    protected static function get_profile_names(){
        return [
            '500px' => esc_html__('500px', 'tpcore'),
            'apple' => esc_html__('Apple', 'tpcore'),
            'behance' => esc_html__('Behance', 'tpcore'),
            'bitbucket' => esc_html__('BitBucket', 'tpcore'),
            'codepen' => esc_html__('CodePen', 'tpcore'),
            'delicious' => esc_html__('Delicious', 'tpcore'),
            'deviantart' => esc_html__('DeviantArt', 'tpcore'),
            'digg' => esc_html__('Digg', 'tpcore'),
            'dribbble' => esc_html__('Dribbble', 'tpcore'),
            'email' => esc_html__('Email', 'tpcore'),
            'facebook' => esc_html__('Facebook', 'tpcore'),
            'flickr' => esc_html__('Flicker', 'tpcore'),
            'foursquare' => esc_html__('FourSquare', 'tpcore'),
            'github' => esc_html__('Github', 'tpcore'),
            'houzz' => esc_html__('Houzz', 'tpcore'),
            'instagram' => esc_html__('Instagram', 'tpcore'),
            'jsfiddle' => esc_html__('JS Fiddle', 'tpcore'),
            'linkedin' => esc_html__('LinkedIn', 'tpcore'),
            'medium' => esc_html__('Medium', 'tpcore'),
            'pinterest' => esc_html__('Pinterest', 'tpcore'),
            'product-hunt' => esc_html__('Product Hunt', 'tpcore'),
            'reddit' => esc_html__('Reddit', 'tpcore'),
            'slideshare' => esc_html__('Slide Share', 'tpcore'),
            'snapchat' => esc_html__('Snapchat', 'tpcore'),
            'soundcloud' => esc_html__('SoundCloud', 'tpcore'),
            'spotify' => esc_html__('Spotify', 'tpcore'),
            'stack-overflow' => esc_html__('StackOverflow', 'tpcore'),
            'tripadvisor' => esc_html__('TripAdvisor', 'tpcore'),
            'tumblr' => esc_html__('Tumblr', 'tpcore'),
            'twitch' => esc_html__('Twitch', 'tpcore'),
            'twitter' => esc_html__('Twitter', 'tpcore'),
            'vimeo' => esc_html__('Vimeo', 'tpcore'),
            'vk' => esc_html__('VK', 'tpcore'),
            'website' => esc_html__('Website', 'tpcore'),
            'whatsapp' => esc_html__('WhatsApp', 'tpcore'),
            'wordpress' => esc_html__('WordPress', 'tpcore'),
            'xing' => esc_html__('Xing', 'tpcore'),
            'yelp' => esc_html__('Yelp', 'tpcore'),
            'youtube' => esc_html__('YouTube', 'tpcore'),
        ];
    }
    public function get_tp_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $tp_cfa         = array();
        $tp_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $tp_forms       = get_posts( $tp_cf_args );
        $tp_cfa         = ['0' => esc_html__( 'Select Form', 'tpcore' ) ];
        if( $tp_forms ){
            foreach ( $tp_forms as $tp_form ){
                $tp_cfa[$tp_form->ID] = $tp_form->post_title;
            }
        }else{
            $tp_cfa[ esc_html__( 'No contact form found', 'tpcore' ) ] = 0;
        }
        return $tp_cfa;
    }

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tpcore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'tpcore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

    protected function register_controls(){
        $this->register_controls_section();
        $this->style_tab_content();
    }   

	protected function register_controls_section() {
		

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tp_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'tpcore'),
                    'layout-2' => esc_html__('Layout 2', 'tpcore'),
                    'layout-3' => esc_html__('Layout 3', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->end_controls_section();

		
		$this->start_controls_section(
            'tp_main_slider',
            [
                'label' => esc_html__('Common Slider', 'tpcore'),
                'description' => esc_html__( 'Control all the style settings from Style tab', 'tpcore' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'repeater_condition',
            [
                'label' => __( 'Field condition', 'tpcore' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'tpcore' ),
                    'style_2' => __( 'Style 2', 'tpcore' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'tp_slider_image',
            [
                'label' => esc_html__('Upload Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );
        $repeater->add_control(
            'tp_slider_title',
            [
                'label' => esc_html__('Gallery Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'repeater_condition' => ['style_1'],
                ]
            ]
        );
        $repeater->add_control(
            'tp_slider_subtitle',
            [
                'label' => esc_html__('Gallery Sub Title', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'repeater_condition' => ['style_1'],
                ]
            ]
        );

        $this->add_control(
            'slider_list',
            [
                'label' => esc_html__('Slider List', 'tpcore'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail', // // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'exclude' => ['custom'],
                // 'default' => 'tp-portfolio-thumb',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'tp_cta_shape',
                [
                  'label' => esc_html__( 'Section Shape', 'tpcore' ),
                  'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                  'condition' => [
                    'tp_design_style' => 'layout-1'
                  ]
                ]
           );
   
           $this->add_control(
            'tp_cta_shape_switch',
            [
              'label'        => esc_html__( 'Shape On/Off', 'tpcore' ),
              'type'         => \Elementor\Controls_Manager::SWITCHER,
              'label_on'     => esc_html__( 'Show', 'tpcore' ),
              'label_off'    => esc_html__( 'Hide', 'tpcore' ),
              'return_value' => 'yes',
              'default'      => '0',
            ]
           );
   
           $this->add_control(
               'tp_shape_image_1',
               [
                   'label' => esc_html__( 'Choose Shape Image 1', 'tp-core' ),
                   'type' => \Elementor\Controls_Manager::MEDIA,
                   'default' => [
                       'url' => \Elementor\Utils::get_placeholder_image_src(),
                   ],
                   'condition' => [
                       'tp_cta_shape_switch' => 'yes'
                   ]
               ]
           );

           $this->add_group_control(
               Group_Control_Image_Size::get_type(),
               [
                   'name' => 'shape_image_size', // // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                   'exclude' => ['custom'],
                   'condition' => [
                       'tp_cta_shape_switch' => 'yes'
                   ]
               ]
           );
           
           $this->end_controls_section();

        // section column
        $this->tp_columns('col', ['layout-1', 'layout-2', 'layout-3']);
	}

    protected function style_tab_content(){
        $this->tp_section_style_controls('comint_section', 'Section - Style', '.tp-el-section');

        $this->tp_link_controls_style('slider_btn', 'Slider - Arrow', '.tp-el-arrow button span, .tp-el-arrow button i');
        $this->tp_link_controls_style('slider_dot', 'Slider - Dots', '.tp-el-dots .slick-dots li button');
        $this->tp_link_controls_style('slider_dot_active', 'Slider - Dot Active', '.tp-el-dots .slick-dots li.slick-active button');
    }


	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

		<?php if ( $settings['tp_design_style']  == 'layout-2' ): ?>

         <div class="tp-gallery-2__area">
            <div class="container-fluid g-0">
                <div class="row g-0">
                <?php foreach ($settings['slider_list'] as $item) :
                        $this->add_render_attribute('title_args', 'class', 'slider__title tp-el-title');

                        if ( !empty($item['tp_slider_image']['url']) ) {
                            $tp_slider_image_url = !empty($item['tp_slider_image']['id']) ? wp_get_attachment_image_url( $item['tp_slider_image']['id'], $settings['thumbnail_size']) : $item['tp_slider_image']['url'];
                            $tp_slider_image_alt = get_post_meta($item["tp_slider_image"]["id"], "_wp_attachment_image_alt", true);
                        }
                    ?>
                    <div class="col-xl-<?php echo esc_attr($settings['tp_col_for_desktop']); ?> col-lg-<?php echo esc_attr($settings['tp_col_for_laptop']); ?> col-md-<?php echo esc_attr($settings['tp_col_for_tablet']); ?> col-<?php echo esc_attr($settings['tp_col_for_mobile']); ?>  wow tpfadeLeft" data-wow-duration=".9s"
                        data-wow-delay=".3s">
                        <div class="tp-gallery-2__item">
                            <img src="<?php echo esc_url($tp_slider_image_url ); ?>" alt="<?php echo esc_attr($tp_slider_image_alt ); ?>">
                            <a class="popup-image" href="<?php echo esc_url($tp_slider_image_url ); ?>">
                                <div class="tp-gallery-2__icon-box">
                                    <svg id="body" xmlns="http://www.w3.org/2000/svg"
                                        xmlns:xlink="http://www.w3.org/1999/xlink" width="103" height="100"
                                        viewBox="0 0 103 100">
                                        <g id="gallery">
                                            <g id="_02_hover" data-name="02 + hover">
                                                <g id="image">
                                                    <image width="103" height="100"
                                                        xlink:href="data:img/png;base64,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" />
                                                </g>
                                            </g>
                                        </g>
                                    </svg>
                                    <div class="tp-gallery-2__icon">
                                        <i class="fa-solid fa-plus"></i>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

         <?php elseif ( $settings['tp_design_style']  == 'layout-3' ): ?>
            <div class="row">
                <?php foreach ($settings['slider_list'] as $item) :
                    $this->add_render_attribute('title_args', 'class', 'slider__title tp-el-title');

                    if ( !empty($item['tp_slider_image']['url']) ) {
                        $tp_slider_image_url = !empty($item['tp_slider_image']['id']) ? wp_get_attachment_image_url( $item['tp_slider_image']['id'], $settings['thumbnail_size']) : $item['tp_slider_image']['url'];
                        $tp_slider_image_alt = get_post_meta($item["tp_slider_image"]["id"], "_wp_attachment_image_alt", true);
                    }
                ?>
                <div class="col-xl-<?php echo esc_attr($settings['tp_col_for_desktop']); ?> col-lg-<?php echo esc_attr($settings['tp_col_for_laptop']); ?> col-md-<?php echo esc_attr($settings['tp_col_for_tablet']); ?> col-<?php echo esc_attr($settings['tp_col_for_mobile']); ?> mb-30 wow tpfadeLeft" data-wow-duration=".9s"
                    data-wow-delay=".3s">
                    <div class="tp-gallery-3__item p-relative">
                        <img src="<?php echo esc_url($tp_slider_image_url ); ?>" alt="<?php echo esc_attr($tp_slider_image_alt ); ?>">
                        <div class="tp-gallery-3__icon">
                            <a class="popup-image" href="<?php echo esc_url($tp_slider_image_url ); ?>">
                                <svg id="body3" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="49" height="51" viewBox="0 0 49 51">
                                    <g id="gallery">
                                        <g id="_02_hover" data-name="02 + hover">
                                        <g id="go_icon" data-name="go icon">
                                            <image id="right-arrow3" width="49" height="51" xlink:href="data:img/png;base64,iVBORw0KGgoAAAANSUhEUgAAADEAAAAzCAYAAAA+VOAXAAAD3klEQVRogdWa24tWZRTGf/PNOH5MY2VREXagojOohNpEh8nEylDRP6XoRugiIagbb7LTRaRmmUVpSVSEFRFFanlAAqOLqCghFZrRrxlnHB9Z9Wx4+XJqZtqnb8EHL/ju7frxrPWuZ+/ZXZKoMLqALIEmMOpUZgHjSVq9wBj/3PdX9FRJANwGXAFcBXzv5G4FhoGfgeuAi4DvnGvs/wX4HbgZeKdqiEhoK3A9cMKJxXrCic4BrgSOAUPAjYb7AbgGuASYC7xcZTmtBXZ4LZdWFuMuKdrWaWTXzK9Sid3AdqAF/ArcBPQB37rErgV+An4EbnBfRKnd5esz6DVVQpwEHgOOApcBlwJH/G+3AMf9i7LqNuBbbfcINXoaFSSfxlGvjyUAeH3c6ziVbgfeBO4GfgMOJHvHq4aYSgwAG4B7fHq9DbwE/OFrR+sMEfPgYeApYJHLL3poE7Ar2ddVZ4hlwDNW4AzwIfACcNA9dLH3NasedpPFoJt+AXDKR/HzwCHvvzy9rm4QFwDLgfVx/vv4fRd4DtiX7Evzrl1P3AE8boBo4vcMcLhtX+qdVBcl+oGlwBNu4rAXO4EXgT3n2T+WrHvqAhHH6JNWIhL8yE38zST707wbdYAIBdYBC32M7rACYT/OTnJNX7IerxIivNAKKxAAI8D7wEYD/Ftk5dRVtRJLgEcTgFDgWT87/Fdk5k9V9cSFLqH1ngNRQjs9B/ZO8R6txKK3iOeJkn9LJe3R33Fa0nZJd0qaNY08mpJ2SXpa0tVlAvRKekjS55LOSDopaZOkgRneb162LgugIWmVpINWYNQKLMrj/mVBDEr61ACnJL0qabGk2Z0A0S9pbaJAlNCWvBQoCyIU+DIpodfdxLkoUDREn6SVkr6SNCFpSNIrBsj9/ysKYoWk/W3H6OKiFC/ipg8kTZwdo6FATydAxABakzRxS9JreTdx0RD3epBF/ClpqxVodgLEHCuQ9cCQS2hJ0cnnCbFc0r6kid8wQHcnQESSD0r6LPFChR2jRUB02wsdsgIjkraV0cR5QkQTf5J4oS15eqGiIbImPmCAYUmbixxkRUCkXuh04oV6OwGiaSvxhZt4OJnElSU/XYhHyvRCRUDcL2l3WxNP95m4Moi+SbxQbRSYCkTqhUbcxANleKE8IPo9yOK1ytnEC830rUQlEOGF9lqBseS9UGle6P9AxB/ml3kST7iJN1uBRl0BUogYVquTSTxiN1qJF5opxH3JI2WrzAeavCAGz+OFajGJp/pr+LuJhX7b/IH/wLG/wLfiuUc0c78/M4jPdj4Gvu4kgIjsU6F5/tKl8wI4B64Oiv+C2BAeAAAAAElFTkSuQmCC"/>
                                        </g>
                                        </g>
                                    </g>
                                    </svg>
                            </a>                        
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
		<?php else:
            
        if ( !empty($settings['tp_shape_image_1']['url']) ) {
            $tp_shape_image = !empty($settings['tp_shape_image_1']['id']) ? wp_get_attachment_image_url( $settings['tp_shape_image_1']['id'], $settings['shape_image_size_size']) : $settings['tp_shape_image_1']['url'];
            $tp_shape_image_alt = get_post_meta($settings["tp_shape_image_1"]["id"], "_wp_attachment_image_alt", true);
        }
            
            ?>

         <div class="tp-gallery__area tp-gallery__plr">
            <div class="container-fluid">
                <div class="row gx-10 row-cols-lg-3 row-cols-md-2 row-cols-sm-2">
                <?php foreach ($settings['slider_list'] as $item) :
                        $this->add_render_attribute('title_args', 'class', 'slider__title tp-el-title');

                        if ( !empty($item['tp_slider_image']['url']) ) {
                            $tp_slider_image_url = !empty($item['tp_slider_image']['id']) ? wp_get_attachment_image_url( $item['tp_slider_image']['id'], $settings['thumbnail_size']) : $item['tp_slider_image']['url'];
                            $tp_slider_image_alt = get_post_meta($item["tp_slider_image"]["id"], "_wp_attachment_image_alt", true);
                        }
                    ?>
                    <div class="col-xl wow fadeInLeft" data-wow-delay="100ms">
                        <div class="tp-gallery__thumb p-relative">
                        <img src="<?php echo esc_url($tp_slider_image_url ); ?>" alt="<?php echo esc_attr($tp_slider_image_alt); ?>">
                            <div class="tp-gallery__thumb-overly d-flex justify-content-center align-items-center">
                                <div class="tp-gallery__overly-text text-center">
                                    <?php  if ( !empty($item['tp_slider_title']) ) : ?>
                                    <span><?php echo esc_html($item['tp_slider_title']) ?></span>
                                    <?php endif;?>
                                    <?php  if ( !empty($item['tp_slider_subtitle']) ) : ?>
                                    <h4 class="tp-gallery__title-sm"><?php echo esc_html($item['tp_slider_subtitle']) ?></h4>
                                    <?php endif;?>
                                </div>
                                <?php if(!empty($tp_shape_image)) : ?>
                                <div class="tp-gallery__shape">
                                    <img src="<?php echo esc_url($tp_shape_image); ?>" alt="<?php echo esc_attr($tp_shape_image_alt); ?>">
                                </div>
                                <?php endif;?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

         <?php endif; ?>


		<?php 
	}
}

$widgets_manager->register( new TP_Gallery_Slider() );