<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Charity extends Widget_Base {

    use \TPCore\Widgets\TPCoreElementFunctions;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tp-charity-post';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Charity', 'tpcore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'tpcore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'tpcore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
    protected function register_controls(){
        $this->register_controls_section();
        $this->style_tab_content();
    }   

	protected function register_controls_section() {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Design Layout', 'tpcore'),
            ]
        );
        $this->add_control(
            'tp_design_style',
            [
                'label' => esc_html__('Select Layout', 'tpcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Charity 1', 'tpcore'),
                    'layout-2' => esc_html__('Charity 2', 'tpcore'),
                    'layout-3' => esc_html__('Charity Slider', 'tpcore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

		
        // title/content
        $this->tp_section_title_render_controls('section', 'Section Title', 'Sub Title', 'your title here', $default_description = 'Hic nesciunt galisum aut dolorem aperiam eum soluta quod ea cupiditate.', ['layout-3'] );

        // Blog Query
		$this->tp_query_controls('charity', 'Charity','campaign','campaign_category');



        // section column
        $this->tp_columns('col', ['layout-1', 'layout-2', 'layout-3']);
        
	}

    // style_tab_content
    protected function style_tab_content(){
        $this->tp_section_style_controls('blog_section', 'Section - Style', '.tp-el-section');
    }

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        /**
         * Setup the post arguments.
        */
        $query_args = TP_Helper::get_query_args('campaign', 'campaign_category', $this->get_settings());

        // The Query
        $query = new \WP_Query($query_args);


        $filter_list = $settings['category'];

        ?>




<?php if ( $settings['tp_design_style']  == 'layout-3' ) : 
	$this->add_render_attribute('title_args', 'class', 'tp-section-title');	
?>

<div class="tp-donate__area p-relative fix">
	<div class="tp-donate__shape-1 d-none d-xxl-block">
		<img src="<?php echo get_template_directory_uri() ?>/assets/img/donate/donate-shape-1-2.png" alt="">
	</div>
	<div class="tp-donate__shape-2 d-none d-xxl-block">
		<img src="<?php echo get_template_directory_uri() ?>/assets/img/donate/donate-shape-1-3.png" alt="">
	</div>
	<div class="tp-donate__shape-3 d-none d-lg-block">
		<img src="<?php echo get_template_directory_uri() ?>/assets/img/donate/donate-shape-1-4.png" alt="">
	</div>
	<div class="tp-donate__bg">
		<div class="container">
			<div class="row align-items-end">
			<?php if ( !empty($settings['tp_section_section_title_show']) ) : ?>
				<div class="col-xl-8 col-lg-8 col-md-8">
					<div class="tp-donate__section-title pb-50">
					<?php if ( !empty($settings['tp_section_sub_title']) ) : ?>
						<span class="tp-section-subtitle"><?php echo tp_kses( $settings['tp_section_sub_title'] ); ?></span>
						<?php endif; ?>
						<?php
						if ( !empty($settings['tp_section_title' ]) ) :
							printf( '<%1$s %2$s>%3$s</%1$s>',
								tag_escape( $settings['tp_section_title_tag'] ),
								$this->get_render_attribute_string( 'title_args' ),
								tp_kses( $settings['tp_section_title' ] )
								);
						endif;
					?>
					</div>
				</div>
				<?php endif; ?>
				<div class="col-xl-4 col-lg-4 col-md-4">
					<div class="tp-donate__section-arrow d-flex justify-content-start  justify-content-md-end pb-50">
						<div class="test-next">
							<button><i class="far fa-arrow-left"></i></button>
						</div>
						<div class="test-prev">
							<button><i class="far fa-arrow-right"></i></button>
						</div>
					</div>
				</div>
			</div>
			<div class="swiper-container tp-donate__active">
				<div class="swiper-wrapper">
				<?php
					while ($query->have_posts()) : $query->the_post();
					$campaign_id   = get_the_ID();
					$campaign_info = charitable_get_campaign($campaign_id); // campaign info

					$campaign_title = $campaign_info->post_title; // title
					$campaign_content = $campaign_info->post_content; // content
					$campaign_description = $campaign_info->description; // description
					$campaign_post_page_link = get_post_permalink($campaign_info->ID); // url
					$campaign_image_url = get_the_post_thumbnail_url($campaign_info->ID, 'loveicon-chariti-1'); // thumbnail
					$campaign_currency_helper = charitable_get_currency_helper();
					$campaign_donated_amount = $campaign_currency_helper->get_monetary_amount($campaign_info->get_donated_amount());
					$campaign_goal = $campaign_currency_helper->get_monetary_amount($campaign_info->get_goal());
					$campaign_due = $campaign_currency_helper->get_monetary_amount($campaign_info->get_goal() - $campaign_info->get_donated_amount());
					$campaign_percent_unround = $campaign_info->get_percent_donated_raw();
					$campaign_percent = round($campaign_percent_unround);
					$campaign_categories = $campaign_info->get('categories', true);
					$campaign_single_cat = explode(',', $campaign_categories);
					$categories = get_the_terms( get_the_id(), 'campaign_category' );

					$casue_due = (int)$campaign_goal - (int)$campaign_donated_amount; 
				?>
					<div class="swiper-slide">
						<div class="tp-donate__item">
						<?php if(has_post_thumbnail()) : ?>
							<div class="tp-donate__thumb p-relative fix">
								<?php the_post_thumbnail(); ?>
								<div class="tp-donate__thumb-shape">
									<img src="<?php echo get_template_directory_uri() ?>/assets/img/donate/donate-shape-1.png" alt="">
									<div class="tp-donate__thumb-text">
										<span><?php echo esc_html($campaign_single_cat[0]); ?></span>
									</div>
								</div>
							</div>
							<?php endif; ?>
							<div class="tp-donate__content">
								<div class="tp-donate__text">
									<a href="<?php the_permalink(); ?>">
										<h5 class="tp-donate__title"><?php the_title(); ?>
										</h5>
									</a>
									<?php if (!empty($settings['tp_post_content'])):
										$content_limit = (!empty($settings['tp_post_content_limit'])) ? $settings['tp_post_content_limit'] : '';
										?>
									<p><?php print wp_trim_words(get_the_excerpt(get_the_ID()), $content_limit, ''); ?></p>
									<?php endif; ?>
								</div>
								<div class="tp-donate-progress">
									<div class="tp-donate-progress-item fix">
										<span class="progress-count"><?php echo $campaign_percent; ?>%</span>
										<div class="progress">
											<div class="progress-bar wow slideInLeft" data-wow-duration="1s"
												data-wow-delay=".3s" role="progressbar" data-width="<?php echo $campaign_percent; ?>%"
												aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"
												style="width: <?php echo $campaign_percent; ?>%;">
											</div>
										</div>
										<div class="progress-goals">
											<span><?php echo esc_html__('Raised','tpcore'); ?> <b> <?php echo $campaign_donated_amount; ?></b></span>
											<span><?php echo esc_html__('Goal','tpcore'); ?> <b> <?php echo $campaign_goal; ?></b></span>
										</div>
									</div>
								</div>
								<?php if(!empty($settings['tp_post_button'])) : ?>
									<div class="tp-donate__button">
										<a class="tp-grey-btn" href="<?php the_permalink(); ?>"><?php echo tp_kses($settings['tp_post_button']); ?></a>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<?php endwhile; wp_reset_query(); ?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php elseif ( $settings['tp_design_style']  == 'layout-2' ): 
	$this->add_render_attribute('title_args', 'class', 'tp-section-title');
?>
<div class="tp-donate-2__area">
            <div class="container">
                <div class="row gx-50">
				<?php
					while ($query->have_posts()) : $query->the_post();
					$campaign_id   = get_the_ID();
					$campaign_info = charitable_get_campaign($campaign_id); // campaign info

					$campaign_title = $campaign_info->post_title; // title
					$campaign_content = $campaign_info->post_content; // content
					$campaign_description = $campaign_info->description; // description
					$campaign_post_page_link = get_post_permalink($campaign_info->ID); // url
					$campaign_image_url = get_the_post_thumbnail_url($campaign_info->ID, 'loveicon-chariti-1'); // thumbnail
					$campaign_currency_helper = charitable_get_currency_helper();
					$campaign_donated_amount = $campaign_currency_helper->get_monetary_amount($campaign_info->get_donated_amount());
					$campaign_goal = $campaign_currency_helper->get_monetary_amount($campaign_info->get_goal());
					$campaign_due = $campaign_currency_helper->get_monetary_amount($campaign_info->get_goal() - $campaign_info->get_donated_amount());
					$campaign_percent_unround = $campaign_info->get_percent_donated_raw();
					$campaign_percent = round($campaign_percent_unround);
					$campaign_categories = $campaign_info->get('categories', true);
					$campaign_single_cat = explode(',', $campaign_categories);
					$categories = get_the_terms( get_the_id(), 'campaign_category' );

					$casue_due = (int)$campaign_goal - (int)$campaign_donated_amount; 
				?>
                    <div class="col-xl-<?php echo esc_attr($settings['tp_col_for_desktop']); ?> col-lg-<?php echo esc_attr($settings['tp_col_for_laptop']); ?> col-md-<?php echo esc_attr($settings['tp_col_for_tablet']); ?> col-<?php echo esc_attr($settings['tp_col_for_mobile']); ?> mb-40 wow tpfadeUp" data-wow-duration=".9s" data-wow-delay=".3s">
                        <div class="tp-donate-2__item">
                            <div class="row">
							<?php if(has_post_thumbnail()) : ?>
                                <div class="col-lg-6">
                                    <div class="tp-donate-2__thumb">
									<?php the_post_thumbnail(); ?>
                                        <div class="tp-donate-2__thumb-text">
                                        <a href="<?php the_permalink(); ?>"><i class="flaticon-tag"></i><?php echo esc_html($campaign_single_cat[0]); ?></a>
                                        </div>
                                    </div>
                                </div>
								<?php endif; ?>
                                <div class="col-lg-6">
                                    <div class="tp-donate-2__content">
                                        <div class="tp-donate-2__text">
                                            <a href="<?php the_permalink(); ?>">
                                                <h5 class="tp-donate-2__title"><?php the_title(); ?></h5>
                                            </a>
                                            <?php if (!empty($settings['tp_post_content'])):
												$content_limit = (!empty($settings['tp_post_content_limit'])) ? $settings['tp_post_content_limit'] : '';
												?>
											<p><?php print wp_trim_words(get_the_excerpt(get_the_ID()), $content_limit, ''); ?></p>
											<?php endif; ?>
                                        </div> 
                                        <div class="tp-donate-2-progress">
                                            <div class="tp-donate-2-progress-item fix">
                                                <span class="progress-count"><?php echo $campaign_percent; ?>%</span>
                                                <div class="progress">
                                                    <div class="progress-bar wow slideInLeft" data-wow-duration="1s"
                                                        data-wow-delay=".3s" role="progressbar" data-width="<?php echo $campaign_percent; ?>%"
                                                        aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"
                                                        style="width: <?php echo $campaign_percent; ?>%;">
                                                    </div>
                                                </div>
                                                <div class="progress-goals">
                                                    <span><?php echo esc_html__('Raised','tpcore'); ?> <b> <?php echo $campaign_donated_amount; ?></b></span>
                                                    <span><?php echo esc_html__('Goal','tpcore'); ?> <b> <?php echo $campaign_goal; ?></b></span>
                                                </div>
                                            </div>
                                        </div>
										<?php if(!empty($settings['tp_post_button'])) : ?>
											<div class="tp-donate__button">
												<a class="tp-grey-btn" href="<?php the_permalink(); ?>"><?php echo tp_kses($settings['tp_post_button']); ?></a>
											</div>
										<?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					<?php endwhile; wp_reset_query(); ?>
                </div>
				<?php if($settings['tp_post_pagination'] == 'yes' && '-1' != $settings['posts_per_page'] ){ ?>
                <div class="row">
                    <div class="col-xl-12">
                        <div class="basic-pagination text-center pt-30">
						<?php
							$big = 999999999; // need an unlikely integer

							if (get_query_var('paged')) {
								$paged = get_query_var('paged');
							} else if (get_query_var('page')) {
								$paged = get_query_var('page');
							} else {
								$paged = 1;
							}
							echo paginate_links( array(
								'base'       => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
								'format'     => '?paged=%#%',
								'current'    => $paged,
								'total'      => $query->max_num_pages,
								'type'       =>'list',
								'prev_text'  =>'<i class="far fa-angle-left"></i>',
								'next_text'  =>'<i class="far fa-angle-right"></i>',
								'show_all'   => false,
								'end_size'   => 1,
								'mid_size'   => 4,
							) );
						?>
                         </div>
                    </div>
                </div>
				<?php } ?>
            </div>
        </div>

<?php else : 
	$this->add_render_attribute('title_args', 'class', 'tp-section-title');	
?>

<div class="tp-donate__area pt-120 pb-120">
	<div class="container">
		<div class="row">
		<?php
			while ($query->have_posts()) : $query->the_post();
			$campaign_id   = get_the_ID();
			$campaign_info = charitable_get_campaign($campaign_id); // campaign info

			$campaign_title = $campaign_info->post_title; // title
			$campaign_content = $campaign_info->post_content; // content
			$campaign_description = $campaign_info->description; // description
			$campaign_post_page_link = get_post_permalink($campaign_info->ID); // url
			$campaign_image_url = get_the_post_thumbnail_url($campaign_info->ID, 'loveicon-chariti-1'); // thumbnail
			$campaign_currency_helper = charitable_get_currency_helper();
			$campaign_donated_amount = $campaign_currency_helper->get_monetary_amount($campaign_info->get_donated_amount());
			$campaign_goal = $campaign_currency_helper->get_monetary_amount($campaign_info->get_goal());
			$campaign_due = $campaign_currency_helper->get_monetary_amount($campaign_info->get_goal() - $campaign_info->get_donated_amount());
			$campaign_percent_unround = $campaign_info->get_percent_donated_raw();
			$campaign_percent = round($campaign_percent_unround);
			$campaign_categories = $campaign_info->get('categories', true);
			$campaign_single_cat = explode(',', $campaign_categories);
			$categories = get_the_terms( get_the_id(), 'campaign_category' );

			$casue_due = (int)$campaign_goal - (int)$campaign_donated_amount; 
		?>
			<div class="col-xl-<?php echo esc_attr($settings['tp_col_for_desktop']); ?> col-lg-<?php echo esc_attr($settings['tp_col_for_laptop']); ?> col-md-<?php echo esc_attr($settings['tp_col_for_tablet']); ?> col-<?php echo esc_attr($settings['tp_col_for_mobile']); ?> wow tpfadeUp" data-wow-duration=".9s"
				data-wow-delay=".3s">
				<div class="tp-donate__item">
						<?php if(has_post_thumbnail()) : ?>
							<div class="tp-donate__thumb p-relative fix">
								<?php the_post_thumbnail(); ?>
								<div class="tp-donate__thumb-shape">
									<img src="<?php echo get_template_directory_uri() ?>/assets/img/donate/donate-shape-1.png" alt="">
									<div class="tp-donate__thumb-text">
										<span><?php echo esc_html($campaign_single_cat[0]); ?></span>
									</div>
								</div>
							</div>
						<?php endif; ?>
					<div class="tp-donate__content">
						<div class="tp-donate__text">
							<a href="<?php the_permalink(); ?>">
								<h5 class="tp-donate__title"> <?php the_title(); ?>
								</h5>
							</a>
							<?php if (!empty($settings['tp_post_content'])):
								$content_limit = (!empty($settings['tp_post_content_limit'])) ? $settings['tp_post_content_limit'] : '';
								?>
							<p><?php print wp_trim_words(get_the_excerpt(get_the_ID()), $content_limit, ''); ?></p>
							<?php endif; ?>
						</div>
						<div class="tp-donate-progress">
							<div class="tp-donate-progress-item fix">
								<span class="progress-count"><?php echo $campaign_percent; ?>%</span>
								<div class="progress">
									<div class="progress-bar wow slideInLeft" data-wow-duration="1s"
										data-wow-delay=".3s" role="progressbar" data-width="<?php echo $campaign_percent; ?>%"
										aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"
										style="width: <?php echo $campaign_percent; ?>%;">
									</div>
								</div>
								<div class="progress-goals">
									<span><?php echo esc_html__('Raised','tpcore'); ?> <b> <?php echo $campaign_donated_amount; ?></b></span>
									<span><?php echo esc_html__('Goal','tpcore'); ?> <b> <?php echo $campaign_goal; ?></b></span>
								</div>
							</div>
						</div>
						<?php if(!empty($settings['tp_post_button'])) : ?>
						<div class="tp-donate__button">
							<a class="tp-grey-btn" href="<?php the_permalink(); ?>"><?php echo tp_kses($settings['tp_post_button']); ?></a>
						</div>
						<?php endif; ?>

					</div>
				</div>
			</div>
			<?php endwhile; wp_reset_query(); ?>
		</div>
		<?php if($settings['tp_post_pagination'] == 'yes' && '-1' != $settings['posts_per_page'] ){ ?>
		<div class="row">
			<div class="col-xl-12">
				<div class="basic-pagination text-center pt-30">
				<?php
					$big = 999999999; // need an unlikely integer

					if (get_query_var('paged')) {
						$paged = get_query_var('paged');
					} else if (get_query_var('page')) {
						$paged = get_query_var('page');
					} else {
						$paged = 1;
					}
					echo paginate_links( array(
						'base'       => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
						'format'     => '?paged=%#%',
						'current'    => $paged,
						'total'      => $query->max_num_pages,
						'type'       =>'list',
						'prev_text'  =>'<i class="far fa-angle-left"></i>',
						'next_text'  =>'<i class="far fa-angle-right"></i>',
						'show_all'   => false,
						'end_size'   => 1,
						'mid_size'   => 4,
					) );
				?>
					</div>
			</div>
		</div>
		<?php } ?>
	</div>
</div>

<?php endif;
	}

}

$widgets_manager->register( new TP_Charity() );